package hsplet.function;

import java.awt.Component;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

import hsplet.Context;
import hsplet.HSPError;
import hsplet.gui.HSPControl;
import hsplet.gui.HSPScreen;
import hsplet.gui.WindowManager;
import hsplet.variable.IntScalar;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;

/**
 * COMARg[n֐QB
 * 
 * @author Yuki
 * @version $Revision: 1.6 $, $Date: 2006/02/05 10:08:13 $
 */
public class ControlCommand extends FunctionBase {
	public static void newcom(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "newcom");
	}

	public static void querycom(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "querycom");
	}

	public static void delcom(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "delcom");
	}

	public static void convstow(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "convstow");
	}

	public static void comres(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "comres");
	}

	public static void axobj(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "axobj");
	}

	public static void winobj(final Context context) {

		context.error(HSPError.UnsupportedOperation, "winobj");
	}

	public static int sendmsg(final Context context, final int handle, final int message, final Operand wv,
			final int wvi, final Operand lv, final int lvi, final int mode) {

		final Component c = WindowManager.getComponent(handle);
		if (c == null) {
			return 0;
		}

		try {
			if (c instanceof HSPControl) {
				return ((HSPControl) c).sendMessage(message, wv == null ? null : wv.ref(wvi), lv == null ? null : lv
						.ref(lvi));
			}
			if (c instanceof HSPScreen) {
				return ((HSPScreen) c).sendMessage(message, wv == null ? null : wv.ref(wvi), lv == null ? null : lv
						.ref(lvi));
			}
		} catch (UnsupportedOperationException e) {

		}

		try {
			return defaultSendMessage(c, message, wv, wvi, lv, lvi);
		} catch (UnsupportedOperationException e) {

		}

		return 0;
	}

	public static int defaultSendMessage(final Component c, final int message, final Operand wv, final int wvi,
			final Operand lv, final int lvi) {

		switch (message) {
		case 0x00B0: //EM_GETSEL
			if (c instanceof JTextComponent) {
				final int start = ((JTextComponent) c).getSelectionStart();
				final int end = ((JTextComponent) c).getSelectionEnd();
				if (wv != null) {
					wv.assign(wvi, Scalar.fromValue(start), 0);
				}
				if (lv != null) {
					lv.assign(lvi, Scalar.fromValue(end), 0);
				}
				return start > 0xFFFF || end > 0xFFFF ? -1 : start | (end << 16);
			}
		case 0x00B1: //EM_SETSEL
			if (c instanceof JTextComponent) {
				int end = toInt(lv, lvi, 0);
				if (end < 0) {
					end = Integer.MAX_VALUE;
				}
				((JTextComponent) c).select(toInt(wv, wvi, 0), end);
			}
			return 0;
		case 0x00CC: //EM_SETPASSWORDCHAR
			if (c instanceof JPasswordField) {
				((JPasswordField) c).setEchoChar((char) toInt(wv, wvi, 0));
			}
			return 0;
		case 0x0300: //WM_CUT
			if (c instanceof JTextComponent) {
				((JTextComponent) c).cut();
			}
			return 0;
		case 0x0301: // WM_COPY
			if (c instanceof JTextComponent) {
				((JTextComponent) c).copy();
			}
			return 0;
		case 0x0302: // WM_PASTE
			if (c instanceof JTextComponent) {
				((JTextComponent) c).paste();
			}
			return 0;
		case 0x0303: // WM_CLEAR
			if (c instanceof JTextComponent) {
				((JTextComponent) c).replaceSelection("");
			}
			return 0;
		}

		throw new UnsupportedOperationException();
	}

	public static void comevent(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "comevent");
	}

	public static void comevarg(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "comevarg");
	}

	public static void sarrayconv(final Context context, final Operand v, final int vi) {

		context.error(HSPError.UnsupportedOperation, "sarrayconv");
	}
}
