/*
 * $Id: Combox.java,v 1.4 2006/02/11 17:19:31 Yuki Exp $
 */
package hsplet.gui;

import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;

/**
 * R{{bNXB
 * <p>
 * IꂽϐXVB
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.4 $, $Date: 2006/02/11 17:19:31 $
 */
public class Combox extends JComboBox implements VolatileValueUpdater, HSPControl, ItemListener {

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: Combox.java,v 1.4 2006/02/11 17:19:31 Yuki Exp $";

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = -8777787617022303507L;

	/** ϐ */
	private VolatileValue v;

	/** ϐCfbNX */
	private int vi;

	/**
	 * IuWFNg\zB
	 * @param v IێϐB
	 * @param vi Iێϐ̃CfbNXB
	 * @param items I̔zB
	 */
	public Combox(final Variable v, final int vi, final String[] items) {

		for (int i = 0; i < items.length; ++i) {
			addItem(items[i]);
		}

		setSelectedIndex(v.toInt(vi));

		this.v = v.makeVolatile();
		this.vi = vi;

		addItemListener(this);
	}

	public Component asComponent() {
		return this;
	}

	public void setValue(Operand v, int vi) {

		switch (v.getType()) {
		case Operand.Type.INTEGER:
			setSelectedIndex(v.toInt(vi));
			break;
		default:
			final int selection = getSelectedIndex();

			removeAll();

			final String[] items = v.toString(vi).split("\\r?\\n");
			for (int i = 0; i < items.length; ++i) {
				addItem(items[i]);
			}

			setSelectedIndex(selection < getItemCount() ? selection : -1);
		}

		this.v.updaters.add(this);
	}

	public void update(Operand value) {

		value.assign(vi, Scalar.fromValue(getSelectedIndex()), 0);
	}

	public void itemStateChanged(ItemEvent e) {

		this.v.updaters.add(this);
	}
	
	public int sendMessage(int message, Operand wparam, Operand lparam) {
		
		throw new UnsupportedOperationException();
	}
}
