/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public final class HtmlGenerator
implements Serializable {
    private static final long serialVersionUID = -5216057552518726784L;
    private static final String fileVersionID = "$Id: HtmlGenerator.java,v 1.4 2006/01/16 19:34:22 Yuki Exp $";
    private static final String TEMPLATE_NAME = "template.html";
    private static final String START_CLASS_NAME_TAG_REGEX = "\\{START_CLASS_NAME\\}";
    private static final String TITLE_TAG_REGEX = "\\{TITLE\\}";
    private static final String LIBS_TAG_REGEX = "\\{LIBS\\}";
    private static final String WIDTH_TAG_REGEX = "\\{WIDTH\\}";
    private static final String HEIGHT_TAG_REGEX = "\\{HEIGHT\\}";
    private final String className;
    private final String title;
    private final Collection libs;
    private final int width;
    private final int height;
    private final File template;

    public HtmlGenerator(String className, String title, Collection libs, int w, int h, File template) {
        this.className = className;
        this.title = title;
        this.libs = libs;
        this.width = w;
        this.height = h;
        this.template = template;
    }

    public void generate(OutputStream out) throws IOException {
        PrintWriter w = new PrintWriter(out, true);
        InputStream in = this.template == null ? this.getClass().getResourceAsStream(TEMPLATE_NAME) : new FileInputStream(this.template);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while ((line = r.readLine()) != null) {
                StringBuffer extLibNames = new StringBuffer();
                Iterator i = this.libs.iterator();
                while (i.hasNext()) {
                    extLibNames.append(i.next() + ",");
                }
                w.println(line.replaceAll(START_CLASS_NAME_TAG_REGEX, this.className).replaceAll(LIBS_TAG_REGEX, extLibNames.toString()).replaceAll(WIDTH_TAG_REGEX, "" + this.width).replaceAll(HEIGHT_TAG_REGEX, "" + this.height).replaceAll(TITLE_TAG_REGEX, this.title));
            }
        }
        finally {
            in.close();
        }
    }
}

