/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.variable.ByteString;
import hsplet.variable.IntScalar;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;

public final class DoubleScalar
extends Scalar {
    private static final long serialVersionUID = -3521657637646866475L;
    private static final String fileVersionID = "$Id: DoubleScalar.java,v 1.2 2006/01/13 20:32:13 Yuki Exp $";
    public double value;

    public DoubleScalar(double value) {
        this.value = value;
    }

    public int getType() {
        return 3;
    }

    public String toString(int index) {
        return Double.toString(this.value);
    }

    public ByteString toByteString(int index) {
        return new ByteString(Double.toString(this.value));
    }

    public int toInt(int index) {
        return (int)this.value;
    }

    public double toDouble(int index) {
        return this.value;
    }

    public void inc(int index) {
        this.value += 1.0;
    }

    public void dec(int index) {
        this.value -= 1.0;
    }

    public void assign(int index, Operand rhs, int rhi) {
        this.value = rhs.toDouble(rhi);
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        this.value += rhs.toDouble(rhi);
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        this.value -= rhs.toDouble(rhi);
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        this.value *= rhs.toDouble(rhi);
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        this.value /= rhs.toDouble(rhi);
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        this.value %= rhs.toDouble(rhi);
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&=");
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|=");
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^=");
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>=");
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<=");
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.value + rhs.toDouble(rhi));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value == rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value != rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value > rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value < rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value >= rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return new IntScalar(this.value <= rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.value - rhs.toDouble(rhi));
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.value * rhs.toDouble(rhi));
    }

    public Operand div(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.value / rhs.toDouble(rhi));
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.value % rhs.toDouble(rhi));
    }

    public Operand and(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&");
    }

    public Operand or(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|");
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^");
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<");
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>");
    }

    public byte peek(int index, int offset) {
        return (byte)(Double.doubleToRawLongBits(this.value) >> offset % 8 * 8);
    }

    public void poke(int index, int offset, byte value) {
        long bits = Double.doubleToRawLongBits(value);
        bits &= 255L << offset % 8 * 8 ^ 0xFFFFFFFFFFFFFFFFL;
        this.value = Double.longBitsToDouble(bits |= ((long)value & 0xFFL) << offset % 8 * 8);
    }
}

