/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.util.Conversion;
import hsplet.variable.Array;
import hsplet.variable.ByteString;
import hsplet.variable.IntScalar;
import hsplet.variable.Operand;
import hsplet.variable.StringScalar;

public final class StringArray
extends Array {
    private static final long serialVersionUID = 5025854224973749708L;
    private static final String fileVersionID = "$Id: StringArray.java,v 1.4 2006/02/27 15:48:01 Yuki Exp $";
    private ByteString[] values;

    public StringArray() {
        this(64, 1, 1, 1, 1);
    }

    public StringArray(int length, int l0, int l1, int l2, int l3) {
        super(l0, l1, l2, l3);
        this.values = new ByteString[l0 * l1 * l2 * l3];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = new ByteString(new byte[length], 0, 0, false);
            ++i;
        }
    }

    public int getType() {
        return 2;
    }

    public String toString(int index) {
        return this.values[index].toString();
    }

    public ByteString toByteString(int index) {
        return this.values[index];
    }

    public int toInt(int index) {
        return Conversion.strtoi(this.values[index].toString());
    }

    public double toDouble(int index) {
        return Conversion.strtod(this.values[index].toString());
    }

    public void inc(int index) {
    }

    public void dec(int index) {
    }

    public void assign(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        this.values[index].assign(rhs.toByteString(rhi));
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        this.values[index].append(rhs.toByteString(rhi));
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("-=");
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("*=");
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("/=");
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("%=");
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&=");
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|=");
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^=");
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>=");
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<=");
    }

    public void expand(int index) {
        super.expand(index);
        ByteString[] newValues = new ByteString[this.l0 * this.l1 * this.l2 * this.l3];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        int i = this.values.length;
        while (i < newValues.length) {
            newValues[i] = new ByteString(new byte[256], 0, 0, false);
            ++i;
        }
        this.values = newValues;
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return new StringScalar(ByteString.concat(this.values[index], rhs.toByteString(rhi)));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].equals(rhs.toByteString(rhi)) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].compareTo(rhs.toByteString(rhi)));
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].compareTo(rhs.toByteString(rhi)) > 0 ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].compareTo(rhs.toByteString(rhi)) < 0 ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].compareTo(rhs.toByteString(rhi)) >= 0 ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index].compareTo(rhs.toByteString(rhi)) <= 0 ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("-");
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("*");
    }

    public Operand div(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("/");
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("%");
    }

    public Operand and(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&");
    }

    public Operand or(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|");
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^");
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<");
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>");
    }

    public byte peek(int index, int offset) {
        return this.values[index].get(offset);
    }

    public void poke(int index, int offset, byte value) {
        this.values[index].set(offset, value);
    }
}

