
//
//	hspvar.cpp header
//
#ifndef __hspvar_core_h
#define __hspvar_core_h

#define HSPVAR_FLAG_NONE 0
#define HSPVAR_FLAG_LABEL 1
#define HSPVAR_FLAG_STR 2
#define HSPVAR_FLAG_DOUBLE 3
#define HSPVAR_FLAG_INT 4
#define HSPVAR_FLAG_STRUCT 5
#define HSPVAR_FLAG_COMSTRUCT 6

//	7VARIANTŗ\ς

#define HSPVAR_FLAG_USERDEF 8
#define HSPVAR_FLAG_MAX 8

#define HSPVAR_MODE_NONE -1
#define HSPVAR_MODE_MALLOC 1
#define HSPVAR_MODE_CLONE 2

#define HSPVAR_ERROR_INVALID HSPERR_WRONG_EXPRESSION
#define HSPVAR_ERROR_DIVZERO HSPERR_DIVIDED_BY_ZERO
#define HSPVAR_ERROR_TYPEMISS HSPERR_TYPE_MISMATCH
#define HSPVAR_ERROR_ARRAYOVER HSPERR_ARRAY_OVERFLOW
#define HSPVAR_ERROR_ILLEGALPRM HSPERR_ILLEGAL_FUNCTION

#define HSPVAR_SUPPORT_STORAGE 1				// Œ蒷Xg[WT|[g
#define HSPVAR_SUPPORT_FLEXSTORAGE 2			// ϒXg[WT|[g
#define HSPVAR_SUPPORT_FIXEDARRAY 4				// zT|[g
#define HSPVAR_SUPPORT_FLEXARRAY 8				// ϒzT|[g
#define HSPVAR_SUPPORT_ARRAYOBJ 16				// AzzT|[g
#define HSPVAR_SUPPORT_FLEXSIZE 32				// vfƂ̃f[^ϒ
#define HSPVAR_SUPPORT_NOCONVERT 64				// ̌^ϊ𖳌ɂ
#define HSPVAR_SUPPORT_VARUSE 128				// varuse֐̃`FbNLɂ
#define HSPVAR_SUPPORT_TEMPVAR 256				// e|ϐƂĎgp
#define HSPVAR_SUPPORT_USER1 0x4000				// [U[tO1
#define HSPVAR_SUPPORT_USER2 0x8000				// [U[tO2

#define HSPVAR_SUPPORT_MISCTYPE (HSPVAR_SUPPORT_ARRAYOBJ)

typedef void * PDAT;							// f[^̎Ԃւ̃|C^
typedef int APTR;								// zf[^ւ̃ItZbgl

enum
{
CALCCODE_ADD = 0,
CALCCODE_SUB,
CALCCODE_MUL,
CALCCODE_DIV,
CALCCODE_MOD,
CALCCODE_AND,
CALCCODE_OR,
CALCCODE_XOR,
CALCCODE_EQ,
CALCCODE_NE,
CALCCODE_GT,
CALCCODE_LT,
CALCCODE_GTEQ,
CALCCODE_LTEQ,
CALCCODE_RR,
CALCCODE_LR,
CALCCODE_MAX
};

//	PVAL structure
//
typedef struct
{
	//	Memory Data structure (2.5 compatible)
	//
	short	flag;		// type of val
	short	mode;		// mode (0=normal/1=clone/2=alloced)
	int		len[5];		// length of array 4byte align (dim)
	int		size;		// size of Val
	char	*pt;		// ptr to array

	//	Memory Data structure (3.0 compatible)
	//
	void	*master;			// Master pointer for data
	unsigned short	support;	// Support Flag
	short	arraycnt;			// Array Set Count
	int		offset;				// Array Data Offset
	int		arraymul;			// Array Multiple Value 

} PVal;


//		command execute core function
//
typedef struct
{
	//		f[^tB[h
	//
	short flag;							// ^^Cvl (eAvP[VŐݒ肳܂)
	short aftertype;					// Z̃^Cvl
	short version;						// ^^Cv^Co[W(0x100 = 1.0)
	unsigned short support;				// T|[g󋵃tO(HSPVAR_SUPPORT_*)
	short basesize;						// P̃f[^gpTCY(byte) / ϒ̎-1
	short opt;							// (gp)

	char *vartype_name;					// ^^Cvւ̃|C^
	char *user;							// [U[f[^(gp)

	//		VXeQƁE^ϊp
	//
	void *(*Cnv)( const void *buffer, int flag );
	void *(*CnvCustom)( const void *buffer, int flag );
	PDAT *(*GetPtr)( PVal *pval );

	void *(*ArrayObjectRead)( PVal *pval, int *mptype );// zvf̎w (Azz/ǂݏo)
	void (*ArrayObject)( PVal *pval );							// zvf̎w (Azz/ݏ)
	void (*ObjectWrite)( PVal *pval, void *data, int type );		// HSPVAR_SUPPORT_NOCONVERTw莞̑
	void (*ObjectMethod)( PVal *pval );							// ϐɑ΂郁\bh̎w

	void (*Alloc)( PVal *pval, const PVal *pval2 );		// ϐmۂ
	void (*Free)( PVal *pval );						// ϐ

	int (*GetSize)( const PDAT *pdat );			// vfgp郁TCYԂ(ϒ̂)
	int (*GetUsing)( const PDAT *pdat );			// vfgpł邩Ԃ(varuse֐p)

	//		ϐobt@(oCi)̃|C^ƃTCYԂ
	//		(vfϒ(str)̏ꍇ͊YPzoCî)
	//		(vfŒ蒷(int,double)̏ꍇ͑SzoCi)
	//		(TCY̓mۃTCYԂ)
	void *(*GetBlockSize)( PVal *pval, PDAT *pdat, int *size );

	//		oCif[^pɃubNmۂ
	//		(vfϒ(str)̏ꍇɃubNTCYIɊmۂ)
	//		(Œ蒷̏ꍇ͉Ȃ)
	void (*AllocBlock)( PVal *pval, PDAT *pdat, int size );

	//		p֐(^̈vۏႳ܂)
	//
	void (*Set)( PVal *pval, PDAT *pdat, const void *in );

	//		Zp֐(^̈vۏႳ܂)
	//
	void (*AddI)( PDAT *pval, const void *val );
	void (*SubI)( PDAT *pval, const void *val );
	void (*MulI)( PDAT *pval, const void *val );
	void (*DivI)( PDAT *pval, const void *val );
	void (*ModI)( PDAT *pval, const void *val );

	void (*AndI)( PDAT *pval, const void *val );
	void (*OrI)( PDAT *pval, const void *val );
	void (*XorI)( PDAT *pval, const void *val );

	void (*EqI)( PDAT *pval, const void *val );
	void (*NeI)( PDAT *pval, const void *val );
	void (*GtI)( PDAT *pval, const void *val );
	void (*LtI)( PDAT *pval, const void *val );
	void (*GtEqI)( PDAT *pval, const void *val );
	void (*LtEqI)( PDAT *pval, const void *val );

	void (*RrI)( PDAT *pval, const void *val );
	void (*LrI)( PDAT *pval, const void *val );
} HspVarProc;

extern HspVarProc *hspvarproc;
extern int hspvartype_max;

typedef void (* HSPVAR_COREFUNC) (HspVarProc *);

extern PVal *mem_pval;
#define HspVarCoreGetPVal( flag ) (&mem_pval[flag])


//	flex value define
//
#define FLEXVAL_TYPE_NONE 0
#define FLEXVAL_TYPE_ALLOC 1
#define FLEXVAL_TYPE_CLONE 2
typedef struct
{
	short type;			// typeID
	short myid;			// ŗLID(gp)
	short customid;		// structure ID
	short clonetype;	// typeID for clone
	int size;			// data size
	void *ptr;			// data ptr
} FlexValue;


/*
	typefunc

	{^Cv HSPVAR_FLAG_STR ` HSPVAR_FLAG_DOUBLE
	g^Cv HSPVAR_FLAG_USERDEF ȍ~

	̕]pval->ptQƂ邽߁Aɔz0̃|Cgpval->ptwKvB
*/


//		Core System Main Function
//
void HspVarCoreInit( void );
void HspVarCoreBye( void );
void HspVarCoreResetVartype( int expand );
int HspVarCoreAddType();
void HspVarCoreRegisterType( int flag, HSPVAR_COREFUNC func );
HspVarProc *HspVarCoreSeekProc( const char *name );

//		low level support functions
//
void HspVarCoreDup( PVal *pval, PVal *arg, APTR aptr );
void HspVarCoreDupPtr( PVal *pval, int flag, void *ptr, int size );
void HspVarCoreClear( PVal *pval, int flag );
void HspVarCoreClearTemp( PVal *pval, int flag );
void HspVarCoreDim( PVal *pval, int flag, int len1, int len2, int len3, int len4 );
void HspVarCoreDimFlex( PVal *pval, int flag, int len0, int len1, int len2, int len3, int len4 );
void HspVarCoreReDim( PVal *pval, int lenid, int len );
void *HspVarCoreCnvPtr( PVal *pval, int flag );
PDAT *HspVarCorePtrAPTR( PVal *pv, APTR ofs );
void HspVarCoreArray( PVal *pval, int offset );

//		macro for PVal
//
#define HspVarCoreGetProc( flag ) (&hspvarproc[flag])
#define HspVarCoreDispose( pv ) hspvarproc[(pv)->flag].Free(pv)
#define HspVarCoreReset( pv ) ((pv)->offset=0,(pv)->arraycnt=0)
#define HspVarCorePtr( pv ) (hspvarproc[(pv)->flag].GetPtr(pv))
#define HspVarCoreArrayObject( pv,in ) (hspvarproc[(pv)->flag].ArrayObject(pv,in))	//	z̗vfw肷(ŏResetĂł)

#define HspVarCoreSet( pv,in ) hspvarproc[(pv)->flag].Set( pv, in )
#define HspVarCoreCnv( in1,in2,in3 ) hspvarproc[in2].Cnv( in3,in1 )		// in1->in2̌^in3|C^ϊ

#define HspVarCoreGetBlockSize( pv,in1,out ) hspvarproc[(pv)->flag].GetBlockSize( pv,in1,out )
#define HspVarCoreAllocBlock( pv,in1,in2 ) hspvarproc[(pv)->flag].AllocBlock( pv,in1,in2 )
#define HspVarCoreGetUsing( pv,in1 ) hspvarproc[(pv)->flag].GetUsing( in1 )

#define HspVarCoreGetAPTR( pv ) ((pv)->offset)

#define HspVarCoreCopyArrayInfo( pv, src ) (pv)->arraycnt = (src)->arraycnt;(pv)->offset = (src)->offset;(pv)->arraymul = (src)->arraymul;


inline PDAT *HspVarCorePtrAPTR( PVal *pv, APTR ofs )
{
	//		ϐf[^̎ԃ|C^𓾂
	//		(APTRpvalԂ߂)
	//
	pv->offset=ofs;
	return hspvarproc[(pv)->flag].GetPtr(pv);
}




#endif
