////////////////////////////////////////////////////////////////////////////////
//  mod_mmaudio  Windows COMɂI[fBI䃂W[
//               ( Windows Vistaȍ~œ삵܂ )
//               https://codetter.com/?p=633
//               inoviãW[ɍ쐬
//               ̃W[͒NłRɎgpEρEĔzz\ł
//

#module

#define CLSID_IMMDeviceEnumerator	"{BCDE0395-E52F-467C-8E3D-C4579291692E}"
#define IID_IMMDeviceEnumerator		"{A95664D2-9614-4F35-A746-DE8DB63617E6}"
#define IID_IMMDevice				"{D666063F-1587-4E43-81F1-B948E807363F}"
#define IID_IAudioEndpointVolume	"{5CDF2C82-841E-4546-9722-0CF74078229A}"
#define IID_IPerChannelDbLevel		"{C2F8E001-F205-4BC9-99BC-C13B1E048CCB}"
#define IID_IAudioMeterInformation	"{C02216F6-8C67-4B5B-9D00-D008E73E0064}"

#define ERender 0x00000000
#define Console 0x00000000

#usecom IMMDeviceEnumerator		IID_IMMDeviceEnumerator 	CLSID_IMMDeviceEnumerator
#comfunc Enumerator_GetDefaultAudioEndpoint		4 int,int,var
#usecom IMMDevice 				IID_IMMDevice 				CLSID_IMMDeviceEnumerator
#comfunc Device_Activate		3 var,int,int,var
#usecom IAudioEndpointVolume 	IID_IAudioEndpointVolume 	CLSID_IMMDeviceEnumerator
#comfunc Volume_SetMasterVolumeLevelScalar 7 float,var
#comfunc Volume_GetMasterVolumeLevelScalar 9 var
#comfunc Volume_SetMute			14 int,int
#comfunc Volume_GetMute			15 var
#usecom IPerChannelDbLevel 	IID_IPerChannelDbLevel 	CLSID_IMMDeviceEnumerator
#comfunc DbLevel_GetChannelCount 		3 var
#comfunc DbLevel_GetLevelRange			4 int,var,var,var
#comfunc DbLevel_GetLevel				5 int,var
#comfunc DbLevel_SetLevel				6 int,float,int
#comfunc DbLevel_SetLevelUniform		7 float,int
#comfunc DbLevel_SetLevelAllChannels	8 float,int,int
#usecom IAudioMeterInformation 	IID_IAudioMeterInformation 	CLSID_IMMDeviceEnumerator
#comfunc MeterInformation_GetPeakValue					3 var
#comfunc MeterInformation_GetMeteringChannelCount		4 var
#comfunc MeterInformation_GetChannelsPeakValues			5 int,var
#comfunc MeterInformation_QueryHardwareSupport			6 var

#defcfunc todouble int p1
	temp = 0.0
	lpoke temp, 4, (p1 & 0x80000000) | (((p1 & 0x7fffffff) >> 3) + ((p1 & 0x7fffffff) ! 0) * 0x38000000)
	lpoke temp, 0, p1 << 29
return temp

#deffunc _OpenDevice

	pMMDeviceEnumerator=0
	pMMDevice=0
	pAudioEndpointVolume=0
	pAudioMeterInformation=0

	newcom pMMDeviceEnumerator,IMMDeviceEnumerator
	if varuse(pMMDeviceEnumerator) = 0 : _CloseDevice : return -1
	newcom pMMDevice,IMMDevice,-1,0
	newcom pAudioEndpointVolume,IAudioEndpointVolume,-1,0
	newcom pAudioMeterInformation,IAudioMeterInformation,-1,0

	Enumerator_GetDefaultAudioEndpoint pMMDeviceEnumerator,ERender,Console,pMMDevice
	if varuse(pMMDevice) = 0 : _CloseDevice : return -2
	
	guid = 0x5CDF2C82 , 0x4546841E , 0xF70C2297 , 0x9A227840
	Device_Activate pMMDevice,guid,1,0,pAudioEndpointVolume
	
	if varuse(pAudioEndpointVolume) = 0 : _CloseDevice : return -3
	
	guid = 0xC02216F6, 0x4B5B8C67, 0x08D0009D, 0x64003EE7
	Device_Activate pMMDevice,guid,1,0,pAudioMeterInformation
	
	if varuse(pAudioMeterInformation) = 0 : _CloseDevice : return -4
	
return 0

#deffunc _CloseDevice

	if vartype(pAudioMeterInformation) = 6{
		if varuse(pAudioMeterInformation) != 0{
			delcom pAudioMeterInformation
		}
	}
	if vartype(pAudioEndpointVolume) = 6{
		if varuse(pAudioEndpointVolume) != 0{
			delcom pAudioEndpointVolume
		}
	}
	if vartype(pMMDevice) = 6{
		if varuse(pMMDevice) != 0{
			delcom pMMDevice
		}
	}
	if vartype(pMMDeviceEnumerator) = 6{
		if varuse(pMMDeviceEnumerator) != 0{
			delcom pMMDeviceEnumerator
		}
	}
		
	
return

#deffunc SetMasterVolume int vol

	_OpenDevice
	if stat<0 : return stat
	uuid = 0,0,0,0
	Volume_SetMasterVolumeLevelScalar pAudioEndpointVolume,1.0f*(double(vol)/100.0f),uuid
	_CloseDevice
	
return

#defcfunc GetMasterVolume

	_OpenDevice
	if stat<0 : return stat
	
	vol = 0
	Volume_GetMasterVolumeLevelScalar pAudioEndpointVolume,vol
	
	_CloseDevice
	
return int(todouble(vol)*100.0f)

#deffunc SetMute int flag

	_OpenDevice
	if stat<0 : return stat
	Volume_SetMute pAudioEndpointVolume,flag,0
	_CloseDevice
	
return
#defcfunc GetMute

	_OpenDevice
	if stat<0 : return stat
	res = 0
	Volume_GetMute pAudioEndpointVolume,res
	
	_CloseDevice
	
return res

#defcfunc GetPeakValue
	_OpenDevice
	if stat<0 : return stat
	res = 0
	MeterInformation_GetPeakValue pAudioMeterInformation, res
	
	_CloseDevice
return todouble(res)

#deffunc GetChannelsPeakValues array v1, int ch
	_OpenDevice
	if stat<0 : return stat
	dim dres, ch
	MeterInformation_GetChannelsPeakValues pAudioMeterInformation, ch, dres
	repeat ch
		res = dres(cnt)
		v1(cnt)=todouble(res)
	loop
	_CloseDevice
return 0

#defcfunc GetMeteringChannelCount
	_OpenDevice
	if stat<0 : return stat
	res = 0
	MeterInformation_GetMeteringChannelCount pAudioMeterInformation, res
	
	_CloseDevice
return res

#global

