//
//	ios Bridge for HGIMG4
//

#include <stdio.h>
#include <math.h>

#import <UIKit/UIKit.h>
#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>
#import <QuartzCore/CAEAGLLayer.h>

#import "iOSgpBridge.h"

#include "../hsp3/hsp3config.h"
#include "../hsp3dish/hgio.h"

#include "../hsp3/supio.h"
#include "../hsp3dish/sysreq.h"


/*------------------------------------------------------------*/
/*
		interface
*/
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*
 file I/O service
 */
/*------------------------------------------------------------*/

static  char fpath_tmp[1024];

char *gb_filepath( char *base )
{
    NSString *fname = [[NSString alloc] initWithUTF8String:base];
    NSString *path = [[NSBundle mainBundle] pathForResource:fname ofType:nil inDirectory:nil];
    if ( path ) {
        sprintf( fpath_tmp, "%s", [path cStringUsingEncoding:1] );
    } else {
        fpath_tmp[0] = 0;
    }
    [fname release];
    return fpath_tmp;
}


int gb_existdata(char* key)
{
    NSString *nskey = [[NSString alloc] initWithUTF8String:key];
    NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
    NSData* nsdata = [defaults dataForKey:nskey];
    [nskey release];
    if(nsdata) {
        int sizeorg = [nsdata length];
        return sizeorg;
    }
    return -1;
}


int gb_loaddata( char* key, char* data, int size, int offset )
{
    NSString *nskey = [[NSString alloc] initWithUTF8String:key];
    NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
    NSData* nsdata = [defaults dataForKey:nskey];
    [nskey release];
    if(nsdata) {
        int sizeorg = [nsdata length];
        if ( sizeorg > (size+offset) ) sizeorg = size-offset;
        unsigned char *dataorg = (unsigned char *)[nsdata bytes];
        memcpy( data, dataorg+offset, sizeorg );
        Alertf( "loaddata: %s,%d,%d", key, sizeorg, offset );
        return 0;
    }
    return -1;
}


void gb_savedata(char* key, char* data, int size, int offset)
{
    int orgsize;
    unsigned char* datatmp;
    NSString *nskey = [[NSString alloc] initWithUTF8String:key];
    NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
    
    if ( offset <= 0 ) {
        orgsize = size;
        datatmp = new unsigned char[size];
        memcpy(datatmp, data, size);
    } else {
        orgsize = gb_existdata(key);
        if ( orgsize <= 0 ) orgsize = size + offset;
        if ( orgsize < (offset+size) ) orgsize = size + offset;
        datatmp = new unsigned char[orgsize];

        gb_loaddata( key, (char *)datatmp, orgsize, 0 );
        
        memcpy( datatmp+offset, data, size );
    }
    
    NSData* nsdata = [NSData dataWithBytes:datatmp length:orgsize];
    [defaults setObject:nsdata forKey:nskey];
    [defaults synchronize];
    
    Alertf( "savedata: %s,%d,%d", key, size, offset);
    
    delete datatmp;
    
    [nskey release];
}


int gb_dialog( int type, char *msg, char *msg_sub )
{
    //Alertf( "dialog: %s,%d", msg, type);
    //[hspview dispDialog:type Msg:msg MsgSub:msg_sub];
    return 0;
}

int gb_exec( int type, char *name )
{
    NSString *fname = [[NSString alloc] initWithUTF8String:name];
    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:fname]];
    [fname release];
    return 0;
}

void gb_nslog( char *msg )
{
    NSString *fname = [[NSString alloc] initWithUTF8String:msg];
    NSLog(fname);
    [fname release];
}

void gb_getSysModel( char *outbuf )
{
    NSString *dev = [[UIDevice currentDevice]model];
    sprintf( outbuf, "%s", [dev cStringUsingEncoding:1] );
}

void gb_getSysVer( char *outbuf )
{
    NSString *version = [[UIDevice currentDevice]systemVersion];
    sprintf( outbuf, "iOS %s", [version cStringUsingEncoding:1] );
}


void gb_getLocale( char *outbuf )
{
    NSLocale *locale = [NSLocale currentLocale];
    NSString *locstr = [locale objectForKey:NSLocaleLanguageCode];
    sprintf( outbuf, "%s", [locstr cStringUsingEncoding:1] );
    //NSLog( @"------%s",outbuf );
}



static int mestext_sx;
static int mestext_sy;

void gpb_textsize( char *msg, int fontsize, int fontstyle, int *out_x, int *out_y )
{
	NSString *text = [[NSString alloc] initWithUTF8String:msg];

	UIFont *font = [UIFont systemFontOfSize:fontsize];
    CGSize size=[text sizeWithFont:font constrainedToSize:CGSizeMake(1024,CGFLOAT_MAX)
    lineBreakMode:NSLineBreakByWordWrapping];
	mestext_sx = size.width;
	mestext_sy = size.height;
	*out_x = mestext_sx;
	*out_y = mestext_sy;
}


void gpb_textbitmap( char *msg, int fontsize, int fontstyle, char *buffer, int pitch )
{
	NSString *text = [[NSString alloc] initWithUTF8String:msg];
	UIFont *font = [UIFont systemFontOfSize:fontsize];

    //ラベルの生成
    UILabel* label=[[[UILabel alloc] init] autorelease]; 
	CGSize size=[text sizeWithFont:font constrainedToSize:CGSizeMake(1024,CGFLOAT_MAX)
        lineBreakMode:NSLineBreakByWordWrapping];

	mestext_sx = size.width;
	mestext_sy = size.height;

    [label setFrame:CGRectMake(0,0,size.width,size.height)];
    [label setText:text];
    [label setFont:font];
    //[label setTextColor:color];
    [label setTextAlignment:NSTextAlignmentLeft];
    //[label setBackgroundColor:bgcolor];
    [label setNumberOfLines:0];

    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    CGContextRef context = CGBitmapContextCreate(buffer,
                                             pitch,
                                             mestext_sy,
                                             8,
                                             4 * pitch,
                                             colorSpace,
                                             kCGImageAlphaPremultipliedFirst);

    //コンテキストの設定
    UIGraphicsPushContext(context);
    CGContextTranslateCTM(context,0,mestext_sy);
    CGContextScaleCTM(context,1,-1);    
    
    //ラベルの描画
    [label.layer renderInContext:context];
    
    //コンテキストの設定解放
    UIGraphicsPopContext();
    
    //コンテキストの解放
    CGColorSpaceRelease(colorSpace);
    CGContextRelease(context);
}


