/**
 * @license
 * Copyright (C) 1997-, Onion Software/onitama.
 * Copyright (C) 2014-, zakki, K-s.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.  Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution.  Neither the name of the Onion Software nor the names
 * of its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 **/
var Module=typeof Module!="undefined"?Module:{};var ENVIRONMENT_IS_WEB=typeof window=="object";var ENVIRONMENT_IS_WORKER=typeof WorkerGlobalScope!="undefined";var ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string"&&process.type!="renderer";if(ENVIRONMENT_IS_NODE){}var moduleOverrides=Object.assign({},Module);var arguments_=[];var thisProgram="./this.program";var quit_=(status,toThrow)=>{throw toThrow};var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}return scriptDirectory+path}var readAsync,readBinary;if(ENVIRONMENT_IS_NODE){var fs=require("fs");var nodePath=require("path");scriptDirectory=__dirname+"/";readBinary=filename=>{filename=isFileURI(filename)?new URL(filename):filename;var ret=fs.readFileSync(filename);return ret};readAsync=async(filename,binary=true)=>{filename=isFileURI(filename)?new URL(filename):filename;var ret=fs.readFileSync(filename,binary?undefined:"utf8");return ret};if(!Module["thisProgram"]&&process.argv.length>1){thisProgram=process.argv[1].replace(/\\/g,"/")}arguments_=process.argv.slice(2);if(typeof module!="undefined"){module["exports"]=Module}quit_=(status,toThrow)=>{process.exitCode=status;throw toThrow}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(typeof document!="undefined"&&document.currentScript){scriptDirectory=document.currentScript.src}if(scriptDirectory.startsWith("blob:")){scriptDirectory=""}else{scriptDirectory=scriptDirectory.substr(0,scriptDirectory.replace(/[?#].*/,"").lastIndexOf("/")+1)}{if(ENVIRONMENT_IS_WORKER){readBinary=url=>{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}}readAsync=async url=>{if(isFileURI(url)){return new Promise((resolve,reject)=>{var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=()=>{if(xhr.status==200||xhr.status==0&&xhr.response){resolve(xhr.response);return}reject(xhr.status)};xhr.onerror=reject;xhr.send(null)})}var response=await fetch(url,{credentials:"same-origin"});if(response.ok){return response.arrayBuffer()}throw new Error(response.status+" : "+response.url)}}}else{}var out=Module["print"]||console.log.bind(console);var err=Module["printErr"]||console.error.bind(console);Object.assign(Module,moduleOverrides);moduleOverrides=null;if(Module["arguments"])arguments_=Module["arguments"];if(Module["thisProgram"])thisProgram=Module["thisProgram"];var wasmBinary=Module["wasmBinary"];var wasmMemory;var ABORT=false;var EXITSTATUS;function assert(condition,text){if(!condition){abort(text)}}var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateMemoryViews(){var b=wasmMemory.buffer;Module["HEAP8"]=HEAP8=new Int8Array(b);Module["HEAP16"]=HEAP16=new Int16Array(b);Module["HEAPU8"]=HEAPU8=new Uint8Array(b);Module["HEAPU16"]=HEAPU16=new Uint16Array(b);Module["HEAP32"]=HEAP32=new Int32Array(b);Module["HEAPU32"]=HEAPU32=new Uint32Array(b);Module["HEAPF32"]=HEAPF32=new Float32Array(b);Module["HEAPF64"]=HEAPF64=new Float64Array(b)}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;if(!Module["noFSInit"]&&!FS.initialized)FS.init();FS.ignorePermissions=false;TTY.init();callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnInit(cb){__ATINIT__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var runDependencies=0;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;Module["monitorRunDependencies"]?.(runDependencies)}function removeRunDependency(id){runDependencies--;Module["monitorRunDependencies"]?.(runDependencies);if(runDependencies==0){if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}function abort(what){Module["onAbort"]?.(what);what="Aborted("+what+")";err(what);ABORT=true;what+=". Build with -sASSERTIONS for more info.";var e=new WebAssembly.RuntimeError(what);throw e}var dataURIPrefix="data:application/octet-stream;base64,";var isDataURI=filename=>filename.startsWith(dataURIPrefix);var isFileURI=filename=>filename.startsWith("file://");function findWasmBinary(){var f="hsp3dish.wasm";if(!isDataURI(f)){return locateFile(f)}return f}var wasmBinaryFile;function getBinarySync(file){if(file==wasmBinaryFile&&wasmBinary){return new Uint8Array(wasmBinary)}if(readBinary){return readBinary(file)}throw"both async and sync fetching of the wasm failed"}async function getWasmBinary(binaryFile){if(!wasmBinary){try{var response=await readAsync(binaryFile);return new Uint8Array(response)}catch{}}return getBinarySync(binaryFile)}async function instantiateArrayBuffer(binaryFile,imports){try{var binary=await getWasmBinary(binaryFile);var instance=await WebAssembly.instantiate(binary,imports);return instance}catch(reason){err(`failed to asynchronously prepare wasm: ${reason}`);abort(reason)}}async function instantiateAsync(binary,binaryFile,imports){if(!binary&&typeof WebAssembly.instantiateStreaming=="function"&&!isDataURI(binaryFile)&&!isFileURI(binaryFile)&&!ENVIRONMENT_IS_NODE&&typeof fetch=="function"){try{var response=fetch(binaryFile,{credentials:"same-origin"});var instantiationResult=await WebAssembly.instantiateStreaming(response,imports);return instantiationResult}catch(reason){err(`wasm streaming compile failed: ${reason}`);err("falling back to ArrayBuffer instantiation")}}return instantiateArrayBuffer(binaryFile,imports)}function getWasmImports(){return{a:wasmImports}}async function createWasm(){function receiveInstance(instance,module){wasmExports=instance.exports;wasmMemory=wasmExports["_f"];updateMemoryViews();wasmTable=wasmExports["ag"];addOnInit(wasmExports["$f"]);removeRunDependency("wasm-instantiate");return wasmExports}addRunDependency("wasm-instantiate");function receiveInstantiationResult(result){receiveInstance(result["instance"])}var info=getWasmImports();if(Module["instantiateWasm"]){try{return Module["instantiateWasm"](info,receiveInstance)}catch(e){err(`Module.instantiateWasm callback failed with error: ${e}`);return false}}wasmBinaryFile??=findWasmBinary();var result=await instantiateAsync(wasmBinary,wasmBinaryFile,info);receiveInstantiationResult(result);return result}var tempDouble;var tempI64;var ASM_CONSTS={342924:($0,$1)=>{if($1>=16){window.open(UTF8ToString($0))}else{window.eval(UTF8ToString($0))}},343015:($0,$1,$2,$3,$4)=>{let d=document.getElementById("hsp3dishFontDiv");if(!d){d=document.createElement("div");d.id="hsp3dishFontDiv";d.style.setProperty("width","auto");d.style.setProperty("height","auto");d.style.setProperty("position","absolute");d.style.setProperty("visibility","hidden");d.style.setProperty("top","0");d.style.setProperty("left","0");document.body.appendChild(d)}d.style.setProperty("font",$1+"px 'sans-serif'");d.innerText=UTF8ToString($0);HEAP32[$2>>2]=d.clientWidth|0;HEAP32[$3>>2]=d.clientHeight|0;let canvas=document.getElementById("hsp3dishFontCanvas");if(!canvas){canvas=document.createElement("canvas");canvas.id="hsp3dishFontCanvas";canvas.style.setProperty("visibility","hidden");document.body.appendChild(canvas)}if($4!=0){const context=canvas.getContext("2d");context.font=$1+"px 'sans-serif'";const msg=UTF8ToString($0);const metrics=context.measureText(msg);const arr=Array.from(msg);for(let i=0;i<msg.length;i++){const sub=arr.slice(0,i+1).join("");const m=context.measureText(sub);HEAP16[($4>>1)+i+1]=m.width|0}}},344165:($0,$1,$2,$3,$4)=>{var canvas=document.getElementById("hsp3dishFontCanvas");if(!canvas){canvas=document.createElement("canvas");canvas.id="hsp3dishFontCanvas";canvas.style.setProperty("visibility","hidden");canvas.style.setProperty("position","absolute");canvas.style.setProperty("top","0");canvas.style.setProperty("left","0");canvas.width=$2;canvas.height=$3;document.body.appendChild(canvas)}if(canvas.width<$2)canvas.width=$2;if(canvas.height<$3)canvas.height=$3;var context=canvas.getContext("2d",{willReadFrequently:true});context.font=$1+"px 'sans-serif'";var msg=UTF8ToString($0);context.clearRect(0,0,Math.min(canvas.width,$2+1),Math.min(canvas.height,$3+1));context.fillStyle="rgba(255, 255, 255, 255)";context.fillText(msg,0,$1);var imageData=context.getImageData(0,0,$2,$3);HEAPU8.set(imageData.data,$4)},345048:$0=>{alert(UTF8ToString($0))},345077:$0=>{var dir=UTF8ToString($0);FS.mkdir(dir);FS.mount(IDBFS,{},dir);FS.syncfs(true,function(err){console.log(err);ccall("hsp3dish_sync_done","v","",[])})},345247:$0=>{var dir=UTF8ToString($0);FS.syncfs(function(err){console.log("syncfs",err)})},345338:()=>{Module.canvas.focus()},345365:$0=>{console.log(UTF8ToString($0))},345400:$0=>{console.log(UTF8ToString($0))},345435:$0=>{console.log(UTF8ToString($0))},345470:()=>{if(typeof AudioContext!=="undefined"){return true}else if(typeof webkitAudioContext!=="undefined"){return true}return false},345617:()=>{if(typeof navigator.mediaDevices!=="undefined"&&typeof navigator.mediaDevices.getUserMedia!=="undefined"){return true}else if(typeof navigator.webkitGetUserMedia!=="undefined"){return true}return false},345851:$0=>{if(typeof Module["SDL2"]==="undefined"){Module["SDL2"]={}}var SDL2=Module["SDL2"];if(!$0){SDL2.audio={}}else{SDL2.capture={}}if(!SDL2.audioContext){if(typeof AudioContext!=="undefined"){SDL2.audioContext=new AudioContext}else if(typeof webkitAudioContext!=="undefined"){SDL2.audioContext=new webkitAudioContext}if(SDL2.audioContext){if(typeof navigator.userActivation==="undefined"){autoResumeAudioContext(SDL2.audioContext)}}}return SDL2.audioContext===undefined?-1:0},346403:()=>{var SDL2=Module["SDL2"];return SDL2.audioContext.sampleRate},346471:($0,$1,$2,$3)=>{var SDL2=Module["SDL2"];var have_microphone=function(stream){if(SDL2.capture.silenceTimer!==undefined){clearInterval(SDL2.capture.silenceTimer);SDL2.capture.silenceTimer=undefined;SDL2.capture.silenceBuffer=undefined}SDL2.capture.mediaStreamNode=SDL2.audioContext.createMediaStreamSource(stream);SDL2.capture.scriptProcessorNode=SDL2.audioContext.createScriptProcessor($1,$0,1);SDL2.capture.scriptProcessorNode.onaudioprocess=function(audioProcessingEvent){if(SDL2===undefined||SDL2.capture===undefined){return}audioProcessingEvent.outputBuffer.getChannelData(0).fill(0);SDL2.capture.currentCaptureBuffer=audioProcessingEvent.inputBuffer;dynCall("vi",$2,[$3])};SDL2.capture.mediaStreamNode.connect(SDL2.capture.scriptProcessorNode);SDL2.capture.scriptProcessorNode.connect(SDL2.audioContext.destination);SDL2.capture.stream=stream};var no_microphone=function(error){};SDL2.capture.silenceBuffer=SDL2.audioContext.createBuffer($0,$1,SDL2.audioContext.sampleRate);SDL2.capture.silenceBuffer.getChannelData(0).fill(0);var silence_callback=function(){SDL2.capture.currentCaptureBuffer=SDL2.capture.silenceBuffer;dynCall("vi",$2,[$3])};SDL2.capture.silenceTimer=setInterval(silence_callback,$1/SDL2.audioContext.sampleRate*1e3);if(navigator.mediaDevices!==undefined&&navigator.mediaDevices.getUserMedia!==undefined){navigator.mediaDevices.getUserMedia({audio:true,video:false}).then(have_microphone).catch(no_microphone)}else if(navigator.webkitGetUserMedia!==undefined){navigator.webkitGetUserMedia({audio:true,video:false},have_microphone,no_microphone)}},348164:($0,$1,$2,$3)=>{var SDL2=Module["SDL2"];SDL2.audio.scriptProcessorNode=SDL2.audioContext["createScriptProcessor"]($1,0,$0);SDL2.audio.scriptProcessorNode["onaudioprocess"]=function(e){if(SDL2===undefined||SDL2.audio===undefined){return}if(SDL2.audio.silenceTimer!==undefined){clearInterval(SDL2.audio.silenceTimer);SDL2.audio.silenceTimer=undefined;SDL2.audio.silenceBuffer=undefined}SDL2.audio.currentOutputBuffer=e["outputBuffer"];dynCall("vi",$2,[$3])};SDL2.audio.scriptProcessorNode["connect"](SDL2.audioContext["destination"]);if(SDL2.audioContext.state==="suspended"){SDL2.audio.silenceBuffer=SDL2.audioContext.createBuffer($0,$1,SDL2.audioContext.sampleRate);SDL2.audio.silenceBuffer.getChannelData(0).fill(0);var silence_callback=function(){if(typeof navigator.userActivation!=="undefined"){if(navigator.userActivation.hasBeenActive){SDL2.audioContext.resume()}}SDL2.audio.currentOutputBuffer=SDL2.audio.silenceBuffer;dynCall("vi",$2,[$3]);SDL2.audio.currentOutputBuffer=undefined};SDL2.audio.silenceTimer=setInterval(silence_callback,$1/SDL2.audioContext.sampleRate*1e3)}},349339:($0,$1)=>{var SDL2=Module["SDL2"];var numChannels=SDL2.capture.currentCaptureBuffer.numberOfChannels;for(var c=0;c<numChannels;++c){var channelData=SDL2.capture.currentCaptureBuffer.getChannelData(c);if(channelData.length!=$1){throw"Web Audio capture buffer length mismatch! Destination size: "+channelData.length+" samples vs expected "+$1+" samples!"}if(numChannels==1){for(var j=0;j<$1;++j){setValue($0+j*4,channelData[j],"float")}}else{for(var j=0;j<$1;++j){setValue($0+(j*numChannels+c)*4,channelData[j],"float")}}}},349944:($0,$1)=>{var SDL2=Module["SDL2"];var buf=$0>>>2;var numChannels=SDL2.audio.currentOutputBuffer["numberOfChannels"];for(var c=0;c<numChannels;++c){var channelData=SDL2.audio.currentOutputBuffer["getChannelData"](c);if(channelData.length!=$1){throw"Web Audio output buffer length mismatch! Destination size: "+channelData.length+" samples vs expected "+$1+" samples!"}for(var j=0;j<$1;++j){channelData[j]=HEAPF32[buf+(j*numChannels+c)]}}},350433:$0=>{var SDL2=Module["SDL2"];if($0){if(SDL2.capture.silenceTimer!==undefined){clearInterval(SDL2.capture.silenceTimer)}if(SDL2.capture.stream!==undefined){var tracks=SDL2.capture.stream.getAudioTracks();for(var i=0;i<tracks.length;i++){SDL2.capture.stream.removeTrack(tracks[i])}}if(SDL2.capture.scriptProcessorNode!==undefined){SDL2.capture.scriptProcessorNode.onaudioprocess=function(audioProcessingEvent){};SDL2.capture.scriptProcessorNode.disconnect()}if(SDL2.capture.mediaStreamNode!==undefined){SDL2.capture.mediaStreamNode.disconnect()}SDL2.capture=undefined}else{if(SDL2.audio.scriptProcessorNode!=undefined){SDL2.audio.scriptProcessorNode.disconnect()}if(SDL2.audio.silenceTimer!==undefined){clearInterval(SDL2.audio.silenceTimer)}SDL2.audio=undefined}if(SDL2.audioContext!==undefined&&SDL2.audio===undefined&&SDL2.capture===undefined){SDL2.audioContext.close();SDL2.audioContext=undefined}},351439:($0,$1,$2)=>{var w=$0;var h=$1;var pixels=$2;if(!Module["SDL2"])Module["SDL2"]={};var SDL2=Module["SDL2"];if(SDL2.ctxCanvas!==Module["canvas"]){SDL2.ctx=Module["createContext"](Module["canvas"],false,true);SDL2.ctxCanvas=Module["canvas"]}if(SDL2.w!==w||SDL2.h!==h||SDL2.imageCtx!==SDL2.ctx){SDL2.image=SDL2.ctx.createImageData(w,h);SDL2.w=w;SDL2.h=h;SDL2.imageCtx=SDL2.ctx}var data=SDL2.image.data;var src=pixels/4;var dst=0;var num;if(typeof CanvasPixelArray!=="undefined"&&data instanceof CanvasPixelArray){num=data.length;while(dst<num){var val=HEAP32[src];data[dst]=val&255;data[dst+1]=val>>8&255;data[dst+2]=val>>16&255;data[dst+3]=255;src++;dst+=4}}else{if(SDL2.data32Data!==data){SDL2.data32=new Int32Array(data.buffer);SDL2.data8=new Uint8Array(data.buffer);SDL2.data32Data=data}var data32=SDL2.data32;num=data32.length;data32.set(HEAP32.subarray(src,src+num));var data8=SDL2.data8;var i=3;var j=i+4*num;if(num%8==0){while(i<j){data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0;data8[i]=255;i=i+4|0}}else{while(i<j){data8[i]=255;i=i+4|0}}}SDL2.ctx.putImageData(SDL2.image,0,0)},352907:($0,$1,$2,$3,$4)=>{var w=$0;var h=$1;var hot_x=$2;var hot_y=$3;var pixels=$4;var canvas=document.createElement("canvas");canvas.width=w;canvas.height=h;var ctx=canvas.getContext("2d");var image=ctx.createImageData(w,h);var data=image.data;var src=pixels/4;var dst=0;var num;if(typeof CanvasPixelArray!=="undefined"&&data instanceof CanvasPixelArray){num=data.length;while(dst<num){var val=HEAP32[src];data[dst]=val&255;data[dst+1]=val>>8&255;data[dst+2]=val>>16&255;data[dst+3]=val>>24&255;src++;dst+=4}}else{var data32=new Int32Array(data.buffer);num=data32.length;data32.set(HEAP32.subarray(src,src+num))}ctx.putImageData(image,0,0);var url=hot_x===0&&hot_y===0?"url("+canvas.toDataURL()+"), auto":"url("+canvas.toDataURL()+") "+hot_x+" "+hot_y+", auto";var urlBuf=_malloc(url.length+1);stringToUTF8(url,urlBuf,url.length+1);return urlBuf},353895:$0=>{if(Module["canvas"]){Module["canvas"].style["cursor"]=UTF8ToString($0)}},353978:()=>{if(Module["canvas"]){Module["canvas"].style["cursor"]="none"}},354047:()=>window.innerWidth,354077:()=>window.innerHeight};class ExitStatus{name="ExitStatus";constructor(status){this.message=`Program terminated with exit(${status})`;this.status=status}}var callRuntimeCallbacks=callbacks=>{while(callbacks.length>0){callbacks.shift()(Module)}};var noExitRuntime=Module["noExitRuntime"]||true;function setValue(ptr,value,type="i8"){if(type.endsWith("*"))type="*";switch(type){case"i1":HEAP8[ptr]=value;break;case"i8":HEAP8[ptr]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":abort("to do setValue(i64) use WASM_BIGINT");case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;case"*":HEAPU32[ptr>>2]=value;break;default:abort(`invalid type for setValue: ${type}`)}}var stackRestore=val=>__emscripten_stack_restore(val);var stackSave=()=>_emscripten_stack_get_current();var exceptionCaught=[];var uncaughtExceptionCount=0;var ___cxa_begin_catch=ptr=>{var info=new ExceptionInfo(ptr);if(!info.get_caught()){info.set_caught(true);uncaughtExceptionCount--}info.set_rethrown(false);exceptionCaught.push(info);___cxa_increment_exception_refcount(ptr);return ___cxa_get_exception_ptr(ptr)};var exceptionLast=0;var ___cxa_end_catch=()=>{_setThrew(0,0);var info=exceptionCaught.pop();___cxa_decrement_exception_refcount(info.excPtr);exceptionLast=0};class ExceptionInfo{constructor(excPtr){this.excPtr=excPtr;this.ptr=excPtr-24}set_type(type){HEAPU32[this.ptr+4>>2]=type}get_type(){return HEAPU32[this.ptr+4>>2]}set_destructor(destructor){HEAPU32[this.ptr+8>>2]=destructor}get_destructor(){return HEAPU32[this.ptr+8>>2]}set_caught(caught){caught=caught?1:0;HEAP8[this.ptr+12]=caught}get_caught(){return HEAP8[this.ptr+12]!=0}set_rethrown(rethrown){rethrown=rethrown?1:0;HEAP8[this.ptr+13]=rethrown}get_rethrown(){return HEAP8[this.ptr+13]!=0}init(type,destructor){this.set_adjusted_ptr(0);this.set_type(type);this.set_destructor(destructor)}set_adjusted_ptr(adjustedPtr){HEAPU32[this.ptr+16>>2]=adjustedPtr}get_adjusted_ptr(){return HEAPU32[this.ptr+16>>2]}}var ___resumeException=ptr=>{if(!exceptionLast){exceptionLast=ptr}throw exceptionLast};var setTempRet0=val=>__emscripten_tempret_set(val);var findMatchingCatch=args=>{var thrown=exceptionLast;if(!thrown){setTempRet0(0);return 0}var info=new ExceptionInfo(thrown);info.set_adjusted_ptr(thrown);var thrownType=info.get_type();if(!thrownType){setTempRet0(0);return thrown}for(var caughtType of args){if(caughtType===0||caughtType===thrownType){break}var adjusted_ptr_addr=info.ptr+16;if(___cxa_can_catch(caughtType,thrownType,adjusted_ptr_addr)){setTempRet0(caughtType);return thrown}}setTempRet0(thrownType);return thrown};var ___cxa_find_matching_catch_2=()=>findMatchingCatch([]);var ___cxa_find_matching_catch_3=arg0=>findMatchingCatch([arg0]);var ___cxa_find_matching_catch_4=(arg0,arg1)=>findMatchingCatch([arg0,arg1]);var ___cxa_throw=(ptr,type,destructor)=>{var info=new ExceptionInfo(ptr);info.init(type,destructor);exceptionLast=ptr;uncaughtExceptionCount++;throw exceptionLast};var PATH={isAbs:path=>path.charAt(0)==="/",splitPath:filename=>{var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)},normalizeArray:(parts,allowAboveRoot)=>{var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts},normalize:path=>{var isAbsolute=PATH.isAbs(path),trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter(p=>!!p),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path},dirname:path=>{var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir},basename:path=>{if(path==="/")return"/";path=PATH.normalize(path);path=path.replace(/\/$/,"");var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)},join:(...paths)=>PATH.normalize(paths.join("/")),join2:(l,r)=>PATH.normalize(l+"/"+r)};var initRandomFill=()=>{if(typeof crypto=="object"&&typeof crypto["getRandomValues"]=="function"){return view=>crypto.getRandomValues(view)}else if(ENVIRONMENT_IS_NODE){try{var crypto_module=require("crypto");var randomFillSync=crypto_module["randomFillSync"];if(randomFillSync){return view=>crypto_module["randomFillSync"](view)}var randomBytes=crypto_module["randomBytes"];return view=>(view.set(randomBytes(view.byteLength)),view)}catch(e){}}abort("initRandomDevice")};var randomFill=view=>(randomFill=initRandomFill())(view);var PATH_FS={resolve:(...args)=>{var resolvedPath="",resolvedAbsolute=false;for(var i=args.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?args[i]:FS.cwd();if(typeof path!="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=PATH.isAbs(path)}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter(p=>!!p),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."},relative:(from,to)=>{from=PATH_FS.resolve(from).substr(1);to=PATH_FS.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")}};var UTF8Decoder=typeof TextDecoder!="undefined"?new TextDecoder:undefined;var UTF8ArrayToString=(heapOrArray,idx=0,maxBytesToRead=NaN)=>{var endIdx=idx+maxBytesToRead;var endPtr=idx;while(heapOrArray[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&heapOrArray.buffer&&UTF8Decoder){return UTF8Decoder.decode(heapOrArray.subarray(idx,endPtr))}var str="";while(idx<endPtr){var u0=heapOrArray[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=heapOrArray[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=heapOrArray[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|heapOrArray[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}return str};var FS_stdin_getChar_buffer=[];var lengthBytesUTF8=str=>{var len=0;for(var i=0;i<str.length;++i){var c=str.charCodeAt(i);if(c<=127){len++}else if(c<=2047){len+=2}else if(c>=55296&&c<=57343){len+=4;++i}else{len+=3}}return len};var stringToUTF8Array=(str,heap,outIdx,maxBytesToWrite)=>{if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;heap[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;heap[outIdx++]=192|u>>6;heap[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;heap[outIdx++]=224|u>>12;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}else{if(outIdx+3>=endIdx)break;heap[outIdx++]=240|u>>18;heap[outIdx++]=128|u>>12&63;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}}heap[outIdx]=0;return outIdx-startIdx};function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}var FS_stdin_getChar=()=>{if(!FS_stdin_getChar_buffer.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=Buffer.alloc(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;try{bytesRead=fs.readSync(fd,buf,0,BUFSIZE)}catch(e){if(e.toString().includes("EOF"))bytesRead=0;else throw e}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else{}if(!result){return null}FS_stdin_getChar_buffer=intArrayFromString(result,true)}return FS_stdin_getChar_buffer.shift()};var TTY={ttys:[],init(){},shutdown(){},register(dev,ops){TTY.ttys[dev]={input:[],output:[],ops};FS.registerDevice(dev,TTY.stream_ops)},stream_ops:{open(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(43)}stream.tty=tty;stream.seekable=false},close(stream){stream.tty.ops.fsync(stream.tty)},fsync(stream){stream.tty.ops.fsync(stream.tty)},read(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(60)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.atime=Date.now()}return bytesRead},write(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(60)}try{for(var i=0;i<length;i++){stream.tty.ops.put_char(stream.tty,buffer[offset+i])}}catch(e){throw new FS.ErrnoError(29)}if(length){stream.node.mtime=stream.node.ctime=Date.now()}return i}},default_tty_ops:{get_char(tty){return FS_stdin_getChar()},put_char(tty,val){if(val===null||val===10){out(UTF8ArrayToString(tty.output));tty.output=[]}else{if(val!=0)tty.output.push(val)}},fsync(tty){if(tty.output&&tty.output.length>0){out(UTF8ArrayToString(tty.output));tty.output=[]}},ioctl_tcgets(tty){return{c_iflag:25856,c_oflag:5,c_cflag:191,c_lflag:35387,c_cc:[3,28,127,21,4,0,1,0,17,19,26,0,18,15,23,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}},ioctl_tcsets(tty,optional_actions,data){return 0},ioctl_tiocgwinsz(tty){return[24,80]}},default_tty1_ops:{put_char(tty,val){if(val===null||val===10){err(UTF8ArrayToString(tty.output));tty.output=[]}else{if(val!=0)tty.output.push(val)}},fsync(tty){if(tty.output&&tty.output.length>0){err(UTF8ArrayToString(tty.output));tty.output=[]}}}};var alignMemory=(size,alignment)=>Math.ceil(size/alignment)*alignment;var mmapAlloc=size=>{abort()};var MEMFS={ops_table:null,mount(mount){return MEMFS.createNode(null,"/",16895,0)},createNode(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(63)}MEMFS.ops_table||={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}};var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.atime=node.mtime=node.ctime=Date.now();if(parent){parent.contents[name]=node;parent.atime=parent.mtime=parent.ctime=node.atime}return node},getFileDataAsTypedArray(node){if(!node.contents)return new Uint8Array(0);if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)},expandFileStorage(node,newCapacity){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)>>>0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0)},resizeFileStorage(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0}else{var oldContents=node.contents;node.contents=new Uint8Array(newSize);if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize}},node_ops:{getattr(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.atime);attr.mtime=new Date(node.mtime);attr.ctime=new Date(node.ctime);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr},setattr(node,attr){for(const key of["mode","atime","mtime","ctime"]){if(attr[key]){node[key]=attr[key]}}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}},lookup(parent,name){throw MEMFS.doesNotExistError},mknod(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)},rename(old_node,new_dir,new_name){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){if(FS.isDir(old_node.mode)){for(var i in new_node.contents){throw new FS.ErrnoError(55)}}FS.hashRemoveNode(new_node)}delete old_node.parent.contents[old_node.name];new_dir.contents[new_name]=old_node;old_node.name=new_name;new_dir.ctime=new_dir.mtime=old_node.parent.ctime=old_node.parent.mtime=Date.now()},unlink(parent,name){delete parent.contents[name];parent.ctime=parent.mtime=Date.now()},rmdir(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(55)}delete parent.contents[name];parent.ctime=parent.mtime=Date.now()},readdir(node){return[".","..",...Object.keys(node.contents)]},symlink(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node},readlink(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(28)}return node.link}},stream_ops:{read(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size},write(stream,buffer,offset,length,position,canOwn){if(buffer.buffer===HEAP8.buffer){canOwn=false}if(!length)return 0;var node=stream.node;node.mtime=node.ctime=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=buffer.slice(offset,offset+length);node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray){node.contents.set(buffer.subarray(offset,offset+length),position)}else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length},llseek(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(28)}return position},allocate(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)},mmap(stream,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&contents&&contents.buffer===HEAP8.buffer){allocated=false;ptr=contents.byteOffset}else{allocated=true;ptr=mmapAlloc(length);if(!ptr){throw new FS.ErrnoError(48)}if(contents){if(position>0||position+length<contents.length){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}HEAP8.set(contents,ptr)}}return{ptr,allocated}},msync(stream,buffer,offset,length,mmapFlags){MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0}}};var asyncLoad=async url=>{var arrayBuffer=await readAsync(url);return new Uint8Array(arrayBuffer)};var FS_createDataFile=(parent,name,fileData,canRead,canWrite,canOwn)=>{FS.createDataFile(parent,name,fileData,canRead,canWrite,canOwn)};var preloadPlugins=Module["preloadPlugins"]||[];var FS_handledByPreloadPlugin=(byteArray,fullname,finish,onerror)=>{if(typeof Browser!="undefined")Browser.init();var handled=false;preloadPlugins.forEach(plugin=>{if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,onerror);handled=true}});return handled};var FS_createPreloadedFile=(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish)=>{var fullname=name?PATH_FS.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency(`cp ${fullname}`);function processData(byteArray){function finish(byteArray){preFinish?.();if(!dontCreateFile){FS_createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}onload?.();removeRunDependency(dep)}if(FS_handledByPreloadPlugin(byteArray,fullname,finish,()=>{onerror?.();removeRunDependency(dep)})){return}finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){asyncLoad(url).then(processData,onerror)}else{processData(url)}};var FS_modeStringToFlags=str=>{var flagModes={r:0,"r+":2,w:512|64|1,"w+":512|64|2,a:1024|64|1,"a+":1024|64|2};var flags=flagModes[str];if(typeof flags=="undefined"){throw new Error(`Unknown file open mode: ${str}`)}return flags};var FS_getMode=(canRead,canWrite)=>{var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode};var IDBFS={dbs:{},indexedDB:()=>{if(typeof indexedDB!="undefined")return indexedDB;var ret=null;if(typeof window=="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;return ret},DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",queuePersist:mount=>{function onPersistComplete(){if(mount.idbPersistState==="again")startPersist();else mount.idbPersistState=0}function startPersist(){mount.idbPersistState="idb";IDBFS.syncfs(mount,false,onPersistComplete)}if(!mount.idbPersistState){mount.idbPersistState=setTimeout(startPersist,0)}else if(mount.idbPersistState==="idb"){mount.idbPersistState="again"}},mount:mount=>{var mnt=MEMFS.mount(mount);if(mount?.opts?.autoPersist){mnt.idbPersistState=0;var memfs_node_ops=mnt.node_ops;mnt.node_ops=Object.assign({},mnt.node_ops);mnt.node_ops.mknod=(parent,name,mode,dev)=>{var node=memfs_node_ops.mknod(parent,name,mode,dev);node.node_ops=mnt.node_ops;node.idbfs_mount=mnt.mount;node.memfs_stream_ops=node.stream_ops;node.stream_ops=Object.assign({},node.stream_ops);node.stream_ops.write=(stream,buffer,offset,length,position,canOwn)=>{stream.node.isModified=true;return node.memfs_stream_ops.write(stream,buffer,offset,length,position,canOwn)};node.stream_ops.close=stream=>{var n=stream.node;if(n.isModified){IDBFS.queuePersist(n.idbfs_mount);n.isModified=false}if(n.memfs_stream_ops.close)return n.memfs_stream_ops.close(stream)};return node};mnt.node_ops.mkdir=(...args)=>(IDBFS.queuePersist(mnt.mount),memfs_node_ops.mkdir(...args));mnt.node_ops.rmdir=(...args)=>(IDBFS.queuePersist(mnt.mount),memfs_node_ops.rmdir(...args));mnt.node_ops.symlink=(...args)=>(IDBFS.queuePersist(mnt.mount),memfs_node_ops.symlink(...args));mnt.node_ops.unlink=(...args)=>(IDBFS.queuePersist(mnt.mount),memfs_node_ops.unlink(...args));mnt.node_ops.rename=(...args)=>(IDBFS.queuePersist(mnt.mount),memfs_node_ops.rename(...args))}return mnt},syncfs:(mount,populate,callback)=>{IDBFS.getLocalSet(mount,(err,local)=>{if(err)return callback(err);IDBFS.getRemoteSet(mount,(err,remote)=>{if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)})})},quit:()=>{Object.values(IDBFS.dbs).forEach(value=>value.close());IDBFS.dbs={}},getDB:(name,callback)=>{var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}if(!req){return callback("Unable to connect to IndexedDB")}req.onupgradeneeded=e=>{var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}};req.onsuccess=()=>{db=req.result;IDBFS.dbs[name]=db;callback(null,db)};req.onerror=e=>{callback(e.target.error);e.preventDefault()}},getLocalSet:(mount,callback)=>{var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return p=>PATH.join2(root,p)}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push(...FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries})},getRemoteSet:(mount,callback)=>{var entries={};IDBFS.getDB(mount.mountpoint,(err,db)=>{if(err)return callback(err);try{var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=e=>{callback(e.target.error);e.preventDefault()};var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=event=>{var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db,entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()}}catch(e){return callback(e)}})},loadLocalEntry:(path,callback)=>{var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}},storeLocalEntry:(path,entry,callback)=>{try{if(FS.isDir(entry["mode"])){FS.mkdirTree(path,entry["mode"])}else if(FS.isFile(entry["mode"])){FS.writeFile(path,entry["contents"],{canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry["mode"]);FS.utime(path,entry["timestamp"],entry["timestamp"])}catch(e){return callback(e)}callback(null)},removeLocalEntry:(path,callback)=>{try{var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)},loadRemoteEntry:(store,path,callback)=>{var req=store.get(path);req.onsuccess=event=>callback(null,event.target.result);req.onerror=e=>{callback(e.target.error);e.preventDefault()}},storeRemoteEntry:(store,path,entry,callback)=>{try{var req=store.put(entry,path)}catch(e){callback(e);return}req.onsuccess=event=>callback();req.onerror=e=>{callback(e.target.error);e.preventDefault()}},removeRemoteEntry:(store,path,callback)=>{var req=store.delete(path);req.onsuccess=event=>callback();req.onerror=e=>{callback(e.target.error);e.preventDefault()}},reconcile:(src,dst,callback)=>{var total=0;var create=[];Object.keys(src.entries).forEach(key=>{var e=src.entries[key];var e2=dst.entries[key];if(!e2||e["timestamp"].getTime()!=e2["timestamp"].getTime()){create.push(key);total++}});var remove=[];Object.keys(dst.entries).forEach(key=>{if(!src.entries[key]){remove.push(key);total++}});if(!total){return callback(null)}var errored=false;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err&&!errored){errored=true;return callback(err)}}transaction.onerror=transaction.onabort=e=>{done(e.target.error);e.preventDefault()};transaction.oncomplete=e=>{if(!errored){callback(null)}};create.sort().forEach(path=>{if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(err,entry)=>{if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)})}else{IDBFS.loadLocalEntry(path,(err,entry)=>{if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)})}});remove.sort().reverse().forEach(path=>{if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}})}};var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:class{name="ErrnoError";constructor(errno){this.errno=errno}},filesystems:null,syncFSRequests:0,readFiles:{},FSStream:class{shared={};get object(){return this.node}set object(val){this.node=val}get isRead(){return(this.flags&2097155)!==1}get isWrite(){return(this.flags&2097155)!==0}get isAppend(){return this.flags&1024}get flags(){return this.shared.flags}set flags(val){this.shared.flags=val}get position(){return this.shared.position}set position(val){this.shared.position=val}},FSNode:class{node_ops={};stream_ops={};readMode=292|73;writeMode=146;mounted=null;constructor(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.rdev=rdev;this.atime=this.mtime=this.ctime=Date.now()}get read(){return(this.mode&this.readMode)===this.readMode}set read(val){val?this.mode|=this.readMode:this.mode&=~this.readMode}get write(){return(this.mode&this.writeMode)===this.writeMode}set write(val){val?this.mode|=this.writeMode:this.mode&=~this.writeMode}get isFolder(){return FS.isDir(this.mode)}get isDevice(){return FS.isChrdev(this.mode)}},lookupPath(path,opts={}){if(!path)return{path:"",node:null};opts.follow_mount??=true;if(!PATH.isAbs(path)){path=FS.cwd()+"/"+path}linkloop:for(var nlinks=0;nlinks<40;nlinks++){var parts=path.split("/").filter(p=>!!p&&p!==".");var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}if(parts[i]===".."){current_path=PATH.dirname(current_path);current=current.parent;continue}current_path=PATH.join2(current_path,parts[i]);try{current=FS.lookupNode(current,parts[i])}catch(e){if(e?.errno===44&&islast&&opts.noent_okay){return{path:current_path}}throw e}if(FS.isMountpoint(current)&&(!islast||opts.follow_mount)){current=current.mounted.root}if(FS.isLink(current.mode)&&(!islast||opts.follow)){if(!current.node_ops.readlink){throw new FS.ErrnoError(52)}var link=current.node_ops.readlink(current);if(!PATH.isAbs(link)){link=PATH.dirname(current_path)+"/"+link}path=link+"/"+parts.slice(i+1).join("/");continue linkloop}}return{path:current_path,node:current}}throw new FS.ErrnoError(32)},getPath(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?`${mount}/${path}`:mount+path}path=path?`${node.name}/${path}`:node.name;node=node.parent}},hashName(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length},hashAddNode(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node},hashRemoveNode(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}},lookupNode(parent,name){var errCode=FS.mayLookup(parent);if(errCode){throw new FS.ErrnoError(errCode)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)},createNode(parent,name,mode,rdev){var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node},destroyNode(node){FS.hashRemoveNode(node)},isRoot(node){return node===node.parent},isMountpoint(node){return!!node.mounted},isFile(mode){return(mode&61440)===32768},isDir(mode){return(mode&61440)===16384},isLink(mode){return(mode&61440)===40960},isChrdev(mode){return(mode&61440)===8192},isBlkdev(mode){return(mode&61440)===24576},isFIFO(mode){return(mode&61440)===4096},isSocket(mode){return(mode&49152)===49152},flagsToPermissionString(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms},nodePermissions(node,perms){if(FS.ignorePermissions){return 0}if(perms.includes("r")&&!(node.mode&292)){return 2}else if(perms.includes("w")&&!(node.mode&146)){return 2}else if(perms.includes("x")&&!(node.mode&73)){return 2}return 0},mayLookup(dir){if(!FS.isDir(dir.mode))return 54;var errCode=FS.nodePermissions(dir,"x");if(errCode)return errCode;if(!dir.node_ops.lookup)return 2;return 0},mayCreate(dir,name){if(!FS.isDir(dir.mode)){return 54}try{var node=FS.lookupNode(dir,name);return 20}catch(e){}return FS.nodePermissions(dir,"wx")},mayDelete(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var errCode=FS.nodePermissions(dir,"wx");if(errCode){return errCode}if(isdir){if(!FS.isDir(node.mode)){return 54}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return 10}}else{if(FS.isDir(node.mode)){return 31}}return 0},mayOpen(node,flags){if(!node){return 44}if(FS.isLink(node.mode)){return 32}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return 31}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))},MAX_OPEN_FDS:4096,nextfd(){for(var fd=0;fd<=FS.MAX_OPEN_FDS;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(33)},getStreamChecked(fd){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(8)}return stream},getStream:fd=>FS.streams[fd],createStream(stream,fd=-1){stream=Object.assign(new FS.FSStream,stream);if(fd==-1){fd=FS.nextfd()}stream.fd=fd;FS.streams[fd]=stream;return stream},closeStream(fd){FS.streams[fd]=null},dupStream(origStream,fd=-1){var stream=FS.createStream(origStream,fd);stream.stream_ops?.dup?.(stream);return stream},chrdev_stream_ops:{open(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;stream.stream_ops.open?.(stream)},llseek(){throw new FS.ErrnoError(70)}},major:dev=>dev>>8,minor:dev=>dev&255,makedev:(ma,mi)=>ma<<8|mi,registerDevice(dev,ops){FS.devices[dev]={stream_ops:ops}},getDevice:dev=>FS.devices[dev],getMounts(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push(...m.mounts)}return mounts},syncfs(populate,callback){if(typeof populate=="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){err(`warning: ${FS.syncFSRequests} FS.syncfs operations in flight at once, probably just doing extra work`)}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(errCode){FS.syncFSRequests--;return callback(errCode)}function done(errCode){if(errCode){if(!done.errored){done.errored=true;return doCallback(errCode)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach(mount=>{if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)})},mount(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(10)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}}var mount={type,opts,mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot},unmount(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(28)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach(hash=>{var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.includes(current.mount)){FS.destroyNode(current)}current=next}});node.mounted=null;var idx=node.mount.mounts.indexOf(mount);node.mount.mounts.splice(idx,1)},lookup(parent,name){return parent.node_ops.lookup(parent,name)},mknod(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(28)}var errCode=FS.mayCreate(parent,name);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(63)}return parent.node_ops.mknod(parent,name,mode,dev)},statfs(path){var rtn={bsize:4096,frsize:4096,blocks:1e6,bfree:5e5,bavail:5e5,files:FS.nextInode,ffree:FS.nextInode-1,fsid:42,flags:2,namelen:255};var parent=FS.lookupPath(path,{follow:true}).node;if(parent?.node_ops.statfs){Object.assign(rtn,parent.node_ops.statfs(parent.mount.opts.root))}return rtn},create(path,mode=438){mode&=4095;mode|=32768;return FS.mknod(path,mode,0)},mkdir(path,mode=511){mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)},mkdirTree(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=20)throw e}}},mkdev(path,mode,dev){if(typeof dev=="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)},symlink(oldpath,newpath){if(!PATH_FS.resolve(oldpath)){throw new FS.ErrnoError(44)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(44)}var newname=PATH.basename(newpath);var errCode=FS.mayCreate(parent,newname);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(63)}return parent.node_ops.symlink(parent,newname,oldpath)},rename(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node;if(!old_dir||!new_dir)throw new FS.ErrnoError(44);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(75)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH_FS.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(28)}relative=PATH_FS.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(55)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var errCode=FS.mayDelete(old_dir,old_name,isdir);if(errCode){throw new FS.ErrnoError(errCode)}errCode=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(errCode){throw new FS.ErrnoError(errCode)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(63)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(10)}if(new_dir!==old_dir){errCode=FS.nodePermissions(old_dir,"w");if(errCode){throw new FS.ErrnoError(errCode)}}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name);old_node.parent=new_dir}catch(e){throw e}finally{FS.hashAddNode(old_node)}},rmdir(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,true);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node)},readdir(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(54)}return node.node_ops.readdir(node)},unlink(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(44)}var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,false);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}parent.node_ops.unlink(parent,name);FS.destroyNode(node)},readlink(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(44)}if(!link.node_ops.readlink){throw new FS.ErrnoError(28)}return link.node_ops.readlink(link)},stat(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(44)}if(!node.node_ops.getattr){throw new FS.ErrnoError(63)}return node.node_ops.getattr(node)},lstat(path){return FS.stat(path,true)},chmod(path,mode,dontFollow){var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,ctime:Date.now()})},lchmod(path,mode){FS.chmod(path,mode,true)},fchmod(fd,mode){var stream=FS.getStreamChecked(fd);FS.chmod(stream.node,mode)},chown(path,uid,gid,dontFollow){var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}node.node_ops.setattr(node,{timestamp:Date.now()})},lchown(path,uid,gid){FS.chown(path,uid,gid,true)},fchown(fd,uid,gid){var stream=FS.getStreamChecked(fd);FS.chown(stream.node,uid,gid)},truncate(path,len){if(len<0){throw new FS.ErrnoError(28)}var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(31)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(28)}var errCode=FS.nodePermissions(node,"w");if(errCode){throw new FS.ErrnoError(errCode)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})},ftruncate(fd,len){var stream=FS.getStreamChecked(fd);if((stream.flags&2097155)===0){throw new FS.ErrnoError(28)}FS.truncate(stream.node,len)},utime(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{atime,mtime})},open(path,flags,mode=438){if(path===""){throw new FS.ErrnoError(44)}flags=typeof flags=="string"?FS_modeStringToFlags(flags):flags;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path=="object"){node=path}else{var lookup=FS.lookupPath(path,{follow:!(flags&131072),noent_okay:true});node=lookup.node;path=lookup.path}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(20)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(44)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}if(!created){var errCode=FS.mayOpen(node,flags);if(errCode){throw new FS.ErrnoError(errCode)}}if(flags&512&&!created){FS.truncate(node,0)}flags&=~(128|512|131072);var stream=FS.createStream({node,path:FS.getPath(node),flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false});if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!(path in FS.readFiles)){FS.readFiles[path]=1}}return stream},close(stream){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}stream.fd=null},isClosed(stream){return stream.fd===null},llseek(stream,offset,whence){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(70)}if(whence!=0&&whence!=1&&whence!=2){throw new FS.ErrnoError(28)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position},read(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.read){throw new FS.ErrnoError(28)}var seeking=typeof position!="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead},write(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.write){throw new FS.ErrnoError(28)}if(stream.seekable&&stream.flags&1024){FS.llseek(stream,0,2)}var seeking=typeof position!="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;return bytesWritten},allocate(stream,offset,length){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(offset<0||length<=0){throw new FS.ErrnoError(28)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(43)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(138)}stream.stream_ops.allocate(stream,offset,length)},mmap(stream,length,position,prot,flags){if((prot&2)!==0&&(flags&2)===0&&(stream.flags&2097155)!==2){throw new FS.ErrnoError(2)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(2)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(43)}if(!length){throw new FS.ErrnoError(28)}return stream.stream_ops.mmap(stream,length,position,prot,flags)},msync(stream,buffer,offset,length,mmapFlags){if(!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)},ioctl(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(59)}return stream.stream_ops.ioctl(stream,cmd,arg)},readFile(path,opts={}){opts.flags=opts.flags||0;opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error(`Invalid encoding type "${opts.encoding}"`)}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret},writeFile(path,data,opts={}){opts.flags=opts.flags||577;var stream=FS.open(path,opts.flags,opts.mode);if(typeof data=="string"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,undefined,opts.canOwn)}else if(ArrayBuffer.isView(data)){FS.write(stream,data,0,data.byteLength,undefined,opts.canOwn)}else{throw new Error("Unsupported data type")}FS.close(stream)},cwd:()=>FS.currentPath,chdir(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(44)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(54)}var errCode=FS.nodePermissions(lookup.node,"x");if(errCode){throw new FS.ErrnoError(errCode)}FS.currentPath=lookup.path},createDefaultDirectories(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")},createDefaultDevices(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:()=>0,write:(stream,buffer,offset,length,pos)=>length,llseek:()=>0});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var randomBuffer=new Uint8Array(1024),randomLeft=0;var randomByte=()=>{if(randomLeft===0){randomLeft=randomFill(randomBuffer).byteLength}return randomBuffer[--randomLeft]};FS.createDevice("/dev","random",randomByte);FS.createDevice("/dev","urandom",randomByte);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")},createSpecialDirectories(){FS.mkdir("/proc");var proc_self=FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount(){var node=FS.createNode(proc_self,"fd",16895,73);node.stream_ops={llseek:MEMFS.stream_ops.llseek};node.node_ops={lookup(parent,name){var fd=+name;var stream=FS.getStreamChecked(fd);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:()=>stream.path},id:fd+1};ret.parent=ret;return ret},readdir(){return Array.from(FS.streams.entries()).filter(([k,v])=>v).map(([k,v])=>k.toString())}};return node}},{},"/proc/self/fd")},createStandardStreams(input,output,error){if(input){FS.createDevice("/dev","stdin",input)}else{FS.symlink("/dev/tty","/dev/stdin")}if(output){FS.createDevice("/dev","stdout",null,output)}else{FS.symlink("/dev/tty","/dev/stdout")}if(error){FS.createDevice("/dev","stderr",null,error)}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin",0);var stdout=FS.open("/dev/stdout",1);var stderr=FS.open("/dev/stderr",1)},staticInit(){FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={MEMFS,IDBFS}},init(input,output,error){FS.initialized=true;input??=Module["stdin"];output??=Module["stdout"];error??=Module["stderr"];FS.createStandardStreams(input,output,error)},quit(){FS.initialized=false;for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}},findObject(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(!ret.exists){return null}return ret.object},analyzePath(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret},createPath(parent,path,canRead,canWrite){parent=typeof parent=="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current},createFile(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent=="string"?parent:FS.getPath(parent),name);var mode=FS_getMode(canRead,canWrite);return FS.create(path,mode)},createDataFile(parent,name,data,canRead,canWrite,canOwn){var path=name;if(parent){parent=typeof parent=="string"?parent:FS.getPath(parent);path=name?PATH.join2(parent,name):parent}var mode=FS_getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data=="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,577);FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}},createDevice(parent,name,input,output){var path=PATH.join2(typeof parent=="string"?parent:FS.getPath(parent),name);var mode=FS_getMode(!!input,!!output);FS.createDevice.major??=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open(stream){stream.seekable=false},close(stream){if(output?.buffer?.length){output(10)}},read(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.atime=Date.now()}return bytesRead},write(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(29)}}if(length){stream.node.mtime=stream.node.ctime=Date.now()}return i}});return FS.mkdev(path,mode,dev)},forceLoadFile(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;if(typeof XMLHttpRequest!="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else{try{obj.contents=readBinary(obj.url);obj.usedBytes=obj.contents.length}catch(e){throw new FS.ErrnoError(29)}}},createLazyFile(parent,name,url,canRead,canWrite){class LazyUint8Array{lengthKnown=false;chunks=[];get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]}setDataGetter(getter){this.getter=getter}cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(from,to)=>{if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}return intArrayFromString(xhr.responseText||"",true)};var lazyArray=this;lazyArray.setDataGetter(chunkNum=>{var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]=="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]=="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]});if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;out("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true}get length(){if(!this.lengthKnown){this.cacheLength()}return this._length}get chunkSize(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize}}if(typeof XMLHttpRequest!="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:function(){return this.contents.length}}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach(key=>{var fn=node.stream_ops[key];stream_ops[key]=(...args)=>{FS.forceLoadFile(node);return fn(...args)}});function writeChunks(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size}stream_ops.read=(stream,buffer,offset,length,position)=>{FS.forceLoadFile(node);return writeChunks(stream,buffer,offset,length,position)};stream_ops.mmap=(stream,length,position,prot,flags)=>{FS.forceLoadFile(node);var ptr=mmapAlloc(length);if(!ptr){throw new FS.ErrnoError(48)}writeChunks(stream,HEAP8,ptr,length,position);return{ptr,allocated:true}};node.stream_ops=stream_ops;return node}};var UTF8ToString=(ptr,maxBytesToRead)=>ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):"";var SYSCALLS={DEFAULT_POLLMASK:5,calculateAt(dirfd,path,allowEmpty){if(PATH.isAbs(path)){return path}var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=SYSCALLS.getStreamFromFD(dirfd);dir=dirstream.path}if(path.length==0){if(!allowEmpty){throw new FS.ErrnoError(44)}return dir}return dir+"/"+path},doStat(func,path,buf){var stat=func(path);HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=stat.mode;HEAPU32[buf+8>>2]=stat.nlink;HEAP32[buf+12>>2]=stat.uid;HEAP32[buf+16>>2]=stat.gid;HEAP32[buf+20>>2]=stat.rdev;tempI64=[stat.size>>>0,(tempDouble=stat.size,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+24>>2]=tempI64[0],HEAP32[buf+28>>2]=tempI64[1];HEAP32[buf+32>>2]=4096;HEAP32[buf+36>>2]=stat.blocks;var atime=stat.atime.getTime();var mtime=stat.mtime.getTime();var ctime=stat.ctime.getTime();tempI64=[Math.floor(atime/1e3)>>>0,(tempDouble=Math.floor(atime/1e3),+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+40>>2]=tempI64[0],HEAP32[buf+44>>2]=tempI64[1];HEAPU32[buf+48>>2]=atime%1e3*1e3*1e3;tempI64=[Math.floor(mtime/1e3)>>>0,(tempDouble=Math.floor(mtime/1e3),+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+56>>2]=tempI64[0],HEAP32[buf+60>>2]=tempI64[1];HEAPU32[buf+64>>2]=mtime%1e3*1e3*1e3;tempI64=[Math.floor(ctime/1e3)>>>0,(tempDouble=Math.floor(ctime/1e3),+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+72>>2]=tempI64[0],HEAP32[buf+76>>2]=tempI64[1];HEAPU32[buf+80>>2]=ctime%1e3*1e3*1e3;tempI64=[stat.ino>>>0,(tempDouble=stat.ino,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+88>>2]=tempI64[0],HEAP32[buf+92>>2]=tempI64[1];return 0},doMsync(addr,stream,len,flags,offset){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}if(flags&2){return 0}var buffer=HEAPU8.slice(addr,addr+len);FS.msync(stream,buffer,offset,len,flags)},getStreamFromFD(fd){var stream=FS.getStreamChecked(fd);return stream},varargs:undefined,getStr(ptr){var ret=UTF8ToString(ptr);return ret}};var ___syscall__newselect=function(nfds,readfds,writefds,exceptfds,timeout){try{var total=0;var srcReadLow=readfds?HEAP32[readfds>>2]:0,srcReadHigh=readfds?HEAP32[readfds+4>>2]:0;var srcWriteLow=writefds?HEAP32[writefds>>2]:0,srcWriteHigh=writefds?HEAP32[writefds+4>>2]:0;var srcExceptLow=exceptfds?HEAP32[exceptfds>>2]:0,srcExceptHigh=exceptfds?HEAP32[exceptfds+4>>2]:0;var dstReadLow=0,dstReadHigh=0;var dstWriteLow=0,dstWriteHigh=0;var dstExceptLow=0,dstExceptHigh=0;var allLow=(readfds?HEAP32[readfds>>2]:0)|(writefds?HEAP32[writefds>>2]:0)|(exceptfds?HEAP32[exceptfds>>2]:0);var allHigh=(readfds?HEAP32[readfds+4>>2]:0)|(writefds?HEAP32[writefds+4>>2]:0)|(exceptfds?HEAP32[exceptfds+4>>2]:0);var check=(fd,low,high,val)=>fd<32?low&val:high&val;for(var fd=0;fd<nfds;fd++){var mask=1<<fd%32;if(!check(fd,allLow,allHigh,mask)){continue}var stream=SYSCALLS.getStreamFromFD(fd);var flags=SYSCALLS.DEFAULT_POLLMASK;if(stream.stream_ops.poll){var timeoutInMillis=-1;if(timeout){var tv_sec=readfds?HEAP32[timeout>>2]:0,tv_usec=readfds?HEAP32[timeout+4>>2]:0;timeoutInMillis=(tv_sec+tv_usec/1e6)*1e3}flags=stream.stream_ops.poll(stream,timeoutInMillis)}if(flags&1&&check(fd,srcReadLow,srcReadHigh,mask)){fd<32?dstReadLow=dstReadLow|mask:dstReadHigh=dstReadHigh|mask;total++}if(flags&4&&check(fd,srcWriteLow,srcWriteHigh,mask)){fd<32?dstWriteLow=dstWriteLow|mask:dstWriteHigh=dstWriteHigh|mask;total++}if(flags&2&&check(fd,srcExceptLow,srcExceptHigh,mask)){fd<32?dstExceptLow=dstExceptLow|mask:dstExceptHigh=dstExceptHigh|mask;total++}}if(readfds){HEAP32[readfds>>2]=dstReadLow;HEAP32[readfds+4>>2]=dstReadHigh}if(writefds){HEAP32[writefds>>2]=dstWriteLow;HEAP32[writefds+4>>2]=dstWriteHigh}if(exceptfds){HEAP32[exceptfds>>2]=dstExceptLow;HEAP32[exceptfds+4>>2]=dstExceptHigh}return total}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}};function ___syscall_chdir(path){try{path=SYSCALLS.getStr(path);FS.chdir(path);return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}var syscallGetVarargI=()=>{var ret=HEAP32[+SYSCALLS.varargs>>2];SYSCALLS.varargs+=4;return ret};var syscallGetVarargP=syscallGetVarargI;function ___syscall_fcntl64(fd,cmd,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(cmd){case 0:{var arg=syscallGetVarargI();if(arg<0){return-28}while(FS.streams[arg]){arg++}var newStream;newStream=FS.dupStream(stream,arg);return newStream.fd}case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=syscallGetVarargI();stream.flags|=arg;return 0}case 12:{var arg=syscallGetVarargP();var offset=0;HEAP16[arg+offset>>1]=2;return 0}case 13:case 14:return 0}return-28}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_fstat64(fd,buf){try{var stream=SYSCALLS.getStreamFromFD(fd);return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}var stringToUTF8=(str,outPtr,maxBytesToWrite)=>stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite);function ___syscall_getcwd(buf,size){try{if(size===0)return-28;var cwd=FS.cwd();var cwdLengthInBytes=lengthBytesUTF8(cwd)+1;if(size<cwdLengthInBytes)return-68;stringToUTF8(cwd,buf,size);return cwdLengthInBytes}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_getdents64(fd,dirp,count){try{var stream=SYSCALLS.getStreamFromFD(fd);stream.getdents||=FS.readdir(stream.path);var struct_size=280;var pos=0;var off=FS.llseek(stream,0,1);var startIdx=Math.floor(off/struct_size);var endIdx=Math.min(stream.getdents.length,startIdx+Math.floor(count/struct_size));for(var idx=startIdx;idx<endIdx;idx++){var id;var type;var name=stream.getdents[idx];if(name==="."){id=stream.node.id;type=4}else if(name===".."){var lookup=FS.lookupPath(stream.path,{parent:true});id=lookup.node.id;type=4}else{var child;try{child=FS.lookupNode(stream.node,name)}catch(e){if(e?.errno===28){continue}throw e}id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}tempI64=[id>>>0,(tempDouble=id,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[dirp+pos>>2]=tempI64[0],HEAP32[dirp+pos+4>>2]=tempI64[1];tempI64=[(idx+1)*struct_size>>>0,(tempDouble=(idx+1)*struct_size,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[dirp+pos+8>>2]=tempI64[0],HEAP32[dirp+pos+12>>2]=tempI64[1];HEAP16[dirp+pos+16>>1]=280;HEAP8[dirp+pos+18]=type;stringToUTF8(name,dirp+pos+19,256);pos+=struct_size}FS.llseek(stream,idx*struct_size,0);return pos}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_ioctl(fd,op,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(op){case 21509:{if(!stream.tty)return-59;return 0}case 21505:{if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tcgets){var termios=stream.tty.ops.ioctl_tcgets(stream);var argp=syscallGetVarargP();HEAP32[argp>>2]=termios.c_iflag||0;HEAP32[argp+4>>2]=termios.c_oflag||0;HEAP32[argp+8>>2]=termios.c_cflag||0;HEAP32[argp+12>>2]=termios.c_lflag||0;for(var i=0;i<32;i++){HEAP8[argp+i+17]=termios.c_cc[i]||0}return 0}return 0}case 21510:case 21511:case 21512:{if(!stream.tty)return-59;return 0}case 21506:case 21507:case 21508:{if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tcsets){var argp=syscallGetVarargP();var c_iflag=HEAP32[argp>>2];var c_oflag=HEAP32[argp+4>>2];var c_cflag=HEAP32[argp+8>>2];var c_lflag=HEAP32[argp+12>>2];var c_cc=[];for(var i=0;i<32;i++){c_cc.push(HEAP8[argp+i+17])}return stream.tty.ops.ioctl_tcsets(stream.tty,op,{c_iflag,c_oflag,c_cflag,c_lflag,c_cc})}return 0}case 21519:{if(!stream.tty)return-59;var argp=syscallGetVarargP();HEAP32[argp>>2]=0;return 0}case 21520:{if(!stream.tty)return-59;return-28}case 21531:{var argp=syscallGetVarargP();return FS.ioctl(stream,op,argp)}case 21523:{if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tiocgwinsz){var winsize=stream.tty.ops.ioctl_tiocgwinsz(stream.tty);var argp=syscallGetVarargP();HEAP16[argp>>1]=winsize[0];HEAP16[argp+2>>1]=winsize[1]}return 0}case 21524:{if(!stream.tty)return-59;return 0}case 21515:{if(!stream.tty)return-59;return 0}default:return-28}}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_lstat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.doStat(FS.lstat,path,buf)}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_mkdirat(dirfd,path,mode){try{path=SYSCALLS.getStr(path);path=SYSCALLS.calculateAt(dirfd,path);FS.mkdir(path,mode,0);return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_newfstatat(dirfd,path,buf,flags){try{path=SYSCALLS.getStr(path);var nofollow=flags&256;var allowEmpty=flags&4096;flags=flags&~6400;path=SYSCALLS.calculateAt(dirfd,path,allowEmpty);return SYSCALLS.doStat(nofollow?FS.lstat:FS.stat,path,buf)}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_openat(dirfd,path,flags,varargs){SYSCALLS.varargs=varargs;try{path=SYSCALLS.getStr(path);path=SYSCALLS.calculateAt(dirfd,path);var mode=varargs?syscallGetVarargI():0;return FS.open(path,flags,mode).fd}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_stat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_unlinkat(dirfd,path,flags){try{path=SYSCALLS.getStr(path);path=SYSCALLS.calculateAt(dirfd,path);if(flags===0){FS.unlink(path)}else if(flags===512){FS.rmdir(path)}else{abort("Invalid flags passed to unlinkat")}return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}var __abort_js=()=>abort("");var __emscripten_memcpy_js=(dest,src,num)=>HEAPU8.copyWithin(dest,src,src+num);var isLeapYear=year=>year%4===0&&(year%100!==0||year%400===0);var MONTH_DAYS_LEAP_CUMULATIVE=[0,31,60,91,121,152,182,213,244,274,305,335];var MONTH_DAYS_REGULAR_CUMULATIVE=[0,31,59,90,120,151,181,212,243,273,304,334];var ydayFromDate=date=>{var leap=isLeapYear(date.getFullYear());var monthDaysCumulative=leap?MONTH_DAYS_LEAP_CUMULATIVE:MONTH_DAYS_REGULAR_CUMULATIVE;var yday=monthDaysCumulative[date.getMonth()]+date.getDate()-1;return yday};var convertI32PairToI53Checked=(lo,hi)=>hi+2097152>>>0<4194305-!!lo?(lo>>>0)+hi*4294967296:NaN;function __localtime_js(time_low,time_high,tmPtr){var time=convertI32PairToI53Checked(time_low,time_high);var date=new Date(time*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var yday=ydayFromDate(date)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var start=new Date(date.getFullYear(),0,1);var summerOffset=new Date(date.getFullYear(),6,1).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=(summerOffset!=winterOffset&&date.getTimezoneOffset()==Math.min(winterOffset,summerOffset))|0;HEAP32[tmPtr+32>>2]=dst}var __tzset_js=(timezone,daylight,std_name,dst_name)=>{var currentYear=(new Date).getFullYear();var winter=new Date(currentYear,0,1);var summer=new Date(currentYear,6,1);var winterOffset=winter.getTimezoneOffset();var summerOffset=summer.getTimezoneOffset();var stdTimezoneOffset=Math.max(winterOffset,summerOffset);HEAPU32[timezone>>2]=stdTimezoneOffset*60;HEAP32[daylight>>2]=Number(winterOffset!=summerOffset);var extractZone=timezoneOffset=>{var sign=timezoneOffset>=0?"-":"+";var absOffset=Math.abs(timezoneOffset);var hours=String(Math.floor(absOffset/60)).padStart(2,"0");var minutes=String(absOffset%60).padStart(2,"0");return`UTC${sign}${hours}${minutes}`};var winterName=extractZone(winterOffset);var summerName=extractZone(summerOffset);if(summerOffset<winterOffset){stringToUTF8(winterName,std_name,17);stringToUTF8(summerName,dst_name,17)}else{stringToUTF8(winterName,dst_name,17);stringToUTF8(summerName,std_name,17)}};var _emscripten_get_now=()=>performance.now();var _emscripten_date_now=()=>Date.now();var nowIsMonotonic=1;var checkWasiClock=clock_id=>clock_id>=0&&clock_id<=3;function _clock_time_get(clk_id,ignored_precision_low,ignored_precision_high,ptime){var ignored_precision=convertI32PairToI53Checked(ignored_precision_low,ignored_precision_high);if(!checkWasiClock(clk_id)){return 28}var now;if(clk_id===0){now=_emscripten_date_now()}else if(nowIsMonotonic){now=_emscripten_get_now()}else{return 52}var nsec=Math.round(now*1e3*1e3);tempI64=[nsec>>>0,(tempDouble=nsec,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[ptime>>2]=tempI64[0],HEAP32[ptime+4>>2]=tempI64[1];return 0}var handleException=e=>{if(e instanceof ExitStatus||e=="unwind"){return EXITSTATUS}quit_(1,e)};var runtimeKeepaliveCounter=0;var keepRuntimeAlive=()=>noExitRuntime||runtimeKeepaliveCounter>0;var _proc_exit=code=>{EXITSTATUS=code;if(!keepRuntimeAlive()){Module["onExit"]?.(code);ABORT=true}quit_(code,new ExitStatus(code))};var exitJS=(status,implicit)=>{EXITSTATUS=status;_proc_exit(status)};var _exit=exitJS;var maybeExit=()=>{if(!keepRuntimeAlive()){try{_exit(EXITSTATUS)}catch(e){handleException(e)}}};var callUserCallback=func=>{if(ABORT){return}try{func();maybeExit()}catch(e){handleException(e)}};var safeSetTimeout=(func,timeout)=>setTimeout(()=>{callUserCallback(func)},timeout);var warnOnce=text=>{warnOnce.shown||={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;if(ENVIRONMENT_IS_NODE)text="warning: "+text;err(text)}};var Browser={useWebGL:false,isFullscreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],preloadedImages:{},preloadedAudios:{},init(){if(Browser.initted)return;Browser.initted=true;var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module["noImageDecoding"]&&/\.(jpg|jpeg|png|bmp|webp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([new Uint8Array(byteArray).buffer],{type:Browser.getMimetype(name)})}var url=URL.createObjectURL(b);var img=new Image;img.onload=()=>{var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Browser.preloadedImages[name]=canvas;URL.revokeObjectURL(url);onload?.(byteArray)};img.onerror=event=>{err(`Image ${url} could not be decoded`);onerror?.()};img.src=url};preloadPlugins.push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module["noAudioDecoding"]&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Browser.preloadedAudios[name]=audio;onload?.(byteArray)}var b=new Blob([byteArray],{type:Browser.getMimetype(name)});var url=URL.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",()=>finish(audio),false);audio.onerror=function audio_onerror(event){if(done)return;err(`warning: browser could not fully decode audio ${name}, trying slower base64 approach`);function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;safeSetTimeout(()=>{finish(audio)},1e4)};preloadPlugins.push(audioPlugin);function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===Module["canvas"]||document["mozPointerLockElement"]===Module["canvas"]||document["webkitPointerLockElement"]===Module["canvas"]||document["msPointerLockElement"]===Module["canvas"]}var canvas=Module["canvas"];if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(()=>{});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(()=>{});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",ev=>{if(!Browser.pointerLock&&Module["canvas"].requestPointerLock){Module["canvas"].requestPointerLock();ev.preventDefault()}},false)}}},createContext(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module["ctx"]&&canvas==Module["canvas"])return Module["ctx"];var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false,majorVersion:1};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}if(typeof GL!="undefined"){contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}}}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){Module["ctx"]=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Browser.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach(callback=>callback());Browser.init()}return ctx},fullscreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullscreen(lockPointer,resizeCanvas){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;if(typeof Browser.lockPointer=="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas=="undefined")Browser.resizeCanvas=false;var canvas=Module["canvas"];function fullscreenChange(){Browser.isFullscreen=false;var canvasContainer=canvas.parentNode;if((document["fullscreenElement"]||document["mozFullScreenElement"]||document["msFullscreenElement"]||document["webkitFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.exitFullscreen=Browser.exitFullscreen;if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullscreen=true;if(Browser.resizeCanvas){Browser.setFullscreenCanvasSize()}else{Browser.updateCanvasDimensions(canvas)}}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas){Browser.setWindowedCanvasSize()}else{Browser.updateCanvasDimensions(canvas)}}Module["onFullScreen"]?.(Browser.isFullscreen);Module["onFullscreen"]?.(Browser.isFullscreen)}if(!Browser.fullscreenHandlersInstalled){Browser.fullscreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullscreenChange,false);document.addEventListener("mozfullscreenchange",fullscreenChange,false);document.addEventListener("webkitfullscreenchange",fullscreenChange,false);document.addEventListener("MSFullscreenChange",fullscreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullscreen=canvasContainer["requestFullscreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullscreen"]?()=>canvasContainer["webkitRequestFullscreen"](Element["ALLOW_KEYBOARD_INPUT"]):null)||(canvasContainer["webkitRequestFullScreen"]?()=>canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"]):null);canvasContainer.requestFullscreen()},exitFullscreen(){if(!Browser.isFullscreen){return false}var CFS=document["exitFullscreen"]||document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["msExitFullscreen"]||document["webkitCancelFullScreen"]||(()=>{});CFS.apply(document,[]);return true},safeSetTimeout(func,timeout){return safeSetTimeout(func,timeout)},getMimetype(name){return{jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",bmp:"image/bmp",ogg:"audio/ogg",wav:"audio/wav",mp3:"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]},getUserMedia(func){window.getUserMedia||=navigator["getUserMedia"]||navigator["mozGetUserMedia"];window.getUserMedia(func)},getMovementX(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0},getMovementY(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0},getMouseWheelDelta(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail/3;break;case"mousewheel":delta=event.wheelDelta/120;break;case"wheel":delta=event.deltaY;switch(event.deltaMode){case 0:delta/=100;break;case 1:delta/=3;break;case 2:delta*=80;break;default:throw"unrecognized mouse wheel delta mode: "+event.deltaMode}break;default:throw"unrecognized mouse wheel event: "+event.type}return delta},mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseCoords(pageX,pageY){var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!="undefined"?window.scrollY:window.pageYOffset;var adjustedX=pageX-(scrollX+rect.left);var adjustedY=pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);return{x:adjustedX,y:adjustedY}},setMouseCoords(pageX,pageY){const{x,y}=Browser.calculateMouseCoords(pageX,pageY);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y},calculateMouseEvent(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}else{if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var coords=Browser.calculateMouseCoords(touch.pageX,touch.pageY);if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];last||=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}Browser.setMouseCoords(event.pageX,event.pageY)}},resizeListeners:[],updateResizeListeners(){var canvas=Module["canvas"];Browser.resizeListeners.forEach(listener=>listener(canvas.width,canvas.height))},setCanvasSize(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()},windowedWidth:0,windowedHeight:0,setFullscreenCanvasSize(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen>>2];flags=flags|8388608;HEAP32[SDL.screen>>2]=flags}Browser.updateCanvasDimensions(Module["canvas"]);Browser.updateResizeListeners()},setWindowedCanvasSize(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen>>2];flags=flags&~8388608;HEAP32[SDL.screen>>2]=flags}Browser.updateCanvasDimensions(Module["canvas"]);Browser.updateResizeListeners()},updateCanvasDimensions(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["fullscreenElement"]||document["mozFullScreenElement"]||document["msFullscreenElement"]||document["webkitFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}};var EGL={errorCode:12288,defaultDisplayInitialized:false,currentContext:0,currentReadSurface:0,currentDrawSurface:0,contextAttributes:{alpha:false,depth:false,stencil:false,antialias:false},stringCache:{},setErrorCode(code){EGL.errorCode=code},chooseConfig(display,attribList,config,config_size,numConfigs){if(display!=62e3){EGL.setErrorCode(12296);return 0}if(attribList){for(;;){var param=HEAP32[attribList>>2];if(param==12321){var alphaSize=HEAP32[attribList+4>>2];EGL.contextAttributes.alpha=alphaSize>0}else if(param==12325){var depthSize=HEAP32[attribList+4>>2];EGL.contextAttributes.depth=depthSize>0}else if(param==12326){var stencilSize=HEAP32[attribList+4>>2];EGL.contextAttributes.stencil=stencilSize>0}else if(param==12337){var samples=HEAP32[attribList+4>>2];EGL.contextAttributes.antialias=samples>0}else if(param==12338){var samples=HEAP32[attribList+4>>2];EGL.contextAttributes.antialias=samples==1}else if(param==12544){var requestedPriority=HEAP32[attribList+4>>2];EGL.contextAttributes.lowLatency=requestedPriority!=12547}else if(param==12344){break}attribList+=8}}if((!config||!config_size)&&!numConfigs){EGL.setErrorCode(12300);return 0}if(numConfigs){HEAP32[numConfigs>>2]=1}if(config&&config_size>0){HEAPU32[config>>2]=62002}EGL.setErrorCode(12288);return 1}};var _eglBindAPI=api=>{if(api==12448){EGL.setErrorCode(12288);return 1}EGL.setErrorCode(12300);return 0};var _eglChooseConfig=(display,attrib_list,configs,config_size,numConfigs)=>EGL.chooseConfig(display,attrib_list,configs,config_size,numConfigs);var GLctx;var webgl_enable_ANGLE_instanced_arrays=ctx=>{var ext=ctx.getExtension("ANGLE_instanced_arrays");if(ext){ctx["vertexAttribDivisor"]=(index,divisor)=>ext["vertexAttribDivisorANGLE"](index,divisor);ctx["drawArraysInstanced"]=(mode,first,count,primcount)=>ext["drawArraysInstancedANGLE"](mode,first,count,primcount);ctx["drawElementsInstanced"]=(mode,count,type,indices,primcount)=>ext["drawElementsInstancedANGLE"](mode,count,type,indices,primcount);return 1}};var webgl_enable_OES_vertex_array_object=ctx=>{var ext=ctx.getExtension("OES_vertex_array_object");if(ext){ctx["createVertexArray"]=()=>ext["createVertexArrayOES"]();ctx["deleteVertexArray"]=vao=>ext["deleteVertexArrayOES"](vao);ctx["bindVertexArray"]=vao=>ext["bindVertexArrayOES"](vao);ctx["isVertexArray"]=vao=>ext["isVertexArrayOES"](vao);return 1}};var webgl_enable_WEBGL_draw_buffers=ctx=>{var ext=ctx.getExtension("WEBGL_draw_buffers");if(ext){ctx["drawBuffers"]=(n,bufs)=>ext["drawBuffersWEBGL"](n,bufs);return 1}};var webgl_enable_EXT_polygon_offset_clamp=ctx=>!!(ctx.extPolygonOffsetClamp=ctx.getExtension("EXT_polygon_offset_clamp"));var webgl_enable_EXT_clip_control=ctx=>!!(ctx.extClipControl=ctx.getExtension("EXT_clip_control"));var webgl_enable_WEBGL_polygon_mode=ctx=>!!(ctx.webglPolygonMode=ctx.getExtension("WEBGL_polygon_mode"));var webgl_enable_WEBGL_multi_draw=ctx=>!!(ctx.multiDrawWebgl=ctx.getExtension("WEBGL_multi_draw"));var getEmscriptenSupportedExtensions=ctx=>{var supportedExtensions=["ANGLE_instanced_arrays","EXT_blend_minmax","EXT_disjoint_timer_query","EXT_frag_depth","EXT_shader_texture_lod","EXT_sRGB","OES_element_index_uint","OES_fbo_render_mipmap","OES_standard_derivatives","OES_texture_float","OES_texture_half_float","OES_texture_half_float_linear","OES_vertex_array_object","WEBGL_color_buffer_float","WEBGL_depth_texture","WEBGL_draw_buffers","EXT_clip_control","EXT_color_buffer_half_float","EXT_depth_clamp","EXT_float_blend","EXT_polygon_offset_clamp","EXT_texture_compression_bptc","EXT_texture_compression_rgtc","EXT_texture_filter_anisotropic","KHR_parallel_shader_compile","OES_texture_float_linear","WEBGL_blend_func_extended","WEBGL_compressed_texture_astc","WEBGL_compressed_texture_etc","WEBGL_compressed_texture_etc1","WEBGL_compressed_texture_s3tc","WEBGL_compressed_texture_s3tc_srgb","WEBGL_debug_renderer_info","WEBGL_debug_shaders","WEBGL_lose_context","WEBGL_multi_draw","WEBGL_polygon_mode"];return(ctx.getSupportedExtensions()||[]).filter(ext=>supportedExtensions.includes(ext))};var registerPreMainLoop=f=>{typeof MainLoop!="undefined"&&MainLoop.preMainLoop.push(f)};var GL={counter:1,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],shaders:[],vaos:[],contexts:[],offscreenCanvases:{},queries:[],byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],stringCache:{},unpackAlignment:4,unpackRowLength:0,recordError:errorCode=>{if(!GL.lastError){GL.lastError=errorCode}},getNewId:table=>{var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}return ret},genObject:(n,buffers,createFunction,objectTable)=>{for(var i=0;i<n;i++){var buffer=GLctx[createFunction]();var id=buffer&&GL.getNewId(objectTable);if(buffer){buffer.name=id;objectTable[id]=buffer}else{GL.recordError(1282)}HEAP32[buffers+i*4>>2]=id}},MAX_TEMP_BUFFER_SIZE:2097152,numTempVertexBuffersPerSize:64,log2ceilLookup:i=>32-Math.clz32(i===0?0:i-1),generateTempBuffers:(quads,context)=>{var largestIndex=GL.log2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);context.tempVertexBufferCounters1=[];context.tempVertexBufferCounters2=[];context.tempVertexBufferCounters1.length=context.tempVertexBufferCounters2.length=largestIndex+1;context.tempVertexBuffers1=[];context.tempVertexBuffers2=[];context.tempVertexBuffers1.length=context.tempVertexBuffers2.length=largestIndex+1;context.tempIndexBuffers=[];context.tempIndexBuffers.length=largestIndex+1;for(var i=0;i<=largestIndex;++i){context.tempIndexBuffers[i]=null;context.tempVertexBufferCounters1[i]=context.tempVertexBufferCounters2[i]=0;var ringbufferLength=GL.numTempVertexBuffersPerSize;context.tempVertexBuffers1[i]=[];context.tempVertexBuffers2[i]=[];var ringbuffer1=context.tempVertexBuffers1[i];var ringbuffer2=context.tempVertexBuffers2[i];ringbuffer1.length=ringbuffer2.length=ringbufferLength;for(var j=0;j<ringbufferLength;++j){ringbuffer1[j]=ringbuffer2[j]=null}}if(quads){context.tempQuadIndexBuffer=GLctx.createBuffer();context.GLctx.bindBuffer(34963,context.tempQuadIndexBuffer);var numIndexes=GL.MAX_TEMP_BUFFER_SIZE>>1;var quadIndexes=new Uint16Array(numIndexes);var i=0,v=0;while(1){quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+1;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v+3;if(i>=numIndexes)break;v+=4}context.GLctx.bufferData(34963,quadIndexes,35044);context.GLctx.bindBuffer(34963,null)}},getTempVertexBuffer:sizeBytes=>{var idx=GL.log2ceilLookup(sizeBytes);var ringbuffer=GL.currentContext.tempVertexBuffers1[idx];var nextFreeBufferIndex=GL.currentContext.tempVertexBufferCounters1[idx];GL.currentContext.tempVertexBufferCounters1[idx]=GL.currentContext.tempVertexBufferCounters1[idx]+1&GL.numTempVertexBuffersPerSize-1;var vbo=ringbuffer[nextFreeBufferIndex];if(vbo){return vbo}var prevVBO=GLctx.getParameter(34964);ringbuffer[nextFreeBufferIndex]=GLctx.createBuffer();GLctx.bindBuffer(34962,ringbuffer[nextFreeBufferIndex]);GLctx.bufferData(34962,1<<idx,35048);GLctx.bindBuffer(34962,prevVBO);return ringbuffer[nextFreeBufferIndex]},getTempIndexBuffer:sizeBytes=>{var idx=GL.log2ceilLookup(sizeBytes);var ibo=GL.currentContext.tempIndexBuffers[idx];if(ibo){return ibo}var prevIBO=GLctx.getParameter(34965);GL.currentContext.tempIndexBuffers[idx]=GLctx.createBuffer();GLctx.bindBuffer(34963,GL.currentContext.tempIndexBuffers[idx]);GLctx.bufferData(34963,1<<idx,35048);GLctx.bindBuffer(34963,prevIBO);return GL.currentContext.tempIndexBuffers[idx]},newRenderingFrameStarted:()=>{if(!GL.currentContext){return}var vb=GL.currentContext.tempVertexBuffers1;GL.currentContext.tempVertexBuffers1=GL.currentContext.tempVertexBuffers2;GL.currentContext.tempVertexBuffers2=vb;vb=GL.currentContext.tempVertexBufferCounters1;GL.currentContext.tempVertexBufferCounters1=GL.currentContext.tempVertexBufferCounters2;GL.currentContext.tempVertexBufferCounters2=vb;var largestIndex=GL.log2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);for(var i=0;i<=largestIndex;++i){GL.currentContext.tempVertexBufferCounters1[i]=0}},getSource:(shader,count,string,length)=>{var source="";for(var i=0;i<count;++i){var len=length?HEAPU32[length+i*4>>2]:undefined;source+=UTF8ToString(HEAPU32[string+i*4>>2],len)}var type=GLctx.getShaderParameter(GL.shaders[shader],35663);if(type==35632){if(GLEmulation.findToken(source,"dFdx")||GLEmulation.findToken(source,"dFdy")||GLEmulation.findToken(source,"fwidth")){source="#extension GL_OES_standard_derivatives : enable\n"+source;var extension=GLctx.getExtension("OES_standard_derivatives")}}return source},createContext:(canvas,webGLContextAttributes)=>{if(!canvas.getContextSafariWebGL2Fixed){canvas.getContextSafariWebGL2Fixed=canvas.getContext;function fixedGetContext(ver,attrs){var gl=canvas.getContextSafariWebGL2Fixed(ver,attrs);return ver=="webgl"==gl instanceof WebGLRenderingContext?gl:null}canvas.getContext=fixedGetContext}var ctx=canvas.getContext("webgl",webGLContextAttributes);if(!ctx)return 0;var handle=GL.registerContext(ctx,webGLContextAttributes);return handle},registerContext:(ctx,webGLContextAttributes)=>{var handle=GL.getNewId(GL.contexts);var context={handle,attributes:webGLContextAttributes,version:webGLContextAttributes.majorVersion,GLctx:ctx};if(ctx.canvas)ctx.canvas.GLctxObject=context;GL.contexts[handle]=context;if(typeof webGLContextAttributes.enableExtensionsByDefault=="undefined"||webGLContextAttributes.enableExtensionsByDefault){GL.initExtensions(context)}return handle},makeContextCurrent:contextHandle=>{GL.currentContext=GL.contexts[contextHandle];Module["ctx"]=GLctx=GL.currentContext?.GLctx;return!(contextHandle&&!GLctx)},getContext:contextHandle=>GL.contexts[contextHandle],deleteContext:contextHandle=>{if(GL.currentContext===GL.contexts[contextHandle]){GL.currentContext=null}if(typeof JSEvents=="object"){JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas)}if(GL.contexts[contextHandle]&&GL.contexts[contextHandle].GLctx.canvas){GL.contexts[contextHandle].GLctx.canvas.GLctxObject=undefined}GL.contexts[contextHandle]=null},initExtensions:context=>{context||=GL.currentContext;if(context.initExtensionsDone)return;context.initExtensionsDone=true;var GLctx=context.GLctx;context.compressionExt=GLctx.getExtension("WEBGL_compressed_texture_s3tc");context.anisotropicExt=GLctx.getExtension("EXT_texture_filter_anisotropic");webgl_enable_WEBGL_multi_draw(GLctx);webgl_enable_EXT_polygon_offset_clamp(GLctx);webgl_enable_EXT_clip_control(GLctx);webgl_enable_WEBGL_polygon_mode(GLctx);webgl_enable_ANGLE_instanced_arrays(GLctx);webgl_enable_OES_vertex_array_object(GLctx);webgl_enable_WEBGL_draw_buffers(GLctx);{GLctx.disjointTimerQueryExt=GLctx.getExtension("EXT_disjoint_timer_query")}getEmscriptenSupportedExtensions(GLctx).forEach(ext=>{if(!ext.includes("lose_context")&&!ext.includes("debug")){GLctx.getExtension(ext)}})}};var _eglCreateContext=(display,config,hmm,contextAttribs)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}var glesContextVersion=1;for(;;){var param=HEAP32[contextAttribs>>2];if(param==12440){glesContextVersion=HEAP32[contextAttribs+4>>2]}else if(param==12344){break}else{EGL.setErrorCode(12292);return 0}contextAttribs+=8}if(glesContextVersion!=2){EGL.setErrorCode(12293);return 0}EGL.contextAttributes.majorVersion=glesContextVersion-1;EGL.contextAttributes.minorVersion=0;EGL.context=GL.createContext(Module["canvas"],EGL.contextAttributes);if(EGL.context!=0){EGL.setErrorCode(12288);GL.makeContextCurrent(EGL.context);Browser.useWebGL=true;Browser.moduleContextCreatedCallbacks.forEach(callback=>callback());GL.makeContextCurrent(null);return 62004}else{EGL.setErrorCode(12297);return 0}};var _eglCreateWindowSurface=(display,config,win,attrib_list)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(config!=62002){EGL.setErrorCode(12293);return 0}EGL.setErrorCode(12288);return 62006};var _eglDestroyContext=(display,context)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(context!=62004){EGL.setErrorCode(12294);return 0}GL.deleteContext(EGL.context);EGL.setErrorCode(12288);if(EGL.currentContext==context){EGL.currentContext=0}return 1};var _eglDestroySurface=(display,surface)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(surface!=62006){EGL.setErrorCode(12301);return 1}if(EGL.currentReadSurface==surface){EGL.currentReadSurface=0}if(EGL.currentDrawSurface==surface){EGL.currentDrawSurface=0}EGL.setErrorCode(12288);return 1};var _eglGetConfigAttrib=(display,config,attribute,value)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(config!=62002){EGL.setErrorCode(12293);return 0}if(!value){EGL.setErrorCode(12300);return 0}EGL.setErrorCode(12288);switch(attribute){case 12320:HEAP32[value>>2]=EGL.contextAttributes.alpha?32:24;return 1;case 12321:HEAP32[value>>2]=EGL.contextAttributes.alpha?8:0;return 1;case 12322:HEAP32[value>>2]=8;return 1;case 12323:HEAP32[value>>2]=8;return 1;case 12324:HEAP32[value>>2]=8;return 1;case 12325:HEAP32[value>>2]=EGL.contextAttributes.depth?24:0;return 1;case 12326:HEAP32[value>>2]=EGL.contextAttributes.stencil?8:0;return 1;case 12327:HEAP32[value>>2]=12344;return 1;case 12328:HEAP32[value>>2]=62002;return 1;case 12329:HEAP32[value>>2]=0;return 1;case 12330:HEAP32[value>>2]=4096;return 1;case 12331:HEAP32[value>>2]=16777216;return 1;case 12332:HEAP32[value>>2]=4096;return 1;case 12333:HEAP32[value>>2]=0;return 1;case 12334:HEAP32[value>>2]=0;return 1;case 12335:HEAP32[value>>2]=12344;return 1;case 12337:HEAP32[value>>2]=EGL.contextAttributes.antialias?4:0;return 1;case 12338:HEAP32[value>>2]=EGL.contextAttributes.antialias?1:0;return 1;case 12339:HEAP32[value>>2]=4;return 1;case 12340:HEAP32[value>>2]=12344;return 1;case 12341:case 12342:case 12343:HEAP32[value>>2]=-1;return 1;case 12345:case 12346:HEAP32[value>>2]=0;return 1;case 12347:HEAP32[value>>2]=0;return 1;case 12348:HEAP32[value>>2]=1;return 1;case 12349:case 12350:HEAP32[value>>2]=0;return 1;case 12351:HEAP32[value>>2]=12430;return 1;case 12352:HEAP32[value>>2]=4;return 1;case 12354:HEAP32[value>>2]=0;return 1;default:EGL.setErrorCode(12292);return 0}};var _eglGetDisplay=nativeDisplayType=>{EGL.setErrorCode(12288);if(nativeDisplayType!=0&&nativeDisplayType!=1){return 0}return 62e3};var _eglGetError=()=>EGL.errorCode;var _eglInitialize=(display,majorVersion,minorVersion)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(majorVersion){HEAP32[majorVersion>>2]=1}if(minorVersion){HEAP32[minorVersion>>2]=4}EGL.defaultDisplayInitialized=true;EGL.setErrorCode(12288);return 1};var _eglMakeCurrent=(display,draw,read,context)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(context!=0&&context!=62004){EGL.setErrorCode(12294);return 0}if(read!=0&&read!=62006||draw!=0&&draw!=62006){EGL.setErrorCode(12301);return 0}GL.makeContextCurrent(context?EGL.context:null);EGL.currentContext=context;EGL.currentDrawSurface=draw;EGL.currentReadSurface=read;EGL.setErrorCode(12288);return 1};var stringToNewUTF8=str=>{var size=lengthBytesUTF8(str)+1;var ret=_malloc(size);if(ret)stringToUTF8(str,ret,size);return ret};var _eglQueryString=(display,name)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}EGL.setErrorCode(12288);if(EGL.stringCache[name])return EGL.stringCache[name];var ret;switch(name){case 12371:ret=stringToNewUTF8("Emscripten");break;case 12372:ret=stringToNewUTF8("1.4 Emscripten EGL");break;case 12373:ret=stringToNewUTF8("");break;case 12429:ret=stringToNewUTF8("OpenGL_ES");break;default:EGL.setErrorCode(12300);return 0}EGL.stringCache[name]=ret;return ret};var _eglSwapBuffers=(dpy,surface)=>{if(!EGL.defaultDisplayInitialized){EGL.setErrorCode(12289)}else if(!GLctx){EGL.setErrorCode(12290)}else if(GLctx.isContextLost()){EGL.setErrorCode(12302)}else{EGL.setErrorCode(12288);return 1}return 0};var setMainLoop=(iterFunc,fps,simulateInfiniteLoop,arg,noSetTiming)=>{MainLoop.func=iterFunc;MainLoop.arg=arg;var thisMainLoopId=MainLoop.currentlyRunningMainloop;function checkIsRunning(){if(thisMainLoopId<MainLoop.currentlyRunningMainloop){maybeExit();return false}return true}MainLoop.running=false;MainLoop.runner=function MainLoop_runner(){if(ABORT)return;if(MainLoop.queue.length>0){var start=Date.now();var blocker=MainLoop.queue.shift();blocker.func(blocker.arg);if(MainLoop.remainingBlockers){var remaining=MainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){MainLoop.remainingBlockers=next}else{next=next+.5;MainLoop.remainingBlockers=(8*remaining+next)/9}}MainLoop.updateStatus();if(!checkIsRunning())return;setTimeout(MainLoop.runner,0);return}if(!checkIsRunning())return;MainLoop.currentFrameNumber=MainLoop.currentFrameNumber+1|0;if(MainLoop.timingMode==1&&MainLoop.timingValue>1&&MainLoop.currentFrameNumber%MainLoop.timingValue!=0){MainLoop.scheduler();return}else if(MainLoop.timingMode==0){MainLoop.tickStartTime=_emscripten_get_now()}MainLoop.runIter(iterFunc);if(!checkIsRunning())return;MainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0){_emscripten_set_main_loop_timing(0,1e3/fps)}else{_emscripten_set_main_loop_timing(1,1)}MainLoop.scheduler()}if(simulateInfiniteLoop){throw"unwind"}};var MainLoop={running:false,scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],preMainLoop:[],postMainLoop:[],pause(){MainLoop.scheduler=null;MainLoop.currentlyRunningMainloop++},resume(){MainLoop.currentlyRunningMainloop++;var timingMode=MainLoop.timingMode;var timingValue=MainLoop.timingValue;var func=MainLoop.func;MainLoop.func=null;setMainLoop(func,0,false,MainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);MainLoop.scheduler()},updateStatus(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=MainLoop.remainingBlockers??0;var expected=MainLoop.expectedBlockers??0;if(remaining){if(remaining<expected){Module["setStatus"](`{message} ({expected - remaining}/{expected})`)}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}},init(){Module["preMainLoop"]&&MainLoop.preMainLoop.push(Module["preMainLoop"]);Module["postMainLoop"]&&MainLoop.postMainLoop.push(Module["postMainLoop"])},runIter(func){if(ABORT)return;for(var pre of MainLoop.preMainLoop){if(pre()===false){return}}callUserCallback(func);for(var post of MainLoop.postMainLoop){post()}},nextRAF:0,fakeRequestAnimationFrame(func){var now=Date.now();if(MainLoop.nextRAF===0){MainLoop.nextRAF=now+1e3/60}else{while(now+2>=MainLoop.nextRAF){MainLoop.nextRAF+=1e3/60}}var delay=Math.max(MainLoop.nextRAF-now,0);setTimeout(func,delay)},requestAnimationFrame(func){if(typeof requestAnimationFrame=="function"){requestAnimationFrame(func);return}var RAF=MainLoop.fakeRequestAnimationFrame;RAF(func)}};var _emscripten_set_main_loop_timing=(mode,value)=>{MainLoop.timingMode=mode;MainLoop.timingValue=value;if(!MainLoop.func){return 1}if(!MainLoop.running){MainLoop.running=true}if(mode==0){MainLoop.scheduler=function MainLoop_scheduler_setTimeout(){var timeUntilNextTick=Math.max(0,MainLoop.tickStartTime+value-_emscripten_get_now())|0;setTimeout(MainLoop.runner,timeUntilNextTick)};MainLoop.method="timeout"}else if(mode==1){MainLoop.scheduler=function MainLoop_scheduler_rAF(){MainLoop.requestAnimationFrame(MainLoop.runner)};MainLoop.method="rAF"}else if(mode==2){if(typeof MainLoop.setImmediate=="undefined"){if(typeof setImmediate=="undefined"){var setImmediates=[];var emscriptenMainLoopMessageId="setimmediate";var MainLoop_setImmediate_messageHandler=event=>{if(event.data===emscriptenMainLoopMessageId||event.data.target===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}};addEventListener("message",MainLoop_setImmediate_messageHandler,true);MainLoop.setImmediate=func=>{setImmediates.push(func);if(ENVIRONMENT_IS_WORKER){Module["setImmediates"]??=[];Module["setImmediates"].push(func);postMessage({target:emscriptenMainLoopMessageId})}else postMessage(emscriptenMainLoopMessageId,"*")}}else{MainLoop.setImmediate=setImmediate}}MainLoop.scheduler=function MainLoop_scheduler_setImmediate(){MainLoop.setImmediate(MainLoop.runner)};MainLoop.method="immediate"}return 0};var _eglSwapInterval=(display,interval)=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}if(interval==0)_emscripten_set_main_loop_timing(0,0);else _emscripten_set_main_loop_timing(1,interval);EGL.setErrorCode(12288);return 1};var _eglTerminate=display=>{if(display!=62e3){EGL.setErrorCode(12296);return 0}EGL.currentContext=0;EGL.currentReadSurface=0;EGL.currentDrawSurface=0;EGL.defaultDisplayInitialized=false;EGL.setErrorCode(12288);return 1};var _eglWaitClient=()=>{EGL.setErrorCode(12288);return 1};var _eglWaitGL=_eglWaitClient;var _eglWaitNative=nativeEngineId=>{EGL.setErrorCode(12288);return 1};var readEmAsmArgsArray=[];var readEmAsmArgs=(sigPtr,buf)=>{readEmAsmArgsArray.length=0;var ch;while(ch=HEAPU8[sigPtr++]){var wide=ch!=105;wide&=ch!=112;buf+=wide&&buf%8?4:0;readEmAsmArgsArray.push(ch==112?HEAPU32[buf>>2]:ch==105?HEAP32[buf>>2]:HEAPF64[buf>>3]);buf+=wide?8:4}return readEmAsmArgsArray};var runEmAsmFunction=(code,sigPtr,argbuf)=>{var args=readEmAsmArgs(sigPtr,argbuf);return ASM_CONSTS[code](...args)};var _emscripten_asm_const_int=(code,sigPtr,argbuf)=>runEmAsmFunction(code,sigPtr,argbuf);var runMainThreadEmAsm=(emAsmAddr,sigPtr,argbuf,sync)=>{var args=readEmAsmArgs(sigPtr,argbuf);return ASM_CONSTS[emAsmAddr](...args)};var _emscripten_asm_const_int_sync_on_main_thread=(emAsmAddr,sigPtr,argbuf)=>runMainThreadEmAsm(emAsmAddr,sigPtr,argbuf,1);var _emscripten_asm_const_ptr_sync_on_main_thread=(emAsmAddr,sigPtr,argbuf)=>runMainThreadEmAsm(emAsmAddr,sigPtr,argbuf,1);var wget={wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle(){var handle=wget.nextWgetRequestHandle;wget.nextWgetRequestHandle++;return handle}};var wasmTableMirror=[];var wasmTable;var getWasmTableEntry=funcPtr=>{var func=wasmTableMirror[funcPtr];if(!func){if(funcPtr>=wasmTableMirror.length)wasmTableMirror.length=funcPtr+1;wasmTableMirror[funcPtr]=func=wasmTable.get(funcPtr)}return func};var _emscripten_async_wget2_data=(url,request,param,userdata,free,onload,onerror,onprogress)=>{var _url=UTF8ToString(url);var _request=UTF8ToString(request);var _param=UTF8ToString(param);var http=new XMLHttpRequest;http.open(_request,_url,true);http.responseType="arraybuffer";var handle=wget.getNextWgetRequestHandle();function onerrorjs(){if(onerror){var sp=stackSave();var statusText=0;if(http.statusText){statusText=stringToUTF8OnStack(http.statusText)}getWasmTableEntry(onerror)(handle,userdata,http.status,statusText);stackRestore(sp)}}http.onload=e=>{if(http.status>=200&&http.status<300||http.status===0&&_url.substr(0,4).toLowerCase()!="http"){var byteArray=new Uint8Array(http.response);var buffer=_malloc(byteArray.length);HEAPU8.set(byteArray,buffer);if(onload)getWasmTableEntry(onload)(handle,userdata,buffer,byteArray.length);if(free)_free(buffer)}else{onerrorjs()}delete wget.wgetRequests[handle]};http.onerror=e=>{onerrorjs();delete wget.wgetRequests[handle]};http.onprogress=e=>{if(onprogress)getWasmTableEntry(onprogress)(handle,userdata,e.loaded,e.lengthComputable||e.lengthComputable===undefined?e.total:0)};http.onabort=e=>{delete wget.wgetRequests[handle]};if(_request=="POST"){http.setRequestHeader("Content-type","application/x-www-form-urlencoded");http.send(_param)}else{http.send(null)}wget.wgetRequests[handle]=http;return handle};var _emscripten_cancel_main_loop=()=>{MainLoop.pause();MainLoop.func=null};var JSEvents={memcpy(target,src,size){HEAP8.set(HEAP8.subarray(src,src+size),target)},removeAllEventListeners(){while(JSEvents.eventHandlers.length){JSEvents._removeHandler(JSEvents.eventHandlers.length-1)}JSEvents.deferredCalls=[]},inEventHandler:0,deferredCalls:[],deferCall(targetFunction,precedence,argsList){function arraysHaveEqualContent(arrA,arrB){if(arrA.length!=arrB.length)return false;for(var i in arrA){if(arrA[i]!=arrB[i])return false}return true}for(var call of JSEvents.deferredCalls){if(call.targetFunction==targetFunction&&arraysHaveEqualContent(call.argsList,argsList)){return}}JSEvents.deferredCalls.push({targetFunction,precedence,argsList});JSEvents.deferredCalls.sort((x,y)=>x.precedence<y.precedence)},removeDeferredCalls(targetFunction){JSEvents.deferredCalls=JSEvents.deferredCalls.filter(call=>call.targetFunction!=targetFunction)},canPerformEventHandlerRequests(){if(navigator.userActivation){return navigator.userActivation.isActive}return JSEvents.inEventHandler&&JSEvents.currentEventHandler.allowsDeferredCalls},runDeferredCalls(){if(!JSEvents.canPerformEventHandlerRequests()){return}var deferredCalls=JSEvents.deferredCalls;JSEvents.deferredCalls=[];for(var call of deferredCalls){call.targetFunction(...call.argsList)}},eventHandlers:[],removeAllHandlersOnTarget:(target,eventTypeString)=>{for(var i=0;i<JSEvents.eventHandlers.length;++i){if(JSEvents.eventHandlers[i].target==target&&(!eventTypeString||eventTypeString==JSEvents.eventHandlers[i].eventTypeString)){JSEvents._removeHandler(i--)}}},_removeHandler(i){var h=JSEvents.eventHandlers[i];h.target.removeEventListener(h.eventTypeString,h.eventListenerFunc,h.useCapture);JSEvents.eventHandlers.splice(i,1)},registerOrRemoveHandler(eventHandler){if(!eventHandler.target){return-4}if(eventHandler.callbackfunc){eventHandler.eventListenerFunc=function(event){++JSEvents.inEventHandler;JSEvents.currentEventHandler=eventHandler;JSEvents.runDeferredCalls();eventHandler.handlerFunc(event);JSEvents.runDeferredCalls();--JSEvents.inEventHandler};eventHandler.target.addEventListener(eventHandler.eventTypeString,eventHandler.eventListenerFunc,eventHandler.useCapture);JSEvents.eventHandlers.push(eventHandler)}else{for(var i=0;i<JSEvents.eventHandlers.length;++i){if(JSEvents.eventHandlers[i].target==eventHandler.target&&JSEvents.eventHandlers[i].eventTypeString==eventHandler.eventTypeString){JSEvents._removeHandler(i--)}}}return 0},getNodeNameForTarget(target){if(!target)return"";if(target==window)return"#window";if(target==screen)return"#screen";return target?.nodeName||""},fullscreenEnabled(){return document.fullscreenEnabled||document.webkitFullscreenEnabled}};var currentFullscreenStrategy={};var maybeCStringToJsString=cString=>cString>2?UTF8ToString(cString):cString;var specialHTMLTargets=[0,typeof document!="undefined"?document:0,typeof window!="undefined"?window:0];var findEventTarget=target=>{target=maybeCStringToJsString(target);var domElement=specialHTMLTargets[target]||(typeof document!="undefined"?document.querySelector(target):null);return domElement};var findCanvasEventTarget=findEventTarget;var _emscripten_get_canvas_element_size=(target,width,height)=>{var canvas=findCanvasEventTarget(target);if(!canvas)return-4;HEAP32[width>>2]=canvas.width;HEAP32[height>>2]=canvas.height};var stackAlloc=sz=>__emscripten_stack_alloc(sz);var stringToUTF8OnStack=str=>{var size=lengthBytesUTF8(str)+1;var ret=stackAlloc(size);stringToUTF8(str,ret,size);return ret};var getCanvasElementSize=target=>{var sp=stackSave();var w=stackAlloc(8);var h=w+4;var targetInt=stringToUTF8OnStack(target.id);var ret=_emscripten_get_canvas_element_size(targetInt,w,h);var size=[HEAP32[w>>2],HEAP32[h>>2]];stackRestore(sp);return size};var _emscripten_set_canvas_element_size=(target,width,height)=>{var canvas=findCanvasEventTarget(target);if(!canvas)return-4;canvas.width=width;canvas.height=height;return 0};var setCanvasElementSize=(target,width,height)=>{if(!target.controlTransferredOffscreen){target.width=width;target.height=height}else{var sp=stackSave();var targetInt=stringToUTF8OnStack(target.id);_emscripten_set_canvas_element_size(targetInt,width,height);stackRestore(sp)}};var registerRestoreOldStyle=canvas=>{var canvasSize=getCanvasElementSize(canvas);var oldWidth=canvasSize[0];var oldHeight=canvasSize[1];var oldCssWidth=canvas.style.width;var oldCssHeight=canvas.style.height;var oldBackgroundColor=canvas.style.backgroundColor;var oldDocumentBackgroundColor=document.body.style.backgroundColor;var oldPaddingLeft=canvas.style.paddingLeft;var oldPaddingRight=canvas.style.paddingRight;var oldPaddingTop=canvas.style.paddingTop;var oldPaddingBottom=canvas.style.paddingBottom;var oldMarginLeft=canvas.style.marginLeft;var oldMarginRight=canvas.style.marginRight;var oldMarginTop=canvas.style.marginTop;var oldMarginBottom=canvas.style.marginBottom;var oldDocumentBodyMargin=document.body.style.margin;var oldDocumentOverflow=document.documentElement.style.overflow;var oldDocumentScroll=document.body.scroll;var oldImageRendering=canvas.style.imageRendering;function restoreOldStyle(){var fullscreenElement=document.fullscreenElement||document.webkitFullscreenElement;if(!fullscreenElement){document.removeEventListener("fullscreenchange",restoreOldStyle);document.removeEventListener("webkitfullscreenchange",restoreOldStyle);setCanvasElementSize(canvas,oldWidth,oldHeight);canvas.style.width=oldCssWidth;canvas.style.height=oldCssHeight;canvas.style.backgroundColor=oldBackgroundColor;if(!oldDocumentBackgroundColor)document.body.style.backgroundColor="white";document.body.style.backgroundColor=oldDocumentBackgroundColor;canvas.style.paddingLeft=oldPaddingLeft;canvas.style.paddingRight=oldPaddingRight;canvas.style.paddingTop=oldPaddingTop;canvas.style.paddingBottom=oldPaddingBottom;canvas.style.marginLeft=oldMarginLeft;canvas.style.marginRight=oldMarginRight;canvas.style.marginTop=oldMarginTop;canvas.style.marginBottom=oldMarginBottom;document.body.style.margin=oldDocumentBodyMargin;document.documentElement.style.overflow=oldDocumentOverflow;document.body.scroll=oldDocumentScroll;canvas.style.imageRendering=oldImageRendering;if(canvas.GLctxObject)canvas.GLctxObject.GLctx.viewport(0,0,oldWidth,oldHeight);if(currentFullscreenStrategy.canvasResizedCallback){getWasmTableEntry(currentFullscreenStrategy.canvasResizedCallback)(37,0,currentFullscreenStrategy.canvasResizedCallbackUserData)}}}document.addEventListener("fullscreenchange",restoreOldStyle);document.addEventListener("webkitfullscreenchange",restoreOldStyle);return restoreOldStyle};var setLetterbox=(element,topBottom,leftRight)=>{element.style.paddingLeft=element.style.paddingRight=leftRight+"px";element.style.paddingTop=element.style.paddingBottom=topBottom+"px"};var getBoundingClientRect=e=>specialHTMLTargets.indexOf(e)<0?e.getBoundingClientRect():{left:0,top:0};var JSEvents_resizeCanvasForFullscreen=(target,strategy)=>{var restoreOldStyle=registerRestoreOldStyle(target);var cssWidth=strategy.softFullscreen?innerWidth:screen.width;var cssHeight=strategy.softFullscreen?innerHeight:screen.height;var rect=getBoundingClientRect(target);var windowedCssWidth=rect.width;var windowedCssHeight=rect.height;var canvasSize=getCanvasElementSize(target);var windowedRttWidth=canvasSize[0];var windowedRttHeight=canvasSize[1];if(strategy.scaleMode==3){setLetterbox(target,(cssHeight-windowedCssHeight)/2,(cssWidth-windowedCssWidth)/2);cssWidth=windowedCssWidth;cssHeight=windowedCssHeight}else if(strategy.scaleMode==2){if(cssWidth*windowedRttHeight<windowedRttWidth*cssHeight){var desiredCssHeight=windowedRttHeight*cssWidth/windowedRttWidth;setLetterbox(target,(cssHeight-desiredCssHeight)/2,0);cssHeight=desiredCssHeight}else{var desiredCssWidth=windowedRttWidth*cssHeight/windowedRttHeight;setLetterbox(target,0,(cssWidth-desiredCssWidth)/2);cssWidth=desiredCssWidth}}target.style.backgroundColor||="black";document.body.style.backgroundColor||="black";target.style.width=cssWidth+"px";target.style.height=cssHeight+"px";if(strategy.filteringMode==1){target.style.imageRendering="optimizeSpeed";target.style.imageRendering="-moz-crisp-edges";target.style.imageRendering="-o-crisp-edges";target.style.imageRendering="-webkit-optimize-contrast";target.style.imageRendering="optimize-contrast";target.style.imageRendering="crisp-edges";target.style.imageRendering="pixelated"}var dpiScale=strategy.canvasResolutionScaleMode==2?devicePixelRatio:1;if(strategy.canvasResolutionScaleMode!=0){var newWidth=cssWidth*dpiScale|0;var newHeight=cssHeight*dpiScale|0;setCanvasElementSize(target,newWidth,newHeight);if(target.GLctxObject)target.GLctxObject.GLctx.viewport(0,0,newWidth,newHeight)}return restoreOldStyle};var JSEvents_requestFullscreen=(target,strategy)=>{if(strategy.scaleMode!=0||strategy.canvasResolutionScaleMode!=0){JSEvents_resizeCanvasForFullscreen(target,strategy)}if(target.requestFullscreen){target.requestFullscreen()}else if(target.webkitRequestFullscreen){target.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)}else{return JSEvents.fullscreenEnabled()?-3:-1}currentFullscreenStrategy=strategy;if(strategy.canvasResizedCallback){getWasmTableEntry(strategy.canvasResizedCallback)(37,0,strategy.canvasResizedCallbackUserData)}return 0};var _emscripten_exit_fullscreen=()=>{if(!JSEvents.fullscreenEnabled())return-1;JSEvents.removeDeferredCalls(JSEvents_requestFullscreen);var d=specialHTMLTargets[1];if(d.exitFullscreen){d.fullscreenElement&&d.exitFullscreen()}else if(d.webkitExitFullscreen){d.webkitFullscreenElement&&d.webkitExitFullscreen()}else{return-1}return 0};var requestPointerLock=target=>{if(target.requestPointerLock){target.requestPointerLock()}else{if(document.body.requestPointerLock){return-3}return-1}return 0};var _emscripten_exit_pointerlock=()=>{JSEvents.removeDeferredCalls(requestPointerLock);if(document.exitPointerLock){document.exitPointerLock()}else{return-1}return 0};var _emscripten_get_device_pixel_ratio=()=>typeof devicePixelRatio=="number"&&devicePixelRatio||1;var _emscripten_get_element_css_size=(target,width,height)=>{target=findEventTarget(target);if(!target)return-4;var rect=getBoundingClientRect(target);HEAPF64[width>>3]=rect.width;HEAPF64[height>>3]=rect.height;return 0};var fillGamepadEventData=(eventStruct,e)=>{HEAPF64[eventStruct>>3]=e.timestamp;for(var i=0;i<e.axes.length;++i){HEAPF64[eventStruct+i*8+16>>3]=e.axes[i]}for(var i=0;i<e.buttons.length;++i){if(typeof e.buttons[i]=="object"){HEAPF64[eventStruct+i*8+528>>3]=e.buttons[i].value}else{HEAPF64[eventStruct+i*8+528>>3]=e.buttons[i]}}for(var i=0;i<e.buttons.length;++i){if(typeof e.buttons[i]=="object"){HEAP8[eventStruct+i+1040]=e.buttons[i].pressed}else{HEAP8[eventStruct+i+1040]=e.buttons[i]==1}}HEAP8[eventStruct+1104]=e.connected;HEAP32[eventStruct+1108>>2]=e.index;HEAP32[eventStruct+8>>2]=e.axes.length;HEAP32[eventStruct+12>>2]=e.buttons.length;stringToUTF8(e.id,eventStruct+1112,64);stringToUTF8(e.mapping,eventStruct+1176,64)};var _emscripten_get_gamepad_status=(index,gamepadState)=>{if(index<0||index>=JSEvents.lastGamepadState.length)return-5;if(!JSEvents.lastGamepadState[index])return-7;fillGamepadEventData(gamepadState,JSEvents.lastGamepadState[index]);return 0};var _emscripten_get_num_gamepads=()=>JSEvents.lastGamepadState.length;var _emscripten_get_screen_size=(width,height)=>{HEAP32[width>>2]=screen.width;HEAP32[height>>2]=screen.height};var _glActiveTexture=x0=>GLctx.activeTexture(x0);var _emscripten_glActiveTexture=_glActiveTexture;var _glAlphaFunc=(func,ref)=>{switch(func){case 512:case 513:case 514:case 515:case 516:case 517:case 518:case 519:GLEmulation.alphaTestRef=ref;if(GLEmulation.alphaTestFunc!=func){GLEmulation.alphaTestFunc=func;GLImmediate.currentRenderer=null}break;default:break}};var _emscripten_glAlphaFunc=_glAlphaFunc;var _glAttachShader=(program,shader)=>{GLctx.attachShader(GL.programs[program],GL.shaders[shader])};var _emscripten_glAttachShader=_glAttachShader;var _glEnable=x0=>GLctx.enable(x0);var _glDisable=x0=>GLctx.disable(x0);var _glIsEnabled=x0=>GLctx.isEnabled(x0);var writeI53ToI64=(ptr,num)=>{HEAPU32[ptr>>2]=num;var lower=HEAPU32[ptr>>2];HEAPU32[ptr+4>>2]=(num-lower)/4294967296};var emscriptenWebGLGet=(name_,p,type)=>{if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){case 36346:ret=1;break;case 36344:if(type!=0&&type!=1){GL.recordError(1280)}return;case 36345:ret=0;break;case 34466:var formats=GLctx.getParameter(34467);ret=formats?formats.length:0;break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);return;case"object":if(result===null){switch(name_){case 34964:case 35725:case 34965:case 36006:case 36007:case 32873:case 34229:case 34068:{ret=0;break}default:{GL.recordError(1280);return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case 0:HEAP32[p+i*4>>2]=result[i];break;case 2:HEAPF32[p+i*4>>2]=result[i];break;case 4:HEAP8[p+i]=result[i]?1:0;break}}return}else{try{ret=result.name|0}catch(e){GL.recordError(1280);err(`GL_INVALID_ENUM in glGet${type}v: Unknown object returned from WebGL getParameter(${name_})! (error: ${e})`);return}}break;default:GL.recordError(1280);err(`GL_INVALID_ENUM in glGet${type}v: Native code calling glGet${type}v(${name_}) and it returns ${result} of type ${typeof result}!`);return}}switch(type){case 1:writeI53ToI64(p,ret);break;case 0:HEAP32[p>>2]=ret;break;case 2:HEAPF32[p>>2]=ret;break;case 4:HEAP8[p]=ret?1:0;break}};var _glGetBooleanv=(name_,p)=>emscriptenWebGLGet(name_,p,4);var _glGetIntegerv=(name_,p)=>emscriptenWebGLGet(name_,p,0);var webglGetExtensions=()=>{var exts=getEmscriptenSupportedExtensions(GLctx);exts=exts.concat(exts.map(e=>"GL_"+e));return exts};var _glGetString=name_=>{var ret=GL.stringCache[name_];if(!ret){switch(name_){case 7939:ret=stringToNewUTF8(webglGetExtensions().join(" "));break;case 7936:case 7937:case 37445:case 37446:var s=GLctx.getParameter(name_);if(!s){GL.recordError(1280)}ret=s?stringToNewUTF8(s):0;break;case 7938:var webGLVersion=GLctx.getParameter(7938);var glVersion=`OpenGL ES 2.0 (${webGLVersion})`;ret=stringToNewUTF8(glVersion);break;case 35724:var glslVersion=GLctx.getParameter(35724);var ver_re=/^WebGL GLSL ES ([0-9]\.[0-9][0-9]?)(?:$| .*)/;var ver_num=glslVersion.match(ver_re);if(ver_num!==null){if(ver_num[1].length==3)ver_num[1]=ver_num[1]+"0";glslVersion=`OpenGL ES GLSL ES ${ver_num[1]} (${glslVersion})`}ret=stringToNewUTF8(glslVersion);break;default:GL.recordError(1280)}GL.stringCache[name_]=ret}return ret};var _glCreateShader=shaderType=>{var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id};var _glShaderSource=(shader,count,string,length)=>{var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)};var _glCompileShader=shader=>{GLctx.compileShader(GL.shaders[shader])};var _glDetachShader=(program,shader)=>{GLctx.detachShader(GL.programs[program],GL.shaders[shader])};var _glUseProgram=program=>{program=GL.programs[program];GLctx.useProgram(program);GLctx.currentProgram=program};var _glDeleteProgram=id=>{if(!id)return;var program=GL.programs[id];if(!program){GL.recordError(1281);return}GLctx.deleteProgram(program);program.name=0;GL.programs[id]=null};var _glBindAttribLocation=(program,index,name)=>{GLctx.bindAttribLocation(GL.programs[program],index,UTF8ToString(name))};var _glLinkProgram=program=>{program=GL.programs[program];GLctx.linkProgram(program);program.uniformLocsById=0;program.uniformSizeAndIdsByName={}};var _glBindBuffer=(target,buffer)=>{if(target==34962){GLctx.currentArrayBufferBinding=buffer;GLImmediate.lastArrayBuffer=buffer}else if(target==34963){GLctx.currentElementArrayBufferBinding=buffer}GLctx.bindBuffer(target,GL.buffers[buffer])};var _glGetFloatv=(name_,p)=>emscriptenWebGLGet(name_,p,2);var _glHint=(x0,x1)=>GLctx.hint(x0,x1);var _glEnableVertexAttribArray=index=>{GLctx.enableVertexAttribArray(index)};var _glDisableVertexAttribArray=index=>{GLctx.disableVertexAttribArray(index)};var _glVertexAttribPointer=(index,size,type,normalized,stride,ptr)=>{GLctx.vertexAttribPointer(index,size,type,!!normalized,stride,ptr)};var ptrToString=ptr=>{ptr>>>=0;return"0x"+ptr.toString(16).padStart(8,"0")};var GLEmulation={fogStart:0,fogEnd:1,fogDensity:1,fogColor:null,fogMode:2048,fogEnabled:false,MAX_CLIP_PLANES:6,clipPlaneEnabled:[false,false,false,false,false,false],clipPlaneEquation:[],lightingEnabled:false,lightModelAmbient:null,lightModelLocalViewer:false,lightModelTwoSide:false,materialAmbient:null,materialDiffuse:null,materialSpecular:null,materialShininess:null,materialEmission:null,MAX_LIGHTS:8,lightEnabled:[false,false,false,false,false,false,false,false],lightAmbient:[],lightDiffuse:[],lightSpecular:[],lightPosition:[],alphaTestEnabled:false,alphaTestFunc:519,alphaTestRef:0,pointSize:1,vaos:[],currentVao:null,enabledVertexAttribArrays:{},hasRunInit:false,findToken(source,token){function isIdentChar(ch){if(ch>=48&&ch<=57)return true;if(ch>=65&&ch<=90)return true;if(ch>=97&&ch<=122)return true;return false}var i=-1;do{i=source.indexOf(token,i+1);if(i<0){break}if(i>0&&isIdentChar(source[i-1])){continue}i+=token.length;if(i<source.length-1&&isIdentChar(source[i+1])){continue}return true}while(true);return false},init(){if(GLEmulation.hasRunInit){return}GLEmulation.hasRunInit=true;GLEmulation.fogColor=new Float32Array(4);for(var clipPlaneId=0;clipPlaneId<GLEmulation.MAX_CLIP_PLANES;clipPlaneId++){GLEmulation.clipPlaneEquation[clipPlaneId]=new Float32Array(4)}GLEmulation.lightModelAmbient=new Float32Array([.2,.2,.2,1]);GLEmulation.materialAmbient=new Float32Array([.2,.2,.2,1]);GLEmulation.materialDiffuse=new Float32Array([.8,.8,.8,1]);GLEmulation.materialSpecular=new Float32Array([0,0,0,1]);GLEmulation.materialShininess=new Float32Array([0]);GLEmulation.materialEmission=new Float32Array([0,0,0,1]);for(var lightId=0;lightId<GLEmulation.MAX_LIGHTS;lightId++){GLEmulation.lightAmbient[lightId]=new Float32Array([0,0,0,1]);GLEmulation.lightDiffuse[lightId]=lightId?new Float32Array([0,0,0,1]):new Float32Array([1,1,1,1]);GLEmulation.lightSpecular[lightId]=lightId?new Float32Array([0,0,0,1]):new Float32Array([1,1,1,1]);GLEmulation.lightPosition[lightId]=new Float32Array([0,0,1,0])}err("WARNING: using emscripten GL emulation. This is a collection of limited workarounds, do not expect it to work.");err("WARNING: using emscripten GL emulation unsafe opts. If weirdness happens, try -sGL_UNSAFE_OPTS=0");var validCapabilities={2884:1,3042:1,3024:1,2960:1,2929:1,3089:1,32823:1,32926:1,32928:1};var orig_glEnable=_glEnable;_glEnable=_emscripten_glEnable=cap=>{GLImmediate.lastRenderer?.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=true){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=true}return}else if(cap>=12288&&cap<12294){var clipPlaneId=cap-12288;if(GLEmulation.clipPlaneEnabled[clipPlaneId]!=true){GLImmediate.currentRenderer=null;GLEmulation.clipPlaneEnabled[clipPlaneId]=true}return}else if(cap>=16384&&cap<16392){var lightId=cap-16384;if(GLEmulation.lightEnabled[lightId]!=true){GLImmediate.currentRenderer=null;GLEmulation.lightEnabled[lightId]=true}return}else if(cap==2896){if(GLEmulation.lightingEnabled!=true){GLImmediate.currentRenderer=null;GLEmulation.lightingEnabled=true}return}else if(cap==3008){if(GLEmulation.alphaTestEnabled!=true){GLImmediate.currentRenderer=null;GLEmulation.alphaTestEnabled=true}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}orig_glEnable(cap)};var orig_glDisable=_glDisable;_glDisable=_emscripten_glDisable=cap=>{GLImmediate.lastRenderer?.cleanup();if(cap==2912){if(GLEmulation.fogEnabled!=false){GLImmediate.currentRenderer=null;GLEmulation.fogEnabled=false}return}else if(cap>=12288&&cap<12294){var clipPlaneId=cap-12288;if(GLEmulation.clipPlaneEnabled[clipPlaneId]!=false){GLImmediate.currentRenderer=null;GLEmulation.clipPlaneEnabled[clipPlaneId]=false}return}else if(cap>=16384&&cap<16392){var lightId=cap-16384;if(GLEmulation.lightEnabled[lightId]!=false){GLImmediate.currentRenderer=null;GLEmulation.lightEnabled[lightId]=false}return}else if(cap==2896){if(GLEmulation.lightingEnabled!=false){GLImmediate.currentRenderer=null;GLEmulation.lightingEnabled=false}return}else if(cap==3008){if(GLEmulation.alphaTestEnabled!=false){GLImmediate.currentRenderer=null;GLEmulation.alphaTestEnabled=false}return}else if(cap==3553){return}else if(!(cap in validCapabilities)){return}orig_glDisable(cap)};_glIsEnabled=_emscripten_glIsEnabled=cap=>{if(cap==2912){return GLEmulation.fogEnabled?1:0}else if(cap>=12288&&cap<12294){var clipPlaneId=cap-12288;return GLEmulation.clipPlaneEnabled[clipPlaneId]?1:0}else if(cap>=16384&&cap<16392){var lightId=cap-16384;return GLEmulation.lightEnabled[lightId]?1:0}else if(cap==2896){return GLEmulation.lightingEnabled?1:0}else if(cap==3008){return GLEmulation.alphaTestEnabled?1:0}else if(!(cap in validCapabilities)){return 0}return GLctx.isEnabled(cap)};var orig_glGetBooleanv=_glGetBooleanv;_glGetBooleanv=_emscripten_glGetBooleanv=(pname,p)=>{var attrib=GLEmulation.getAttributeFromCapability(pname);if(attrib!==null){var result=GLImmediate.enabledClientAttributes[attrib];HEAP8[p]=result===true?1:0;return}orig_glGetBooleanv(pname,p)};var orig_glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=(pname,params)=>{switch(pname){case 34018:pname=GLctx.MAX_TEXTURE_IMAGE_UNITS;break;case 35658:{var result=GLctx.getParameter(GLctx.MAX_VERTEX_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return}case 35657:{var result=GLctx.getParameter(GLctx.MAX_FRAGMENT_UNIFORM_VECTORS);HEAP32[params>>2]=result*4;return}case 35659:{var result=GLctx.getParameter(GLctx.MAX_VARYING_VECTORS);HEAP32[params>>2]=result*4;return}case 34929:pname=GLctx.MAX_COMBINED_TEXTURE_IMAGE_UNITS;break;case 32890:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.size:0;return}case 32891:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.type:0;return}case 32892:{var attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];HEAP32[params>>2]=attribute?attribute.stride:0;return}case 32897:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.size:0;return}case 32898:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.type:0;return}case 32899:{var attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];HEAP32[params>>2]=attribute?attribute.stride:0;return}case 32904:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.size:0;return}case 32905:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.type:0;return}case 32906:{var attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];HEAP32[params>>2]=attribute?attribute.stride:0;return}case 3378:{HEAP32[params>>2]=GLEmulation.MAX_CLIP_PLANES;return}case 2976:{HEAP32[params>>2]=GLImmediate.currentMatrix+5888;return}case 3009:{HEAP32[params>>2]=GLEmulation.alphaTestFunc;return}}orig_glGetIntegerv(pname,params)};var orig_glGetString=_glGetString;_glGetString=_emscripten_glGetString=name_=>{if(GL.stringCache[name_])return GL.stringCache[name_];switch(name_){case 7939:var ret=stringToNewUTF8(getEmscriptenSupportedExtensions(GLctx).join(" ")+" GL_EXT_texture_env_combine GL_ARB_texture_env_crossbar GL_ATI_texture_env_combine3 GL_NV_texture_env_combine4 GL_EXT_texture_env_dot3 GL_ARB_multitexture GL_ARB_vertex_buffer_object GL_EXT_framebuffer_object GL_ARB_vertex_program GL_ARB_fragment_program GL_ARB_shading_language_100 GL_ARB_shader_objects GL_ARB_vertex_shader GL_ARB_fragment_shader GL_ARB_texture_cube_map GL_EXT_draw_range_elements"+(GL.currentContext.compressionExt?" GL_ARB_texture_compression GL_EXT_texture_compression_s3tc":"")+(GL.currentContext.anisotropicExt?" GL_EXT_texture_filter_anisotropic":""));return GL.stringCache[name_]=ret}return orig_glGetString(name_)};GL.shaderInfos={};var orig_glCreateShader=_glCreateShader;_glCreateShader=_emscripten_glCreateShader=shaderType=>{var id=orig_glCreateShader(shaderType);GL.shaderInfos[id]={type:shaderType,ftransform:false};return id};function ensurePrecision(source){if(!/precision +(low|medium|high)p +float *;/.test(source)){source="#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n"+source}return source}_glShaderSource=_emscripten_glShaderSource=(shader,count,string,length)=>{var source=GL.getSource(shader,count,string,length);if(GL.shaderInfos[shader].type==GLctx.VERTEX_SHADER){var has_pm=source.search(/u_projection/)>=0;var has_mm=source.search(/u_modelView/)>=0;var has_pv=source.search(/a_position/)>=0;var need_pm=0,need_mm=0,need_pv=0;var old=source;source=source.replace(/ftransform\(\)/g,"(u_projection * u_modelView * a_position)");if(old!=source)need_pm=need_mm=need_pv=1;old=source;source=source.replace(/gl_ProjectionMatrix/g,"u_projection");if(old!=source)need_pm=1;old=source;source=source.replace(/gl_ModelViewMatrixTranspose\[2\]/g,"vec4(u_modelView[0][2], u_modelView[1][2], u_modelView[2][2], u_modelView[3][2])");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_ModelViewMatrix/g,"u_modelView");if(old!=source)need_mm=1;old=source;source=source.replace(/gl_Vertex/g,"a_position");if(old!=source)need_pv=1;old=source;source=source.replace(/gl_ModelViewProjectionMatrix/g,"(u_projection * u_modelView)");if(old!=source)need_pm=need_mm=1;if(need_pv&&!has_pv)source="attribute vec4 a_position; \n"+source;if(need_mm&&!has_mm)source="uniform mat4 u_modelView; \n"+source;if(need_pm&&!has_pm)source="uniform mat4 u_projection; \n"+source;GL.shaderInfos[shader].ftransform=need_pm||need_mm||need_pv;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){old=source;var need_vtc=source.search(`v_texCoord${i}`)==-1;source=source.replace(new RegExp(`gl_TexCoord\\[${i}\\]`,"g"),`v_texCoord${i}`).replace(new RegExp(`gl_MultiTexCoord${i}`,"g"),`a_texCoord${i}`);if(source!=old){source=`attribute vec4 a_texCoord${i}; \n${source}`;if(need_vtc){source=`varying vec4 v_texCoord${i};   \n${source}`}}old=source;source=source.replace(new RegExp(`gl_TextureMatrix\\[${i}\\]`,"g"),`u_textureMatrix${i}`);if(source!=old){source=`uniform mat4 u_textureMatrix${i}; \n${source}`}}if(source.includes("gl_FrontColor")){source="varying vec4 v_color; \n"+source.replace(/gl_FrontColor/g,"v_color")}if(source.includes("gl_Color")){source="attribute vec4 a_color; \n"+source.replace(/gl_Color/g,"a_color")}if(source.includes("gl_Normal")){source="attribute vec3 a_normal; \n"+source.replace(/gl_Normal/g,"a_normal")}if(source.includes("gl_FogFragCoord")){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}}else{for(i=0;i<GLImmediate.MAX_TEXTURES;i++){old=source;source=source.replace(new RegExp(`gl_TexCoord\\[${i}\\]`,"g"),`v_texCoord${i}`);if(source!=old){source="varying vec4 v_texCoord"+i+";   \n"+source}}if(source.includes("gl_Color")){source="varying vec4 v_color; \n"+source.replace(/gl_Color/g,"v_color")}if(source.includes("gl_Fog.color")){source="uniform vec4 u_fogColor;   \n"+source.replace(/gl_Fog.color/g,"u_fogColor")}if(source.includes("gl_Fog.end")){source="uniform float u_fogEnd;   \n"+source.replace(/gl_Fog.end/g,"u_fogEnd")}if(source.includes("gl_Fog.scale")){source="uniform float u_fogScale;   \n"+source.replace(/gl_Fog.scale/g,"u_fogScale")}if(source.includes("gl_Fog.density")){source="uniform float u_fogDensity;   \n"+source.replace(/gl_Fog.density/g,"u_fogDensity")}if(source.includes("gl_FogFragCoord")){source="varying float v_fogFragCoord;   \n"+source.replace(/gl_FogFragCoord/g,"v_fogFragCoord")}source=ensurePrecision(source)}GLctx.shaderSource(GL.shaders[shader],source)};_glCompileShader=_emscripten_glCompileShader=shader=>{GLctx.compileShader(GL.shaders[shader])};GL.programShaders={};var orig_glAttachShader=_glAttachShader;_glAttachShader=_emscripten_glAttachShader=(program,shader)=>{GL.programShaders[program]||=[];GL.programShaders[program].push(shader);orig_glAttachShader(program,shader)};var orig_glDetachShader=_glDetachShader;_glDetachShader=_emscripten_glDetachShader=(program,shader)=>{var programShader=GL.programShaders[program];if(!programShader){err(`WARNING: _glDetachShader received invalid program: ${program}`);return}var index=programShader.indexOf(shader);programShader.splice(index,1);orig_glDetachShader(program,shader)};var orig_glUseProgram=_glUseProgram;_glUseProgram=_emscripten_glUseProgram=program=>{if(GL.currProgram!=program){GLImmediate.currentRenderer=null;GL.currProgram=program;GLImmediate.fixedFunctionProgram=0;orig_glUseProgram(program)}};var orig_glDeleteProgram=_glDeleteProgram;_glDeleteProgram=_emscripten_glDeleteProgram=program=>{orig_glDeleteProgram(program);if(program==GL.currProgram){GLImmediate.currentRenderer=null;GL.currProgram=0}};var zeroUsedPrograms={};var orig_glBindAttribLocation=_glBindAttribLocation;_glBindAttribLocation=_emscripten_glBindAttribLocation=(program,index,name)=>{if(index==0)zeroUsedPrograms[program]=true;orig_glBindAttribLocation(program,index,name)};var orig_glLinkProgram=_glLinkProgram;_glLinkProgram=_emscripten_glLinkProgram=program=>{if(!(program in zeroUsedPrograms)){GLctx.bindAttribLocation(GL.programs[program],0,"a_position")}orig_glLinkProgram(program)};var orig_glBindBuffer=_glBindBuffer;_glBindBuffer=_emscripten_glBindBuffer=(target,buffer)=>{orig_glBindBuffer(target,buffer);if(target==GLctx.ARRAY_BUFFER){if(GLEmulation.currentVao){GLEmulation.currentVao.arrayBuffer=buffer}}else if(target==GLctx.ELEMENT_ARRAY_BUFFER){if(GLEmulation.currentVao)GLEmulation.currentVao.elementArrayBuffer=buffer}};var orig_glGetFloatv=_glGetFloatv;_glGetFloatv=_emscripten_glGetFloatv=(pname,params)=>{if(pname==2982){HEAPF32.set(GLImmediate.matrix[0],params>>2)}else if(pname==2983){HEAPF32.set(GLImmediate.matrix[1],params>>2)}else if(pname==2984){HEAPF32.set(GLImmediate.matrix[2+GLImmediate.clientActiveTexture],params>>2)}else if(pname==2918){HEAPF32.set(GLEmulation.fogColor,params>>2)}else if(pname==2915){HEAPF32[params>>2]=GLEmulation.fogStart}else if(pname==2916){HEAPF32[params>>2]=GLEmulation.fogEnd}else if(pname==2914){HEAPF32[params>>2]=GLEmulation.fogDensity}else if(pname==2917){HEAPF32[params>>2]=GLEmulation.fogMode}else if(pname==2899){HEAPF32[params>>2]=GLEmulation.lightModelAmbient[0];HEAPF32[params+4>>2]=GLEmulation.lightModelAmbient[1];HEAPF32[params+8>>2]=GLEmulation.lightModelAmbient[2];HEAPF32[params+12>>2]=GLEmulation.lightModelAmbient[3]}else if(pname==3010){HEAPF32[params>>2]=GLEmulation.alphaTestRef}else{orig_glGetFloatv(pname,params)}};var orig_glHint=_glHint;_glHint=_emscripten_glHint=(target,mode)=>{if(target==34031){return}orig_glHint(target,mode)};var orig_glEnableVertexAttribArray=_glEnableVertexAttribArray;_glEnableVertexAttribArray=_emscripten_glEnableVertexAttribArray=index=>{orig_glEnableVertexAttribArray(index);GLEmulation.enabledVertexAttribArrays[index]=1;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledVertexAttribArrays[index]=1};var orig_glDisableVertexAttribArray=_glDisableVertexAttribArray;_glDisableVertexAttribArray=_emscripten_glDisableVertexAttribArray=index=>{orig_glDisableVertexAttribArray(index);delete GLEmulation.enabledVertexAttribArrays[index];if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledVertexAttribArrays[index]};var orig_glVertexAttribPointer=_glVertexAttribPointer;_glVertexAttribPointer=_emscripten_glVertexAttribPointer=(index,size,type,normalized,stride,pointer)=>{orig_glVertexAttribPointer(index,size,type,normalized,stride,pointer);if(GLEmulation.currentVao){GLEmulation.currentVao.vertexAttribPointers[index]=[index,size,type,normalized,stride,pointer]}}},getAttributeFromCapability(cap){var attrib=null;switch(cap){case 3553:case 32888:attrib=GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture;break;case 32884:attrib=GLImmediate.VERTEX;break;case 32885:attrib=GLImmediate.NORMAL;break;case 32886:attrib=GLImmediate.COLOR;break}return attrib}};var GLImmediate={MapTreeLib:null,spawnMapTreeLib:()=>{function CNaiveListMap(){var list=[];this.insert=function CNaiveListMap_insert(key,val){if(this.contains(key|0))return false;list.push([key,val]);return true};var __contains_i;this.contains=function CNaiveListMap_contains(key){for(__contains_i=0;__contains_i<list.length;++__contains_i){if(list[__contains_i][0]===key)return true}return false};var __get_i;this.get=function CNaiveListMap_get(key){for(__get_i=0;__get_i<list.length;++__get_i){if(list[__get_i][0]===key)return list[__get_i][1]}return undefined}}function CMapTree(){function CNLNode(){var map=new CNaiveListMap;this.child=function CNLNode_child(keyFrag){if(!map.contains(keyFrag|0)){map.insert(keyFrag|0,new CNLNode)}return map.get(keyFrag|0)};this.value=undefined;this.get=function CNLNode_get(){return this.value};this.set=function CNLNode_set(val){this.value=val}}function CKeyView(root){var cur;this.reset=function CKeyView_reset(){cur=root;return this};this.reset();this.next=function CKeyView_next(keyFrag){cur=cur.child(keyFrag);return this};this.get=function CKeyView_get(){return cur.get()};this.set=function CKeyView_set(val){cur.set(val)}}var root;var staticKeyView;this.createKeyView=function CNLNode_createKeyView(){return new CKeyView(root)};this.clear=function CNLNode_clear(){root=new CNLNode;staticKeyView=this.createKeyView()};this.clear();this.getStaticKeyView=function CNLNode_getStaticKeyView(){staticKeyView.reset();return staticKeyView}}return{create:()=>new CMapTree}},TexEnvJIT:null,spawnTexEnvJIT:()=>{var GL_TEXTURE0=33984;var GL_TEXTURE_1D=3552;var GL_TEXTURE_2D=3553;var GL_TEXTURE_3D=32879;var GL_TEXTURE_CUBE_MAP=34067;var GL_TEXTURE_ENV=8960;var GL_TEXTURE_ENV_MODE=8704;var GL_TEXTURE_ENV_COLOR=8705;var GL_SRC0_RGB=34176;var GL_SRC1_RGB=34177;var GL_SRC2_RGB=34178;var GL_SRC0_ALPHA=34184;var GL_SRC1_ALPHA=34185;var GL_SRC2_ALPHA=34186;var GL_OPERAND0_RGB=34192;var GL_OPERAND1_RGB=34193;var GL_OPERAND2_RGB=34194;var GL_OPERAND0_ALPHA=34200;var GL_OPERAND1_ALPHA=34201;var GL_OPERAND2_ALPHA=34202;var GL_COMBINE_RGB=34161;var GL_COMBINE_ALPHA=34162;var GL_RGB_SCALE=34163;var GL_ALPHA_SCALE=3356;var GL_ADD=260;var GL_BLEND=3042;var GL_REPLACE=7681;var GL_MODULATE=8448;var GL_DECAL=8449;var GL_COMBINE=34160;var GL_SUBTRACT=34023;var GL_INTERPOLATE=34165;var GL_TEXTURE=5890;var GL_CONSTANT=34166;var GL_PRIMARY_COLOR=34167;var GL_PREVIOUS=34168;var GL_SRC_COLOR=768;var GL_ONE_MINUS_SRC_COLOR=769;var GL_SRC_ALPHA=770;var GL_ONE_MINUS_SRC_ALPHA=771;var TEXENVJIT_NAMESPACE_PREFIX="tej_";var TEX_UNIT_UNIFORM_PREFIX="uTexUnit";var TEX_COORD_VARYING_PREFIX="vTexCoord";var PRIM_COLOR_VARYING="vPrimColor";var TEX_MATRIX_UNIFORM_PREFIX="uTexMatrix";var s_texUnits=null;var s_activeTexture=0;var s_requiredTexUnitsForPass=[];function abort(info){assert(false,"[TexEnvJIT] ABORT: "+info)}function abort_noSupport(info){abort("No support: "+info)}function abort_sanity(info){abort("Sanity failure: "+info)}function genTexUnitSampleExpr(texUnitID){var texUnit=s_texUnits[texUnitID];var texType=texUnit.getTexType();var func=null;switch(texType){case GL_TEXTURE_1D:func="texture2D";break;case GL_TEXTURE_2D:func="texture2D";break;case GL_TEXTURE_3D:return abort_noSupport("No support for 3D textures.");case GL_TEXTURE_CUBE_MAP:func="textureCube";break;default:return abort_sanity(`Unknown texType: ${ptrToString(texType)}`)}var texCoordExpr=TEX_COORD_VARYING_PREFIX+texUnitID;if(TEX_MATRIX_UNIFORM_PREFIX!=null){texCoordExpr=`(${TEX_MATRIX_UNIFORM_PREFIX}${texUnitID} * ${texCoordExpr})`}return`${func}(${TEX_UNIT_UNIFORM_PREFIX}${texUnitID}, ${texCoordExpr}.xy)`}function getTypeFromCombineOp(op){switch(op){case GL_SRC_COLOR:case GL_ONE_MINUS_SRC_COLOR:return"vec3";case GL_SRC_ALPHA:case GL_ONE_MINUS_SRC_ALPHA:return"float"}return abort_noSupport("Unsupported combiner op: "+ptrToString(op))}function getCurTexUnit(){return s_texUnits[s_activeTexture]}function genCombinerSourceExpr(texUnitID,constantExpr,previousVar,src,op){var srcExpr=null;switch(src){case GL_TEXTURE:srcExpr=genTexUnitSampleExpr(texUnitID);break;case GL_CONSTANT:srcExpr=constantExpr;break;case GL_PRIMARY_COLOR:srcExpr=PRIM_COLOR_VARYING;break;case GL_PREVIOUS:srcExpr=previousVar;break;default:return abort_noSupport("Unsupported combiner src: "+ptrToString(src))}var expr=null;switch(op){case GL_SRC_COLOR:expr=srcExpr+".rgb";break;case GL_ONE_MINUS_SRC_COLOR:expr="(vec3(1.0) - "+srcExpr+".rgb)";break;case GL_SRC_ALPHA:expr=srcExpr+".a";break;case GL_ONE_MINUS_SRC_ALPHA:expr="(1.0 - "+srcExpr+".a)";break;default:return abort_noSupport("Unsupported combiner op: "+ptrToString(op))}return expr}function valToFloatLiteral(val){if(val==Math.round(val))return val+".0";return val}function CTexEnv(){this.mode=GL_MODULATE;this.colorCombiner=GL_MODULATE;this.alphaCombiner=GL_MODULATE;this.colorScale=1;this.alphaScale=1;this.envColor=[0,0,0,0];this.colorSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.alphaSrc=[GL_TEXTURE,GL_PREVIOUS,GL_CONSTANT];this.colorOp=[GL_SRC_COLOR,GL_SRC_COLOR,GL_SRC_ALPHA];this.alphaOp=[GL_SRC_ALPHA,GL_SRC_ALPHA,GL_SRC_ALPHA];this.traverseKey={7681:0,8448:1,260:2,3042:3,8449:4,34160:5,34023:3,34165:4,5890:0,34166:1,34167:2,34168:3,768:0,769:1,770:2,771:3};this.key0=-1;this.key1=0;this.key2=0;this.computeKey0=function(){var k=this.traverseKey;var key=k[this.mode]*1638400;key+=k[this.colorCombiner]*327680;key+=k[this.alphaCombiner]*65536;key+=(this.colorScale-1)*16384;key+=(this.alphaScale-1)*4096;key+=k[this.colorSrc[0]]*1024;key+=k[this.colorSrc[1]]*256;key+=k[this.colorSrc[2]]*64;key+=k[this.alphaSrc[0]]*16;key+=k[this.alphaSrc[1]]*4;key+=k[this.alphaSrc[2]];return key};this.computeKey1=function(){var k=this.traverseKey;var key=k[this.colorOp[0]]*4096;key+=k[this.colorOp[1]]*1024;key+=k[this.colorOp[2]]*256;key+=k[this.alphaOp[0]]*16;key+=k[this.alphaOp[1]]*4;key+=k[this.alphaOp[2]];return key};this.computeKey2=function(){return this.envColor[0]*16777216+this.envColor[1]*65536+this.envColor[2]*256+1+this.envColor[3]};this.recomputeKey=function(){this.key0=this.computeKey0();this.key1=this.computeKey1();this.key2=this.computeKey2()};this.invalidateKey=function(){this.key0=-1;GLImmediate.currentRenderer=null}}function CTexUnit(){this.env=new CTexEnv;this.enabled_tex1D=false;this.enabled_tex2D=false;this.enabled_tex3D=false;this.enabled_texCube=false;this.texTypesEnabled=0;this.traverseState=function CTexUnit_traverseState(keyView){if(this.texTypesEnabled){if(this.env.key0==-1){this.env.recomputeKey()}keyView.next(this.texTypesEnabled|this.env.key0<<4);keyView.next(this.env.key1);keyView.next(this.env.key2)}else{keyView.next(0)}}}CTexUnit.prototype.enabled=function CTexUnit_enabled(){return this.texTypesEnabled};CTexUnit.prototype.genPassLines=function CTexUnit_genPassLines(passOutputVar,passInputVar,texUnitID){if(!this.enabled()){return["vec4 "+passOutputVar+" = "+passInputVar+";"]}var lines=this.env.genPassLines(passOutputVar,passInputVar,texUnitID).join("\n");var texLoadLines="";var texLoadRegex=/(texture.*?\(.*?\))/g;var loadCounter=0;var load;while(load=texLoadRegex.exec(lines)){var texLoadExpr=load[1];var secondOccurrence=lines.slice(load.index+1).indexOf(texLoadExpr);if(secondOccurrence!=-1){var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texLoadVar=prefix+"texload"+loadCounter++;var texLoadLine="vec4 "+texLoadVar+" = "+texLoadExpr+";\n";texLoadLines+=texLoadLine+"\n";lines=lines.split(texLoadExpr).join(texLoadVar);texLoadRegex=/(texture.*\(.*\))/g}}return[texLoadLines+lines]};CTexUnit.prototype.getTexType=function CTexUnit_getTexType(){if(this.enabled_texCube){return GL_TEXTURE_CUBE_MAP}else if(this.enabled_tex3D){return GL_TEXTURE_3D}else if(this.enabled_tex2D){return GL_TEXTURE_2D}else if(this.enabled_tex1D){return GL_TEXTURE_1D}return 0};CTexEnv.prototype.genPassLines=function CTexEnv_genPassLines(passOutputVar,passInputVar,texUnitID){switch(this.mode){case GL_REPLACE:{return["vec4 "+passOutputVar+" = "+genTexUnitSampleExpr(texUnitID)+";"]}case GL_ADD:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";","vec3 "+colorVar+" = "+passInputVar+".rgb + "+texVar+".rgb;","float "+alphaVar+" = "+passInputVar+".a * "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]}case GL_MODULATE:{var line=["vec4 "+passOutputVar," = ",passInputVar," * ",genTexUnitSampleExpr(texUnitID),";"];return[line.join("")]}case GL_DECAL:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".a)"," + ",texVar+".rgb * "+texVar+".a",";"].join(""),"float "+alphaVar+" = "+passInputVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]}case GL_BLEND:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var texVar=prefix+"tex";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";return["vec4 "+texVar+" = "+genTexUnitSampleExpr(texUnitID)+";",["vec3 "+colorVar+" = ",passInputVar+".rgb * (1.0 - "+texVar+".rgb)"," + ",PRIM_COLOR_VARYING+".rgb * "+texVar+".rgb",";"].join(""),"float "+alphaVar+" = "+texVar+".a;","vec4 "+passOutputVar+" = vec4("+colorVar+", "+alphaVar+");"]}case GL_COMBINE:{var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+texUnitID+"_";var colorVar=prefix+"color";var alphaVar=prefix+"alpha";var colorLines=this.genCombinerLines(true,colorVar,passInputVar,texUnitID,this.colorCombiner,this.colorSrc,this.colorOp);var alphaLines=this.genCombinerLines(false,alphaVar,passInputVar,texUnitID,this.alphaCombiner,this.alphaSrc,this.alphaOp);var scaledColor=this.colorScale==1?colorVar:colorVar+" * "+valToFloatLiteral(this.colorScale);var scaledAlpha=this.alphaScale==1?alphaVar:alphaVar+" * "+valToFloatLiteral(this.alphaScale);var line=["vec4 "+passOutputVar," = ","vec4(",scaledColor,", ",scaledAlpha,")",";"].join("");return[].concat(colorLines,alphaLines,[line])}}return abort_noSupport("Unsupported TexEnv mode: "+ptrToString(this.mode))};CTexEnv.prototype.genCombinerLines=function CTexEnv_getCombinerLines(isColor,outputVar,passInputVar,texUnitID,combiner,srcArr,opArr){var argsNeeded=null;switch(combiner){case GL_REPLACE:argsNeeded=1;break;case GL_MODULATE:case GL_ADD:case GL_SUBTRACT:argsNeeded=2;break;case GL_INTERPOLATE:argsNeeded=3;break;default:return abort_noSupport("Unsupported combiner: "+ptrToString(combiner))}var constantExpr=["vec4(",valToFloatLiteral(this.envColor[0]),", ",valToFloatLiteral(this.envColor[1]),", ",valToFloatLiteral(this.envColor[2]),", ",valToFloatLiteral(this.envColor[3]),")"].join("");var src0Expr=argsNeeded>=1?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[0],opArr[0]):null;var src1Expr=argsNeeded>=2?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[1],opArr[1]):null;var src2Expr=argsNeeded>=3?genCombinerSourceExpr(texUnitID,constantExpr,passInputVar,srcArr[2],opArr[2]):null;var outputType=isColor?"vec3":"float";var lines=null;switch(combiner){case GL_REPLACE:{lines=[`${outputType} ${outputVar} = ${src0Expr};`];break}case GL_MODULATE:{lines=[`${outputType} ${outputVar} = ${src0Expr} * ${src1Expr};`];break}case GL_ADD:{lines=[`${outputType} ${outputVar} = ${src0Expr} + ${src1Expr};`];break}case GL_SUBTRACT:{lines=[`${outputType} ${outputVar} = ${src0Expr} - ${src1Expr};`];break}case GL_INTERPOLATE:{var prefix=`${TEXENVJIT_NAMESPACE_PREFIX}env${texUnitID}_`;var arg2Var=`${prefix}colorSrc2`;var arg2Type=getTypeFromCombineOp(this.colorOp[2]);lines=[`${arg2Type} ${arg2Var} = ${src2Expr};`,`${outputType} ${outputVar} = ${src0Expr} * ${arg2Var} + ${src1Expr} * (1.0 - ${arg2Var});`];break}default:return abort_sanity("Unmatched TexEnv.colorCombiner?")}return lines};return{init:(gl,specifiedMaxTextureImageUnits)=>{var maxTexUnits=0;if(specifiedMaxTextureImageUnits){maxTexUnits=specifiedMaxTextureImageUnits}else if(gl){maxTexUnits=gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS)}s_texUnits=[];for(var i=0;i<maxTexUnits;i++){s_texUnits.push(new CTexUnit)}},setGLSLVars:(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix)=>{TEX_UNIT_UNIFORM_PREFIX=uTexUnitPrefix;TEX_COORD_VARYING_PREFIX=vTexCoordPrefix;PRIM_COLOR_VARYING=vPrimColor;TEX_MATRIX_UNIFORM_PREFIX=uTexMatrixPrefix},genAllPassLines:(resultDest,indentSize=0)=>{s_requiredTexUnitsForPass.length=0;var lines=[];var lastPassVar=PRIM_COLOR_VARYING;for(var i=0;i<s_texUnits.length;i++){if(!s_texUnits[i].enabled())continue;s_requiredTexUnitsForPass.push(i);var prefix=TEXENVJIT_NAMESPACE_PREFIX+"env"+i+"_";var passOutputVar=prefix+"result";var newLines=s_texUnits[i].genPassLines(passOutputVar,lastPassVar,i);lines=lines.concat(newLines,[""]);lastPassVar=passOutputVar}lines.push(resultDest+" = "+lastPassVar+";");var indent="";for(var i=0;i<indentSize;i++)indent+=" ";var output=indent+lines.join("\n"+indent);return output},getUsedTexUnitList:()=>s_requiredTexUnitsForPass,getActiveTexture:()=>s_activeTexture,traverseState:keyView=>{for(var i=0;i<s_texUnits.length;i++){s_texUnits[i].traverseState(keyView)}},getTexUnitType:texUnitID=>s_texUnits[texUnitID].getTexType(),hook_activeTexture:texture=>{s_activeTexture=texture-GL_TEXTURE0;if(GLImmediate.currentMatrix>=2){GLImmediate.currentMatrix=2+s_activeTexture}},hook_enable:cap=>{var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(!cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=true;cur.texTypesEnabled|=1}break;case GL_TEXTURE_2D:if(!cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=true;cur.texTypesEnabled|=2}break;case GL_TEXTURE_3D:if(!cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=true;cur.texTypesEnabled|=4}break;case GL_TEXTURE_CUBE_MAP:if(!cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=true;cur.texTypesEnabled|=8}break}},hook_disable:cap=>{var cur=getCurTexUnit();switch(cap){case GL_TEXTURE_1D:if(cur.enabled_tex1D){GLImmediate.currentRenderer=null;cur.enabled_tex1D=false;cur.texTypesEnabled&=~1}break;case GL_TEXTURE_2D:if(cur.enabled_tex2D){GLImmediate.currentRenderer=null;cur.enabled_tex2D=false;cur.texTypesEnabled&=~2}break;case GL_TEXTURE_3D:if(cur.enabled_tex3D){GLImmediate.currentRenderer=null;cur.enabled_tex3D=false;cur.texTypesEnabled&=~4}break;case GL_TEXTURE_CUBE_MAP:if(cur.enabled_texCube){GLImmediate.currentRenderer=null;cur.enabled_texCube=false;cur.texTypesEnabled&=~8}break}},hook_texEnvf(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:err("WARNING: Unhandled `pname` in call to `glTexEnvf`.")}},hook_texEnvi(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:if(env.mode!=param){env.invalidateKey();env.mode=param}break;case GL_COMBINE_RGB:if(env.colorCombiner!=param){env.invalidateKey();env.colorCombiner=param}break;case GL_COMBINE_ALPHA:if(env.alphaCombiner!=param){env.invalidateKey();env.alphaCombiner=param}break;case GL_SRC0_RGB:if(env.colorSrc[0]!=param){env.invalidateKey();env.colorSrc[0]=param}break;case GL_SRC1_RGB:if(env.colorSrc[1]!=param){env.invalidateKey();env.colorSrc[1]=param}break;case GL_SRC2_RGB:if(env.colorSrc[2]!=param){env.invalidateKey();env.colorSrc[2]=param}break;case GL_SRC0_ALPHA:if(env.alphaSrc[0]!=param){env.invalidateKey();env.alphaSrc[0]=param}break;case GL_SRC1_ALPHA:if(env.alphaSrc[1]!=param){env.invalidateKey();env.alphaSrc[1]=param}break;case GL_SRC2_ALPHA:if(env.alphaSrc[2]!=param){env.invalidateKey();env.alphaSrc[2]=param}break;case GL_OPERAND0_RGB:if(env.colorOp[0]!=param){env.invalidateKey();env.colorOp[0]=param}break;case GL_OPERAND1_RGB:if(env.colorOp[1]!=param){env.invalidateKey();env.colorOp[1]=param}break;case GL_OPERAND2_RGB:if(env.colorOp[2]!=param){env.invalidateKey();env.colorOp[2]=param}break;case GL_OPERAND0_ALPHA:if(env.alphaOp[0]!=param){env.invalidateKey();env.alphaOp[0]=param}break;case GL_OPERAND1_ALPHA:if(env.alphaOp[1]!=param){env.invalidateKey();env.alphaOp[1]=param}break;case GL_OPERAND2_ALPHA:if(env.alphaOp[2]!=param){env.invalidateKey();env.alphaOp[2]=param}break;case GL_RGB_SCALE:if(env.colorScale!=param){env.invalidateKey();env.colorScale=param}break;case GL_ALPHA_SCALE:if(env.alphaScale!=param){env.invalidateKey();env.alphaScale=param}break;default:err("WARNING: Unhandled `pname` in call to `glTexEnvi`.")}},hook_texEnvfv(target,pname,params){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:{for(var i=0;i<4;i++){var param=HEAPF32[params+i*4>>2];if(env.envColor[i]!=param){env.invalidateKey();env.envColor[i]=param}}break}default:err("WARNING: Unhandled `pname` in call to `glTexEnvfv`.")}},hook_getTexEnviv(target,pname,param){if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_MODE:HEAP32[param>>2]=env.mode;return;case GL_TEXTURE_ENV_COLOR:HEAP32[param>>2]=Math.max(Math.min(env.envColor[0]*255,255,-255));HEAP32[param+1>>2]=Math.max(Math.min(env.envColor[1]*255,255,-255));HEAP32[param+2>>2]=Math.max(Math.min(env.envColor[2]*255,255,-255));HEAP32[param+3>>2]=Math.max(Math.min(env.envColor[3]*255,255,-255));return;case GL_COMBINE_RGB:HEAP32[param>>2]=env.colorCombiner;return;case GL_COMBINE_ALPHA:HEAP32[param>>2]=env.alphaCombiner;return;case GL_SRC0_RGB:HEAP32[param>>2]=env.colorSrc[0];return;case GL_SRC1_RGB:HEAP32[param>>2]=env.colorSrc[1];return;case GL_SRC2_RGB:HEAP32[param>>2]=env.colorSrc[2];return;case GL_SRC0_ALPHA:HEAP32[param>>2]=env.alphaSrc[0];return;case GL_SRC1_ALPHA:HEAP32[param>>2]=env.alphaSrc[1];return;case GL_SRC2_ALPHA:HEAP32[param>>2]=env.alphaSrc[2];return;case GL_OPERAND0_RGB:HEAP32[param>>2]=env.colorOp[0];return;case GL_OPERAND1_RGB:HEAP32[param>>2]=env.colorOp[1];return;case GL_OPERAND2_RGB:HEAP32[param>>2]=env.colorOp[2];return;case GL_OPERAND0_ALPHA:HEAP32[param>>2]=env.alphaOp[0];return;case GL_OPERAND1_ALPHA:HEAP32[param>>2]=env.alphaOp[1];return;case GL_OPERAND2_ALPHA:HEAP32[param>>2]=env.alphaOp[2];return;case GL_RGB_SCALE:HEAP32[param>>2]=env.colorScale;return;case GL_ALPHA_SCALE:HEAP32[param>>2]=env.alphaScale;return;default:err("WARNING: Unhandled `pname` in call to `glGetTexEnvi`.")}},hook_getTexEnvfv:(target,pname,param)=>{if(target!=GL_TEXTURE_ENV)return;var env=getCurTexUnit().env;switch(pname){case GL_TEXTURE_ENV_COLOR:HEAPF32[param>>2]=env.envColor[0];HEAPF32[param+4>>2]=env.envColor[1];HEAPF32[param+8>>2]=env.envColor[2];HEAPF32[param+12>>2]=env.envColor[3];return}}}},vertexData:null,vertexDataU8:null,tempData:null,indexData:null,vertexCounter:0,mode:-1,rendererCache:null,rendererComponents:[],rendererComponentPointer:0,lastRenderer:null,lastArrayBuffer:null,lastProgram:null,lastStride:-1,matrix:[],matrixStack:[],currentMatrix:0,tempMatrix:null,matricesModified:false,useTextureMatrix:false,VERTEX:0,NORMAL:1,COLOR:2,TEXTURE0:3,NUM_ATTRIBUTES:-1,MAX_TEXTURES:-1,totalEnabledClientAttributes:0,enabledClientAttributes:[0,0],clientAttributes:[],liveClientAttributes:[],currentRenderer:null,modifiedClientAttributes:false,clientActiveTexture:0,clientColor:null,usedTexUnitList:[],fixedFunctionProgram:null,setClientAttribute(name,size,type,stride,pointer){var attrib=GLImmediate.clientAttributes[name];if(!attrib){for(var i=0;i<=name;i++){GLImmediate.clientAttributes[i]||={name,size,type,stride,pointer,offset:0}}}else{attrib.name=name;attrib.size=size;attrib.type=type;attrib.stride=stride;attrib.pointer=pointer;attrib.offset=0}GLImmediate.modifiedClientAttributes=true},addRendererComponent(name,size,type){if(!GLImmediate.rendererComponents[name]){GLImmediate.rendererComponents[name]=1;GLImmediate.enabledClientAttributes[name]=true;GLImmediate.setClientAttribute(name,size,type,0,GLImmediate.rendererComponentPointer);GLImmediate.rendererComponentPointer+=size*GL.byteSizeByType[type-GL.byteSizeByTypeRoot]}else{GLImmediate.rendererComponents[name]++}},disableBeginEndClientAttributes(){for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){if(GLImmediate.rendererComponents[i])GLImmediate.enabledClientAttributes[i]=false}},getRenderer(){if(GLImmediate.currentRenderer){return GLImmediate.currentRenderer}var attributes=GLImmediate.liveClientAttributes;var cacheMap=GLImmediate.rendererCache;var keyView=cacheMap.getStaticKeyView().reset();var enabledAttributesKey=0;for(var i=0;i<attributes.length;i++){enabledAttributesKey|=1<<attributes[i].name}keyView.next(enabledAttributesKey);enabledAttributesKey=0;var fogParam=0;if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:fogParam=1;break;case 9729:fogParam=2;break;default:fogParam=3;break}}enabledAttributesKey=enabledAttributesKey<<2|fogParam;for(var clipPlaneId=0;clipPlaneId<GLEmulation.MAX_CLIP_PLANES;clipPlaneId++){enabledAttributesKey=enabledAttributesKey<<1|GLEmulation.clipPlaneEnabled[clipPlaneId]}enabledAttributesKey=enabledAttributesKey<<1|GLEmulation.lightingEnabled;for(var lightId=0;lightId<GLEmulation.MAX_LIGHTS;lightId++){enabledAttributesKey=enabledAttributesKey<<1|(GLEmulation.lightingEnabled?GLEmulation.lightEnabled[lightId]:0)}enabledAttributesKey=enabledAttributesKey<<3|(GLEmulation.alphaTestEnabled?GLEmulation.alphaTestFunc-512:7);enabledAttributesKey=enabledAttributesKey<<1|(GLImmediate.mode==GLctx.POINTS?1:0);keyView.next(enabledAttributesKey);keyView.next(GL.currProgram);if(!GL.currProgram){GLImmediate.TexEnvJIT.traverseState(keyView)}var renderer=keyView.get();if(!renderer){renderer=GLImmediate.createRenderer();GLImmediate.currentRenderer=renderer;keyView.set(renderer);return renderer}GLImmediate.currentRenderer=renderer;return renderer},createRenderer(renderer){var useCurrProgram=!!GL.currProgram;var hasTextures=false;for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var texAttribName=GLImmediate.TEXTURE0+i;if(!GLImmediate.enabledClientAttributes[texAttribName])continue;hasTextures=true}function Renderer(){this.init=function(){var uTexUnitPrefix="u_texUnit";var aTexCoordPrefix="a_texCoord";var vTexCoordPrefix="v_texCoord";var vPrimColor="v_color";var uTexMatrixPrefix=GLImmediate.useTextureMatrix?"u_textureMatrix":null;if(useCurrProgram){if(GL.shaderInfos[GL.programShaders[GL.currProgram][0]].type==GLctx.VERTEX_SHADER){this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][0]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][1]]}else{this.vertexShader=GL.shaders[GL.programShaders[GL.currProgram][1]];this.fragmentShader=GL.shaders[GL.programShaders[GL.currProgram][0]]}this.program=GL.programs[GL.currProgram];this.usedTexUnitList=[]}else{if(GLEmulation.fogEnabled){switch(GLEmulation.fogMode){case 2049:var fogFormula="  float fog = exp(-u_fogDensity * u_fogDensity * ecDistance * ecDistance); \n";break;case 9729:var fogFormula="  float fog = (u_fogEnd - ecDistance) * u_fogScale; \n";break;default:var fogFormula="  float fog = exp(-u_fogDensity * ecDistance); \n";break}}GLImmediate.TexEnvJIT.setGLSLVars(uTexUnitPrefix,vTexCoordPrefix,vPrimColor,uTexMatrixPrefix);var fsTexEnvPass=GLImmediate.TexEnvJIT.genAllPassLines("gl_FragColor",2);var texUnitAttribList="";var texUnitVaryingList="";var texUnitUniformList="";var vsTexCoordInits="";this.usedTexUnitList=GLImmediate.TexEnvJIT.getUsedTexUnitList();for(var i=0;i<this.usedTexUnitList.length;i++){var texUnit=this.usedTexUnitList[i];texUnitAttribList+="attribute vec4 "+aTexCoordPrefix+texUnit+";\n";texUnitVaryingList+="varying vec4 "+vTexCoordPrefix+texUnit+";\n";texUnitUniformList+="uniform sampler2D "+uTexUnitPrefix+texUnit+";\n";vsTexCoordInits+="  "+vTexCoordPrefix+texUnit+" = "+aTexCoordPrefix+texUnit+";\n";if(GLImmediate.useTextureMatrix){texUnitUniformList+="uniform mat4 "+uTexMatrixPrefix+texUnit+";\n"}}var vsFogVaryingInit=null;if(GLEmulation.fogEnabled){vsFogVaryingInit="  v_fogFragCoord = abs(ecPosition.z);\n"}var vsPointSizeDefs=null;var vsPointSizeInit=null;if(GLImmediate.mode==GLctx.POINTS){vsPointSizeDefs="uniform float u_pointSize;\n";vsPointSizeInit="  gl_PointSize = u_pointSize;\n"}var vsClipPlaneDefs="";var vsClipPlaneInit="";var fsClipPlaneDefs="";var fsClipPlanePass="";for(var clipPlaneId=0;clipPlaneId<GLEmulation.MAX_CLIP_PLANES;clipPlaneId++){if(GLEmulation.clipPlaneEnabled[clipPlaneId]){vsClipPlaneDefs+="uniform vec4 u_clipPlaneEquation"+clipPlaneId+";";vsClipPlaneDefs+="varying float v_clipDistance"+clipPlaneId+";";vsClipPlaneInit+="  v_clipDistance"+clipPlaneId+" = dot(ecPosition, u_clipPlaneEquation"+clipPlaneId+");";fsClipPlaneDefs+="varying float v_clipDistance"+clipPlaneId+";";fsClipPlanePass+="  if (v_clipDistance"+clipPlaneId+" < 0.0) discard;"}}var vsLightingDefs="";var vsLightingPass="";if(GLEmulation.lightingEnabled){vsLightingDefs+="attribute vec3 a_normal;";vsLightingDefs+="uniform mat3 u_normalMatrix;";vsLightingDefs+="uniform vec4 u_lightModelAmbient;";vsLightingDefs+="uniform vec4 u_materialAmbient;";vsLightingDefs+="uniform vec4 u_materialDiffuse;";vsLightingDefs+="uniform vec4 u_materialSpecular;";vsLightingDefs+="uniform float u_materialShininess;";vsLightingDefs+="uniform vec4 u_materialEmission;";vsLightingPass+="  vec3 ecNormal = normalize(u_normalMatrix * a_normal);";vsLightingPass+="  v_color.w = u_materialDiffuse.w;";vsLightingPass+="  v_color.xyz = u_materialEmission.xyz;";vsLightingPass+="  v_color.xyz += u_lightModelAmbient.xyz * u_materialAmbient.xyz;";for(var lightId=0;lightId<GLEmulation.MAX_LIGHTS;lightId++){if(GLEmulation.lightEnabled[lightId]){vsLightingDefs+="uniform vec4 u_lightAmbient"+lightId+";";vsLightingDefs+="uniform vec4 u_lightDiffuse"+lightId+";";vsLightingDefs+="uniform vec4 u_lightSpecular"+lightId+";";vsLightingDefs+="uniform vec4 u_lightPosition"+lightId+";";vsLightingPass+="  {";vsLightingPass+="    vec3 lightDirection = normalize(u_lightPosition"+lightId+").xyz;";vsLightingPass+="    vec3 halfVector = normalize(lightDirection + vec3(0,0,1));";vsLightingPass+="    vec3 ambient = u_lightAmbient"+lightId+".xyz * u_materialAmbient.xyz;";vsLightingPass+="    float diffuseI = max(dot(ecNormal, lightDirection), 0.0);";vsLightingPass+="    float specularI = max(dot(ecNormal, halfVector), 0.0);";vsLightingPass+="    vec3 diffuse = diffuseI * u_lightDiffuse"+lightId+".xyz * u_materialDiffuse.xyz;";vsLightingPass+="    specularI = (diffuseI > 0.0 && specularI > 0.0) ? exp(u_materialShininess * log(specularI)) : 0.0;";vsLightingPass+="    vec3 specular = specularI * u_lightSpecular"+lightId+".xyz * u_materialSpecular.xyz;";vsLightingPass+="    v_color.xyz += ambient + diffuse + specular;";vsLightingPass+="  }"}}vsLightingPass+="  v_color = clamp(v_color, 0.0, 1.0);"}var vsSource=["attribute vec4 a_position;","attribute vec4 a_color;","varying vec4 v_color;",texUnitAttribList,texUnitVaryingList,GLEmulation.fogEnabled?"varying float v_fogFragCoord;":null,"uniform mat4 u_modelView;","uniform mat4 u_projection;",vsPointSizeDefs,vsClipPlaneDefs,vsLightingDefs,"void main()","{","  vec4 ecPosition = u_modelView * a_position;","  gl_Position = u_projection * ecPosition;","  v_color = a_color;",vsTexCoordInits,vsFogVaryingInit,vsPointSizeInit,vsClipPlaneInit,vsLightingPass,"}",""].join("\n").replace(/\n\n+/g,"\n");this.vertexShader=GLctx.createShader(GLctx.VERTEX_SHADER);GLctx.shaderSource(this.vertexShader,vsSource);GLctx.compileShader(this.vertexShader);var fogHeaderIfNeeded=null;if(GLEmulation.fogEnabled){fogHeaderIfNeeded=["","varying float v_fogFragCoord; ","uniform vec4 u_fogColor;      ","uniform float u_fogEnd;       ","uniform float u_fogScale;     ","uniform float u_fogDensity;   ","float ffog(in float ecDistance) { ",fogFormula,"  fog = clamp(fog, 0.0, 1.0); ","  return fog;                 ","}",""].join("\n")}var fogPass=null;if(GLEmulation.fogEnabled){fogPass="gl_FragColor = vec4(mix(u_fogColor.rgb, gl_FragColor.rgb, ffog(v_fogFragCoord)), gl_FragColor.a);\n"}var fsAlphaTestDefs="";var fsAlphaTestPass="";if(GLEmulation.alphaTestEnabled){fsAlphaTestDefs="uniform float u_alphaTestRef;";switch(GLEmulation.alphaTestFunc){case 512:fsAlphaTestPass="discard;";break;case 513:fsAlphaTestPass="if (!(gl_FragColor.a < u_alphaTestRef)) { discard; }";break;case 514:fsAlphaTestPass="if (!(gl_FragColor.a == u_alphaTestRef)) { discard; }";break;case 515:fsAlphaTestPass="if (!(gl_FragColor.a <= u_alphaTestRef)) { discard; }";break;case 516:fsAlphaTestPass="if (!(gl_FragColor.a > u_alphaTestRef)) { discard; }";break;case 517:fsAlphaTestPass="if (!(gl_FragColor.a != u_alphaTestRef)) { discard; }";break;case 518:fsAlphaTestPass="if (!(gl_FragColor.a >= u_alphaTestRef)) { discard; }";break;case 519:fsAlphaTestPass="";break}}var fsSource=["precision mediump float;",texUnitVaryingList,texUnitUniformList,"varying vec4 v_color;",fogHeaderIfNeeded,fsClipPlaneDefs,fsAlphaTestDefs,"void main()","{",fsClipPlanePass,fsTexEnvPass,fogPass,fsAlphaTestPass,"}",""].join("\n").replace(/\n\n+/g,"\n");this.fragmentShader=GLctx.createShader(GLctx.FRAGMENT_SHADER);GLctx.shaderSource(this.fragmentShader,fsSource);GLctx.compileShader(this.fragmentShader);this.program=GLctx.createProgram();GLctx.attachShader(this.program,this.vertexShader);GLctx.attachShader(this.program,this.fragmentShader);GLctx.bindAttribLocation(this.program,GLImmediate.VERTEX,"a_position");GLctx.bindAttribLocation(this.program,GLImmediate.COLOR,"a_color");GLctx.bindAttribLocation(this.program,GLImmediate.NORMAL,"a_normal");var maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);for(var i=0;i<GLImmediate.MAX_TEXTURES&&GLImmediate.TEXTURE0+i<maxVertexAttribs;i++){GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,"a_texCoord"+i);GLctx.bindAttribLocation(this.program,GLImmediate.TEXTURE0+i,aTexCoordPrefix+i)}GLctx.linkProgram(this.program)}this.textureMatrixVersion=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];this.positionLocation=GLctx.getAttribLocation(this.program,"a_position");this.texCoordLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(!GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]){this.texCoordLocations[i]=-1;continue}if(useCurrProgram){this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,`a_texCoord${i}`)}else{this.texCoordLocations[i]=GLctx.getAttribLocation(this.program,aTexCoordPrefix+i)}}this.colorLocation=GLctx.getAttribLocation(this.program,"a_color");if(!useCurrProgram){var prevBoundProg=GLctx.getParameter(GLctx.CURRENT_PROGRAM);GLctx.useProgram(this.program);{for(var i=0;i<this.usedTexUnitList.length;i++){var texUnitID=this.usedTexUnitList[i];var texSamplerLoc=GLctx.getUniformLocation(this.program,uTexUnitPrefix+texUnitID);GLctx.uniform1i(texSamplerLoc,texUnitID)}}GLctx.vertexAttrib4fv(this.colorLocation,[1,1,1,1]);GLctx.useProgram(prevBoundProg)}this.textureMatrixLocations=[];for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){this.textureMatrixLocations[i]=GLctx.getUniformLocation(this.program,`u_textureMatrix${i}`)}this.normalLocation=GLctx.getAttribLocation(this.program,"a_normal");this.modelViewLocation=GLctx.getUniformLocation(this.program,"u_modelView");this.projectionLocation=GLctx.getUniformLocation(this.program,"u_projection");this.normalMatrixLocation=GLctx.getUniformLocation(this.program,"u_normalMatrix");this.hasTextures=hasTextures;this.hasNormal=GLImmediate.enabledClientAttributes[GLImmediate.NORMAL]&&GLImmediate.clientAttributes[GLImmediate.NORMAL].size>0&&this.normalLocation>=0;this.hasColor=this.colorLocation===0||this.colorLocation>0;this.floatType=GLctx.FLOAT;this.fogColorLocation=GLctx.getUniformLocation(this.program,"u_fogColor");this.fogEndLocation=GLctx.getUniformLocation(this.program,"u_fogEnd");this.fogScaleLocation=GLctx.getUniformLocation(this.program,"u_fogScale");this.fogDensityLocation=GLctx.getUniformLocation(this.program,"u_fogDensity");this.hasFog=!!(this.fogColorLocation||this.fogEndLocation||this.fogScaleLocation||this.fogDensityLocation);this.pointSizeLocation=GLctx.getUniformLocation(this.program,"u_pointSize");this.hasClipPlane=false;this.clipPlaneEquationLocation=[];for(var clipPlaneId=0;clipPlaneId<GLEmulation.MAX_CLIP_PLANES;clipPlaneId++){this.clipPlaneEquationLocation[clipPlaneId]=GLctx.getUniformLocation(this.program,`u_clipPlaneEquation${clipPlaneId}`);this.hasClipPlane=this.hasClipPlane||this.clipPlaneEquationLocation[clipPlaneId]}this.hasLighting=GLEmulation.lightingEnabled;this.lightModelAmbientLocation=GLctx.getUniformLocation(this.program,"u_lightModelAmbient");this.materialAmbientLocation=GLctx.getUniformLocation(this.program,"u_materialAmbient");this.materialDiffuseLocation=GLctx.getUniformLocation(this.program,"u_materialDiffuse");this.materialSpecularLocation=GLctx.getUniformLocation(this.program,"u_materialSpecular");this.materialShininessLocation=GLctx.getUniformLocation(this.program,"u_materialShininess");this.materialEmissionLocation=GLctx.getUniformLocation(this.program,"u_materialEmission");this.lightAmbientLocation=[];this.lightDiffuseLocation=[];this.lightSpecularLocation=[];this.lightPositionLocation=[];for(var lightId=0;lightId<GLEmulation.MAX_LIGHTS;lightId++){this.lightAmbientLocation[lightId]=GLctx.getUniformLocation(this.program,`u_lightAmbient${lightId}`);this.lightDiffuseLocation[lightId]=GLctx.getUniformLocation(this.program,`u_lightDiffuse${lightId}`);this.lightSpecularLocation[lightId]=GLctx.getUniformLocation(this.program,`u_lightSpecular${lightId}`);this.lightPositionLocation[lightId]=GLctx.getUniformLocation(this.program,`u_lightPosition${lightId}`)}this.hasAlphaTest=GLEmulation.alphaTestEnabled;this.alphaTestRefLocation=GLctx.getUniformLocation(this.program,"u_alphaTestRef")};this.prepare=function(){var arrayBuffer;if(!GLctx.currentArrayBufferBinding){var start=GLImmediate.firstVertex*GLImmediate.stride;var end=GLImmediate.lastVertex*GLImmediate.stride;arrayBuffer=GL.getTempVertexBuffer(end)}else{arrayBuffer=GLctx.currentArrayBufferBinding}var lastRenderer=GLImmediate.lastRenderer;var canSkip=this==lastRenderer&&arrayBuffer==GLImmediate.lastArrayBuffer&&(GL.currProgram||this.program)==GLImmediate.lastProgram&&GLImmediate.stride==GLImmediate.lastStride&&!GLImmediate.matricesModified;if(!canSkip&&lastRenderer)lastRenderer.cleanup();if(!GLctx.currentArrayBufferBinding){if(arrayBuffer!=GLImmediate.lastArrayBuffer){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,arrayBuffer);GLImmediate.lastArrayBuffer=arrayBuffer}GLctx.bufferSubData(GLctx.ARRAY_BUFFER,start,GLImmediate.vertexData.subarray(start>>2,end>>2))}if(canSkip)return;GLImmediate.lastRenderer=this;GLImmediate.lastProgram=GL.currProgram||this.program;GLImmediate.lastStride=GLImmediate.stride;GLImmediate.matricesModified=false;if(!GL.currProgram){if(GLImmediate.fixedFunctionProgram!=this.program){GLctx.useProgram(this.program);GLImmediate.fixedFunctionProgram=this.program}}if(this.modelViewLocation&&this.modelViewMatrixVersion!=GLImmediate.matrixVersion[0]){this.modelViewMatrixVersion=GLImmediate.matrixVersion[0];GLctx.uniformMatrix4fv(this.modelViewLocation,false,GLImmediate.matrix[0]);if(GLEmulation.lightEnabled){var tmpMVinv=GLImmediate.matrixLib.mat4.create(GLImmediate.matrix[0]);GLImmediate.matrixLib.mat4.inverse(tmpMVinv);GLImmediate.matrixLib.mat4.transpose(tmpMVinv);GLctx.uniformMatrix3fv(this.normalMatrixLocation,false,GLImmediate.matrixLib.mat4.toMat3(tmpMVinv))}}if(this.projectionLocation&&this.projectionMatrixVersion!=GLImmediate.matrixVersion[1]){this.projectionMatrixVersion=GLImmediate.matrixVersion[1];GLctx.uniformMatrix4fv(this.projectionLocation,false,GLImmediate.matrix[1])}var clientAttributes=GLImmediate.clientAttributes;var posAttr=clientAttributes[GLImmediate.VERTEX];GLctx.vertexAttribPointer(this.positionLocation,posAttr.size,posAttr.type,false,GLImmediate.stride,posAttr.offset);GLctx.enableVertexAttribArray(this.positionLocation);if(this.hasNormal){var normalAttr=clientAttributes[GLImmediate.NORMAL];GLctx.vertexAttribPointer(this.normalLocation,normalAttr.size,normalAttr.type,true,GLImmediate.stride,normalAttr.offset);GLctx.enableVertexAttribArray(this.normalLocation)}if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){var attribLoc=this.texCoordLocations[i];if(attribLoc===undefined||attribLoc<0)continue;var texAttr=clientAttributes[GLImmediate.TEXTURE0+i];if(texAttr.size){GLctx.vertexAttribPointer(attribLoc,texAttr.size,texAttr.type,false,GLImmediate.stride,texAttr.offset);GLctx.enableVertexAttribArray(attribLoc)}else{GLctx.vertexAttrib4f(attribLoc,0,0,0,1);GLctx.disableVertexAttribArray(attribLoc)}var t=2+i;if(this.textureMatrixLocations[i]&&this.textureMatrixVersion[t]!=GLImmediate.matrixVersion[t]){this.textureMatrixVersion[t]=GLImmediate.matrixVersion[t];GLctx.uniformMatrix4fv(this.textureMatrixLocations[i],false,GLImmediate.matrix[t])}}}if(GLImmediate.enabledClientAttributes[GLImmediate.COLOR]){var colorAttr=clientAttributes[GLImmediate.COLOR];GLctx.vertexAttribPointer(this.colorLocation,colorAttr.size,colorAttr.type,true,GLImmediate.stride,colorAttr.offset);GLctx.enableVertexAttribArray(this.colorLocation)}else if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation);GLctx.vertexAttrib4fv(this.colorLocation,GLImmediate.clientColor)}if(this.hasFog){if(this.fogColorLocation)GLctx.uniform4fv(this.fogColorLocation,GLEmulation.fogColor);if(this.fogEndLocation)GLctx.uniform1f(this.fogEndLocation,GLEmulation.fogEnd);if(this.fogScaleLocation)GLctx.uniform1f(this.fogScaleLocation,1/(GLEmulation.fogEnd-GLEmulation.fogStart));if(this.fogDensityLocation)GLctx.uniform1f(this.fogDensityLocation,GLEmulation.fogDensity)}if(this.hasClipPlane){for(var clipPlaneId=0;clipPlaneId<GLEmulation.MAX_CLIP_PLANES;clipPlaneId++){if(this.clipPlaneEquationLocation[clipPlaneId])GLctx.uniform4fv(this.clipPlaneEquationLocation[clipPlaneId],GLEmulation.clipPlaneEquation[clipPlaneId])}}if(this.hasLighting){if(this.lightModelAmbientLocation)GLctx.uniform4fv(this.lightModelAmbientLocation,GLEmulation.lightModelAmbient);if(this.materialAmbientLocation)GLctx.uniform4fv(this.materialAmbientLocation,GLEmulation.materialAmbient);if(this.materialDiffuseLocation)GLctx.uniform4fv(this.materialDiffuseLocation,GLEmulation.materialDiffuse);if(this.materialSpecularLocation)GLctx.uniform4fv(this.materialSpecularLocation,GLEmulation.materialSpecular);if(this.materialShininessLocation)GLctx.uniform1f(this.materialShininessLocation,GLEmulation.materialShininess[0]);if(this.materialEmissionLocation)GLctx.uniform4fv(this.materialEmissionLocation,GLEmulation.materialEmission);for(var lightId=0;lightId<GLEmulation.MAX_LIGHTS;lightId++){if(this.lightAmbientLocation[lightId])GLctx.uniform4fv(this.lightAmbientLocation[lightId],GLEmulation.lightAmbient[lightId]);if(this.lightDiffuseLocation[lightId])GLctx.uniform4fv(this.lightDiffuseLocation[lightId],GLEmulation.lightDiffuse[lightId]);if(this.lightSpecularLocation[lightId])GLctx.uniform4fv(this.lightSpecularLocation[lightId],GLEmulation.lightSpecular[lightId]);if(this.lightPositionLocation[lightId])GLctx.uniform4fv(this.lightPositionLocation[lightId],GLEmulation.lightPosition[lightId])}}if(this.hasAlphaTest){if(this.alphaTestRefLocation)GLctx.uniform1f(this.alphaTestRefLocation,GLEmulation.alphaTestRef)}if(GLImmediate.mode==GLctx.POINTS){if(this.pointSizeLocation){GLctx.uniform1f(this.pointSizeLocation,GLEmulation.pointSize)}}};this.cleanup=function(){GLctx.disableVertexAttribArray(this.positionLocation);if(this.hasTextures){for(var i=0;i<GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[GLImmediate.TEXTURE0+i]&&this.texCoordLocations[i]>=0){GLctx.disableVertexAttribArray(this.texCoordLocations[i])}}}if(this.hasColor){GLctx.disableVertexAttribArray(this.colorLocation)}if(this.hasNormal){GLctx.disableVertexAttribArray(this.normalLocation)}if(!GL.currProgram){GLctx.useProgram(null);GLImmediate.fixedFunctionProgram=0}if(!GLctx.currentArrayBufferBinding){GLctx.bindBuffer(GLctx.ARRAY_BUFFER,null);GLImmediate.lastArrayBuffer=null}GLImmediate.lastRenderer=null;GLImmediate.lastProgram=null;GLImmediate.matricesModified=true};this.init()}return new Renderer},setupFuncs(){GLImmediate.MapTreeLib=GLImmediate.spawnMapTreeLib();GLImmediate.spawnMapTreeLib=null;GLImmediate.TexEnvJIT=GLImmediate.spawnTexEnvJIT();GLImmediate.spawnTexEnvJIT=null;GLImmediate.setupHooks()},setupHooks(){if(!GLEmulation.hasRunInit){GLEmulation.init()}var glActiveTexture=_glActiveTexture;_glActiveTexture=_emscripten_glActiveTexture=texture=>{GLImmediate.TexEnvJIT.hook_activeTexture(texture);glActiveTexture(texture)};var glEnable=_glEnable;_glEnable=_emscripten_glEnable=cap=>{GLImmediate.TexEnvJIT.hook_enable(cap);glEnable(cap)};var glDisable=_glDisable;_glDisable=_emscripten_glDisable=cap=>{GLImmediate.TexEnvJIT.hook_disable(cap);glDisable(cap)};_glTexEnvf=_emscripten_glTexEnvf=(target,pname,param)=>{GLImmediate.TexEnvJIT.hook_texEnvf(target,pname,param)};_glTexEnvi=_emscripten_glTexEnvi=(target,pname,param)=>{GLImmediate.TexEnvJIT.hook_texEnvi(target,pname,param)};_glTexEnvfv=_emscripten_glTexEnvfv=(target,pname,param)=>{GLImmediate.TexEnvJIT.hook_texEnvfv(target,pname,param)};_glGetTexEnviv=(target,pname,param)=>{GLImmediate.TexEnvJIT.hook_getTexEnviv(target,pname,param)};_glGetTexEnvfv=(target,pname,param)=>{GLImmediate.TexEnvJIT.hook_getTexEnvfv(target,pname,param)};var glGetIntegerv=_glGetIntegerv;_glGetIntegerv=_emscripten_glGetIntegerv=(pname,params)=>{switch(pname){case 35725:{var cur=GLctx.getParameter(GLctx.CURRENT_PROGRAM);if(cur==GLImmediate.fixedFunctionProgram){HEAP32[params>>2]=0;return}break}}glGetIntegerv(pname,params)}},initted:false,init(){err("WARNING: using emscripten GL immediate mode emulation. This is very limited in what it supports");GLImmediate.initted=true;if(!Browser.useWebGL)return;GLImmediate.MAX_TEXTURES=Math.min(Module["GL_MAX_TEXTURE_IMAGE_UNITS"]||GLctx.getParameter(GLctx.MAX_TEXTURE_IMAGE_UNITS),28);GLImmediate.TexEnvJIT.init(GLctx,GLImmediate.MAX_TEXTURES);GLImmediate.NUM_ATTRIBUTES=3+GLImmediate.MAX_TEXTURES;GLImmediate.clientAttributes=[];GLEmulation.enabledClientAttribIndices=[];for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){GLImmediate.clientAttributes.push({});GLEmulation.enabledClientAttribIndices.push(false)}GLImmediate.matrix=[];GLImmediate.matrixStack=[];GLImmediate.matrixVersion=[];for(var i=0;i<2+GLImmediate.MAX_TEXTURES;i++){GLImmediate.matrixStack.push([]);GLImmediate.matrixVersion.push(0);GLImmediate.matrix.push(GLImmediate.matrixLib.mat4.create());GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[i])}GLImmediate.rendererCache=GLImmediate.MapTreeLib.create();GLImmediate.tempData=new Float32Array(GL.MAX_TEMP_BUFFER_SIZE>>2);GLImmediate.indexData=new Uint16Array(GL.MAX_TEMP_BUFFER_SIZE>>1);GLImmediate.vertexDataU8=new Uint8Array(GLImmediate.tempData.buffer);GL.generateTempBuffers(true,GL.currentContext);GLImmediate.clientColor=new Float32Array([1,1,1,1])},prepareClientAttributes(count,beginEnd){if(!GLImmediate.modifiedClientAttributes){GLImmediate.vertexCounter=GLImmediate.stride*count/4;return}GLImmediate.modifiedClientAttributes=false;var clientStartPointer=4294967295;var bytes=0;var minStride=4294967295;var maxStride=0;var attributes=GLImmediate.liveClientAttributes;attributes.length=0;for(var i=0;i<3+GLImmediate.MAX_TEXTURES;i++){if(GLImmediate.enabledClientAttributes[i]){var attr=GLImmediate.clientAttributes[i];attributes.push(attr);clientStartPointer=Math.min(clientStartPointer,attr.pointer);attr.sizeBytes=attr.size*GL.byteSizeByType[attr.type-GL.byteSizeByTypeRoot];bytes+=attr.sizeBytes;minStride=Math.min(minStride,attr.stride);maxStride=Math.max(maxStride,attr.stride)}}if((minStride!=maxStride||maxStride<bytes)&&!beginEnd){GLImmediate.restrideBuffer||=_malloc(GL.MAX_TEMP_BUFFER_SIZE);var start=GLImmediate.restrideBuffer;bytes=0;for(var i=0;i<attributes.length;i++){var attr=attributes[i];var size=attr.sizeBytes;if(size%4!=0)size+=4-size%4;attr.offset=bytes;bytes+=size}for(var i=0;i<attributes.length;i++){var attr=attributes[i];var srcStride=Math.max(attr.sizeBytes,attr.stride);if((srcStride&3)==0&&(attr.sizeBytes&3)==0){for(var j=0;j<count;j++){for(var k=0;k<attr.sizeBytes;k+=4){var val=HEAP32[attr.pointer+(j*srcStride+k)>>2];HEAP32[start+attr.offset+(bytes*j+k)>>2]=val}}}else{for(var j=0;j<count;j++){for(var k=0;k<attr.sizeBytes;k++){HEAP8[start+attr.offset+bytes*j+k]=HEAP8[attr.pointer+j*srcStride+k]}}}attr.pointer=start+attr.offset}GLImmediate.stride=bytes;GLImmediate.vertexPointer=start}else{if(GLctx.currentArrayBufferBinding){GLImmediate.vertexPointer=0}else{GLImmediate.vertexPointer=clientStartPointer}for(var i=0;i<attributes.length;i++){var attr=attributes[i];attr.offset=attr.pointer-GLImmediate.vertexPointer}GLImmediate.stride=Math.max(maxStride,bytes)}if(!beginEnd){GLImmediate.vertexCounter=GLImmediate.stride*count/4}},flush(numProvidedIndexes,startIndex=0,ptr=0){var renderer=GLImmediate.getRenderer();var numVertices=4*GLImmediate.vertexCounter/GLImmediate.stride;if(!numVertices)return;var emulatedElementArrayBuffer=false;var numIndexes=0;if(numProvidedIndexes){numIndexes=numProvidedIndexes;if(!GLctx.currentArrayBufferBinding&&GLImmediate.firstVertex>GLImmediate.lastVertex){for(var i=0;i<numProvidedIndexes;i++){var currIndex=HEAPU16[ptr+i*2>>1];GLImmediate.firstVertex=Math.min(GLImmediate.firstVertex,currIndex);GLImmediate.lastVertex=Math.max(GLImmediate.lastVertex,currIndex+1)}}if(!GLctx.currentElementArrayBufferBinding){var indexBuffer=GL.getTempIndexBuffer(numProvidedIndexes<<1);GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,indexBuffer);GLctx.bufferSubData(GLctx.ELEMENT_ARRAY_BUFFER,0,HEAPU16.subarray(ptr>>1,ptr+(numProvidedIndexes<<1)>>1));ptr=0;emulatedElementArrayBuffer=true}}else if(GLImmediate.mode>6){if(GLImmediate.mode!=7)throw"unsupported immediate mode "+GLImmediate.mode;ptr=GLImmediate.firstVertex*3;var numQuads=numVertices/4;numIndexes=numQuads*6;GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.currentContext.tempQuadIndexBuffer);emulatedElementArrayBuffer=true;GLImmediate.mode=GLctx.TRIANGLES}renderer.prepare();if(numIndexes){GLctx.drawElements(GLImmediate.mode,numIndexes,GLctx.UNSIGNED_SHORT,ptr)}else{GLctx.drawArrays(GLImmediate.mode,startIndex,numVertices)}if(emulatedElementArrayBuffer){GLctx.bindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,GL.buffers[GLctx.currentElementArrayBufferBinding]||null)}}};GLImmediate.matrixLib=(()=>{var vec3={};var mat3={};var mat4={};var quat4={};var MatrixArray=Float32Array;vec3.create=function(vec){var dest=new MatrixArray(3);if(vec){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2]}else{dest[0]=dest[1]=dest[2]=0}return dest};vec3.set=function(vec,dest){dest[0]=vec[0];dest[1]=vec[1];dest[2]=vec[2];return dest};vec3.add=function(vec,vec2,dest){if(!dest||vec===dest){vec[0]+=vec2[0];vec[1]+=vec2[1];vec[2]+=vec2[2];return vec}dest[0]=vec[0]+vec2[0];dest[1]=vec[1]+vec2[1];dest[2]=vec[2]+vec2[2];return dest};vec3.subtract=function(vec,vec2,dest){if(!dest||vec===dest){vec[0]-=vec2[0];vec[1]-=vec2[1];vec[2]-=vec2[2];return vec}dest[0]=vec[0]-vec2[0];dest[1]=vec[1]-vec2[1];dest[2]=vec[2]-vec2[2];return dest};vec3.multiply=function(vec,vec2,dest){if(!dest||vec===dest){vec[0]*=vec2[0];vec[1]*=vec2[1];vec[2]*=vec2[2];return vec}dest[0]=vec[0]*vec2[0];dest[1]=vec[1]*vec2[1];dest[2]=vec[2]*vec2[2];return dest};vec3.negate=function(vec,dest){if(!dest){dest=vec}dest[0]=-vec[0];dest[1]=-vec[1];dest[2]=-vec[2];return dest};vec3.scale=function(vec,val,dest){if(!dest||vec===dest){vec[0]*=val;vec[1]*=val;vec[2]*=val;return vec}dest[0]=vec[0]*val;dest[1]=vec[1]*val;dest[2]=vec[2]*val;return dest};vec3.normalize=function(vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}else if(len===1){dest[0]=x;dest[1]=y;dest[2]=z;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest};vec3.cross=function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],x2=vec2[0],y2=vec2[1],z2=vec2[2];dest[0]=y*z2-z*y2;dest[1]=z*x2-x*z2;dest[2]=x*y2-y*x2;return dest};vec3.length=function(vec){var x=vec[0],y=vec[1],z=vec[2];return Math.sqrt(x*x+y*y+z*z)};vec3.dot=function(vec,vec2){return vec[0]*vec2[0]+vec[1]*vec2[1]+vec[2]*vec2[2]};vec3.direction=function(vec,vec2,dest){if(!dest){dest=vec}var x=vec[0]-vec2[0],y=vec[1]-vec2[1],z=vec[2]-vec2[2],len=Math.sqrt(x*x+y*y+z*z);if(!len){dest[0]=0;dest[1]=0;dest[2]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;return dest};vec3.lerp=function(vec,vec2,lerp,dest){if(!dest){dest=vec}dest[0]=vec[0]+lerp*(vec2[0]-vec[0]);dest[1]=vec[1]+lerp*(vec2[1]-vec[1]);dest[2]=vec[2]+lerp*(vec2[2]-vec[2]);return dest};vec3.dist=function(vec,vec2){var x=vec2[0]-vec[0],y=vec2[1]-vec[1],z=vec2[2]-vec[2];return Math.sqrt(x*x+y*y+z*z)};vec3.unproject=function(vec,view,proj,viewport,dest){if(!dest){dest=vec}var m=mat4.create();var v=new MatrixArray(4);v[0]=(vec[0]-viewport[0])*2/viewport[2]-1;v[1]=(vec[1]-viewport[1])*2/viewport[3]-1;v[2]=2*vec[2]-1;v[3]=1;mat4.multiply(proj,view,m);if(!mat4.inverse(m)){return null}mat4.multiplyVec4(m,v);if(v[3]===0){return null}dest[0]=v[0]/v[3];dest[1]=v[1]/v[3];dest[2]=v[2]/v[3];return dest};vec3.str=function(vec){return"["+vec[0]+", "+vec[1]+", "+vec[2]+"]"};mat3.create=function(mat){var dest=new MatrixArray(9);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8]}return dest};mat3.set=function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];return dest};mat3.identity=function(dest){if(!dest){dest=mat3.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=1;dest[5]=0;dest[6]=0;dest[7]=0;dest[8]=1;return dest};mat3.transpose=function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a12=mat[5];mat[1]=mat[3];mat[2]=mat[6];mat[3]=a01;mat[5]=mat[7];mat[6]=a02;mat[7]=a12;return mat}dest[0]=mat[0];dest[1]=mat[3];dest[2]=mat[6];dest[3]=mat[1];dest[4]=mat[4];dest[5]=mat[7];dest[6]=mat[2];dest[7]=mat[5];dest[8]=mat[8];return dest};mat3.toMat4=function(mat,dest){if(!dest){dest=mat4.create()}dest[15]=1;dest[14]=0;dest[13]=0;dest[12]=0;dest[11]=0;dest[10]=mat[8];dest[9]=mat[7];dest[8]=mat[6];dest[7]=0;dest[6]=mat[5];dest[5]=mat[4];dest[4]=mat[3];dest[3]=0;dest[2]=mat[2];dest[1]=mat[1];dest[0]=mat[0];return dest};mat3.str=function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+"]"};mat4.create=function(mat){var dest=new MatrixArray(16);if(mat){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}return dest};mat4.set=function(mat,dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest};mat4.identity=function(dest){if(!dest){dest=mat4.create()}dest[0]=1;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=1;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=1;dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest};mat4.transpose=function(mat,dest){if(!dest||mat===dest){var a01=mat[1],a02=mat[2],a03=mat[3],a12=mat[6],a13=mat[7],a23=mat[11];mat[1]=mat[4];mat[2]=mat[8];mat[3]=mat[12];mat[4]=a01;mat[6]=mat[9];mat[7]=mat[13];mat[8]=a02;mat[9]=a12;mat[11]=mat[14];mat[12]=a03;mat[13]=a13;mat[14]=a23;return mat}dest[0]=mat[0];dest[1]=mat[4];dest[2]=mat[8];dest[3]=mat[12];dest[4]=mat[1];dest[5]=mat[5];dest[6]=mat[9];dest[7]=mat[13];dest[8]=mat[2];dest[9]=mat[6];dest[10]=mat[10];dest[11]=mat[14];dest[12]=mat[3];dest[13]=mat[7];dest[14]=mat[11];dest[15]=mat[15];return dest};mat4.determinant=function(mat){var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15];return a30*a21*a12*a03-a20*a31*a12*a03-a30*a11*a22*a03+a10*a31*a22*a03+a20*a11*a32*a03-a10*a21*a32*a03-a30*a21*a02*a13+a20*a31*a02*a13+a30*a01*a22*a13-a00*a31*a22*a13-a20*a01*a32*a13+a00*a21*a32*a13+a30*a11*a02*a23-a10*a31*a02*a23-a30*a01*a12*a23+a00*a31*a12*a23+a10*a01*a32*a23-a00*a11*a32*a23-a20*a11*a02*a33+a10*a21*a02*a33+a20*a01*a12*a33-a00*a21*a12*a33-a10*a01*a22*a33+a00*a11*a22*a33};mat4.inverse=function(mat,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32,d=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06,invDet;if(!d){return null}invDet=1/d;dest[0]=(a11*b11-a12*b10+a13*b09)*invDet;dest[1]=(-a01*b11+a02*b10-a03*b09)*invDet;dest[2]=(a31*b05-a32*b04+a33*b03)*invDet;dest[3]=(-a21*b05+a22*b04-a23*b03)*invDet;dest[4]=(-a10*b11+a12*b08-a13*b07)*invDet;dest[5]=(a00*b11-a02*b08+a03*b07)*invDet;dest[6]=(-a30*b05+a32*b02-a33*b01)*invDet;dest[7]=(a20*b05-a22*b02+a23*b01)*invDet;dest[8]=(a10*b10-a11*b08+a13*b06)*invDet;dest[9]=(-a00*b10+a01*b08-a03*b06)*invDet;dest[10]=(a30*b04-a31*b02+a33*b00)*invDet;dest[11]=(-a20*b04+a21*b02-a23*b00)*invDet;dest[12]=(-a10*b09+a11*b07-a12*b06)*invDet;dest[13]=(a00*b09-a01*b07+a02*b06)*invDet;dest[14]=(-a30*b03+a31*b01-a32*b00)*invDet;dest[15]=(a20*b03-a21*b01+a22*b00)*invDet;return dest};mat4.toRotationMat=function(mat,dest){if(!dest){dest=mat4.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest};mat4.toMat3=function(mat,dest){if(!dest){dest=mat3.create()}dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[4];dest[4]=mat[5];dest[5]=mat[6];dest[6]=mat[8];dest[7]=mat[9];dest[8]=mat[10];return dest};mat4.toInverseMat3=function(mat,dest){var a00=mat[0],a01=mat[1],a02=mat[2],a10=mat[4],a11=mat[5],a12=mat[6],a20=mat[8],a21=mat[9],a22=mat[10],b01=a22*a11-a12*a21,b11=-a22*a10+a12*a20,b21=a21*a10-a11*a20,d=a00*b01+a01*b11+a02*b21,id;if(!d){return null}id=1/d;if(!dest){dest=mat3.create()}dest[0]=b01*id;dest[1]=(-a22*a01+a02*a21)*id;dest[2]=(a12*a01-a02*a11)*id;dest[3]=b11*id;dest[4]=(a22*a00-a02*a20)*id;dest[5]=(-a12*a00+a02*a10)*id;dest[6]=b21*id;dest[7]=(-a21*a00+a01*a20)*id;dest[8]=(a11*a00-a01*a10)*id;return dest};mat4.multiply=function(mat,mat2,dest){if(!dest){dest=mat}var a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11],a30=mat[12],a31=mat[13],a32=mat[14],a33=mat[15],b00=mat2[0],b01=mat2[1],b02=mat2[2],b03=mat2[3],b10=mat2[4],b11=mat2[5],b12=mat2[6],b13=mat2[7],b20=mat2[8],b21=mat2[9],b22=mat2[10],b23=mat2[11],b30=mat2[12],b31=mat2[13],b32=mat2[14],b33=mat2[15];dest[0]=b00*a00+b01*a10+b02*a20+b03*a30;dest[1]=b00*a01+b01*a11+b02*a21+b03*a31;dest[2]=b00*a02+b01*a12+b02*a22+b03*a32;dest[3]=b00*a03+b01*a13+b02*a23+b03*a33;dest[4]=b10*a00+b11*a10+b12*a20+b13*a30;dest[5]=b10*a01+b11*a11+b12*a21+b13*a31;dest[6]=b10*a02+b11*a12+b12*a22+b13*a32;dest[7]=b10*a03+b11*a13+b12*a23+b13*a33;dest[8]=b20*a00+b21*a10+b22*a20+b23*a30;dest[9]=b20*a01+b21*a11+b22*a21+b23*a31;dest[10]=b20*a02+b21*a12+b22*a22+b23*a32;dest[11]=b20*a03+b21*a13+b22*a23+b23*a33;dest[12]=b30*a00+b31*a10+b32*a20+b33*a30;dest[13]=b30*a01+b31*a11+b32*a21+b33*a31;dest[14]=b30*a02+b31*a12+b32*a22+b33*a32;dest[15]=b30*a03+b31*a13+b32*a23+b33*a33;return dest};mat4.multiplyVec3=function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];return dest};mat4.multiplyVec4=function(mat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],w=vec[3];dest[0]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12]*w;dest[1]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13]*w;dest[2]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14]*w;dest[3]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15]*w;return dest};mat4.translate=function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2],a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;if(!dest||mat===dest){mat[12]=mat[0]*x+mat[4]*y+mat[8]*z+mat[12];mat[13]=mat[1]*x+mat[5]*y+mat[9]*z+mat[13];mat[14]=mat[2]*x+mat[6]*y+mat[10]*z+mat[14];mat[15]=mat[3]*x+mat[7]*y+mat[11]*z+mat[15];return mat}a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];dest[0]=a00;dest[1]=a01;dest[2]=a02;dest[3]=a03;dest[4]=a10;dest[5]=a11;dest[6]=a12;dest[7]=a13;dest[8]=a20;dest[9]=a21;dest[10]=a22;dest[11]=a23;dest[12]=a00*x+a10*y+a20*z+mat[12];dest[13]=a01*x+a11*y+a21*z+mat[13];dest[14]=a02*x+a12*y+a22*z+mat[14];dest[15]=a03*x+a13*y+a23*z+mat[15];return dest};mat4.scale=function(mat,vec,dest){var x=vec[0],y=vec[1],z=vec[2];if(!dest||mat===dest){mat[0]*=x;mat[1]*=x;mat[2]*=x;mat[3]*=x;mat[4]*=y;mat[5]*=y;mat[6]*=y;mat[7]*=y;mat[8]*=z;mat[9]*=z;mat[10]*=z;mat[11]*=z;return mat}dest[0]=mat[0]*x;dest[1]=mat[1]*x;dest[2]=mat[2]*x;dest[3]=mat[3]*x;dest[4]=mat[4]*y;dest[5]=mat[5]*y;dest[6]=mat[6]*y;dest[7]=mat[7]*y;dest[8]=mat[8]*z;dest[9]=mat[9]*z;dest[10]=mat[10]*z;dest[11]=mat[11]*z;dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15];return dest};mat4.rotate=function(mat,angle,axis,dest){var x=axis[0],y=axis[1],z=axis[2],len=Math.sqrt(x*x+y*y+z*z),s,c,t,a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23,b00,b01,b02,b10,b11,b12,b20,b21,b22;if(!len){return null}if(len!==1){len=1/len;x*=len;y*=len;z*=len}s=Math.sin(angle);c=Math.cos(angle);t=1-c;a00=mat[0];a01=mat[1];a02=mat[2];a03=mat[3];a10=mat[4];a11=mat[5];a12=mat[6];a13=mat[7];a20=mat[8];a21=mat[9];a22=mat[10];a23=mat[11];b00=x*x*t+c;b01=y*x*t+z*s;b02=z*x*t-y*s;b10=x*y*t-z*s;b11=y*y*t+c;b12=z*y*t+x*s;b20=x*z*t+y*s;b21=y*z*t-x*s;b22=z*z*t+c;if(!dest){dest=mat}else if(mat!==dest){dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*b00+a10*b01+a20*b02;dest[1]=a01*b00+a11*b01+a21*b02;dest[2]=a02*b00+a12*b01+a22*b02;dest[3]=a03*b00+a13*b01+a23*b02;dest[4]=a00*b10+a10*b11+a20*b12;dest[5]=a01*b10+a11*b11+a21*b12;dest[6]=a02*b10+a12*b11+a22*b12;dest[7]=a03*b10+a13*b11+a23*b12;dest[8]=a00*b20+a10*b21+a20*b22;dest[9]=a01*b20+a11*b21+a21*b22;dest[10]=a02*b20+a12*b21+a22*b22;dest[11]=a03*b20+a13*b21+a23*b22;return dest};mat4.rotateX=function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[0]=mat[0];dest[1]=mat[1];dest[2]=mat[2];dest[3]=mat[3];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[4]=a10*c+a20*s;dest[5]=a11*c+a21*s;dest[6]=a12*c+a22*s;dest[7]=a13*c+a23*s;dest[8]=a10*-s+a20*c;dest[9]=a11*-s+a21*c;dest[10]=a12*-s+a22*c;dest[11]=a13*-s+a23*c;return dest};mat4.rotateY=function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a20=mat[8],a21=mat[9],a22=mat[10],a23=mat[11];if(!dest){dest=mat}else if(mat!==dest){dest[4]=mat[4];dest[5]=mat[5];dest[6]=mat[6];dest[7]=mat[7];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a20*-s;dest[1]=a01*c+a21*-s;dest[2]=a02*c+a22*-s;dest[3]=a03*c+a23*-s;dest[8]=a00*s+a20*c;dest[9]=a01*s+a21*c;dest[10]=a02*s+a22*c;dest[11]=a03*s+a23*c;return dest};mat4.rotateZ=function(mat,angle,dest){var s=Math.sin(angle),c=Math.cos(angle),a00=mat[0],a01=mat[1],a02=mat[2],a03=mat[3],a10=mat[4],a11=mat[5],a12=mat[6],a13=mat[7];if(!dest){dest=mat}else if(mat!==dest){dest[8]=mat[8];dest[9]=mat[9];dest[10]=mat[10];dest[11]=mat[11];dest[12]=mat[12];dest[13]=mat[13];dest[14]=mat[14];dest[15]=mat[15]}dest[0]=a00*c+a10*s;dest[1]=a01*c+a11*s;dest[2]=a02*c+a12*s;dest[3]=a03*c+a13*s;dest[4]=a00*-s+a10*c;dest[5]=a01*-s+a11*c;dest[6]=a02*-s+a12*c;dest[7]=a03*-s+a13*c;return dest};mat4.frustum=function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=near*2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=near*2/tb;dest[6]=0;dest[7]=0;dest[8]=(right+left)/rl;dest[9]=(top+bottom)/tb;dest[10]=-(far+near)/fn;dest[11]=-1;dest[12]=0;dest[13]=0;dest[14]=-(far*near*2)/fn;dest[15]=0;return dest};mat4.perspective=function(fovy,aspect,near,far,dest){var top=near*Math.tan(fovy*Math.PI/360),right=top*aspect;return mat4.frustum(-right,right,-top,top,near,far,dest)};mat4.ortho=function(left,right,bottom,top,near,far,dest){if(!dest){dest=mat4.create()}var rl=right-left,tb=top-bottom,fn=far-near;dest[0]=2/rl;dest[1]=0;dest[2]=0;dest[3]=0;dest[4]=0;dest[5]=2/tb;dest[6]=0;dest[7]=0;dest[8]=0;dest[9]=0;dest[10]=-2/fn;dest[11]=0;dest[12]=-(left+right)/rl;dest[13]=-(top+bottom)/tb;dest[14]=-(far+near)/fn;dest[15]=1;return dest};mat4.lookAt=function(eye,center,up,dest){if(!dest){dest=mat4.create()}var x0,x1,x2,y0,y1,y2,z0,z1,z2,len,eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2],centerx=center[0],centery=center[1],centerz=center[2];if(eyex===centerx&&eyey===centery&&eyez===centerz){return mat4.identity(dest)}z0=eyex-centerx;z1=eyey-centery;z2=eyez-centerz;len=1/Math.sqrt(z0*z0+z1*z1+z2*z2);z0*=len;z1*=len;z2*=len;x0=upy*z2-upz*z1;x1=upz*z0-upx*z2;x2=upx*z1-upy*z0;len=Math.sqrt(x0*x0+x1*x1+x2*x2);if(!len){x0=0;x1=0;x2=0}else{len=1/len;x0*=len;x1*=len;x2*=len}y0=z1*x2-z2*x1;y1=z2*x0-z0*x2;y2=z0*x1-z1*x0;len=Math.sqrt(y0*y0+y1*y1+y2*y2);if(!len){y0=0;y1=0;y2=0}else{len=1/len;y0*=len;y1*=len;y2*=len}dest[0]=x0;dest[1]=y0;dest[2]=z0;dest[3]=0;dest[4]=x1;dest[5]=y1;dest[6]=z1;dest[7]=0;dest[8]=x2;dest[9]=y2;dest[10]=z2;dest[11]=0;dest[12]=-(x0*eyex+x1*eyey+x2*eyez);dest[13]=-(y0*eyex+y1*eyey+y2*eyez);dest[14]=-(z0*eyex+z1*eyey+z2*eyez);dest[15]=1;return dest};mat4.fromRotationTranslation=function(quat,vec,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=vec[0];dest[13]=vec[1];dest[14]=vec[2];dest[15]=1;return dest};mat4.str=function(mat){return"["+mat[0]+", "+mat[1]+", "+mat[2]+", "+mat[3]+", "+mat[4]+", "+mat[5]+", "+mat[6]+", "+mat[7]+", "+mat[8]+", "+mat[9]+", "+mat[10]+", "+mat[11]+", "+mat[12]+", "+mat[13]+", "+mat[14]+", "+mat[15]+"]"};quat4.create=function(quat){var dest=new MatrixArray(4);if(quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest};quat4.set=function(quat,dest){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3];return dest};quat4.calculateW=function(quat,dest){var x=quat[0],y=quat[1],z=quat[2];if(!dest||quat===dest){quat[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return quat}dest[0]=x;dest[1]=y;dest[2]=z;dest[3]=-Math.sqrt(Math.abs(1-x*x-y*y-z*z));return dest};quat4.dot=function(quat,quat2){return quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3]};quat4.inverse=function(quat,dest){var q0=quat[0],q1=quat[1],q2=quat[2],q3=quat[3],dot=q0*q0+q1*q1+q2*q2+q3*q3,invDot=dot?1/dot:0;if(!dest||quat===dest){quat[0]*=-invDot;quat[1]*=-invDot;quat[2]*=-invDot;quat[3]*=invDot;return quat}dest[0]=-quat[0]*invDot;dest[1]=-quat[1]*invDot;dest[2]=-quat[2]*invDot;dest[3]=quat[3]*invDot;return dest};quat4.conjugate=function(quat,dest){if(!dest||quat===dest){quat[0]*=-1;quat[1]*=-1;quat[2]*=-1;return quat}dest[0]=-quat[0];dest[1]=-quat[1];dest[2]=-quat[2];dest[3]=quat[3];return dest};quat4.length=function(quat){var x=quat[0],y=quat[1],z=quat[2],w=quat[3];return Math.sqrt(x*x+y*y+z*z+w*w)};quat4.normalize=function(quat,dest){if(!dest){dest=quat}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],len=Math.sqrt(x*x+y*y+z*z+w*w);if(len===0){dest[0]=0;dest[1]=0;dest[2]=0;dest[3]=0;return dest}len=1/len;dest[0]=x*len;dest[1]=y*len;dest[2]=z*len;dest[3]=w*len;return dest};quat4.add=function(quat,quat2,dest){if(!dest||quat===dest){quat[0]+=quat2[0];quat[1]+=quat2[1];quat[2]+=quat2[2];quat[3]+=quat2[3];return quat}dest[0]=quat[0]+quat2[0];dest[1]=quat[1]+quat2[1];dest[2]=quat[2]+quat2[2];dest[3]=quat[3]+quat2[3];return dest};quat4.multiply=function(quat,quat2,dest){if(!dest){dest=quat}var qax=quat[0],qay=quat[1],qaz=quat[2],qaw=quat[3],qbx=quat2[0],qby=quat2[1],qbz=quat2[2],qbw=quat2[3];dest[0]=qax*qbw+qaw*qbx+qay*qbz-qaz*qby;dest[1]=qay*qbw+qaw*qby+qaz*qbx-qax*qbz;dest[2]=qaz*qbw+qaw*qbz+qax*qby-qay*qbx;dest[3]=qaw*qbw-qax*qbx-qay*qby-qaz*qbz;return dest};quat4.multiplyVec3=function(quat,vec,dest){if(!dest){dest=vec}var x=vec[0],y=vec[1],z=vec[2],qx=quat[0],qy=quat[1],qz=quat[2],qw=quat[3],ix=qw*x+qy*z-qz*y,iy=qw*y+qz*x-qx*z,iz=qw*z+qx*y-qy*x,iw=-qx*x-qy*y-qz*z;dest[0]=ix*qw+iw*-qx+iy*-qz-iz*-qy;dest[1]=iy*qw+iw*-qy+iz*-qx-ix*-qz;dest[2]=iz*qw+iw*-qz+ix*-qy-iy*-qx;return dest};quat4.scale=function(quat,val,dest){if(!dest||quat===dest){quat[0]*=val;quat[1]*=val;quat[2]*=val;quat[3]*=val;return quat}dest[0]=quat[0]*val;dest[1]=quat[1]*val;dest[2]=quat[2]*val;dest[3]=quat[3]*val;return dest};quat4.toMat3=function(quat,dest){if(!dest){dest=mat3.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=xy-wz;dest[4]=1-(xx+zz);dest[5]=yz+wx;dest[6]=xz+wy;dest[7]=yz-wx;dest[8]=1-(xx+yy);return dest};quat4.toMat4=function(quat,dest){if(!dest){dest=mat4.create()}var x=quat[0],y=quat[1],z=quat[2],w=quat[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;dest[0]=1-(yy+zz);dest[1]=xy+wz;dest[2]=xz-wy;dest[3]=0;dest[4]=xy-wz;dest[5]=1-(xx+zz);dest[6]=yz+wx;dest[7]=0;dest[8]=xz+wy;dest[9]=yz-wx;dest[10]=1-(xx+yy);dest[11]=0;dest[12]=0;dest[13]=0;dest[14]=0;dest[15]=1;return dest};quat4.slerp=function(quat,quat2,slerp,dest){if(!dest){dest=quat}var cosHalfTheta=quat[0]*quat2[0]+quat[1]*quat2[1]+quat[2]*quat2[2]+quat[3]*quat2[3],halfTheta,sinHalfTheta,ratioA,ratioB;if(Math.abs(cosHalfTheta)>=1){if(dest!==quat){dest[0]=quat[0];dest[1]=quat[1];dest[2]=quat[2];dest[3]=quat[3]}return dest}halfTheta=Math.acos(cosHalfTheta);sinHalfTheta=Math.sqrt(1-cosHalfTheta*cosHalfTheta);if(Math.abs(sinHalfTheta)<.001){dest[0]=quat[0]*.5+quat2[0]*.5;dest[1]=quat[1]*.5+quat2[1]*.5;dest[2]=quat[2]*.5+quat2[2]*.5;dest[3]=quat[3]*.5+quat2[3]*.5;return dest}ratioA=Math.sin((1-slerp)*halfTheta)/sinHalfTheta;ratioB=Math.sin(slerp*halfTheta)/sinHalfTheta;dest[0]=quat[0]*ratioA+quat2[0]*ratioB;dest[1]=quat[1]*ratioA+quat2[1]*ratioB;dest[2]=quat[2]*ratioA+quat2[2]*ratioB;dest[3]=quat[3]*ratioA+quat2[3]*ratioB;return dest};quat4.str=function(quat){return"["+quat[0]+", "+quat[1]+", "+quat[2]+", "+quat[3]+"]"};return{vec3,mat3,mat4,quat4}})();var _glBegin=mode=>{GLImmediate.enabledClientAttributes_preBegin=GLImmediate.enabledClientAttributes;GLImmediate.enabledClientAttributes=[];GLImmediate.clientAttributes_preBegin=GLImmediate.clientAttributes;GLImmediate.clientAttributes=[];for(var i=0;i<GLImmediate.clientAttributes_preBegin.length;i++){GLImmediate.clientAttributes.push({})}GLImmediate.mode=mode;GLImmediate.vertexCounter=0;var components=GLImmediate.rendererComponents=[];for(var i=0;i<GLImmediate.NUM_ATTRIBUTES;i++){components[i]=0}GLImmediate.rendererComponentPointer=0;GLImmediate.vertexData=GLImmediate.tempData};var _emscripten_glBegin=_glBegin;var _glBeginQueryEXT=(target,id)=>{GLctx.disjointTimerQueryExt["beginQueryEXT"](target,GL.queries[id])};var _emscripten_glBeginQueryEXT=_glBeginQueryEXT;var _emscripten_glBindAttribLocation=_glBindAttribLocation;var _emscripten_glBindBuffer=_glBindBuffer;var _glBindFramebuffer=(target,framebuffer)=>{GLctx.bindFramebuffer(target,GL.framebuffers[framebuffer])};var _emscripten_glBindFramebuffer=_glBindFramebuffer;var _glBindProgram=(type,id)=>{};var _emscripten_glBindProgram=_glBindProgram;var _glBindRenderbuffer=(target,renderbuffer)=>{GLctx.bindRenderbuffer(target,GL.renderbuffers[renderbuffer])};var _emscripten_glBindRenderbuffer=_glBindRenderbuffer;var _glBindTexture=(target,texture)=>{GLctx.bindTexture(target,GL.textures[texture])};var _emscripten_glBindTexture=_glBindTexture;var _glEnableClientState=cap=>{var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(!GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=true;GLImmediate.totalEnabledClientAttributes++;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)GLEmulation.currentVao.enabledClientStates[cap]=1;GLImmediate.modifiedClientAttributes=true}};var emulGlBindVertexArray=vao=>{GLEmulation.currentVao=null;GLImmediate.lastRenderer?.cleanup();_glBindBuffer(GLctx.ARRAY_BUFFER,0);_glBindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,0);for(var vaa in GLEmulation.enabledVertexAttribArrays){GLctx.disableVertexAttribArray(vaa)}GLEmulation.enabledVertexAttribArrays={};GLImmediate.enabledClientAttributes=[0,0];GLImmediate.totalEnabledClientAttributes=0;GLImmediate.modifiedClientAttributes=true;if(vao){var info=GLEmulation.vaos[vao];_glBindBuffer(GLctx.ARRAY_BUFFER,info.arrayBuffer);_glBindBuffer(GLctx.ELEMENT_ARRAY_BUFFER,info.elementArrayBuffer);for(var vaa in info.enabledVertexAttribArrays){_glEnableVertexAttribArray(vaa)}for(var vaa in info.vertexAttribPointers){_glVertexAttribPointer(...info.vertexAttribPointers[vaa])}for(var attrib in info.enabledClientStates){_glEnableClientState(attrib|0)}GLEmulation.currentVao=info}};var _glBindVertexArray=vao=>{emulGlBindVertexArray(vao);var ibo=GLctx.getParameter(34965);GLctx.currentElementArrayBufferBinding=ibo?ibo.name|0:0};var _glBindVertexArrayOES=_glBindVertexArray;var _emscripten_glBindVertexArrayOES=_glBindVertexArrayOES;var _glBlendColor=(x0,x1,x2,x3)=>GLctx.blendColor(x0,x1,x2,x3);var _emscripten_glBlendColor=_glBlendColor;var _glBlendEquation=x0=>GLctx.blendEquation(x0);var _emscripten_glBlendEquation=_glBlendEquation;var _glBlendEquationSeparate=(x0,x1)=>GLctx.blendEquationSeparate(x0,x1);var _emscripten_glBlendEquationSeparate=_glBlendEquationSeparate;var _glBlendFunc=(x0,x1)=>GLctx.blendFunc(x0,x1);var _emscripten_glBlendFunc=_glBlendFunc;var _glBlendFuncSeparate=(x0,x1,x2,x3)=>GLctx.blendFuncSeparate(x0,x1,x2,x3);var _emscripten_glBlendFuncSeparate=_glBlendFuncSeparate;var _glBufferData=(target,size,data,usage)=>{switch(usage){case 35041:case 35042:usage=35040;break;case 35045:case 35046:usage=35044;break;case 35049:case 35050:usage=35048;break}GLctx.bufferData(target,data?HEAPU8.subarray(data,data+size):size,usage)};var _emscripten_glBufferData=_glBufferData;var _glBufferSubData=(target,offset,size,data)=>{GLctx.bufferSubData(target,offset,HEAPU8.subarray(data,data+size))};var _emscripten_glBufferSubData=_glBufferSubData;var _glCheckFramebufferStatus=x0=>GLctx.checkFramebufferStatus(x0);var _emscripten_glCheckFramebufferStatus=_glCheckFramebufferStatus;var _glClear=x0=>GLctx.clear(x0);var _emscripten_glClear=_glClear;var _glClearColor=(x0,x1,x2,x3)=>GLctx.clearColor(x0,x1,x2,x3);var _emscripten_glClearColor=_glClearColor;var _glClearDepthf=x0=>GLctx.clearDepth(x0);var _emscripten_glClearDepthf=_glClearDepthf;var _glClearStencil=x0=>GLctx.clearStencil(x0);var _emscripten_glClearStencil=_glClearStencil;var _glClientActiveTexture=texture=>{GLImmediate.clientActiveTexture=texture-33984};var _emscripten_glClientActiveTexture=_glClientActiveTexture;var _glClipControlEXT=(origin,depth)=>{GLctx.extClipControl["clipControlEXT"](origin,depth)};var _emscripten_glClipControlEXT=_glClipControlEXT;var _glClipPlane=(pname,param)=>{if(pname>=12288&&pname<12294){var clipPlaneId=pname-12288;GLEmulation.clipPlaneEquation[clipPlaneId][0]=HEAPF64[param>>3];GLEmulation.clipPlaneEquation[clipPlaneId][1]=HEAPF64[param+8>>3];GLEmulation.clipPlaneEquation[clipPlaneId][2]=HEAPF64[param+16>>3];GLEmulation.clipPlaneEquation[clipPlaneId][3]=HEAPF64[param+24>>3];var tmpMV=GLImmediate.matrixLib.mat4.create(GLImmediate.matrix[0]);GLImmediate.matrixLib.mat4.inverse(tmpMV);GLImmediate.matrixLib.mat4.transpose(tmpMV);GLImmediate.matrixLib.mat4.multiplyVec4(tmpMV,GLEmulation.clipPlaneEquation[clipPlaneId])}};var _emscripten_glClipPlane=_glClipPlane;var _glColor4f=(r,g,b,a)=>{r=Math.max(Math.min(r,1),0);g=Math.max(Math.min(g,1),0);b=Math.max(Math.min(b,1),0);a=Math.max(Math.min(a,1),0);if(GLImmediate.mode>=0){var start=GLImmediate.vertexCounter<<2;GLImmediate.vertexDataU8[start+0]=r*255;GLImmediate.vertexDataU8[start+1]=g*255;GLImmediate.vertexDataU8[start+2]=b*255;GLImmediate.vertexDataU8[start+3]=a*255;GLImmediate.vertexCounter++;GLImmediate.addRendererComponent(GLImmediate.COLOR,4,GLctx.UNSIGNED_BYTE)}else{GLImmediate.clientColor[0]=r;GLImmediate.clientColor[1]=g;GLImmediate.clientColor[2]=b;GLImmediate.clientColor[3]=a}};var _glColor3f=(r,g,b)=>_glColor4f(r,g,b,1);var _glColor3d=_glColor3f;var _emscripten_glColor3d=_glColor3d;var _emscripten_glColor3f=_glColor3f;var _glColor3fv=p=>_glColor3f(HEAPF32[p>>2],HEAPF32[p+4>>2],HEAPF32[p+8>>2]);var _emscripten_glColor3fv=_glColor3fv;var _glColor4ub=(r,g,b,a)=>_glColor4f((r&255)/255,(g&255)/255,(b&255)/255,(a&255)/255);var _glColor3ub=(r,g,b)=>_glColor4ub(r,g,b,255);var _emscripten_glColor3ub=_glColor3ub;var _glColor3ubv=p=>_glColor3ub(HEAP8[p],HEAP8[p+1],HEAP8[p+2]);var _emscripten_glColor3ubv=_glColor3ubv;var _glColor4ui=(r,g,b,a)=>_glColor4f((r>>>0)/4294967295,(g>>>0)/4294967295,(b>>>0)/4294967295,(a>>>0)/4294967295);var _glColor3ui=(r,g,b)=>_glColor4ui(r,g,b,4294967295);var _emscripten_glColor3ui=_glColor3ui;var _glColor3uiv=p=>_glColor3ui(HEAP32[p>>2],HEAP32[p+4>>2],HEAP32[p+8>>2]);var _emscripten_glColor3uiv=_glColor3uiv;var _glColor4us=(r,g,b,a)=>_glColor4f((r&65535)/65535,(g&65535)/65535,(b&65535)/65535,(a&65535)/65535);var _glColor3us=(r,g,b)=>_glColor4us(r,g,b,65535);var _emscripten_glColor3us=_glColor3us;var _glColor3usv=p=>_glColor3us(HEAP16[p>>1],HEAP16[p+2>>1],HEAP16[p+4>>1]);var _emscripten_glColor3usv=_glColor3usv;var _glColor4d=_glColor4f;var _emscripten_glColor4d=_glColor4d;var _emscripten_glColor4f=_glColor4f;var _glColor4fv=p=>_glColor4f(HEAPF32[p>>2],HEAPF32[p+4>>2],HEAPF32[p+8>>2],HEAPF32[p+12>>2]);var _emscripten_glColor4fv=_glColor4fv;var _emscripten_glColor4ub=_glColor4ub;var _glColor4ubv=p=>_glColor4ub(HEAP8[p],HEAP8[p+1],HEAP8[p+2],HEAP8[p+3]);var _emscripten_glColor4ubv=_glColor4ubv;var _emscripten_glColor4ui=_glColor4ui;var _emscripten_glColor4us=_glColor4us;var _glColorMask=(red,green,blue,alpha)=>{GLctx.colorMask(!!red,!!green,!!blue,!!alpha)};var _emscripten_glColorMask=_glColorMask;var _glColorPointer=(size,type,stride,pointer)=>{GLImmediate.setClientAttribute(GLImmediate.COLOR,size,type,stride,pointer)};var _emscripten_glColorPointer=_glColorPointer;var _emscripten_glCompileShader=_glCompileShader;var _glCompressedTexImage2D=(target,level,internalFormat,width,height,border,imageSize,data)=>{GLctx.compressedTexImage2D(target,level,internalFormat,width,height,border,HEAPU8.subarray(data,data+imageSize))};var _emscripten_glCompressedTexImage2D=_glCompressedTexImage2D;var _glCompressedTexSubImage2D=(target,level,xoffset,yoffset,width,height,format,imageSize,data)=>{GLctx.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,HEAPU8.subarray(data,data+imageSize))};var _emscripten_glCompressedTexSubImage2D=_glCompressedTexSubImage2D;var _glCopyTexImage2D=(x0,x1,x2,x3,x4,x5,x6,x7)=>GLctx.copyTexImage2D(x0,x1,x2,x3,x4,x5,x6,x7);var _emscripten_glCopyTexImage2D=_glCopyTexImage2D;var _glCopyTexSubImage2D=(x0,x1,x2,x3,x4,x5,x6,x7)=>GLctx.copyTexSubImage2D(x0,x1,x2,x3,x4,x5,x6,x7);var _emscripten_glCopyTexSubImage2D=_glCopyTexSubImage2D;var _glCreateProgram=()=>{var id=GL.getNewId(GL.programs);var program=GLctx.createProgram();program.name=id;program.maxUniformLength=program.maxAttributeLength=program.maxUniformBlockNameLength=0;program.uniformIdCounter=1;GL.programs[id]=program;return id};var _emscripten_glCreateProgram=_glCreateProgram;var _emscripten_glCreateShader=_glCreateShader;var _glCullFace=x0=>GLctx.cullFace(x0);var _emscripten_glCullFace=_glCullFace;var _glDeleteBuffers=(n,buffers)=>{for(var i=0;i<n;i++){var id=HEAP32[buffers+i*4>>2];var buffer=GL.buffers[id];if(!buffer)continue;GLctx.deleteBuffer(buffer);buffer.name=0;GL.buffers[id]=null;if(id==GLctx.currentArrayBufferBinding)GLctx.currentArrayBufferBinding=0;if(id==GLctx.currentElementArrayBufferBinding)GLctx.currentElementArrayBufferBinding=0}};var _emscripten_glDeleteBuffers=_glDeleteBuffers;var _glDeleteFramebuffers=(n,framebuffers)=>{for(var i=0;i<n;++i){var id=HEAP32[framebuffers+i*4>>2];var framebuffer=GL.framebuffers[id];if(!framebuffer)continue;GLctx.deleteFramebuffer(framebuffer);framebuffer.name=0;GL.framebuffers[id]=null}};var _emscripten_glDeleteFramebuffers=_glDeleteFramebuffers;var _glDeleteShader=id=>{if(!id)return;var shader=GL.shaders[id];if(!shader){GL.recordError(1281);return}GLctx.deleteShader(shader);GL.shaders[id]=null};var _glDeleteObject=id=>{if(GL.programs[id]){_glDeleteProgram(id)}else if(GL.shaders[id]){_glDeleteShader(id)}else{err(`WARNING: deleteObject received invalid id: ${id}`)}};var _emscripten_glDeleteObject=_glDeleteObject;var _emscripten_glDeleteProgram=_glDeleteProgram;var _glDeleteQueriesEXT=(n,ids)=>{for(var i=0;i<n;i++){var id=HEAP32[ids+i*4>>2];var query=GL.queries[id];if(!query)continue;GLctx.disjointTimerQueryExt["deleteQueryEXT"](query);GL.queries[id]=null}};var _emscripten_glDeleteQueriesEXT=_glDeleteQueriesEXT;var _glDeleteRenderbuffers=(n,renderbuffers)=>{for(var i=0;i<n;i++){var id=HEAP32[renderbuffers+i*4>>2];var renderbuffer=GL.renderbuffers[id];if(!renderbuffer)continue;GLctx.deleteRenderbuffer(renderbuffer);renderbuffer.name=0;GL.renderbuffers[id]=null}};var _emscripten_glDeleteRenderbuffers=_glDeleteRenderbuffers;var _emscripten_glDeleteShader=_glDeleteShader;var _glDeleteTextures=(n,textures)=>{for(var i=0;i<n;i++){var id=HEAP32[textures+i*4>>2];var texture=GL.textures[id];if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}};var _emscripten_glDeleteTextures=_glDeleteTextures;var emulGlDeleteVertexArrays=(n,vaos)=>{for(var i=0;i<n;i++){var id=HEAP32[vaos+i*4>>2];GLEmulation.vaos[id]=null;if(GLEmulation.currentVao&&GLEmulation.currentVao.id==id)GLEmulation.currentVao=null}};var _glDeleteVertexArrays=(n,vaos)=>{emulGlDeleteVertexArrays(n,vaos)};var _glDeleteVertexArraysOES=_glDeleteVertexArrays;var _emscripten_glDeleteVertexArraysOES=_glDeleteVertexArraysOES;var _glDepthFunc=x0=>GLctx.depthFunc(x0);var _emscripten_glDepthFunc=_glDepthFunc;var _glDepthMask=flag=>{GLctx.depthMask(!!flag)};var _emscripten_glDepthMask=_glDepthMask;var _glDepthRangef=(x0,x1)=>GLctx.depthRange(x0,x1);var _emscripten_glDepthRangef=_glDepthRangef;var _emscripten_glDetachShader=_glDetachShader;var _emscripten_glDisable=_glDisable;var _glDisableClientState=cap=>{var attrib=GLEmulation.getAttributeFromCapability(cap);if(attrib===null){return}if(GLImmediate.enabledClientAttributes[attrib]){GLImmediate.enabledClientAttributes[attrib]=false;GLImmediate.totalEnabledClientAttributes--;GLImmediate.currentRenderer=null;if(GLEmulation.currentVao)delete GLEmulation.currentVao.enabledClientStates[cap];GLImmediate.modifiedClientAttributes=true}};var _emscripten_glDisableClientState=_glDisableClientState;var _emscripten_glDisableVertexAttribArray=_glDisableVertexAttribArray;var _glDrawArrays=(mode,first,count)=>{if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6){GLctx.drawArrays(mode,first,count);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GLctx.currentArrayBufferBinding){GLImmediate.vertexData=HEAPF32.subarray(GLImmediate.vertexPointer>>2,GLImmediate.vertexPointer+(first+count)*GLImmediate.stride>>2);GLImmediate.firstVertex=first;GLImmediate.lastVertex=first+count}GLImmediate.flush(null,first);GLImmediate.mode=-1};var _emscripten_glDrawArrays=_glDrawArrays;var _glDrawArraysInstanced=(mode,first,count,primcount)=>{GLctx.drawArraysInstanced(mode,first,count,primcount)};var _glDrawArraysInstancedANGLE=_glDrawArraysInstanced;var _emscripten_glDrawArraysInstancedANGLE=_glDrawArraysInstancedANGLE;var _glDrawBuffer=()=>{throw"glDrawBuffer: TODO"};var _emscripten_glDrawBuffer=_glDrawBuffer;var tempFixedLengthArray=[];var _glDrawBuffers=(n,bufs)=>{var bufArray=tempFixedLengthArray[n];for(var i=0;i<n;i++){bufArray[i]=HEAP32[bufs+i*4>>2]}GLctx.drawBuffers(bufArray)};var _glDrawBuffersWEBGL=_glDrawBuffers;var _emscripten_glDrawBuffersWEBGL=_glDrawBuffersWEBGL;var _glDrawElements=(mode,count,type,indices,start,end)=>{if(GLImmediate.totalEnabledClientAttributes==0&&mode<=6&&GLctx.currentElementArrayBufferBinding){GLctx.drawElements(mode,count,type,indices);return}GLImmediate.prepareClientAttributes(count,false);GLImmediate.mode=mode;if(!GLctx.currentArrayBufferBinding){GLImmediate.firstVertex=end?start:HEAP8.length;GLImmediate.lastVertex=end?end+1:0;start=GLImmediate.vertexPointer;if(end){end=GLImmediate.vertexPointer+(end+1)*GLImmediate.stride;GLImmediate.vertexData=HEAPF32.subarray(start>>2,end>>2)}else{GLImmediate.vertexData=HEAPF32.subarray(start>>2)}}GLImmediate.flush(count,0,indices);GLImmediate.mode=-1};var _emscripten_glDrawElements=_glDrawElements;var _glDrawElementsInstanced=(mode,count,type,indices,primcount)=>{GLctx.drawElementsInstanced(mode,count,type,indices,primcount)};var _glDrawElementsInstancedANGLE=_glDrawElementsInstanced;var _emscripten_glDrawElementsInstancedANGLE=_glDrawElementsInstancedANGLE;var _glDrawRangeElements=(mode,start,end,count,type,indices)=>{_glDrawElements(mode,count,type,indices,start,end)};var _emscripten_glDrawRangeElements=_glDrawRangeElements;var _emscripten_glEnable=_glEnable;var _emscripten_glEnableClientState=_glEnableClientState;var _emscripten_glEnableVertexAttribArray=_glEnableVertexAttribArray;var _glEnd=()=>{GLImmediate.prepareClientAttributes(GLImmediate.rendererComponents[GLImmediate.VERTEX],true);GLImmediate.firstVertex=0;GLImmediate.lastVertex=GLImmediate.vertexCounter/(GLImmediate.stride>>2);GLImmediate.flush();GLImmediate.disableBeginEndClientAttributes();GLImmediate.mode=-1;GLImmediate.enabledClientAttributes=GLImmediate.enabledClientAttributes_preBegin;GLImmediate.clientAttributes=GLImmediate.clientAttributes_preBegin;GLImmediate.currentRenderer=null;GLImmediate.modifiedClientAttributes=true};var _emscripten_glEnd=_glEnd;var _glEndQueryEXT=target=>{GLctx.disjointTimerQueryExt["endQueryEXT"](target)};var _emscripten_glEndQueryEXT=_glEndQueryEXT;var _glFinish=()=>GLctx.finish();var _emscripten_glFinish=_glFinish;var _glFlush=()=>GLctx.flush();var _emscripten_glFlush=_glFlush;var _glFramebufferRenderbuffer=(target,attachment,renderbuffertarget,renderbuffer)=>{GLctx.framebufferRenderbuffer(target,attachment,renderbuffertarget,GL.renderbuffers[renderbuffer])};var _emscripten_glFramebufferRenderbuffer=_glFramebufferRenderbuffer;var _glFramebufferTexture2D=(target,attachment,textarget,texture,level)=>{GLctx.framebufferTexture2D(target,attachment,textarget,GL.textures[texture],level)};var _emscripten_glFramebufferTexture2D=_glFramebufferTexture2D;var _glFrontFace=x0=>GLctx.frontFace(x0);var _emscripten_glFrontFace=_glFrontFace;var _glFrustum=(left,right,bottom,top_,nearVal,farVal)=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],GLImmediate.matrixLib.mat4.frustum(left,right,bottom,top_,nearVal,farVal))};var _emscripten_glFrustum=_glFrustum;var _glGenBuffers=(n,buffers)=>{GL.genObject(n,buffers,"createBuffer",GL.buffers)};var _emscripten_glGenBuffers=_glGenBuffers;var _glGenFramebuffers=(n,ids)=>{GL.genObject(n,ids,"createFramebuffer",GL.framebuffers)};var _emscripten_glGenFramebuffers=_glGenFramebuffers;var _glGenQueriesEXT=(n,ids)=>{for(var i=0;i<n;i++){var query=GLctx.disjointTimerQueryExt["createQueryEXT"]();if(!query){GL.recordError(1282);while(i<n)HEAP32[ids+i++*4>>2]=0;return}var id=GL.getNewId(GL.queries);query.name=id;GL.queries[id]=query;HEAP32[ids+i*4>>2]=id}};var _emscripten_glGenQueriesEXT=_glGenQueriesEXT;var _glGenRenderbuffers=(n,renderbuffers)=>{GL.genObject(n,renderbuffers,"createRenderbuffer",GL.renderbuffers)};var _emscripten_glGenRenderbuffers=_glGenRenderbuffers;var _glGenTextures=(n,textures)=>{GL.genObject(n,textures,"createTexture",GL.textures)};var _emscripten_glGenTextures=_glGenTextures;var emulGlGenVertexArrays=(n,vaos)=>{for(var i=0;i<n;i++){var id=GL.getNewId(GLEmulation.vaos);GLEmulation.vaos[id]={id,arrayBuffer:0,elementArrayBuffer:0,enabledVertexAttribArrays:{},vertexAttribPointers:{},enabledClientStates:{}};HEAP32[vaos+i*4>>2]=id}};var _glGenVertexArrays=(n,arrays)=>{emulGlGenVertexArrays(n,arrays)};var _glGenVertexArraysOES=_glGenVertexArrays;var _emscripten_glGenVertexArraysOES=_glGenVertexArraysOES;var _glGenerateMipmap=x0=>GLctx.generateMipmap(x0);var _emscripten_glGenerateMipmap=_glGenerateMipmap;var __glGetActiveAttribOrUniform=(funcName,program,index,bufSize,length,size,type,name)=>{program=GL.programs[program];var info=GLctx[funcName](program,index);if(info){var numBytesWrittenExclNull=name&&stringToUTF8(info.name,name,bufSize);if(length)HEAP32[length>>2]=numBytesWrittenExclNull;if(size)HEAP32[size>>2]=info.size;if(type)HEAP32[type>>2]=info.type}};var _glGetActiveAttrib=(program,index,bufSize,length,size,type,name)=>__glGetActiveAttribOrUniform("getActiveAttrib",program,index,bufSize,length,size,type,name);var _emscripten_glGetActiveAttrib=_glGetActiveAttrib;var _glGetActiveUniform=(program,index,bufSize,length,size,type,name)=>__glGetActiveAttribOrUniform("getActiveUniform",program,index,bufSize,length,size,type,name);var _emscripten_glGetActiveUniform=_glGetActiveUniform;var _glGetAttachedShaders=(program,maxCount,count,shaders)=>{var result=GLctx.getAttachedShaders(GL.programs[program]);var len=result.length;if(len>maxCount){len=maxCount}HEAP32[count>>2]=len;for(var i=0;i<len;++i){var id=GL.shaders.indexOf(result[i]);HEAP32[shaders+i*4>>2]=id}};var _emscripten_glGetAttachedShaders=_glGetAttachedShaders;var _glGetAttribLocation=(program,name)=>GLctx.getAttribLocation(GL.programs[program],UTF8ToString(name));var _emscripten_glGetAttribLocation=_glGetAttribLocation;var _emscripten_glGetBooleanv=_glGetBooleanv;var _glGetBufferParameteriv=(target,value,data)=>{if(!data){GL.recordError(1281);return}HEAP32[data>>2]=GLctx.getBufferParameter(target,value)};var _emscripten_glGetBufferParameteriv=_glGetBufferParameteriv;var _glGetError=()=>{var error=GLctx.getError()||GL.lastError;GL.lastError=0;return error};var _emscripten_glGetError=_glGetError;var _emscripten_glGetFloatv=_glGetFloatv;var _glGetFramebufferAttachmentParameteriv=(target,attachment,pname,params)=>{var result=GLctx.getFramebufferAttachmentParameter(target,attachment,pname);if(result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){result=result.name|0}HEAP32[params>>2]=result};var _emscripten_glGetFramebufferAttachmentParameteriv=_glGetFramebufferAttachmentParameteriv;var _glGetProgramInfoLog=(program,maxLength,length,infoLog)=>{var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";var numBytesWrittenExclNull=maxLength>0&&infoLog?stringToUTF8(log,infoLog,maxLength):0;if(length)HEAP32[length>>2]=numBytesWrittenExclNull};var _glGetShaderInfoLog=(shader,maxLength,length,infoLog)=>{var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";var numBytesWrittenExclNull=maxLength>0&&infoLog?stringToUTF8(log,infoLog,maxLength):0;if(length)HEAP32[length>>2]=numBytesWrittenExclNull};var _glGetInfoLog=(id,maxLength,length,infoLog)=>{if(GL.programs[id]){_glGetProgramInfoLog(id,maxLength,length,infoLog)}else if(GL.shaders[id]){_glGetShaderInfoLog(id,maxLength,length,infoLog)}else{err(`WARNING: glGetInfoLog received invalid id: ${id}`)}};var _emscripten_glGetInfoLog=_glGetInfoLog;var _emscripten_glGetIntegerv=_glGetIntegerv;var _glGetProgramiv=(program,pname,p)=>{if(!p){GL.recordError(1281);return}if(program>=GL.counter){GL.recordError(1281);return}program=GL.programs[program];if(pname==35716){var log=GLctx.getProgramInfoLog(program);if(log===null)log="(unknown error)";HEAP32[p>>2]=log.length+1}else if(pname==35719){if(!program.maxUniformLength){var numActiveUniforms=GLctx.getProgramParameter(program,35718);for(var i=0;i<numActiveUniforms;++i){program.maxUniformLength=Math.max(program.maxUniformLength,GLctx.getActiveUniform(program,i).name.length+1)}}HEAP32[p>>2]=program.maxUniformLength}else if(pname==35722){if(!program.maxAttributeLength){var numActiveAttributes=GLctx.getProgramParameter(program,35721);for(var i=0;i<numActiveAttributes;++i){program.maxAttributeLength=Math.max(program.maxAttributeLength,GLctx.getActiveAttrib(program,i).name.length+1)}}HEAP32[p>>2]=program.maxAttributeLength}else if(pname==35381){if(!program.maxUniformBlockNameLength){var numActiveUniformBlocks=GLctx.getProgramParameter(program,35382);for(var i=0;i<numActiveUniformBlocks;++i){program.maxUniformBlockNameLength=Math.max(program.maxUniformBlockNameLength,GLctx.getActiveUniformBlockName(program,i).length+1)}}HEAP32[p>>2]=program.maxUniformBlockNameLength}else{HEAP32[p>>2]=GLctx.getProgramParameter(program,pname)}};var _glGetShaderiv=(shader,pname,p)=>{if(!p){GL.recordError(1281);return}if(pname==35716){var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";var logLength=log?log.length+1:0;HEAP32[p>>2]=logLength}else if(pname==35720){var source=GLctx.getShaderSource(GL.shaders[shader]);var sourceLength=source?source.length+1:0;HEAP32[p>>2]=sourceLength}else{HEAP32[p>>2]=GLctx.getShaderParameter(GL.shaders[shader],pname)}};var _glGetObjectParameteriv=(id,type,result)=>{if(GL.programs[id]){if(type==35716){var log=GLctx.getProgramInfoLog(GL.programs[id]);if(log===null)log="(unknown error)";HEAP32[result>>2]=log.length;return}_glGetProgramiv(id,type,result)}else if(GL.shaders[id]){if(type==35716){var log=GLctx.getShaderInfoLog(GL.shaders[id]);if(log===null)log="(unknown error)";HEAP32[result>>2]=log.length;return}else if(type==35720){var source=GLctx.getShaderSource(GL.shaders[id]);if(source===null)return;HEAP32[result>>2]=source.length;return}_glGetShaderiv(id,type,result)}else{err(`WARNING: getObjectParameteriv received invalid id: ${id}`)}};var _emscripten_glGetObjectParameteriv=_glGetObjectParameteriv;var _glGetPointerv=(name,p)=>{var attribute;switch(name){case 32910:attribute=GLImmediate.clientAttributes[GLImmediate.VERTEX];break;case 32912:attribute=GLImmediate.clientAttributes[GLImmediate.COLOR];break;case 32914:attribute=GLImmediate.clientAttributes[GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture];break;default:GL.recordError(1280);return}HEAP32[p>>2]=attribute?attribute.pointer:0};var _emscripten_glGetPointerv=_glGetPointerv;var _emscripten_glGetProgramInfoLog=_glGetProgramInfoLog;var _emscripten_glGetProgramiv=_glGetProgramiv;var _glGetQueryObjecti64vEXT=(id,pname,params)=>{if(!params){GL.recordError(1281);return}var query=GL.queries[id];var param;{param=GLctx.disjointTimerQueryExt["getQueryObjectEXT"](query,pname)}var ret;if(typeof param=="boolean"){ret=param?1:0}else{ret=param}writeI53ToI64(params,ret)};var _emscripten_glGetQueryObjecti64vEXT=_glGetQueryObjecti64vEXT;var _glGetQueryObjectivEXT=(id,pname,params)=>{if(!params){GL.recordError(1281);return}var query=GL.queries[id];var param=GLctx.disjointTimerQueryExt["getQueryObjectEXT"](query,pname);var ret;if(typeof param=="boolean"){ret=param?1:0}else{ret=param}HEAP32[params>>2]=ret};var _emscripten_glGetQueryObjectivEXT=_glGetQueryObjectivEXT;var _glGetQueryObjectui64vEXT=_glGetQueryObjecti64vEXT;var _emscripten_glGetQueryObjectui64vEXT=_glGetQueryObjectui64vEXT;var _glGetQueryObjectuivEXT=_glGetQueryObjectivEXT;var _emscripten_glGetQueryObjectuivEXT=_glGetQueryObjectuivEXT;var _glGetQueryivEXT=(target,pname,params)=>{if(!params){GL.recordError(1281);return}HEAP32[params>>2]=GLctx.disjointTimerQueryExt["getQueryEXT"](target,pname)};var _emscripten_glGetQueryivEXT=_glGetQueryivEXT;var _glGetRenderbufferParameteriv=(target,pname,params)=>{if(!params){GL.recordError(1281);return}HEAP32[params>>2]=GLctx.getRenderbufferParameter(target,pname)};var _emscripten_glGetRenderbufferParameteriv=_glGetRenderbufferParameteriv;var _emscripten_glGetShaderInfoLog=_glGetShaderInfoLog;var _glGetShaderPrecisionFormat=(shaderType,precisionType,range,precision)=>{var result=GLctx.getShaderPrecisionFormat(shaderType,precisionType);HEAP32[range>>2]=result.rangeMin;HEAP32[range+4>>2]=result.rangeMax;HEAP32[precision>>2]=result.precision};var _emscripten_glGetShaderPrecisionFormat=_glGetShaderPrecisionFormat;var _glGetShaderSource=(shader,bufSize,length,source)=>{var result=GLctx.getShaderSource(GL.shaders[shader]);if(!result)return;var numBytesWrittenExclNull=bufSize>0&&source?stringToUTF8(result,source,bufSize):0;if(length)HEAP32[length>>2]=numBytesWrittenExclNull};var _emscripten_glGetShaderSource=_glGetShaderSource;var _emscripten_glGetShaderiv=_glGetShaderiv;var _emscripten_glGetString=_glGetString;var _glGetTexEnvfv=(target,pname,param)=>{throw"GL emulation not initialized!"};var _emscripten_glGetTexEnvfv=_glGetTexEnvfv;var _glGetTexEnviv=(target,pname,param)=>{throw"GL emulation not initialized!"};var _emscripten_glGetTexEnviv=_glGetTexEnviv;var _glGetTexLevelParameteriv=(target,level,pname,params)=>{throw"glGetTexLevelParameteriv: TODO"};var _emscripten_glGetTexLevelParameteriv=_glGetTexLevelParameteriv;var _glGetTexParameterfv=(target,pname,params)=>{if(!params){GL.recordError(1281);return}HEAPF32[params>>2]=GLctx.getTexParameter(target,pname)};var _emscripten_glGetTexParameterfv=_glGetTexParameterfv;var _glGetTexParameteriv=(target,pname,params)=>{if(!params){GL.recordError(1281);return}HEAP32[params>>2]=GLctx.getTexParameter(target,pname)};var _emscripten_glGetTexParameteriv=_glGetTexParameteriv;var jstoi_q=str=>parseInt(str);var webglGetLeftBracePos=name=>name.slice(-1)=="]"&&name.lastIndexOf("[");var webglPrepareUniformLocationsBeforeFirstUse=program=>{var uniformLocsById=program.uniformLocsById,uniformSizeAndIdsByName=program.uniformSizeAndIdsByName,i,j;if(!uniformLocsById){program.uniformLocsById=uniformLocsById={};program.uniformArrayNamesById={};var numActiveUniforms=GLctx.getProgramParameter(program,35718);for(i=0;i<numActiveUniforms;++i){var u=GLctx.getActiveUniform(program,i);var nm=u.name;var sz=u.size;var lb=webglGetLeftBracePos(nm);var arrayName=lb>0?nm.slice(0,lb):nm;var id=program.uniformIdCounter;program.uniformIdCounter+=sz;uniformSizeAndIdsByName[arrayName]=[sz,id];for(j=0;j<sz;++j){uniformLocsById[id]=j;program.uniformArrayNamesById[id++]=arrayName}}}};var _glGetUniformLocation=(program,name)=>{name=UTF8ToString(name);if(program=GL.programs[program]){webglPrepareUniformLocationsBeforeFirstUse(program);var uniformLocsById=program.uniformLocsById;var arrayIndex=0;var uniformBaseName=name;var leftBrace=webglGetLeftBracePos(name);if(leftBrace>0){arrayIndex=jstoi_q(name.slice(leftBrace+1))>>>0;uniformBaseName=name.slice(0,leftBrace)}var sizeAndId=program.uniformSizeAndIdsByName[uniformBaseName];if(sizeAndId&&arrayIndex<sizeAndId[0]){arrayIndex+=sizeAndId[1];if(uniformLocsById[arrayIndex]=uniformLocsById[arrayIndex]||GLctx.getUniformLocation(program,name)){return arrayIndex}}}else{GL.recordError(1281)}return-1};var _emscripten_glGetUniformLocation=_glGetUniformLocation;var webglGetUniformLocation=location=>{var p=GLctx.currentProgram;if(p){var webglLoc=p.uniformLocsById[location];if(typeof webglLoc=="number"){p.uniformLocsById[location]=webglLoc=GLctx.getUniformLocation(p,p.uniformArrayNamesById[location]+(webglLoc>0?`[${webglLoc}]`:""))}return webglLoc}else{GL.recordError(1282)}};var emscriptenWebGLGetUniform=(program,location,params,type)=>{if(!params){GL.recordError(1281);return}program=GL.programs[program];webglPrepareUniformLocationsBeforeFirstUse(program);var data=GLctx.getUniform(program,webglGetUniformLocation(location));if(typeof data=="number"||typeof data=="boolean"){switch(type){case 0:HEAP32[params>>2]=data;break;case 2:HEAPF32[params>>2]=data;break}}else{for(var i=0;i<data.length;i++){switch(type){case 0:HEAP32[params+i*4>>2]=data[i];break;case 2:HEAPF32[params+i*4>>2]=data[i];break}}}};var _glGetUniformfv=(program,location,params)=>{emscriptenWebGLGetUniform(program,location,params,2)};var _emscripten_glGetUniformfv=_glGetUniformfv;var _glGetUniformiv=(program,location,params)=>{emscriptenWebGLGetUniform(program,location,params,0)};var _emscripten_glGetUniformiv=_glGetUniformiv;var _glGetVertexAttribPointerv=(index,pname,pointer)=>{if(!pointer){GL.recordError(1281);return}HEAP32[pointer>>2]=GLctx.getVertexAttribOffset(index,pname)};var _emscripten_glGetVertexAttribPointerv=_glGetVertexAttribPointerv;var emscriptenWebGLGetVertexAttrib=(index,pname,params,type)=>{if(!params){GL.recordError(1281);return}var data=GLctx.getVertexAttrib(index,pname);if(pname==34975){HEAP32[params>>2]=data&&data["name"]}else if(typeof data=="number"||typeof data=="boolean"){switch(type){case 0:HEAP32[params>>2]=data;break;case 2:HEAPF32[params>>2]=data;break;case 5:HEAP32[params>>2]=Math.fround(data);break}}else{for(var i=0;i<data.length;i++){switch(type){case 0:HEAP32[params+i*4>>2]=data[i];break;case 2:HEAPF32[params+i*4>>2]=data[i];break;case 5:HEAP32[params+i*4>>2]=Math.fround(data[i]);break}}}};var _glGetVertexAttribfv=(index,pname,params)=>{emscriptenWebGLGetVertexAttrib(index,pname,params,2)};var _emscripten_glGetVertexAttribfv=_glGetVertexAttribfv;var _glGetVertexAttribiv=(index,pname,params)=>{emscriptenWebGLGetVertexAttrib(index,pname,params,5)};var _emscripten_glGetVertexAttribiv=_glGetVertexAttribiv;var _emscripten_glHint=_glHint;var _glIsBuffer=buffer=>{var b=GL.buffers[buffer];if(!b)return 0;return GLctx.isBuffer(b)};var _emscripten_glIsBuffer=_glIsBuffer;var _emscripten_glIsEnabled=_glIsEnabled;var _glIsFramebuffer=framebuffer=>{var fb=GL.framebuffers[framebuffer];if(!fb)return 0;return GLctx.isFramebuffer(fb)};var _emscripten_glIsFramebuffer=_glIsFramebuffer;var _glIsProgram=program=>{program=GL.programs[program];if(!program)return 0;return GLctx.isProgram(program)};var _emscripten_glIsProgram=_glIsProgram;var _glIsQueryEXT=id=>{var query=GL.queries[id];if(!query)return 0;return GLctx.disjointTimerQueryExt["isQueryEXT"](query)};var _emscripten_glIsQueryEXT=_glIsQueryEXT;var _glIsRenderbuffer=renderbuffer=>{var rb=GL.renderbuffers[renderbuffer];if(!rb)return 0;return GLctx.isRenderbuffer(rb)};var _emscripten_glIsRenderbuffer=_glIsRenderbuffer;var _glIsShader=shader=>{var s=GL.shaders[shader];if(!s)return 0;return GLctx.isShader(s)};var _emscripten_glIsShader=_glIsShader;var _glIsTexture=id=>{var texture=GL.textures[id];if(!texture)return 0;return GLctx.isTexture(texture)};var _emscripten_glIsTexture=_glIsTexture;var emulGlIsVertexArray=array=>{var vao=GLEmulation.vaos[array];if(!vao)return 0;return 1};var _glIsVertexArray=array=>emulGlIsVertexArray(array);var _glIsVertexArrayOES=_glIsVertexArray;var _emscripten_glIsVertexArrayOES=_glIsVertexArrayOES;var _glLightModelf=(pname,param)=>{if(pname==2898){GLEmulation.lightModelTwoSide=param!=0?true:false}else{throw"glLightModelf: TODO: "+pname}};var _emscripten_glLightModelf=_glLightModelf;var _glLightModelfv=(pname,param)=>{if(pname==2899){GLEmulation.lightModelAmbient[0]=HEAPF32[param>>2];GLEmulation.lightModelAmbient[1]=HEAPF32[param+4>>2];GLEmulation.lightModelAmbient[2]=HEAPF32[param+8>>2];GLEmulation.lightModelAmbient[3]=HEAPF32[param+12>>2]}else{throw"glLightModelfv: TODO: "+pname}};var _emscripten_glLightModelfv=_glLightModelfv;var _glLightfv=(light,pname,param)=>{if(light>=16384&&light<16392){var lightId=light-16384;if(pname==4608){GLEmulation.lightAmbient[lightId][0]=HEAPF32[param>>2];GLEmulation.lightAmbient[lightId][1]=HEAPF32[param+4>>2];GLEmulation.lightAmbient[lightId][2]=HEAPF32[param+8>>2];GLEmulation.lightAmbient[lightId][3]=HEAPF32[param+12>>2]}else if(pname==4609){GLEmulation.lightDiffuse[lightId][0]=HEAPF32[param>>2];GLEmulation.lightDiffuse[lightId][1]=HEAPF32[param+4>>2];GLEmulation.lightDiffuse[lightId][2]=HEAPF32[param+8>>2];GLEmulation.lightDiffuse[lightId][3]=HEAPF32[param+12>>2]}else if(pname==4610){GLEmulation.lightSpecular[lightId][0]=HEAPF32[param>>2];GLEmulation.lightSpecular[lightId][1]=HEAPF32[param+4>>2];GLEmulation.lightSpecular[lightId][2]=HEAPF32[param+8>>2];GLEmulation.lightSpecular[lightId][3]=HEAPF32[param+12>>2]}else if(pname==4611){GLEmulation.lightPosition[lightId][0]=HEAPF32[param>>2];GLEmulation.lightPosition[lightId][1]=HEAPF32[param+4>>2];GLEmulation.lightPosition[lightId][2]=HEAPF32[param+8>>2];GLEmulation.lightPosition[lightId][3]=HEAPF32[param+12>>2];GLImmediate.matrixLib.mat4.multiplyVec4(GLImmediate.matrix[0],GLEmulation.lightPosition[lightId])}else{throw"glLightfv: TODO: "+pname}}};var _emscripten_glLightfv=_glLightfv;var _glLineWidth=x0=>GLctx.lineWidth(x0);var _emscripten_glLineWidth=_glLineWidth;var _emscripten_glLinkProgram=_glLinkProgram;var _glLoadIdentity=()=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.identity(GLImmediate.matrix[GLImmediate.currentMatrix])};var _emscripten_glLoadIdentity=_glLoadIdentity;var _glLoadMatrixd=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.set(HEAPF64.subarray(matrix>>3,matrix+128>>3),GLImmediate.matrix[GLImmediate.currentMatrix])};var _emscripten_glLoadMatrixd=_glLoadMatrixd;var _glLoadMatrixf=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.set(HEAPF32.subarray(matrix>>2,matrix+64>>2),GLImmediate.matrix[GLImmediate.currentMatrix])};var _emscripten_glLoadMatrixf=_glLoadMatrixf;var _glLoadTransposeMatrixd=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.set(HEAPF64.subarray(matrix>>3,matrix+128>>3),GLImmediate.matrix[GLImmediate.currentMatrix]);GLImmediate.matrixLib.mat4.transpose(GLImmediate.matrix[GLImmediate.currentMatrix])};var _emscripten_glLoadTransposeMatrixd=_glLoadTransposeMatrixd;var _glLoadTransposeMatrixf=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.set(HEAPF32.subarray(matrix>>2,matrix+64>>2),GLImmediate.matrix[GLImmediate.currentMatrix]);GLImmediate.matrixLib.mat4.transpose(GLImmediate.matrix[GLImmediate.currentMatrix])};var _emscripten_glLoadTransposeMatrixf=_glLoadTransposeMatrixf;var _glMaterialfv=(face,pname,param)=>{if(face!=1028&&face!=1032){throw"glMaterialfv: TODO"+face}if(pname==4608){GLEmulation.materialAmbient[0]=HEAPF32[param>>2];GLEmulation.materialAmbient[1]=HEAPF32[param+4>>2];GLEmulation.materialAmbient[2]=HEAPF32[param+8>>2];GLEmulation.materialAmbient[3]=HEAPF32[param+12>>2]}else if(pname==4609){GLEmulation.materialDiffuse[0]=HEAPF32[param>>2];GLEmulation.materialDiffuse[1]=HEAPF32[param+4>>2];GLEmulation.materialDiffuse[2]=HEAPF32[param+8>>2];GLEmulation.materialDiffuse[3]=HEAPF32[param+12>>2]}else if(pname==4610){GLEmulation.materialSpecular[0]=HEAPF32[param>>2];GLEmulation.materialSpecular[1]=HEAPF32[param+4>>2];GLEmulation.materialSpecular[2]=HEAPF32[param+8>>2];GLEmulation.materialSpecular[3]=HEAPF32[param+12>>2]}else if(pname==5633){GLEmulation.materialShininess[0]=HEAPF32[param>>2]}else{throw"glMaterialfv: TODO: "+pname}};var _emscripten_glMaterialfv=_glMaterialfv;var _glMatrixMode=mode=>{if(mode==5888){GLImmediate.currentMatrix=0}else if(mode==5889){GLImmediate.currentMatrix=1}else if(mode==5890){GLImmediate.useTextureMatrix=true;GLImmediate.currentMatrix=2+GLImmediate.TexEnvJIT.getActiveTexture()}else{throw`Wrong mode ${mode} passed to glMatrixMode`}};var _emscripten_glMatrixMode=_glMatrixMode;var _glMultMatrixd=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],HEAPF64.subarray(matrix>>3,matrix+128>>3))};var _emscripten_glMultMatrixd=_glMultMatrixd;var _glMultMatrixf=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],HEAPF32.subarray(matrix>>2,matrix+64>>2))};var _emscripten_glMultMatrixf=_glMultMatrixf;var _glMultTransposeMatrixd=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;var colMajor=GLImmediate.matrixLib.mat4.create();GLImmediate.matrixLib.mat4.set(HEAPF64.subarray(matrix>>3,matrix+128>>3),colMajor);GLImmediate.matrixLib.mat4.transpose(colMajor);GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],colMajor)};var _emscripten_glMultTransposeMatrixd=_glMultTransposeMatrixd;var _glMultTransposeMatrixf=matrix=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;var colMajor=GLImmediate.matrixLib.mat4.create();GLImmediate.matrixLib.mat4.set(HEAPF32.subarray(matrix>>2,matrix+64>>2),colMajor);GLImmediate.matrixLib.mat4.transpose(colMajor);GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],colMajor)};var _emscripten_glMultTransposeMatrixf=_glMultTransposeMatrixf;var _glNormal3f=(x,y,z)=>{GLImmediate.vertexData[GLImmediate.vertexCounter++]=x;GLImmediate.vertexData[GLImmediate.vertexCounter++]=y;GLImmediate.vertexData[GLImmediate.vertexCounter++]=z;GLImmediate.addRendererComponent(GLImmediate.NORMAL,3,GLctx.FLOAT)};var _emscripten_glNormal3f=_glNormal3f;var _glNormalPointer=(type,stride,pointer)=>{GLImmediate.setClientAttribute(GLImmediate.NORMAL,3,type,stride,pointer)};var _emscripten_glNormalPointer=_glNormalPointer;var _glOrtho=(left,right,bottom,top_,nearVal,farVal)=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.multiply(GLImmediate.matrix[GLImmediate.currentMatrix],GLImmediate.matrixLib.mat4.ortho(left,right,bottom,top_,nearVal,farVal))};var _emscripten_glOrtho=_glOrtho;var _glPixelStorei=(pname,param)=>{if(pname==3317){GL.unpackAlignment=param}else if(pname==3314){GL.unpackRowLength=param}GLctx.pixelStorei(pname,param)};var _emscripten_glPixelStorei=_glPixelStorei;var _glPolygonMode=()=>{};var _emscripten_glPolygonMode=_glPolygonMode;var _glPolygonModeWEBGL=(face,mode)=>{GLctx.webglPolygonMode["polygonModeWEBGL"](face,mode)};var _emscripten_glPolygonModeWEBGL=_glPolygonModeWEBGL;var _glPolygonOffset=(x0,x1)=>GLctx.polygonOffset(x0,x1);var _emscripten_glPolygonOffset=_glPolygonOffset;var _glPolygonOffsetClampEXT=(factor,units,clamp)=>{GLctx.extPolygonOffsetClamp["polygonOffsetClampEXT"](factor,units,clamp)};var _emscripten_glPolygonOffsetClampEXT=_glPolygonOffsetClampEXT;var _glPopMatrix=()=>{if(GLImmediate.matrixStack[GLImmediate.currentMatrix].length==0){GL.recordError(1284);return}GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrix[GLImmediate.currentMatrix]=GLImmediate.matrixStack[GLImmediate.currentMatrix].pop()};var _emscripten_glPopMatrix=_glPopMatrix;var _glPushMatrix=()=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixStack[GLImmediate.currentMatrix].push(Array.prototype.slice.call(GLImmediate.matrix[GLImmediate.currentMatrix]))};var _emscripten_glPushMatrix=_glPushMatrix;var _glQueryCounterEXT=(id,target)=>{GLctx.disjointTimerQueryExt["queryCounterEXT"](GL.queries[id],target)};var _emscripten_glQueryCounterEXT=_glQueryCounterEXT;var _glReadBuffer=()=>{throw"glReadBuffer: TODO"};var _emscripten_glReadBuffer=_glReadBuffer;var computeUnpackAlignedImageSize=(width,height,sizePerPixel)=>{function roundedToNextMultipleOf(x,y){return x+y-1&-y}var plainRowSize=(GL.unpackRowLength||width)*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,GL.unpackAlignment);return height*alignedRowSize};var colorChannelsInGlTextureFormat=format=>{var colorChannels={5:3,6:4,8:2,29502:3,29504:4};return colorChannels[format-6402]||1};var heapObjectForWebGLType=type=>{type-=5120;if(type==1)return HEAPU8;if(type==4)return HEAP32;if(type==6)return HEAPF32;if(type==5||type==28922)return HEAPU32;return HEAPU16};var toTypedArrayIndex=(pointer,heap)=>pointer>>>31-Math.clz32(heap.BYTES_PER_ELEMENT);var emscriptenWebGLGetTexPixelData=(type,format,width,height,pixels,internalFormat)=>{var heap=heapObjectForWebGLType(type);var sizePerPixel=colorChannelsInGlTextureFormat(format)*heap.BYTES_PER_ELEMENT;var bytes=computeUnpackAlignedImageSize(width,height,sizePerPixel);return heap.subarray(toTypedArrayIndex(pixels,heap),toTypedArrayIndex(pixels+bytes,heap))};var _glReadPixels=(x,y,width,height,format,type,pixels)=>{var pixelData=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,format);if(!pixelData){GL.recordError(1280);return}GLctx.readPixels(x,y,width,height,format,type,pixelData)};var _emscripten_glReadPixels=_glReadPixels;var _glReleaseShaderCompiler=()=>{};var _emscripten_glReleaseShaderCompiler=_glReleaseShaderCompiler;var _glRenderbufferStorage=(x0,x1,x2,x3)=>GLctx.renderbufferStorage(x0,x1,x2,x3);var _emscripten_glRenderbufferStorage=_glRenderbufferStorage;var _glRotated=(angle,x,y,z)=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.rotate(GLImmediate.matrix[GLImmediate.currentMatrix],angle*Math.PI/180,[x,y,z])};var _emscripten_glRotated=_glRotated;var _glRotatef=_glRotated;var _emscripten_glRotatef=_glRotatef;var _glSampleCoverage=(value,invert)=>{GLctx.sampleCoverage(value,!!invert)};var _emscripten_glSampleCoverage=_glSampleCoverage;var _glScaled=(x,y,z)=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.scale(GLImmediate.matrix[GLImmediate.currentMatrix],[x,y,z])};var _emscripten_glScaled=_glScaled;var _glScalef=_glScaled;var _emscripten_glScalef=_glScalef;var _glScissor=(x0,x1,x2,x3)=>GLctx.scissor(x0,x1,x2,x3);var _emscripten_glScissor=_glScissor;var _glShadeModel=()=>warnOnce("TODO: glShadeModel");var _emscripten_glShadeModel=_glShadeModel;var _glShaderBinary=(count,shaders,binaryformat,binary,length)=>{GL.recordError(1280)};var _emscripten_glShaderBinary=_glShaderBinary;var _emscripten_glShaderSource=_glShaderSource;var _glStencilFunc=(x0,x1,x2)=>GLctx.stencilFunc(x0,x1,x2);var _emscripten_glStencilFunc=_glStencilFunc;var _glStencilFuncSeparate=(x0,x1,x2,x3)=>GLctx.stencilFuncSeparate(x0,x1,x2,x3);var _emscripten_glStencilFuncSeparate=_glStencilFuncSeparate;var _glStencilMask=x0=>GLctx.stencilMask(x0);var _emscripten_glStencilMask=_glStencilMask;var _glStencilMaskSeparate=(x0,x1)=>GLctx.stencilMaskSeparate(x0,x1);var _emscripten_glStencilMaskSeparate=_glStencilMaskSeparate;var _glStencilOp=(x0,x1,x2)=>GLctx.stencilOp(x0,x1,x2);var _emscripten_glStencilOp=_glStencilOp;var _glStencilOpSeparate=(x0,x1,x2,x3)=>GLctx.stencilOpSeparate(x0,x1,x2,x3);var _emscripten_glStencilOpSeparate=_glStencilOpSeparate;var _glTexCoord2i=(u,v)=>{GLImmediate.vertexData[GLImmediate.vertexCounter++]=u;GLImmediate.vertexData[GLImmediate.vertexCounter++]=v;GLImmediate.addRendererComponent(GLImmediate.TEXTURE0,2,GLctx.FLOAT)};var _glTexCoord2f=_glTexCoord2i;var _emscripten_glTexCoord2f=_glTexCoord2f;var _glTexCoord2fv=v=>_glTexCoord2i(HEAPF32[v>>2],HEAPF32[v+4>>2]);var _emscripten_glTexCoord2fv=_glTexCoord2fv;var _emscripten_glTexCoord2i=_glTexCoord2i;var _glTexCoord3f=(target,level,internalformat,width,border,format,type,data)=>{throw"glTexCoord3f: TODO"};var _emscripten_glTexCoord3f=_glTexCoord3f;var _glTexCoord4f=()=>{throw"glTexCoord4f: TODO"};var _emscripten_glTexCoord4f=_glTexCoord4f;var _glTexCoordPointer=(size,type,stride,pointer)=>{GLImmediate.setClientAttribute(GLImmediate.TEXTURE0+GLImmediate.clientActiveTexture,size,type,stride,pointer)};var _emscripten_glTexCoordPointer=_glTexCoordPointer;var _glTexGenfv=(coord,pname,param)=>{throw"glTexGenfv: TODO"};var _emscripten_glTexGenfv=_glTexGenfv;var _glTexGeni=(coord,pname,param)=>{throw"glTexGeni: TODO"};var _emscripten_glTexGeni=_glTexGeni;var _glTexImage1D=(target,level,internalformat,width,border,format,type,data)=>{throw"glTexImage1D: TODO"};var _emscripten_glTexImage1D=_glTexImage1D;var _glTexImage2D=(target,level,internalFormat,width,height,border,format,type,pixels)=>{var pixelData=pixels?emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat):null;GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixelData)};var _emscripten_glTexImage2D=_glTexImage2D;var _glTexParameterf=(x0,x1,x2)=>GLctx.texParameterf(x0,x1,x2);var _emscripten_glTexParameterf=_glTexParameterf;var _glTexParameterfv=(target,pname,params)=>{var param=HEAPF32[params>>2];GLctx.texParameterf(target,pname,param)};var _emscripten_glTexParameterfv=_glTexParameterfv;var _glTexParameteri=(x0,x1,x2)=>GLctx.texParameteri(x0,x1,x2);var _emscripten_glTexParameteri=_glTexParameteri;var _glTexParameteriv=(target,pname,params)=>{var param=HEAP32[params>>2];GLctx.texParameteri(target,pname,param)};var _emscripten_glTexParameteriv=_glTexParameteriv;var _glTexSubImage2D=(target,level,xoffset,yoffset,width,height,format,type,pixels)=>{var pixelData=pixels?emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,0):null;GLctx.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixelData)};var _emscripten_glTexSubImage2D=_glTexSubImage2D;var _glTranslated=(x,y,z)=>{GLImmediate.matricesModified=true;GLImmediate.matrixVersion[GLImmediate.currentMatrix]=GLImmediate.matrixVersion[GLImmediate.currentMatrix]+1|0;GLImmediate.matrixLib.mat4.translate(GLImmediate.matrix[GLImmediate.currentMatrix],[x,y,z])};var _emscripten_glTranslated=_glTranslated;var _glTranslatef=_glTranslated;var _emscripten_glTranslatef=_glTranslatef;var _glUniform1f=(location,v0)=>{GLctx.uniform1f(webglGetUniformLocation(location),v0)};var _emscripten_glUniform1f=_glUniform1f;var miniTempWebGLFloatBuffers=[];var _glUniform1fv=(location,count,value)=>{if(count<=288){var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;++i){view[i]=HEAPF32[value+4*i>>2]}}else{var view=HEAPF32.subarray(value>>2,value+count*4>>2)}GLctx.uniform1fv(webglGetUniformLocation(location),view)};var _emscripten_glUniform1fv=_glUniform1fv;var _glUniform1i=(location,v0)=>{GLctx.uniform1i(webglGetUniformLocation(location),v0)};var _emscripten_glUniform1i=_glUniform1i;var miniTempWebGLIntBuffers=[];var _glUniform1iv=(location,count,value)=>{if(count<=288){var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;++i){view[i]=HEAP32[value+4*i>>2]}}else{var view=HEAP32.subarray(value>>2,value+count*4>>2)}GLctx.uniform1iv(webglGetUniformLocation(location),view)};var _emscripten_glUniform1iv=_glUniform1iv;var _glUniform2f=(location,v0,v1)=>{GLctx.uniform2f(webglGetUniformLocation(location),v0,v1)};var _emscripten_glUniform2f=_glUniform2f;var _glUniform2fv=(location,count,value)=>{if(count<=144){count*=2;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=2){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2]}}else{var view=HEAPF32.subarray(value>>2,value+count*8>>2)}GLctx.uniform2fv(webglGetUniformLocation(location),view)};var _emscripten_glUniform2fv=_glUniform2fv;var _glUniform2i=(location,v0,v1)=>{GLctx.uniform2i(webglGetUniformLocation(location),v0,v1)};var _emscripten_glUniform2i=_glUniform2i;var _glUniform2iv=(location,count,value)=>{if(count<=144){count*=2;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=2){view[i]=HEAP32[value+4*i>>2];view[i+1]=HEAP32[value+(4*i+4)>>2]}}else{var view=HEAP32.subarray(value>>2,value+count*8>>2)}GLctx.uniform2iv(webglGetUniformLocation(location),view)};var _emscripten_glUniform2iv=_glUniform2iv;var _glUniform3f=(location,v0,v1,v2)=>{GLctx.uniform3f(webglGetUniformLocation(location),v0,v1,v2)};var _emscripten_glUniform3f=_glUniform3f;var _glUniform3fv=(location,count,value)=>{if(count<=96){count*=3;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=3){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2]}}else{var view=HEAPF32.subarray(value>>2,value+count*12>>2)}GLctx.uniform3fv(webglGetUniformLocation(location),view)};var _emscripten_glUniform3fv=_glUniform3fv;var _glUniform3i=(location,v0,v1,v2)=>{GLctx.uniform3i(webglGetUniformLocation(location),v0,v1,v2)};var _emscripten_glUniform3i=_glUniform3i;var _glUniform3iv=(location,count,value)=>{if(count<=96){count*=3;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=3){view[i]=HEAP32[value+4*i>>2];view[i+1]=HEAP32[value+(4*i+4)>>2];view[i+2]=HEAP32[value+(4*i+8)>>2]}}else{var view=HEAP32.subarray(value>>2,value+count*12>>2)}GLctx.uniform3iv(webglGetUniformLocation(location),view)};var _emscripten_glUniform3iv=_glUniform3iv;var _glUniform4f=(location,v0,v1,v2,v3)=>{GLctx.uniform4f(webglGetUniformLocation(location),v0,v1,v2,v3)};var _emscripten_glUniform4f=_glUniform4f;var _glUniform4fv=(location,count,value)=>{if(count<=72){var view=miniTempWebGLFloatBuffers[4*count];var heap=HEAPF32;value=value>>2;count*=4;for(var i=0;i<count;i+=4){var dst=value+i;view[i]=heap[dst];view[i+1]=heap[dst+1];view[i+2]=heap[dst+2];view[i+3]=heap[dst+3]}}else{var view=HEAPF32.subarray(value>>2,value+count*16>>2)}GLctx.uniform4fv(webglGetUniformLocation(location),view)};var _emscripten_glUniform4fv=_glUniform4fv;var _glUniform4i=(location,v0,v1,v2,v3)=>{GLctx.uniform4i(webglGetUniformLocation(location),v0,v1,v2,v3)};var _emscripten_glUniform4i=_glUniform4i;var _glUniform4iv=(location,count,value)=>{if(count<=72){count*=4;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=4){view[i]=HEAP32[value+4*i>>2];view[i+1]=HEAP32[value+(4*i+4)>>2];view[i+2]=HEAP32[value+(4*i+8)>>2];view[i+3]=HEAP32[value+(4*i+12)>>2]}}else{var view=HEAP32.subarray(value>>2,value+count*16>>2)}GLctx.uniform4iv(webglGetUniformLocation(location),view)};var _emscripten_glUniform4iv=_glUniform4iv;var _glUniformMatrix2fv=(location,count,transpose,value)=>{if(count<=72){count*=4;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=4){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2];view[i+3]=HEAPF32[value+(4*i+12)>>2]}}else{var view=HEAPF32.subarray(value>>2,value+count*16>>2)}GLctx.uniformMatrix2fv(webglGetUniformLocation(location),!!transpose,view)};var _emscripten_glUniformMatrix2fv=_glUniformMatrix2fv;var _glUniformMatrix3fv=(location,count,transpose,value)=>{if(count<=32){count*=9;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=9){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2];view[i+3]=HEAPF32[value+(4*i+12)>>2];view[i+4]=HEAPF32[value+(4*i+16)>>2];view[i+5]=HEAPF32[value+(4*i+20)>>2];view[i+6]=HEAPF32[value+(4*i+24)>>2];view[i+7]=HEAPF32[value+(4*i+28)>>2];view[i+8]=HEAPF32[value+(4*i+32)>>2]}}else{var view=HEAPF32.subarray(value>>2,value+count*36>>2)}GLctx.uniformMatrix3fv(webglGetUniformLocation(location),!!transpose,view)};var _emscripten_glUniformMatrix3fv=_glUniformMatrix3fv;var _glUniformMatrix4fv=(location,count,transpose,value)=>{if(count<=18){var view=miniTempWebGLFloatBuffers[16*count];var heap=HEAPF32;value=value>>2;count*=16;for(var i=0;i<count;i+=16){var dst=value+i;view[i]=heap[dst];view[i+1]=heap[dst+1];view[i+2]=heap[dst+2];view[i+3]=heap[dst+3];view[i+4]=heap[dst+4];view[i+5]=heap[dst+5];view[i+6]=heap[dst+6];view[i+7]=heap[dst+7];view[i+8]=heap[dst+8];view[i+9]=heap[dst+9];view[i+10]=heap[dst+10];view[i+11]=heap[dst+11];view[i+12]=heap[dst+12];view[i+13]=heap[dst+13];view[i+14]=heap[dst+14];view[i+15]=heap[dst+15]}}else{var view=HEAPF32.subarray(value>>2,value+count*64>>2)}GLctx.uniformMatrix4fv(webglGetUniformLocation(location),!!transpose,view)};var _emscripten_glUniformMatrix4fv=_glUniformMatrix4fv;var _emscripten_glUseProgram=_glUseProgram;var _glValidateProgram=program=>{GLctx.validateProgram(GL.programs[program])};var _emscripten_glValidateProgram=_glValidateProgram;var _glVertex2f=(x,y)=>{GLImmediate.vertexData[GLImmediate.vertexCounter++]=x;GLImmediate.vertexData[GLImmediate.vertexCounter++]=y;GLImmediate.vertexData[GLImmediate.vertexCounter++]=0;GLImmediate.vertexData[GLImmediate.vertexCounter++]=1;GLImmediate.addRendererComponent(GLImmediate.VERTEX,4,GLctx.FLOAT)};var _emscripten_glVertex2f=_glVertex2f;var _glVertex2fv=p=>_glVertex2f(HEAPF32[p>>2],HEAPF32[p+4>>2]);var _emscripten_glVertex2fv=_glVertex2fv;var _glVertex2i=_glVertex2f;var _emscripten_glVertex2i=_glVertex2i;var _glVertex3f=(x,y,z)=>{GLImmediate.vertexData[GLImmediate.vertexCounter++]=x;GLImmediate.vertexData[GLImmediate.vertexCounter++]=y;GLImmediate.vertexData[GLImmediate.vertexCounter++]=z;GLImmediate.vertexData[GLImmediate.vertexCounter++]=1;GLImmediate.addRendererComponent(GLImmediate.VERTEX,4,GLctx.FLOAT)};var _emscripten_glVertex3f=_glVertex3f;var _glVertex3fv=p=>_glVertex3f(HEAPF32[p>>2],HEAPF32[p+4>>2],HEAPF32[p+8>>2]);var _emscripten_glVertex3fv=_glVertex3fv;var _glVertex3i=_glVertex3f;var _emscripten_glVertex3i=_glVertex3i;var _glVertex4f=(x,y,z,w)=>{GLImmediate.vertexData[GLImmediate.vertexCounter++]=x;GLImmediate.vertexData[GLImmediate.vertexCounter++]=y;GLImmediate.vertexData[GLImmediate.vertexCounter++]=z;GLImmediate.vertexData[GLImmediate.vertexCounter++]=w;GLImmediate.addRendererComponent(GLImmediate.VERTEX,4,GLctx.FLOAT)};var _emscripten_glVertex4f=_glVertex4f;var _glVertex4fv=p=>_glVertex4f(HEAPF32[p>>2],HEAPF32[p+4>>2],HEAPF32[p+8>>2],HEAPF32[p+12>>2]);var _emscripten_glVertex4fv=_glVertex4fv;var _glVertex4i=_glVertex4f;var _emscripten_glVertex4i=_glVertex4i;var _glVertexAttrib1f=(x0,x1)=>GLctx.vertexAttrib1f(x0,x1);var _emscripten_glVertexAttrib1f=_glVertexAttrib1f;var _glVertexAttrib1fv=(index,v)=>{GLctx.vertexAttrib1f(index,HEAPF32[v>>2])};var _emscripten_glVertexAttrib1fv=_glVertexAttrib1fv;var _glVertexAttrib2f=(x0,x1,x2)=>GLctx.vertexAttrib2f(x0,x1,x2);var _emscripten_glVertexAttrib2f=_glVertexAttrib2f;var _glVertexAttrib2fv=(index,v)=>{GLctx.vertexAttrib2f(index,HEAPF32[v>>2],HEAPF32[v+4>>2])};var _emscripten_glVertexAttrib2fv=_glVertexAttrib2fv;var _glVertexAttrib3f=(x0,x1,x2,x3)=>GLctx.vertexAttrib3f(x0,x1,x2,x3);var _emscripten_glVertexAttrib3f=_glVertexAttrib3f;var _glVertexAttrib3fv=(index,v)=>{GLctx.vertexAttrib3f(index,HEAPF32[v>>2],HEAPF32[v+4>>2],HEAPF32[v+8>>2])};var _emscripten_glVertexAttrib3fv=_glVertexAttrib3fv;var _glVertexAttrib4f=(x0,x1,x2,x3,x4)=>GLctx.vertexAttrib4f(x0,x1,x2,x3,x4);var _emscripten_glVertexAttrib4f=_glVertexAttrib4f;var _glVertexAttrib4fv=(index,v)=>{GLctx.vertexAttrib4f(index,HEAPF32[v>>2],HEAPF32[v+4>>2],HEAPF32[v+8>>2],HEAPF32[v+12>>2])};var _emscripten_glVertexAttrib4fv=_glVertexAttrib4fv;var _glVertexAttribDivisor=(index,divisor)=>{GLctx.vertexAttribDivisor(index,divisor)};var _glVertexAttribDivisorANGLE=_glVertexAttribDivisor;var _emscripten_glVertexAttribDivisorANGLE=_glVertexAttribDivisorANGLE;var _emscripten_glVertexAttribPointer=_glVertexAttribPointer;var _glVertexPointer=(size,type,stride,pointer)=>{GLImmediate.setClientAttribute(GLImmediate.VERTEX,size,type,stride,pointer)};var _emscripten_glVertexPointer=_glVertexPointer;var _glViewport=(x0,x1,x2,x3)=>GLctx.viewport(x0,x1,x2,x3);var _emscripten_glViewport=_glViewport;var _emscripten_has_asyncify=()=>0;var doRequestFullscreen=(target,strategy)=>{if(!JSEvents.fullscreenEnabled())return-1;target=findEventTarget(target);if(!target)return-4;if(!target.requestFullscreen&&!target.webkitRequestFullscreen){return-3}if(!JSEvents.canPerformEventHandlerRequests()){if(strategy.deferUntilInEventHandler){JSEvents.deferCall(JSEvents_requestFullscreen,1,[target,strategy]);return 1}return-2}return JSEvents_requestFullscreen(target,strategy)};var _emscripten_request_fullscreen_strategy=(target,deferUntilInEventHandler,fullscreenStrategy)=>{var strategy={scaleMode:HEAP32[fullscreenStrategy>>2],canvasResolutionScaleMode:HEAP32[fullscreenStrategy+4>>2],filteringMode:HEAP32[fullscreenStrategy+8>>2],deferUntilInEventHandler,canvasResizedCallback:HEAP32[fullscreenStrategy+12>>2],canvasResizedCallbackUserData:HEAP32[fullscreenStrategy+16>>2]};return doRequestFullscreen(target,strategy)};var _emscripten_request_pointerlock=(target,deferUntilInEventHandler)=>{target=findEventTarget(target);if(!target)return-4;if(!target.requestPointerLock){return-1}if(!JSEvents.canPerformEventHandlerRequests()){if(deferUntilInEventHandler){JSEvents.deferCall(requestPointerLock,2,[target]);return 1}return-2}return requestPointerLock(target)};var getHeapMax=()=>2147483648;var growMemory=size=>{var b=wasmMemory.buffer;var pages=(size-b.byteLength+65535)/65536|0;try{wasmMemory.grow(pages);updateMemoryViews();return 1}catch(e){}};var _emscripten_resize_heap=requestedSize=>{var oldSize=HEAPU8.length;requestedSize>>>=0;var maxHeapSize=getHeapMax();if(requestedSize>maxHeapSize){return false}for(var cutDown=1;cutDown<=4;cutDown*=2){var overGrownHeapSize=oldSize*(1+.2/cutDown);overGrownHeapSize=Math.min(overGrownHeapSize,requestedSize+100663296);var newSize=Math.min(maxHeapSize,alignMemory(Math.max(requestedSize,overGrownHeapSize),65536));var replacement=growMemory(newSize);if(replacement){return true}}return false};var _emscripten_sample_gamepad_data=()=>{try{if(navigator.getGamepads)return(JSEvents.lastGamepadState=navigator.getGamepads())?0:-1}catch(e){navigator.getGamepads=null}return-1};var registerBeforeUnloadEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString)=>{var beforeUnloadEventHandlerFunc=(e=event)=>{var confirmationMessage=getWasmTableEntry(callbackfunc)(eventTypeId,0,userData);if(confirmationMessage){confirmationMessage=UTF8ToString(confirmationMessage)}if(confirmationMessage){e.preventDefault();e.returnValue=confirmationMessage;return confirmationMessage}};var eventHandler={target:findEventTarget(target),eventTypeString,callbackfunc,handlerFunc:beforeUnloadEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_beforeunload_callback_on_thread=(userData,callbackfunc,targetThread)=>{if(typeof onbeforeunload=="undefined")return-1;if(targetThread!==1)return-5;return registerBeforeUnloadEventCallback(2,userData,true,callbackfunc,28,"beforeunload")};var registerFocusEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.focusEvent||=_malloc(256);var focusEventHandlerFunc=(e=event)=>{var nodeName=JSEvents.getNodeNameForTarget(e.target);var id=e.target.id?e.target.id:"";var focusEvent=JSEvents.focusEvent;stringToUTF8(nodeName,focusEvent+0,128);stringToUTF8(id,focusEvent+128,128);if(getWasmTableEntry(callbackfunc)(eventTypeId,focusEvent,userData))e.preventDefault()};var eventHandler={target:findEventTarget(target),eventTypeString,callbackfunc,handlerFunc:focusEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_blur_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerFocusEventCallback(target,userData,useCapture,callbackfunc,12,"blur",targetThread);var fillDeviceMotionEventData=(eventStruct,e,target)=>{var supportedFields=0;var a=e["acceleration"];supportedFields|=a&&1;var ag=e["accelerationIncludingGravity"];supportedFields|=ag&&2;var rr=e["rotationRate"];supportedFields|=rr&&4;a=a||{};ag=ag||{};rr=rr||{};HEAPF64[eventStruct>>3]=a["x"];HEAPF64[eventStruct+8>>3]=a["y"];HEAPF64[eventStruct+16>>3]=a["z"];HEAPF64[eventStruct+24>>3]=ag["x"];HEAPF64[eventStruct+32>>3]=ag["y"];HEAPF64[eventStruct+40>>3]=ag["z"];HEAPF64[eventStruct+48>>3]=rr["alpha"];HEAPF64[eventStruct+56>>3]=rr["beta"];HEAPF64[eventStruct+64>>3]=rr["gamma"]};var registerDeviceMotionEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.deviceMotionEvent||=_malloc(80);var deviceMotionEventHandlerFunc=(e=event)=>{fillDeviceMotionEventData(JSEvents.deviceMotionEvent,e,target);if(getWasmTableEntry(callbackfunc)(eventTypeId,JSEvents.deviceMotionEvent,userData))e.preventDefault()};var eventHandler={target:findEventTarget(target),eventTypeString,callbackfunc,handlerFunc:deviceMotionEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_devicemotion_callback_on_thread=(userData,useCapture,callbackfunc,targetThread)=>registerDeviceMotionEventCallback(2,userData,useCapture,callbackfunc,17,"devicemotion",targetThread);var fillDeviceOrientationEventData=(eventStruct,e,target)=>{HEAPF64[eventStruct>>3]=e.alpha;HEAPF64[eventStruct+8>>3]=e.beta;HEAPF64[eventStruct+16>>3]=e.gamma;HEAP8[eventStruct+24]=e.absolute};var registerDeviceOrientationEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.deviceOrientationEvent||=_malloc(32);var deviceOrientationEventHandlerFunc=(e=event)=>{fillDeviceOrientationEventData(JSEvents.deviceOrientationEvent,e,target);if(getWasmTableEntry(callbackfunc)(eventTypeId,JSEvents.deviceOrientationEvent,userData))e.preventDefault()};var eventHandler={target:findEventTarget(target),eventTypeString,callbackfunc,handlerFunc:deviceOrientationEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_deviceorientation_callback_on_thread=(userData,useCapture,callbackfunc,targetThread)=>registerDeviceOrientationEventCallback(2,userData,useCapture,callbackfunc,16,"deviceorientation",targetThread);var _emscripten_set_element_css_size=(target,width,height)=>{target=findEventTarget(target);if(!target)return-4;target.style.width=width+"px";target.style.height=height+"px";return 0};var _emscripten_set_focus_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerFocusEventCallback(target,userData,useCapture,callbackfunc,13,"focus",targetThread);var fillFullscreenChangeEventData=eventStruct=>{var fullscreenElement=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement;var isFullscreen=!!fullscreenElement;HEAP8[eventStruct]=isFullscreen;HEAP8[eventStruct+1]=JSEvents.fullscreenEnabled();var reportedElement=isFullscreen?fullscreenElement:JSEvents.previousFullscreenElement;var nodeName=JSEvents.getNodeNameForTarget(reportedElement);var id=reportedElement?.id||"";stringToUTF8(nodeName,eventStruct+2,128);stringToUTF8(id,eventStruct+130,128);HEAP32[eventStruct+260>>2]=reportedElement?reportedElement.clientWidth:0;HEAP32[eventStruct+264>>2]=reportedElement?reportedElement.clientHeight:0;HEAP32[eventStruct+268>>2]=screen.width;HEAP32[eventStruct+272>>2]=screen.height;if(isFullscreen){JSEvents.previousFullscreenElement=fullscreenElement}};var registerFullscreenChangeEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.fullscreenChangeEvent||=_malloc(276);var fullscreenChangeEventhandlerFunc=(e=event)=>{var fullscreenChangeEvent=JSEvents.fullscreenChangeEvent;fillFullscreenChangeEventData(fullscreenChangeEvent);if(getWasmTableEntry(callbackfunc)(eventTypeId,fullscreenChangeEvent,userData))e.preventDefault()};var eventHandler={target,eventTypeString,callbackfunc,handlerFunc:fullscreenChangeEventhandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_fullscreenchange_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>{if(!JSEvents.fullscreenEnabled())return-1;target=findEventTarget(target);if(!target)return-4;registerFullscreenChangeEventCallback(target,userData,useCapture,callbackfunc,19,"webkitfullscreenchange",targetThread);return registerFullscreenChangeEventCallback(target,userData,useCapture,callbackfunc,19,"fullscreenchange",targetThread)};var registerGamepadEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.gamepadEvent||=_malloc(1240);var gamepadEventHandlerFunc=(e=event)=>{var gamepadEvent=JSEvents.gamepadEvent;fillGamepadEventData(gamepadEvent,e["gamepad"]);if(getWasmTableEntry(callbackfunc)(eventTypeId,gamepadEvent,userData))e.preventDefault()};var eventHandler={target:findEventTarget(target),allowsDeferredCalls:true,eventTypeString,callbackfunc,handlerFunc:gamepadEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_gamepadconnected_callback_on_thread=(userData,useCapture,callbackfunc,targetThread)=>{if(_emscripten_sample_gamepad_data())return-1;return registerGamepadEventCallback(2,userData,useCapture,callbackfunc,26,"gamepadconnected",targetThread)};var _emscripten_set_gamepaddisconnected_callback_on_thread=(userData,useCapture,callbackfunc,targetThread)=>{if(_emscripten_sample_gamepad_data())return-1;return registerGamepadEventCallback(2,userData,useCapture,callbackfunc,27,"gamepaddisconnected",targetThread)};var registerKeyEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.keyEvent||=_malloc(160);var keyEventHandlerFunc=e=>{var keyEventData=JSEvents.keyEvent;HEAPF64[keyEventData>>3]=e.timeStamp;var idx=keyEventData>>2;HEAP32[idx+2]=e.location;HEAP8[keyEventData+12]=e.ctrlKey;HEAP8[keyEventData+13]=e.shiftKey;HEAP8[keyEventData+14]=e.altKey;HEAP8[keyEventData+15]=e.metaKey;HEAP8[keyEventData+16]=e.repeat;HEAP32[idx+5]=e.charCode;HEAP32[idx+6]=e.keyCode;HEAP32[idx+7]=e.which;stringToUTF8(e.key||"",keyEventData+32,32);stringToUTF8(e.code||"",keyEventData+64,32);stringToUTF8(e.char||"",keyEventData+96,32);stringToUTF8(e.locale||"",keyEventData+128,32);if(getWasmTableEntry(callbackfunc)(eventTypeId,keyEventData,userData))e.preventDefault()};var eventHandler={target:findEventTarget(target),eventTypeString,callbackfunc,handlerFunc:keyEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_keydown_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerKeyEventCallback(target,userData,useCapture,callbackfunc,2,"keydown",targetThread);var _emscripten_set_keypress_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerKeyEventCallback(target,userData,useCapture,callbackfunc,1,"keypress",targetThread);var _emscripten_set_keyup_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerKeyEventCallback(target,userData,useCapture,callbackfunc,3,"keyup",targetThread);var _emscripten_set_main_loop=(func,fps,simulateInfiniteLoop)=>{var iterFunc=getWasmTableEntry(func);setMainLoop(iterFunc,fps,simulateInfiniteLoop)};var fillMouseEventData=(eventStruct,e,target)=>{HEAPF64[eventStruct>>3]=e.timeStamp;var idx=eventStruct>>2;HEAP32[idx+2]=e.screenX;HEAP32[idx+3]=e.screenY;HEAP32[idx+4]=e.clientX;HEAP32[idx+5]=e.clientY;HEAP8[eventStruct+24]=e.ctrlKey;HEAP8[eventStruct+25]=e.shiftKey;HEAP8[eventStruct+26]=e.altKey;HEAP8[eventStruct+27]=e.metaKey;HEAP16[idx*2+14]=e.button;HEAP16[idx*2+15]=e.buttons;HEAP32[idx+8]=e["movementX"];HEAP32[idx+9]=e["movementY"];var rect=getBoundingClientRect(target);HEAP32[idx+10]=e.clientX-(rect.left|0);HEAP32[idx+11]=e.clientY-(rect.top|0)};var registerMouseEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.mouseEvent||=_malloc(64);target=findEventTarget(target);var mouseEventHandlerFunc=(e=event)=>{fillMouseEventData(JSEvents.mouseEvent,e,target);if(getWasmTableEntry(callbackfunc)(eventTypeId,JSEvents.mouseEvent,userData))e.preventDefault()};var eventHandler={target,allowsDeferredCalls:eventTypeString!="mousemove"&&eventTypeString!="mouseenter"&&eventTypeString!="mouseleave",eventTypeString,callbackfunc,handlerFunc:mouseEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_mousedown_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerMouseEventCallback(target,userData,useCapture,callbackfunc,5,"mousedown",targetThread);var _emscripten_set_mouseenter_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerMouseEventCallback(target,userData,useCapture,callbackfunc,33,"mouseenter",targetThread);var _emscripten_set_mouseleave_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerMouseEventCallback(target,userData,useCapture,callbackfunc,34,"mouseleave",targetThread);var _emscripten_set_mousemove_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerMouseEventCallback(target,userData,useCapture,callbackfunc,8,"mousemove",targetThread);var _emscripten_set_mouseup_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerMouseEventCallback(target,userData,useCapture,callbackfunc,6,"mouseup",targetThread);var fillPointerlockChangeEventData=eventStruct=>{var pointerLockElement=document.pointerLockElement||document.mozPointerLockElement||document.webkitPointerLockElement||document.msPointerLockElement;var isPointerlocked=!!pointerLockElement;HEAP8[eventStruct]=isPointerlocked;var nodeName=JSEvents.getNodeNameForTarget(pointerLockElement);var id=pointerLockElement?.id||"";stringToUTF8(nodeName,eventStruct+1,128);stringToUTF8(id,eventStruct+129,128)};var registerPointerlockChangeEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.pointerlockChangeEvent||=_malloc(257);var pointerlockChangeEventHandlerFunc=(e=event)=>{var pointerlockChangeEvent=JSEvents.pointerlockChangeEvent;fillPointerlockChangeEventData(pointerlockChangeEvent);if(getWasmTableEntry(callbackfunc)(eventTypeId,pointerlockChangeEvent,userData))e.preventDefault()};var eventHandler={target,eventTypeString,callbackfunc,handlerFunc:pointerlockChangeEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_pointerlockchange_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>{if(!document||!document.body||!document.body.requestPointerLock&&!document.body.mozRequestPointerLock&&!document.body.webkitRequestPointerLock&&!document.body.msRequestPointerLock){return-1}target=findEventTarget(target);if(!target)return-4;registerPointerlockChangeEventCallback(target,userData,useCapture,callbackfunc,20,"mozpointerlockchange",targetThread);registerPointerlockChangeEventCallback(target,userData,useCapture,callbackfunc,20,"webkitpointerlockchange",targetThread);registerPointerlockChangeEventCallback(target,userData,useCapture,callbackfunc,20,"mspointerlockchange",targetThread);return registerPointerlockChangeEventCallback(target,userData,useCapture,callbackfunc,20,"pointerlockchange",targetThread)};var registerUiEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.uiEvent||=_malloc(36);target=findEventTarget(target);var uiEventHandlerFunc=(e=event)=>{if(e.target!=target){return}var b=document.body;if(!b){return}var uiEvent=JSEvents.uiEvent;HEAP32[uiEvent>>2]=0;HEAP32[uiEvent+4>>2]=b.clientWidth;HEAP32[uiEvent+8>>2]=b.clientHeight;HEAP32[uiEvent+12>>2]=innerWidth;HEAP32[uiEvent+16>>2]=innerHeight;HEAP32[uiEvent+20>>2]=outerWidth;HEAP32[uiEvent+24>>2]=outerHeight;HEAP32[uiEvent+28>>2]=pageXOffset|0;HEAP32[uiEvent+32>>2]=pageYOffset|0;if(getWasmTableEntry(callbackfunc)(eventTypeId,uiEvent,userData))e.preventDefault()};var eventHandler={target,eventTypeString,callbackfunc,handlerFunc:uiEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_resize_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerUiEventCallback(target,userData,useCapture,callbackfunc,10,"resize",targetThread);var registerTouchEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.touchEvent||=_malloc(1552);target=findEventTarget(target);var touchEventHandlerFunc=e=>{var t,touches={},et=e.touches;for(let t of et){t.isChanged=t.onTarget=0;touches[t.identifier]=t}for(let t of e.changedTouches){t.isChanged=1;touches[t.identifier]=t}for(let t of e.targetTouches){touches[t.identifier].onTarget=1}var touchEvent=JSEvents.touchEvent;HEAPF64[touchEvent>>3]=e.timeStamp;HEAP8[touchEvent+12]=e.ctrlKey;HEAP8[touchEvent+13]=e.shiftKey;HEAP8[touchEvent+14]=e.altKey;HEAP8[touchEvent+15]=e.metaKey;var idx=touchEvent+16;var targetRect=getBoundingClientRect(target);var numTouches=0;for(let t of Object.values(touches)){var idx32=idx>>2;HEAP32[idx32+0]=t.identifier;HEAP32[idx32+1]=t.screenX;HEAP32[idx32+2]=t.screenY;HEAP32[idx32+3]=t.clientX;HEAP32[idx32+4]=t.clientY;HEAP32[idx32+5]=t.pageX;HEAP32[idx32+6]=t.pageY;HEAP8[idx+28]=t.isChanged;HEAP8[idx+29]=t.onTarget;HEAP32[idx32+8]=t.clientX-(targetRect.left|0);HEAP32[idx32+9]=t.clientY-(targetRect.top|0);idx+=48;if(++numTouches>31){break}}HEAP32[touchEvent+8>>2]=numTouches;if(getWasmTableEntry(callbackfunc)(eventTypeId,touchEvent,userData))e.preventDefault()};var eventHandler={target,allowsDeferredCalls:eventTypeString=="touchstart"||eventTypeString=="touchend",eventTypeString,callbackfunc,handlerFunc:touchEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_touchcancel_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerTouchEventCallback(target,userData,useCapture,callbackfunc,25,"touchcancel",targetThread);var _emscripten_set_touchend_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerTouchEventCallback(target,userData,useCapture,callbackfunc,23,"touchend",targetThread);var _emscripten_set_touchmove_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerTouchEventCallback(target,userData,useCapture,callbackfunc,24,"touchmove",targetThread);var _emscripten_set_touchstart_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>registerTouchEventCallback(target,userData,useCapture,callbackfunc,22,"touchstart",targetThread);var fillVisibilityChangeEventData=eventStruct=>{var visibilityStates=["hidden","visible","prerender","unloaded"];var visibilityState=visibilityStates.indexOf(document.visibilityState);HEAP8[eventStruct]=document.hidden;HEAP32[eventStruct+4>>2]=visibilityState};var registerVisibilityChangeEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.visibilityChangeEvent||=_malloc(8);var visibilityChangeEventHandlerFunc=(e=event)=>{var visibilityChangeEvent=JSEvents.visibilityChangeEvent;fillVisibilityChangeEventData(visibilityChangeEvent);if(getWasmTableEntry(callbackfunc)(eventTypeId,visibilityChangeEvent,userData))e.preventDefault()};var eventHandler={target,eventTypeString,callbackfunc,handlerFunc:visibilityChangeEventHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_visibilitychange_callback_on_thread=(userData,useCapture,callbackfunc,targetThread)=>{if(!specialHTMLTargets[1]){return-4}return registerVisibilityChangeEventCallback(specialHTMLTargets[1],userData,useCapture,callbackfunc,21,"visibilitychange",targetThread)};var registerWheelEventCallback=(target,userData,useCapture,callbackfunc,eventTypeId,eventTypeString,targetThread)=>{JSEvents.wheelEvent||=_malloc(96);var wheelHandlerFunc=(e=event)=>{var wheelEvent=JSEvents.wheelEvent;fillMouseEventData(wheelEvent,e,target);HEAPF64[wheelEvent+64>>3]=e["deltaX"];HEAPF64[wheelEvent+72>>3]=e["deltaY"];HEAPF64[wheelEvent+80>>3]=e["deltaZ"];HEAP32[wheelEvent+88>>2]=e["deltaMode"];if(getWasmTableEntry(callbackfunc)(eventTypeId,wheelEvent,userData))e.preventDefault()};var eventHandler={target,allowsDeferredCalls:true,eventTypeString,callbackfunc,handlerFunc:wheelHandlerFunc,useCapture};return JSEvents.registerOrRemoveHandler(eventHandler)};var _emscripten_set_wheel_callback_on_thread=(target,userData,useCapture,callbackfunc,targetThread)=>{target=findEventTarget(target);if(!target)return-4;if(typeof target.onwheel!="undefined"){return registerWheelEventCallback(target,userData,useCapture,callbackfunc,9,"wheel",targetThread)}else{return-1}};var _emscripten_set_window_title=title=>document.title=UTF8ToString(title);var _emscripten_sleep=()=>{throw"Please compile your program with async support in order to use asynchronous operations like emscripten_sleep"};var ENV={};var getExecutableName=()=>thisProgram||"./this.program";var getEnvStrings=()=>{if(!getEnvStrings.strings){var lang=(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8";var env={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:lang,_:getExecutableName()};for(var x in ENV){if(ENV[x]===undefined)delete env[x];else env[x]=ENV[x]}var strings=[];for(var x in env){strings.push(`${x}=${env[x]}`)}getEnvStrings.strings=strings}return getEnvStrings.strings};var stringToAscii=(str,buffer)=>{for(var i=0;i<str.length;++i){HEAP8[buffer++]=str.charCodeAt(i)}HEAP8[buffer]=0};var _environ_get=(__environ,environ_buf)=>{var bufSize=0;getEnvStrings().forEach((string,i)=>{var ptr=environ_buf+bufSize;HEAPU32[__environ+i*4>>2]=ptr;stringToAscii(string,ptr);bufSize+=string.length+1});return 0};var _environ_sizes_get=(penviron_count,penviron_buf_size)=>{var strings=getEnvStrings();HEAPU32[penviron_count>>2]=strings.length;var bufSize=0;strings.forEach(string=>bufSize+=string.length+1);HEAPU32[penviron_buf_size>>2]=bufSize;return 0};function _fd_close(fd){try{var stream=SYSCALLS.getStreamFromFD(fd);FS.close(stream);return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}var doReadv=(stream,iov,iovcnt,offset)=>{var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAPU32[iov>>2];var len=HEAPU32[iov+4>>2];iov+=8;var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break;if(typeof offset!="undefined"){offset+=curr}}return ret};function _fd_read(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=doReadv(stream,iov,iovcnt);HEAPU32[pnum>>2]=num;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}function _fd_seek(fd,offset_low,offset_high,whence,newOffset){var offset=convertI32PairToI53Checked(offset_low,offset_high);try{if(isNaN(offset))return 61;var stream=SYSCALLS.getStreamFromFD(fd);FS.llseek(stream,offset,whence);tempI64=[stream.position>>>0,(tempDouble=stream.position,+Math.abs(tempDouble)>=1?tempDouble>0?+Math.floor(tempDouble/4294967296)>>>0:~~+Math.ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[newOffset>>2]=tempI64[0],HEAP32[newOffset+4>>2]=tempI64[1];if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}var doWritev=(stream,iov,iovcnt,offset)=>{var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAPU32[iov>>2];var len=HEAPU32[iov+4>>2];iov+=8;var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len){break}if(typeof offset!="undefined"){offset+=curr}}return ret};function _fd_write(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=doWritev(stream,iov,iovcnt);HEAPU32[pnum>>2]=num;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}var _llvm_eh_typeid_for=type=>type;var listenOnce=(object,event,func)=>object.addEventListener(event,func,{once:true});var autoResumeAudioContext=(ctx,elements)=>{if(!elements){elements=[document,document.getElementById("canvas")]}["keydown","mousedown","touchstart"].forEach(event=>{elements.forEach(element=>{if(element){listenOnce(element,event,()=>{if(ctx.state==="suspended")ctx.resume()})}})})};var dynCallLegacy=(sig,ptr,args)=>{sig=sig.replace(/p/g,"i");var f=Module["dynCall_"+sig];return f(ptr,...args)};var dynCall=(sig,ptr,args=[])=>{if(sig.includes("j")){return dynCallLegacy(sig,ptr,args)}var rtn=getWasmTableEntry(ptr)(...args);return rtn};var FS_createPath=FS.createPath;var getCFunc=ident=>{var func=Module["_"+ident];return func};var writeArrayToMemory=(array,buffer)=>{HEAP8.set(array,buffer)};var ccall=(ident,returnType,argTypes,args,opts)=>{var toC={string:str=>{var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=stringToUTF8OnStack(str)}return ret},array:arr=>{var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}};function convertReturnValue(ret){if(returnType==="string"){return UTF8ToString(ret)}if(returnType==="boolean")return Boolean(ret);return ret}var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func(...cArgs);function onDone(ret){if(stack!==0)stackRestore(stack);return convertReturnValue(ret)}ret=onDone(ret);return ret};var cwrap=(ident,returnType,argTypes,opts)=>{var numericArgs=!argTypes||argTypes.every(type=>type==="number"||type==="boolean");var numericRet=returnType!=="string";if(numericRet&&numericArgs&&!opts){return getCFunc(ident)}return(...args)=>ccall(ident,returnType,argTypes,args,opts)};FS.createPreloadedFile=FS_createPreloadedFile;FS.staticInit();Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createPath"]=FS.createPath;MEMFS.doesNotExistError=new FS.ErrnoError(44);MEMFS.doesNotExistError.stack="<generic error, no stack>";Module["requestFullscreen"]=Browser.requestFullscreen;Module["setCanvasSize"]=Browser.setCanvasSize;Module["getUserMedia"]=Browser.getUserMedia;Module["createContext"]=Browser.createContext;registerPreMainLoop(()=>GL.newRenderingFrameStarted());Module["requestAnimationFrame"]=MainLoop.requestAnimationFrame;Module["pauseMainLoop"]=MainLoop.pause;Module["resumeMainLoop"]=MainLoop.resume;MainLoop.init();GLImmediate.setupFuncs();Browser.moduleContextCreatedCallbacks.push(()=>GLImmediate.init());GLEmulation.init();for(var i=0;i<32;++i)tempFixedLengthArray.push(new Array(i));var miniTempWebGLFloatBuffersStorage=new Float32Array(288);for(var i=0;i<=288;++i){miniTempWebGLFloatBuffers[i]=miniTempWebGLFloatBuffersStorage.subarray(0,i)}var miniTempWebGLIntBuffersStorage=new Int32Array(288);for(var i=0;i<=288;++i){miniTempWebGLIntBuffers[i]=miniTempWebGLIntBuffersStorage.subarray(0,i)}var wasmImports={y:___cxa_begin_catch,q:___cxa_end_catch,b:___cxa_find_matching_catch_2,d:___cxa_find_matching_catch_3,Ff:___cxa_find_matching_catch_4,a:___cxa_throw,e:___resumeException,_a:___syscall__newselect,kb:___syscall_chdir,m:___syscall_fcntl64,ib:___syscall_fstat64,eb:___syscall_getcwd,$a:___syscall_getdents64,lb:___syscall_ioctl,fb:___syscall_lstat64,bb:___syscall_mkdirat,gb:___syscall_newfstatat,ma:___syscall_openat,hb:___syscall_stat64,Za:___syscall_unlinkat,Xa:__abort_js,jb:__emscripten_memcpy_js,Ua:__localtime_js,ab:__tzset_js,Wa:_clock_time_get,Ja:_eglBindAPI,Ma:_eglChooseConfig,Aa:_eglCreateContext,Ca:_eglCreateWindowSurface,Ba:_eglDestroyContext,Da:_eglDestroySurface,Na:_eglGetConfigAttrib,da:_eglGetDisplay,za:_eglGetError,Ka:_eglInitialize,Ea:_eglMakeCurrent,ya:_eglQueryString,Fa:_eglSwapBuffers,Ga:_eglSwapInterval,La:_eglTerminate,Ia:_eglWaitGL,Ha:_eglWaitNative,p:_emscripten_asm_const_int,f:_emscripten_asm_const_int_sync_on_main_thread,Pa:_emscripten_asm_const_ptr_sync_on_main_thread,Qa:_emscripten_async_wget2_data,ja:_emscripten_cancel_main_loop,na:_emscripten_date_now,Yf:_emscripten_exit_fullscreen,wa:_emscripten_exit_pointerlock,v:_emscripten_get_device_pixel_ratio,r:_emscripten_get_element_css_size,ga:_emscripten_get_gamepad_status,la:_emscripten_get_now,Oa:_emscripten_get_num_gamepads,xa:_emscripten_get_screen_size,Xd:_emscripten_glActiveTexture,kf:_emscripten_glAlphaFunc,Uf:_emscripten_glAttachShader,Nf:_emscripten_glBegin,de:_emscripten_glBeginQueryEXT,Wd:_emscripten_glBindAttribLocation,Vd:_emscripten_glBindBuffer,Ud:_emscripten_glBindFramebuffer,Pf:_emscripten_glBindProgram,Td:_emscripten_glBindRenderbuffer,Sd:_emscripten_glBindTexture,oe:_emscripten_glBindVertexArrayOES,Rd:_emscripten_glBlendColor,Qd:_emscripten_glBlendEquation,Pd:_emscripten_glBlendEquationSeparate,Od:_emscripten_glBlendFunc,Nd:_emscripten_glBlendFuncSeparate,Md:_emscripten_glBufferData,Ld:_emscripten_glBufferSubData,Kd:_emscripten_glCheckFramebufferStatus,Jd:_emscripten_glClear,Id:_emscripten_glClearColor,Hd:_emscripten_glClearDepthf,Gd:_emscripten_glClearStencil,af:_emscripten_glClientActiveTexture,nb:_emscripten_glClipControlEXT,He:_emscripten_glClipPlane,Bf:_emscripten_glColor3d,Af:_emscripten_glColor3f,rf:_emscripten_glColor3fv,zf:_emscripten_glColor3ub,qf:_emscripten_glColor3ubv,yf:_emscripten_glColor3ui,pf:_emscripten_glColor3uiv,xf:_emscripten_glColor3us,of:_emscripten_glColor3usv,wf:_emscripten_glColor4d,vf:_emscripten_glColor4f,nf:_emscripten_glColor4fv,uf:_emscripten_glColor4ub,mf:_emscripten_glColor4ubv,tf:_emscripten_glColor4ui,sf:_emscripten_glColor4us,Fd:_emscripten_glColorMask,cf:_emscripten_glColorPointer,Ed:_emscripten_glCompileShader,Dd:_emscripten_glCompressedTexImage2D,Cd:_emscripten_glCompressedTexSubImage2D,Bd:_emscripten_glCopyTexImage2D,Ad:_emscripten_glCopyTexSubImage2D,Xf:_emscripten_glCreateProgram,Vf:_emscripten_glCreateShader,zd:_emscripten_glCullFace,yd:_emscripten_glDeleteBuffers,xd:_emscripten_glDeleteFramebuffers,Sf:_emscripten_glDeleteObject,wd:_emscripten_glDeleteProgram,fe:_emscripten_glDeleteQueriesEXT,vd:_emscripten_glDeleteRenderbuffers,ud:_emscripten_glDeleteShader,td:_emscripten_glDeleteTextures,ne:_emscripten_glDeleteVertexArraysOES,sd:_emscripten_glDepthFunc,rd:_emscripten_glDepthMask,qd:_emscripten_glDepthRangef,Tf:_emscripten_glDetachShader,pd:_emscripten_glDisable,ff:_emscripten_glDisableClientState,od:_emscripten_glDisableVertexAttribArray,nd:_emscripten_glDrawArrays,je:_emscripten_glDrawArraysInstancedANGLE,Ge:_emscripten_glDrawBuffer,ke:_emscripten_glDrawBuffersWEBGL,md:_emscripten_glDrawElements,ie:_emscripten_glDrawElementsInstancedANGLE,hf:_emscripten_glDrawRangeElements,ld:_emscripten_glEnable,gf:_emscripten_glEnableClientState,kd:_emscripten_glEnableVertexAttribArray,Mf:_emscripten_glEnd,ce:_emscripten_glEndQueryEXT,jd:_emscripten_glFinish,id:_emscripten_glFlush,gd:_emscripten_glFramebufferRenderbuffer,fd:_emscripten_glFramebufferTexture2D,ed:_emscripten_glFrontFace,Oe:_emscripten_glFrustum,dd:_emscripten_glGenBuffers,bd:_emscripten_glGenFramebuffers,ge:_emscripten_glGenQueriesEXT,ad:_emscripten_glGenRenderbuffers,$c:_emscripten_glGenTextures,me:_emscripten_glGenVertexArraysOES,cd:_emscripten_glGenerateMipmap,_c:_emscripten_glGetActiveAttrib,Zc:_emscripten_glGetActiveUniform,Xc:_emscripten_glGetAttachedShaders,Wc:_emscripten_glGetAttribLocation,Vc:_emscripten_glGetBooleanv,Uc:_emscripten_glGetBufferParameteriv,Tc:_emscripten_glGetError,Sc:_emscripten_glGetFloatv,Rc:_emscripten_glGetFramebufferAttachmentParameteriv,Qf:_emscripten_glGetInfoLog,Qc:_emscripten_glGetIntegerv,Rf:_emscripten_glGetObjectParameteriv,Of:_emscripten_glGetPointerv,Oc:_emscripten_glGetProgramInfoLog,Pc:_emscripten_glGetProgramiv,Zd:_emscripten_glGetQueryObjecti64vEXT,$d:_emscripten_glGetQueryObjectivEXT,Yd:_emscripten_glGetQueryObjectui64vEXT,_d:_emscripten_glGetQueryObjectuivEXT,ae:_emscripten_glGetQueryivEXT,Nc:_emscripten_glGetRenderbufferParameteriv,Lc:_emscripten_glGetShaderInfoLog,Kc:_emscripten_glGetShaderPrecisionFormat,Jc:_emscripten_glGetShaderSource,Mc:_emscripten_glGetShaderiv,Ic:_emscripten_glGetString,ye:_emscripten_glGetTexEnvfv,xe:_emscripten_glGetTexEnviv,qe:_emscripten_glGetTexLevelParameteriv,Hc:_emscripten_glGetTexParameterfv,Gc:_emscripten_glGetTexParameteriv,Dc:_emscripten_glGetUniformLocation,Fc:_emscripten_glGetUniformfv,Ec:_emscripten_glGetUniformiv,Ac:_emscripten_glGetVertexAttribPointerv,Cc:_emscripten_glGetVertexAttribfv,Bc:_emscripten_glGetVertexAttribiv,zc:_emscripten_glHint,yc:_emscripten_glIsBuffer,xc:_emscripten_glIsEnabled,wc:_emscripten_glIsFramebuffer,vc:_emscripten_glIsProgram,ee:_emscripten_glIsQueryEXT,uc:_emscripten_glIsRenderbuffer,tc:_emscripten_glIsShader,sc:_emscripten_glIsTexture,le:_emscripten_glIsVertexArrayOES,De:_emscripten_glLightModelf,Ce:_emscripten_glLightModelfv,Ee:_emscripten_glLightfv,rc:_emscripten_glLineWidth,qc:_emscripten_glLinkProgram,Ye:_emscripten_glLoadIdentity,Xe:_emscripten_glLoadMatrixd,We:_emscripten_glLoadMatrixf,Ue:_emscripten_glLoadTransposeMatrixd,Ve:_emscripten_glLoadTransposeMatrixf,Be:_emscripten_glMaterialfv,$e:_emscripten_glMatrixMode,Re:_emscripten_glMultMatrixd,Qe:_emscripten_glMultMatrixf,Se:_emscripten_glMultTransposeMatrixd,Te:_emscripten_glMultTransposeMatrixf,jf:_emscripten_glNormal3f,df:_emscripten_glNormalPointer,Pe:_emscripten_glOrtho,pc:_emscripten_glPixelStorei,lf:_emscripten_glPolygonMode,mb:_emscripten_glPolygonModeWEBGL,oc:_emscripten_glPolygonOffset,ob:_emscripten_glPolygonOffsetClampEXT,Ze:_emscripten_glPopMatrix,_e:_emscripten_glPushMatrix,be:_emscripten_glQueryCounterEXT,Fe:_emscripten_glReadBuffer,nc:_emscripten_glReadPixels,mc:_emscripten_glReleaseShaderCompiler,lc:_emscripten_glRenderbufferStorage,Ne:_emscripten_glRotated,Me:_emscripten_glRotatef,kc:_emscripten_glSampleCoverage,Le:_emscripten_glScaled,Ke:_emscripten_glScalef,ic:_emscripten_glScissor,pe:_emscripten_glShadeModel,hc:_emscripten_glShaderBinary,gc:_emscripten_glShaderSource,fc:_emscripten_glStencilFunc,ec:_emscripten_glStencilFuncSeparate,dc:_emscripten_glStencilMask,cc:_emscripten_glStencilMaskSeparate,bc:_emscripten_glStencilOp,ac:_emscripten_glStencilOpSeparate,ve:_emscripten_glTexCoord2f,re:_emscripten_glTexCoord2fv,ue:_emscripten_glTexCoord2i,te:_emscripten_glTexCoord3f,se:_emscripten_glTexCoord4f,bf:_emscripten_glTexCoordPointer,ze:_emscripten_glTexGenfv,Ae:_emscripten_glTexGeni,we:_emscripten_glTexImage1D,$b:_emscripten_glTexImage2D,Zb:_emscripten_glTexParameterf,Yb:_emscripten_glTexParameterfv,Xb:_emscripten_glTexParameteri,Wb:_emscripten_glTexParameteriv,Vb:_emscripten_glTexSubImage2D,Je:_emscripten_glTranslated,Ie:_emscripten_glTranslatef,Ub:_emscripten_glUniform1f,Tb:_emscripten_glUniform1fv,Sb:_emscripten_glUniform1i,Rb:_emscripten_glUniform1iv,Qb:_emscripten_glUniform2f,Pb:_emscripten_glUniform2fv,Ob:_emscripten_glUniform2i,Nb:_emscripten_glUniform2iv,Mb:_emscripten_glUniform3f,Lb:_emscripten_glUniform3fv,Kb:_emscripten_glUniform3i,Jb:_emscripten_glUniform3iv,Ib:_emscripten_glUniform4f,Hb:_emscripten_glUniform4fv,Gb:_emscripten_glUniform4i,Eb:_emscripten_glUniform4iv,Db:_emscripten_glUniformMatrix2fv,Cb:_emscripten_glUniformMatrix3fv,Bb:_emscripten_glUniformMatrix4fv,Wf:_emscripten_glUseProgram,Ab:_emscripten_glValidateProgram,Lf:_emscripten_glVertex2f,Ef:_emscripten_glVertex2fv,Kf:_emscripten_glVertex2i,Jf:_emscripten_glVertex3f,Df:_emscripten_glVertex3fv,If:_emscripten_glVertex3i,Hf:_emscripten_glVertex4f,Cf:_emscripten_glVertex4fv,Gf:_emscripten_glVertex4i,zb:_emscripten_glVertexAttrib1f,yb:_emscripten_glVertexAttrib1fv,xb:_emscripten_glVertexAttrib2f,wb:_emscripten_glVertexAttrib2fv,vb:_emscripten_glVertexAttrib3f,tb:_emscripten_glVertexAttrib3fv,sb:_emscripten_glVertexAttrib4f,rb:_emscripten_glVertexAttrib4fv,he:_emscripten_glVertexAttribDivisorANGLE,qb:_emscripten_glVertexAttribPointer,ef:_emscripten_glVertexPointer,pb:_emscripten_glViewport,E:_emscripten_has_asyncify,Zf:_emscripten_request_fullscreen_strategy,ca:_emscripten_request_pointerlock,Ya:_emscripten_resize_heap,ha:_emscripten_sample_gamepad_data,L:_emscripten_set_beforeunload_callback_on_thread,X:_emscripten_set_blur_callback_on_thread,u:_emscripten_set_canvas_element_size,Sa:_emscripten_set_devicemotion_callback_on_thread,Ta:_emscripten_set_deviceorientation_callback_on_thread,C:_emscripten_set_element_css_size,Y:_emscripten_set_focus_callback_on_thread,O:_emscripten_set_fullscreenchange_callback_on_thread,fa:_emscripten_set_gamepadconnected_callback_on_thread,ea:_emscripten_set_gamepaddisconnected_callback_on_thread,R:_emscripten_set_keydown_callback_on_thread,P:_emscripten_set_keypress_callback_on_thread,Q:_emscripten_set_keyup_callback_on_thread,Ra:_emscripten_set_main_loop,G:_emscripten_set_mousedown_callback_on_thread,$:_emscripten_set_mouseenter_callback_on_thread,_:_emscripten_set_mouseleave_callback_on_thread,ba:_emscripten_set_mousemove_callback_on_thread,aa:_emscripten_set_mouseup_callback_on_thread,S:_emscripten_set_pointerlockchange_callback_on_thread,N:_emscripten_set_resize_callback_on_thread,T:_emscripten_set_touchcancel_callback_on_thread,V:_emscripten_set_touchend_callback_on_thread,U:_emscripten_set_touchmove_callback_on_thread,W:_emscripten_set_touchstart_callback_on_thread,M:_emscripten_set_visibilitychange_callback_on_thread,Z:_emscripten_set_wheel_callback_on_thread,va:_emscripten_set_window_title,D:_emscripten_sleep,cb:_environ_get,db:_environ_sizes_get,F:_exit,w:_fd_close,pa:_fd_read,Va:_fd_seek,oa:_fd_write,t:_glBindTexture,H:_glBlendFunc,_b:_glClear,jc:_glClearColor,o:_glColorPointer,sa:_glDeleteTextures,i:_glDisable,ka:_glDisableClientState,l:_glDrawArrays,s:_glEnable,j:_glEnableClientState,K:_glGenTextures,qa:_glLoadIdentity,Fb:_glLoadMatrixf,I:_glMatrixMode,hd:_glOrtho,ub:_glReadPixels,x:_glTexCoordPointer,J:_glTexImage2D,B:_glTexParameteri,ra:_glTexSubImage2D,k:_glVertexPointer,Yc:_glViewport,z:invoke_i,h:invoke_ii,c:invoke_iii,ia:invoke_iiii,n:invoke_v,g:invoke_vi,A:invoke_vii,ta:invoke_viii,ua:_llvm_eh_typeid_for};var wasmExports;createWasm();var ___wasm_call_ctors=()=>(___wasm_call_ctors=wasmExports["$f"])();var _free=Module["_free"]=a0=>(_free=Module["_free"]=wasmExports["bg"])(a0);var _malloc=Module["_malloc"]=a0=>(_malloc=Module["_malloc"]=wasmExports["cg"])(a0);var _hsp3dish_sync_done=Module["_hsp3dish_sync_done"]=()=>(_hsp3dish_sync_done=Module["_hsp3dish_sync_done"]=wasmExports["dg"])();var _main=Module["_main"]=(a0,a1)=>(_main=Module["_main"]=wasmExports["eg"])(a0,a1);var _setThrew=(a0,a1)=>(_setThrew=wasmExports["fg"])(a0,a1);var __emscripten_tempret_set=a0=>(__emscripten_tempret_set=wasmExports["gg"])(a0);var __emscripten_stack_restore=a0=>(__emscripten_stack_restore=wasmExports["hg"])(a0);var __emscripten_stack_alloc=a0=>(__emscripten_stack_alloc=wasmExports["ig"])(a0);var _emscripten_stack_get_current=()=>(_emscripten_stack_get_current=wasmExports["jg"])();var ___cxa_increment_exception_refcount=a0=>(___cxa_increment_exception_refcount=wasmExports["kg"])(a0);var ___cxa_decrement_exception_refcount=a0=>(___cxa_decrement_exception_refcount=wasmExports["lg"])(a0);var ___cxa_can_catch=(a0,a1,a2)=>(___cxa_can_catch=wasmExports["mg"])(a0,a1,a2);var ___cxa_get_exception_ptr=a0=>(___cxa_get_exception_ptr=wasmExports["ng"])(a0);var dynCall_ji=Module["dynCall_ji"]=(a0,a1)=>(dynCall_ji=Module["dynCall_ji"]=wasmExports["og"])(a0,a1);var dynCall_jiji=Module["dynCall_jiji"]=(a0,a1,a2,a3,a4)=>(dynCall_jiji=Module["dynCall_jiji"]=wasmExports["pg"])(a0,a1,a2,a3,a4);var dynCall_iiji=Module["dynCall_iiji"]=(a0,a1,a2,a3,a4)=>(dynCall_iiji=Module["dynCall_iiji"]=wasmExports["qg"])(a0,a1,a2,a3,a4);var dynCall_jij=Module["dynCall_jij"]=(a0,a1,a2,a3)=>(dynCall_jij=Module["dynCall_jij"]=wasmExports["rg"])(a0,a1,a2,a3);var dynCall_iij=Module["dynCall_iij"]=(a0,a1,a2,a3)=>(dynCall_iij=Module["dynCall_iij"]=wasmExports["sg"])(a0,a1,a2,a3);function invoke_ii(index,a1){var sp=stackSave();try{return getWasmTableEntry(index)(a1)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_vi(index,a1){var sp=stackSave();try{getWasmTableEntry(index)(a1)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_v(index){var sp=stackSave();try{getWasmTableEntry(index)()}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_vii(index,a1,a2){var sp=stackSave();try{getWasmTableEntry(index)(a1,a2)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_iii(index,a1,a2){var sp=stackSave();try{return getWasmTableEntry(index)(a1,a2)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_i(index){var sp=stackSave();try{return getWasmTableEntry(index)()}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_viii(index,a1,a2,a3){var sp=stackSave();try{getWasmTableEntry(index)(a1,a2,a3)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}function invoke_iiii(index,a1,a2,a3){var sp=stackSave();try{return getWasmTableEntry(index)(a1,a2,a3)}catch(e){stackRestore(sp);if(e!==e+0)throw e;_setThrew(1,0)}}Module["addRunDependency"]=addRunDependency;Module["removeRunDependency"]=removeRunDependency;Module["ccall"]=ccall;Module["cwrap"]=cwrap;Module["FS_createPreloadedFile"]=FS_createPreloadedFile;Module["FS_createPath"]=FS_createPath;var calledRun;dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function callMain(args=[]){var entryFunction=_main;args.unshift(thisProgram);var argc=args.length;var argv=stackAlloc((argc+1)*4);var argv_ptr=argv;args.forEach(arg=>{HEAPU32[argv_ptr>>2]=stringToUTF8OnStack(arg);argv_ptr+=4});HEAPU32[argv_ptr>>2]=0;try{var ret=entryFunction(argc,argv);exitJS(ret,true);return ret}catch(e){return handleException(e)}}function run(args=arguments_){if(runDependencies>0){return}preRun();if(runDependencies>0){return}function doRun(){if(calledRun)return;calledRun=true;Module["calledRun"]=true;if(ABORT)return;initRuntime();preMain();Module["onRuntimeInitialized"]?.();if(shouldRunNow)callMain(args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout(()=>{setTimeout(()=>Module["setStatus"](""),1);doRun()},1)}else{doRun()}}if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"])shouldRunNow=false;run();
