#ifndef __MOD_HSP3UPDATE
#define __MOD_HSP3UPDATE

;HSP3 update Module

#include "mod_appconfig.as"

#uselib "kernel32"
#cfunc GetUserDefaultUILanguage "GetUserDefaultUILanguage"

#uselib "wininet.dll"
#func DeleteUrlCacheEntry "DeleteUrlCacheEntryA" str

#define STRMAP_EN "en.strmap"

goto *_end_mod_hsp3update

//---------------------------------------------------------

#define INIFILE "hsp3update.ini"
#define APPNAME "HSP3 Update"
#define APPNAME2 "HSP3 MakeUpdate"
#define PLATFORM "win32"
#define HSPUPD "index.hspupd"
#define EXT_HSPUPD ".hspupd"
#define EXT_FILELIST ".txt"
#define HSPINSTALL "install.ini"
#define HSPURL "https://www.onionsoft.net/hsp/update/"
#define HSPFLIST "flist.txt"
#define HSPINDEX "index.hspupd"
#define SELFEXE "hsp3upd.exe"
#define SELFAX "hsp3upd_main.ax"
#define HSP3EXE "hsp3.exe"
#define HSPPKGDIR "package"

#deffunc hsp3update_init

	;	Avݒ̏(N)
	;
	langset=0

	langid = GetUserDefaultUILanguage()
	if langid!=$411 : langset=1
	;if langset : strexchange STRMAP_EN

	sdim s1,256
	sdim s2,256
	sdim s3,256
	sdim fname,256
	sdim uuid,256
	sdim hspbase_dir,256
	sdim hsppkg_dir, 256
	sdim confpath, 256
	sdim confdir, 256
	sdim flist,$1000			; t@CnbV(s)
	sdim flistnew,$1000			; t@CnbV(ŐV)
	sdim installbuf,$1000
	sdim addurl,$1000
	sdim idxbuf,$1000
	sdim idxdiv,$1000
	sdim allfiles,$1000
	sdim owrfiles,512
	sdim name_prevopen,256

	def_nlicense=0
	sdim def_seedid, 64
	sdim def_author, 64
	sdim def_license, $1000
	sdim def_linkurl, 256
	sdim def_pubdir, 256

	instflag=0

	sdim basetype,$1000
	basetype={"vOCEVXe
vOCE摜
vOCETEh
vOCȆ
W[EVXe
W[E摜
W[ETEh
W[Ȇ
c[EVXe
c[E摜
c[ETEh
c[Ȇ
fށE摜
fށETEh
fށȆ
TvXNvgEVXe
TvXNvgE摜
TvXNvgETEh
TvXNvgEQ[
TvXNvgȆ
Tvf[^
̑f[^"}

	cfg_init INIFILE,""
	cfg_load:modcfg=stat

	addurl_num=0

	if modcfg {	; init@Cǂݍ
		hspbase_dir=cfg_getvar("hspbase_dir")
		uuid=cfg_getvar("uuid")
		addurl_num=0+cfg_getvar("addurl_num")
		repeat addurl_num
			s1=cfg_getvar("addurl"+cnt)
			addurl+=s1+"\n"
		loop
		def_nlicense=0+cfg_getvar("def_nlicense")
		repeat def_nlicense
			s1=cfg_getvar("def_license"+cnt)
			def_license+=s1+"\n"
		loop
		def_author=cfg_getvar("def_author")
		def_seedid=cfg_getvar("def_seedid")
		def_linkurl=cfg_getvar("def_linkurl")
		def_pubdir=cfg_getvar("def_pubdir")

		dirlist s2,hspbase_dir,5
		if stat=0 : hspbase_dir=""	; ȑÕtH_Ȃꍇ
	}

	if hspbase_dir="" {
#ifdef _DEBUG
			hspbase_dir=dir_exe
#else
			s1=dir_cmdline
			if peek(s1,0)=$22 {
				s1=strmid(s1,1,strlen(s1)-2)
			}
			hspbase_dir=s1
#endif
	}

	if uuid="" {
		uuid = strf("%04d%02d%02d%02d%02d%02d",gettime(0),gettime(1),gettime(3),gettime(4),gettime(5),gettime(6))
	}

	cfg_getpath confpath
	confpath=getpath(confpath,32+16)
	confdir=strmid(confpath,0,strlen(confpath)-1)

	fname=hspbase_dir+"/"+HSPFLIST
	exist fname
	if strsize>0 {
		notesel flist
		noteload fname
	}
	fname=hspbase_dir+"/"+HSPINSTALL
	exist fname
	if strsize>0 {
		notesel idxbuf
		noteload fname
		installbuf=""
		repeat notemax
			noteget s1,cnt
			if s1!="" : installbuf+=s1+"\n"
		loop
		instflag=1
	}

	s1=hspbase_dir+"/"+HSPPKGDIR
	hsppkg_dir=s1+"/"
	dirlist s2,s1,5
	if stat=0 {
		mkdir s1
	}
	return

#deffunc hsp3update_term

	;	Avݒ̕ۑ(I)
	;
	cfg_init INIFILE,""
	cfg_sets "hspbase_dir",hspbase_dir
	cfg_sets "uuid",uuid
	notesel addurl
	addurl_num = notemax
	cfg_seti "addurl_num",addurl_num
	repeat addurl_num
		noteget s1,cnt
		cfg_sets "addurl"+cnt,s1
	loop
	notesel def_license
	def_nlicense = notemax
	cfg_seti "def_nlicense",def_nlicense
	repeat def_nlicense
		noteget s1,cnt
		cfg_sets "def_license"+cnt,s1
	loop
	cfg_sets "def_author",def_author
	cfg_sets "def_seedid",def_seedid
	cfg_sets "def_linkurl",def_linkurl
	cfg_sets "def_pubdir",def_pubdir

	cfg_save

	return

#deffunc hsp3update_addhash str p1, local _s1, local _s2

	;	flistnew(ŐV)̃Gg[ǉ
	;	(ufilename:sha256v`ŏ㏑Ȃ)
	;
	_s1=p1
	i=instr(_s1,0,":")
	if i<=0 : return
	_s2=strmid(_s1,0,i+1)
	notesel flistnew
	i=notefind(_s2,notefind_first)
	if i<0 {
		flistnew+=_s1+"\n"
		return
	}
	return 0


#deffunc hsp3update_gethash str p1, local _s1, local _s2, local _i1

	;	nbṼGg[擾
	;	(p1=filename / s1ɌÂsha256As2ɐVsha256 )
	;
	s1="":s2=""
	if p1="" : return 0
	_s1=p1+":"
	notesel flistnew
	i=notefind(_s1,notefind_first)
	if i>=0 {
		noteget _s2,i
		_i1=instr(_s2,0,":")
		if _i1>0 : s2=strmid(_s2,_i1+1,128)
	}
	if s2="" {
		dialog "No Hash:"+p1
	}
	notesel flist
	i=notefind(_s1,notefind_first)
	if i>=0 {
		noteget _s2,i
		_i1=instr(_s2,0,":")
		if _i1>0 : s1=strmid(_s2,_i1+1,128)
	}
	return 0


#deffunc hsp3update_sethash var p1, local _i1, local _i2, local _s1

	;	flistnew(ŐV)̃Gg[XV
	;	(p1̃obt@Ɋ܂܂%sha256Ggǉ)
	;
	if p1="" : return 0
	notesel p1
	_i1=notemax
	_i2=notefind("%sha256",notefind_first)
	if _i2<0 : return 1
	repeat
		_i2++:if _i2>=_i1 : break
		notesel p1
		noteget _s1,_i2
		if _s1="" : break
		hsp3update_addhash _s1
	loop
	return 0


#deffunc hsp3update_hashupd str p1

	;	flist̃t@CnbVŐVɍXV
	;	( p1̃t@CXV )
	;	( flistnew(ŐV)̃Gg[ flist(Rs[ς)ɃRs[  )
	;
	if p1="" : return 0
	hsp3update_gethash p1
	if s1="" {
		flist+=p1+":"+s2+"\n"		; nbVȂꍇ͒ǋL
		return 1
	}
	if s1=s2 : return 0				; nbVXV̕KvȂ
	notesel flist
	s1=p1+":"+s2
	noteadd s1,i,1					; nbVXV
	return 1


#deffunc hsp3update_idxupd str p1, local _s1

	;	index.hspupd̃CfbNXŐVɍXV
	;	( p1IDXV )
	;
	_s1=hsppkg_dir+p1+EXT_HSPUPD
	exist _s1
	if strsize>0 : delete _s1		; CfbNXLbV폜
	return 0


#defcfunc hsp3update_gettypeid str p1

	;	basetype̕񂩂ID𓾂
	;
	notesel basetype
	return notefind(p1,0)


#deffunc hsp3update_addfiles str p1, local _s1, local _s2

	;	CXg[ς݃t@CXgXV
	;	( p1IDXV )
	;
	_s1=hsppkg_dir+p1+EXT_FILELIST
	exist _s1
	if strsize>0 {
		notesel _s2
		noteload _s1
		allfiles+=_s2
	}
	return 0


#deffunc hsp3update_chkfiles str p1, local _s1, local _s2, local _max

	;	CXg[ς݃t@CXgɂ邩ׂ
	;	( p1ID owrfiles Ƀt@CXg )
	;
	owrfiles=""
	_s1=hsppkg_dir+p1+EXT_FILELIST
	exist _s1
	if strsize>0 {
		notesel _s2
		noteload _s1
		_max = notemax
		repeat _max
			notesel _s2
			noteget _s1,cnt
			notesel allfiles
			if notefind(_s1,0)>=0 : owrfiles+=_s1+"\n"
		loop
	}
	return 0


#deffunc hsp3update_index

	;	CfbNX쐬
	;
	sdim index_data,$1000
	sdim allfiles,$1000
	hspinst = 0

	sdim st_install,4,64
	if langset {
		st_install(1)="Install"
		st_install(2)="Delete"
		st_install(3)="Installed"
	} else {
		st_install(1)="CXg["
		st_install(2)="폜"
		st_install(3)="CXg[ς"
	}

	notesel idxbuf
	cfg_loadvar idxbuf				; idxbufɃCINDEXĂ
	if stat=0 : return 1

	id_start = cfg_getindex()
	id_master = id_start

	;	O[o쐬
	sdim g_platform,256
	sdim g_date,256
	sdim g_note,256
	sdim g_link,256
	sdim g_latest,256
	sdim g_stable,256
	cfg_searchidx g_platform,"platform"
	cfg_searchidx g_date,"date"
	cfg_searchidx g_note,"note"
	cfg_searchidx g_link,"link"
	cfg_searchidx g_latest,"latest"
	cfg_searchidx g_stable,"stable"

	g_info  = "Platform : " + g_platform + "\n"
	g_info += "Date : " + g_date + "\n"
	g_info += "Link : " + g_link + "\n"
	g_info += "Latest : " + g_latest + "\n"
	g_info += "Stable : " + g_stable + "\n"
	g_info += "Note :\n" + g_note + "\n"

	;	pbP[WXg쐬
	sdim base_id,$1000
	sdim base_group,$1000
	sdim base_package,$1000

	sdim list_id,$1000
	sdim list_package,$1000
	sdim list_ref,$1000
	sdim list_uninstall,$1000
	dim list_active,256
	dim list_update,256

	sdim addon_id,$1000
	sdim addon_package,$1000
	sdim addon_base,$1000
	dim addon_active,256
	dim addon_update,256
	dim addon_user,256
	dim addon_type,256

	base_max=0
	list_max=0
	addon_max=0

	sdim s1,256
	sdim s2,256
	sdim name_id,256
	sdim cur_package,256
	sdim cur_group,256

	base_sel=-1
	list_sel=-1
	addon_sel=-1

	userpkgid=-1
	gosub *mkdividx

	id_start = id_master

*mkpackage
	cfg_searchidx name_id,"index",id_start
	if name_id!="" {
		id_start = cfg_getindex()

		sdim name_group,256
		sdim name_base,256
		sdim name_href,256
		sdim name_type,256
		sdim name_filename,256
		sdim name_uninstall,256

		cfg_searchidx name_group,"group",id_start,1
		cfg_searchidx name_base,"base",id_start,1
		cfg_searchidx name_href,"href",id_start,1
		cfg_searchidx name_type,"type",id_start,1
		cfg_searchidx name_uninstall,"uninstall",id_start,1

		notesel name_id
		noteget s1,0
		noteget s2,1
		name_filename = s1+".zip"

		if name_href="*" {		; href*̏ꍇ̓x[XpbP[W
			base_id+=s1+"\n"
			base_group+=name_group+"\n"
			if installbuf!="" {	; CXg[Ă邩?
				notesel installbuf
				i=notefind(s1,0)
				if i>=0 {
					base_sel=base_max
					cur_package = s2
					;s2+=" ("+st_install(3)+")"
					hsp3update_addfiles s1
				}
			}
			base_package+=s2+"\n"
			base_max++
			goto *mkpackage
		}
		if name_group="addon" {	; groupaddon̏ꍇ̓AhI
			addon_id+=s1+"\n"
			addon_package+=s2+"\n"
			addon_base+=name_base+"\n"
			if installbuf!="" {	; CXg[Ă邩?
				notesel installbuf
				i=notefind(s1,0)
				if i>=0 {
					addon_active(addon_max)=3
					hsp3update_addfiles s1
					hsp3update_gethash name_filename
					if s1!="" {
						if s1!=s2 : addon_update(addon_max)=1
					}
				}
			}
			addon_type(addon_max)=hsp3update_gettypeid(name_type)
			addon_user(addon_max)=-1
			addon_max++
			goto *mkpackage
		}
		;	ʏpbP[W
		list_id+=s1+"\n"
		list_package+=s2+"\n"
		list_ref+=name_href+"\n"
		list_uninstall+=name_uninstall+"\n"
		;dialog ""+s1+":"+id_start+"\n"+name_group+"\n"+name_href+"\n"+name_base
		if installbuf!="" {	; CXg[Ă邩?
			notesel installbuf
			i=notefind(s1,0)
			if i>=0 {
					list_active(list_max)=3
					hsp3update_addfiles s1
					hsp3update_gethash name_filename
					if s1!="" {
						if s1!=s2 : list_update(list_max)=1
					}
			}
		}
		list_max++
		goto *mkpackage
	}

	if cur_package!="" : hspinst = 1

	;	[U[pbP[W
	;
	sdim user_addon_index,$1000
	sdim user_addon_url,$1000
	sdim pkgerror,256
	notesel addurl
	addurl_num = notemax
	repeat addurl_num
		userpkgid=cnt
		notesel addurl
		noteget fname,userpkgid
		gosub *get_userpackage
		if pkgerror!="" {
			dialog pkgerror
		}
	loop

	;	SCXg[t@C̗
	;
	sdim nkfbuf,$10000
	notesel allfiles
	repeat notemax
		noteget s1,cnt
		nkfcnv s2,s1,"W"	; UTF8SJISɕϊ
		nkfbuf+=s2+"\n"
	loop
	;notesel nkfbuf
	;notesave hspbase_dir+"\\WOW.txt"
	allfiles = nkfbuf
	sdim nkfbuf,64

	return 0

*get_userpackage

	s3=fname
	i=0
	pkgerror=""
	pkgurl=""
	repeat
		getstr s1,s3,i,'/',64
		if strsize=0 : break
		i+=strsize
		if peek(s3,i)=0 {
			fname=s1
		} else {
			pkgurl+=s1+"/"
		}
	loop
	pkgname=getpath(fname,1)

	hsp3update_getusrfile fname, pkgurl
	if stat : pkgerror="[U[pbP[W_E[hł܂["+pkgname+"]" : return

	rfname=PLATFORM+"/"+fname

	sdim idxbufusr,$1000
	notesel idxbufusr
	exist rfname
	if strsize<0 : pkgerror="t@C܂["+rfname+"]" : return
	noteload rfname

	user_addon_index+=fname+"\n"
	user_addon_url+=pkgurl+"\n"

	hsp3update_sethash idxbufusr

	cfg_loadvar idxbufusr
	if stat=0 {
		pkgerror="ȃ[U[pbP[Wł["+pkgname+"]"
		return
	}

	s1=""
	cfg_searchidx s1,"platform"
	if s1!=PLATFORM {
		pkgerror="ȃ[U[pbP[Wł["+pkgname+"]"
		return
	}

	id_start = cfg_getindex()
	id_master_usr = id_start

	gosub *mkdividx
	id_start = id_master_usr

*mk_userpackage
	cfg_searchidx name_id,"index",id_start
	if name_id!="" {
		id_start = cfg_getindex()

		sdim name_group,256
		sdim name_base,256
		sdim name_href,256
		sdim name_type,256

		cfg_searchidx name_group,"group",id_start,1
		cfg_searchidx name_href,"href",id_start,1
		cfg_searchidx name_base,"base",id_start,1
		cfg_searchidx name_type,"type",id_start,1

		if name_group!="addon" {
			pkgerror="[U[pbP[WŎgpłȂO[v["+name_group+"/"+name_id+"]"
			return
		}

		; groupaddon̏ꍇ̓AhI
		notesel name_id
		noteget s1,0 : addon_id+=s1+"\n"
		noteget s2,1 : addon_package+="*"+s2+"\n"
		name_filename = s1+".zip"
		addon_base+=name_base+"\n"
		if installbuf!="" {	; CXg[Ă邩?
			notesel installbuf
			i=notefind(s1,0)
			if i>=0 {
					addon_active(addon_max)=3
					hsp3update_addfiles s1
					hsp3update_gethash name_filename
					if s1!="" {
						if s1!=s2 : addon_update(addon_max)=1
					}
			}
		}
		addon_type(addon_max)=hsp3update_gettypeid(name_type)
		addon_user(addon_max)=userpkgid
		addon_max++
		goto *mk_userpackage
	}
	return


*mkdividx
	;	indext@C쐬
	;
	cfg_searchidx name_id,"index",id_start
*mkdividx_lp
	if name_id!="" {
		id_start = cfg_getindex()
		getstr s1,name_id,0,0
		s2=hsppkg_dir+s1+EXT_HSPUPD

		cfg_searchidx s1,"index",id_start
		id_end = cfg_getindex()-3
		if s1="" : id_end = notemax
		name_id=s1

		exist s2
		if strsize<0 {
			idxdiv=""
			if userpkgid<0 {
				notesel idxbuf
			} else {
				notesel idxbufusr
			}
			i=id_start-3
			repeat
				if i>=id_end : break
				noteget s1,i
				idxdiv+=s1+"\n"
				i++
			loop
			notesel idxdiv
			notesave s2
		}
		goto *mkdividx_lp
	}
	return


#deffunc hsp3update_curlist int _p1, int _p2

	;	JgXgXV
	;	p1 = bit0:install̂ bit1:wtypê
	;	p2 = typeID
	;
	plist_max=0
	paddon_max=0
	sdim curbase,256
	sdim curgroup,256

	;I\ȃXg(pbP[W)
	sdim plist_package,$1000
	dim plist_ref,list_max

	;I\ȃXg(AhI)
	sdim paddon_package,$1000
	dim paddon_ref,addon_max

	if base_sel<0 : return 1
	notesel base_id
	noteget curbase, base_sel
	notesel base_group
	noteget curgroup, base_sel

	repeat list_max
		notesel list_ref
		noteget s1,cnt
		if s1=curbase {
			notesel list_package
			noteget s1,cnt
			if list_active(cnt) : s1+=" ("+st_install(list_active(cnt))+")"
			if list_update(cnt)=1 : s1+=" (Update)"
			plist_package += s1+"\n"
			plist_ref(plist_max)=cnt
			plist_max++
		}
	loop

	repeat addon_max
		notesel addon_base
		noteget s1,cnt
		if instr(s1,0,curgroup)>=0 {
			notesel addon_package
			noteget s1,cnt
			addflag=1
			if _p1&1 {			; CXg[ς݈ȊO𖳌ɂ
				if (addon_active(cnt)&2)=0 : addflag=0
			}
			if _p1&2 {			; w^CvȊO𖳌ɂ
				;dialog "["+addon_type(cnt)+"]("+cnt+")"+s1+"/"+_p2
				if addon_type(cnt)!=_p2 : addflag=0
			}
			if addflag {
				if addon_active(cnt) : s1+=" ("+st_install(addon_active(cnt))+")"
				if addon_update(cnt)=1 : s1+=" (Update)"
				paddon_package += s1+"\n"
				paddon_ref(paddon_max)=cnt
				paddon_max++
			}
		}
	loop


	return 0

#deffunc hsp3update_selectindex int p1, int p2

	;	IꂽpbP[W擾
	;	(p1=ID / p2=0:default 1:addon 2:new info )
	;
	index_data=""
	pkgid=-1
	sdim name_selid, 256
	if (p2&1)=0 {
		i=plist_ref(p1)
		notesel list_id
		noteget name_selid,i
	} else {
		i=paddon_ref(p1)
		notesel addon_id
		noteget name_selid,i
		pkgid=addon_user(i)
	}

	if pkgid<0 {
		notesel idxbuf
		cfg_loadvar idxbuf
		id_start = id_master
	} else {
		notesel user_addon_index
		noteget s1,pkgid
		sdim idxbufusr,$1000
		notesel idxbufusr
		s1=PLATFORM+"/"+s1
		exist s1
		if strsize>0 : noteload s1
		cfg_loadvar idxbufusr
		id_start = cfg_getindex()
	}

	if p2&2 : goto *pkgsel

	;	hspupdLbV擾
	;
	sdim idxdiv,$1000
	notesel idxdiv
	s2=hsppkg_dir+name_selid+EXT_HSPUPD
	exist s2
	if strsize<=0 {		; hspupdLbVȂꍇ͍ŐVindex擾
		if pkgid<0 {
			cfg_loadvar idxbuf
		} else {
			cfg_loadvar idxbufusr
		}
		goto *pkgsel
	}
	noteload s2
	cfg_loadvar idxdiv
	id_start = cfg_getindex()

*pkgsel
	cfg_searchidx name_id,"index",id_start
	if name_id="" : index_data="No package." : return 1

	id_start = cfg_getindex()
	notesel name_id
	noteget s1,0
	noteget s2,1
	if s1!=name_selid : goto *pkgsel

	index_data=s2+"\n"

	sdim name_last,256
	sdim name_inst,256
	sdim name_base,256
	sdim name_url,256
	sdim name_type,256
	sdim name_author,256
	sdim name_open,256
	sdim name_license,256
	sdim name_uninstall,256

	gosub *getpkginfo

	if name_open!="" {
		name_open=hspbase_dir+"/"+name_open
		exist name_open
		if strsize<0 : name_open=""
	}

	index_data+="Author  : "+name_author + "\n"
	if name_last!="" : index_data+="Date : "+name_last + "\n"
	index_data+=name_inst + "\n\n"
	if name_url!="" : index_data+="URL : "+name_url + "\n"
	if name_open!="" : index_data+="Manual : "+name_open + "\n"
	if name_type!="" : index_data+="Type : "+name_type + "\n"
	if p2!=0 {
		if name_base!="" : index_data+="System : "+name_base + "\n"
	}
	return 0

*getpkginfo
	cfg_searchidx name_last,"last",id_start,1
	cfg_searchidx name_inst,"inst",id_start,1

	cfg_searchidx name_base,"base",id_start,1
	cfg_searchidx name_url,"url",id_start,1
	cfg_searchidx name_author,"author",id_start,1
	cfg_searchidx name_open,"open",id_start,1
	cfg_searchidx name_license,"license",id_start,1
	cfg_searchidx name_uninstall,"uninstall",id_start,1
	cfg_searchidx name_type,"type",id_start,1

	return


#deffunc hsp3update_install_init

	;	CXg[񏉊
	sdim installnew,$1000		; VKCXg[ID
	sdim installnewexp,$1000	; VKCXg[^Cg
	sdim installnewurl,$1000	; VKCXg[URL
	sdim installdel,$1000		; 폜ID (CXg[ς݊܂)
	sdim installdelexp,$1000	; 폜^Cg (폜^Cĝ)
	sdim installfix,$1000		; CID (ACXg[̏C)
	sdim installfixurl,$1000	; CCXg[URL
	dim installupdate,128
	installcnt=0
	return


#deffunc hsp3update_install_adddel str p1, str p2, local _s1

	;	CXg[폜ǉ
	;	(p1=ID/p2=^Cg)
	;
	_s1=p1
	if _s1!="" : installdel+=_s1+"\n"
	_s1=p2
	if _s1!="" : installdelexp+=_s1+"\n"
	return


#deffunc hsp3update_addinstall str p1, str p2, str p3, int p4

	;	CXg[ǉ
	;	(p1=ID/p2=^Cg/p3=customURL,p4=update flag)
	;
	;
	installnew+=p1+"\n"
	installnewexp+=p2+"\n"
	installnewurl+=p3+"\n"
	installupdate(installcnt)=p4
	installcnt++
	return


#deffunc hsp3update_build int p1

	;	CXg[
	;	(p1=syschg 1̏ꍇbase܂)
	;
	hsp3update_install_init

	notesel base_group
	noteget cur_group, base_sel
	notesel base_id
	noteget s1,base_sel

	if p1>0 {
		notesel base_package
		noteget s2,base_sel
		hsp3update_addinstall s1,s2, "", 1
		goto *update_build_new
	}

*update_build
	;	CXg[\z
	;
	repeat plist_max
			i=plist_ref(cnt)
			notesel list_package
			noteget s1,i
			notesel list_id
			noteget s2,i
			notesel list_uninstall
			noteget s3,i
			actflag=list_active(i)
			if actflag=1 {										; No install->Install
				hsp3update_addinstall s2,s1,"",1
			}
			if actflag=2 {										; Install->No install
				hsp3update_install_adddel s2,s1
				installfix+=s3+"\n"
				installfixurl+="\n"
			}
			if actflag=3 {										; Install -> Install(update)
				if list_update(i)=1 {
					hsp3update_install_adddel s2,""
					hsp3update_addinstall s2,s1,"",1
				}
			}
	loop

	repeat paddon_max
			i=paddon_ref(cnt)
			notesel addon_package
			noteget s1,i
			notesel addon_id
			noteget s2,i
			pkgid=addon_user(i)
			if pkgid<0 {
				s3=""
			} else {
				notesel user_addon_url
				noteget s3,pkgid			; JX^URL
			}

			actflag=addon_active(i)
			if actflag=1 {										; No install->Install
				hsp3update_addinstall s2,s1,s3,1
			}
			if actflag=2 {										; Install->No install
				hsp3update_install_adddel s2,s1
			}
			if actflag=3 {										; Install -> Install(update)
				if addon_update(i)=1 {
					hsp3update_install_adddel s2,""
					hsp3update_addinstall s2,s1,s3,1
				}
			}
	loop

	return 0

*update_build_new
	;	VKCXg[\z
	;
	installdelexp+="ׂẴpbP[W\n"
	repeat plist_max
			i=plist_ref(cnt)
			notesel list_package
			noteget s1,i
			notesel list_id
			noteget s2,i
			if list_active(i)&1 {
				hsp3update_addinstall s2,s1,"",1
			}
	loop

	repeat paddon_max
			i=paddon_ref(cnt)

			notesel addon_package
			noteget s1,i
			notesel addon_id
			noteget s2,i
			if addon_active(i)&1 {
				pkgid=addon_user(i)
				if pkgid<0 {
					s3=""
				} else {
					notesel user_addon_url
					noteget s3,pkgid
				}
				hsp3update_addinstall s2,s1,s3,1
			}
	loop

	return 0


#deffunc hsp3update_getnetfile str p1, local _fname

	;	t@C_E[h
	;
	s3=PLATFORM+"/"+p1
	;dialog "["+s3+"]"

	DeleteUrlCacheEntry ""+HSPURL+s3	; LbV폜

	s2=""
	i=0
	repeat
		getstr s1,s3,i,'/',64
		if strsize=0 : break
		i+=strsize
		if peek(s3,i)=0 {
			_fname=s1
		} else {
			s2+=s1+"/"
		}
	loop
	neturl HSPURL+s2
	s2=PLATFORM


	if s2!="" {					; tH_݂邩?
		chdir confdir
		dirlist s1,s2,5
		if stat=0 {
			mkdir s2
		}
		chdir s2
	}

	netrequest _fname

	res=0
	repeat
	netexec res
	if res : break
	await 50
	loop

	chdir confdir

	if res > 0 : return 0
	return 1


#deffunc hsp3update_getusrfile str p1, str p2, int p3, local _fname

	;	t@C_E[h(O)
	;	p1=ID / p2=URL / p3=0:hashȂ 1:hash
	;
	s3=p1

	DeleteUrlCacheEntry ""+p2+s3	; LbV폜

	s2=""
	i=0
	repeat
		getstr s1,s3,i,'/',64
		if strsize=0 : break
		i+=strsize
		if peek(s3,i)=0 {
			_fname=s1
		} else {
			s2+=s1+"/"
		}
	loop
	;dialog "["+s2+"]:"+_fname
	neturl p2+s2
	s2=PLATFORM

	if s2!="" {					; tH_݂邩?
		chdir confdir
		dirlist s1,s2,5
		if stat=0 {
			mkdir s2
		}
		chdir s2
	}

	netrequest _fname

	res=0
	repeat
	netexec res
	if res : break
	await 50
	loop

	chdir confdir

	if res <= 0 : return 0

	downfile = PLATFORM+"/"+p1
	downok=0
	repeat 100
		exist downfile
		if strsize>0 : downok=1 : break
		wait 1
	loop
	if downok=0 : dialog "Download file missing ["+downfile+"]" : return 2

	if p3=0 : return 0

	s1=p1
	hsp3update_gethash s1
	filesha256 s2,downfile
	if s2!=s1 {					; SHA256
		dialog "Download file SHA256 not match ["+downfile+"]"
		return 2
	}

	return 0


#deffunc hsp3update_fetchfile str p1

	;	t@C݂Ȃ΃_E[h
	;	downstat = 0:XVȂ/1:t@CXV/2:t@CȂ
	;
	s1=p1
	downfile = PLATFORM+"/"+s1
	downstat = 0

	hsp3update_gethash s1
	orghash=s1
	if s1="" {
		orghash=s2
		hsp3update_hashupd s1	; nbVȂꍇ͍ŐṼnbVɃAbvf[g
	}

	exist downfile			; ̃t@C`FbN
	if strsize>0 {
		filesha256 s2,downfile
		if orghash=s2 : return 0	; ێnbVƓȂ΃pX
		downstat = 1
	} else {
		downstat = 2
	}

	hsp3update_getnetfile p1
	if stat : return 1

	downok=0
	repeat 100
		exist downfile
		if strsize>0 : downok=1 : break
		wait 1
	loop
	if downok=0 : dialog "Download file missing ["+downfile+"]" : return 2

	s1=p1
	hsp3update_gethash s1
	filesha256 s2,downfile
	if s2!=s1 {					; SHA256
		dialog "Download file SHA256 not match ["+downfile+"]"
		return 2
	}
	return 0


#deffunc hsp3update_getflist

	;	flistXV(Cindex擾)
	;
	flist_stat=0
	netinit
	if stat : return -1

	chdir confdir
	hsp3update_getnetfile HSPUPD
	if stat : return -2

	sdim idxbuf,$1000
	fname=PLATFORM+"/"+HSPUPD
	notesel idxbuf
	noteload fname

	hsp3update_sethash idxbuf

	hsp3update_hashupd SELFAX
	hsp3update_fetchfile SELFAX
	if stat : return -2

	flist_stat=downstat

	return 0


#deffunc hsp3update_preload int p1

	;	CXg[ɕKvȃt@C_E[h
	;	(p1=syschg 1̏ꍇ̓t@CׂčŐVɍXV)
	;
	sdim install_master,$1000
	sdim install_masterurl,$1000
	install_master = installnew
	install_master += installfix
	install_masterurl = installnewurl
	install_masterurl += installfixurl

	if p1 {
		;	ׂčŐVɍXV
		flist=""
		notesel install_master
		repeat notemax
			notesel install_master
			noteget s1,cnt
			if s1!="" {
				hsp3update_hashupd s1+".zip"		; nbVAbvf[g
			}
		loop
	} else {
		;	ꕔ̃nbVŐVɍXV
		notesel install_master
		repeat notemax
			if installupdate(cnt) {
				notesel install_master
				noteget s1,cnt
				if s1!="" {
					hsp3update_hashupd s1+".zip"	; nbVAbvf[g
					notesel install_master
					noteget s1,cnt
					hsp3update_idxupd s1			; CfbNXAbvf[g
				}
			}
		loop
	}
	;
	sdim pkgerror,256
	notesel install_master
	maxinst=notemax
	repeat maxinst
		notesel install_master
		noteget fname,cnt
		notesel install_masterurl
		noteget s3,cnt

		if fname!="" {
			;dialog "["+s3+"] "+fname
			if s3="" {
				hsp3update_fetchfile fname+".zip"
			} else {
				hsp3update_getusrfile fname+".zip",s3
			}
			if stat {
					pkgerror="Error Download : "+fname
					return 1
			}
		}
	loop
	sdim install_master,64
	sdim install_masterurl,64

	return 0


#deffunc hsp3update_uninstall

	;	ACXg[s㏈
	;
	fname=hspbase_dir+"/"+HSPINSTALL

	;	CXg[̍XV
	notesel installdel
	max=notemax
	repeat max
		notesel installdel
		noteget s1,cnt
		notesel installbuf
		i=notefind(s1,0)
		if i>=0 {
			noteadd "",i,1
		}
	loop

	notesel installbuf
	notesave fname
	return 0


#deffunc hsp3update_install int p1

	;	CXg[s㏈
	;	(p1=syschg 1̏ꍇinstallbufč\z)
	;
	fname=hspbase_dir+"/"+HSPFLIST
	notesel flist
	notesave fname
	;
	fname=hspbase_dir+"/"+HSPINSTALL

	if p1 {
		installbuf = "; HSP3Update install info\n"+installnew
		notesel installbuf
		notesave fname
		return 0
	}

	installbuf += installnew
	notesel installbuf
	notesave fname
	return 0


#deffunc hsp3update_loadupd str p1

	;	.hspupd [h (c[p)
	;
	sdim name_id,128
	sdim name_exp,64
	sdim name_last,64
	sdim name_inst,$1000
	sdim name_base,64
	sdim name_url,128
	sdim name_author,64
	sdim name_open,128
	sdim name_license,$1000
	sdim name_type,64
	sdim name_group,64
	id_type=0
	name_group="addon"
	;
	if p1="" : return 0

	exist p1
	if strsize<0 : return 1

	notesel idxbuf
	noteload p1
	cfg_loadvar idxbuf

	cfg_searchidx s1,"index"
	if s1="" : return 1

	notesel s1
	noteget name_id, 0
	noteget name_exp, 1

	s2="u"+def_seedid+"_"
	i=instr(name_id,0,s2)
	if i>=0 {
		name_id=strmid(name_id,i+strlen(s2),255)
	}
	id_start = cfg_getindex()

	gosub *getpkginfo

	return 0


#deffunc hsp3update_saveupd str p1

	;	.hspupd Z[u (c[p)
	;
	sdim idxbuf,$1000
	sdim pkgerror,256
	if name_id="" : pkgerror="indexڂ܂" : return
	if name_exp="" : pkgerror="^Cgڂ܂" : return
	if name_author="" : pkgerror="ҍڂ܂" : return
	if name_inst="" : pkgerror="ڂ܂" : return
	if name_last="" : pkgerror="Dateڂ܂" : return
	if name_base="" : pkgerror="x[XVXeڂ܂" : return

	s2="u"+def_seedid+"_"
	idxbuf="%index\n"+s2+name_id+"\n"+name_exp+"\n"
	idxbuf+="%group\n"+name_group+"\n"
	idxbuf+="%type\n"+name_type+"\n"
	idxbuf+="%author\n"+name_author+"\n"
	idxbuf+="%inst\n"+name_inst+"\n"
	idxbuf+="%last\n"+name_last+"\n"
	idxbuf+="%base\n"+name_base+"\n"

	if name_license!="" : idxbuf+="%license\n"+name_license+"\n"
	if name_open!="" : idxbuf+="%open\n"+name_open+"\n"
	if name_url!="" : idxbuf+="%url\n"+name_url+"\n"

	notesel idxbuf
	notesave p1
	return


//---------------------------------------------------------

*_end_mod_hsp3update

#endif

