/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.zzez;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpy;

@zzmb
public final class SearchAdView
extends ViewGroup {
    private final zzez zzrJ;

    public SearchAdView(Context context) {
        super(context);
        this.zzrJ = new zzez(this);
    }

    public SearchAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzrJ = new zzez(this, attributeSet, false);
    }

    public SearchAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzrJ = new zzez(this, attributeSet, false);
    }

    public void destroy() {
        this.zzrJ.destroy();
    }

    public AdListener getAdListener() {
        return this.zzrJ.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzrJ.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzrJ.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(SearchAdRequest searchAdRequest) {
        this.zzrJ.zza(searchAdRequest.zzbq());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        if (!AdSize.SEARCH.equals(this.getAdSize())) {
            throw new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
        }
        this.zzrJ.zza(dynamicHeightSearchAdRequest.zzbq());
    }

    public void pause() {
        this.zzrJ.pause();
    }

    public void resume() {
        this.zzrJ.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zzrJ.setAdListener(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.zzrJ.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzrJ.setAdUnitId(string);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzpy.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

