/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqj;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzmd
extends zzpd
implements zzme.zza {
    private final zzmc.zza zzQQ;
    private final zzmh.zza zzQR;
    private final Object zzPr = new Object();
    private final Context mContext;
    private final zzav zzGr;
    private zzmh zzKG;
    private Runnable zzPq;
    zzpk zzQS;
    zzmk zzPp;
    zzjj zzKq;

    public zzmd(Context context, zzmh.zza zza2, zzav zzav2, zzmc.zza zza3) {
        this.zzQQ = zza3;
        this.mContext = context;
        this.zzQR = zza2;
        this.zzGr = zzav2;
    }

    zzpk zza(zzqa zzqa2, zzqi<zzmh> zzqi2) {
        return zzme.zza(this.mContext, zzqa2, zzqi2, this);
    }

    @Override
    public void zzcm() {
        zzpe.zzbc((String)"AdLoaderBackgroundTask started.");
        this.zzPq = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzmd.this.zzPr;
                synchronized (object) {
                    if (zzmd.this.zzQS == null) {
                        return;
                    }
                    zzmd.this.onStop();
                    zzmd.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzpi.zzWR.postDelayed(this.zzPq, zzfx.zzDd.get().longValue());
        final zzqj<zzmh> zzqj2 = new zzqj<zzmh>();
        long l = zzv.zzcP().elapsedRealtime();
        zzph.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzmd.this.zzPr;
                synchronized (object) {
                    zzmd.this.zzQS = zzmd.this.zza(((zzmd)zzmd.this).zzQR.zzvf, zzqj2);
                    if (zzmd.this.zzQS == null) {
                        zzmd.this.zzd(0, "Could not start the ad request service.");
                        zzpi.zzWR.removeCallbacks(zzmd.this.zzPq);
                    }
                }
            }
        });
        zzaq zzaq2 = this.zzGr.zzW();
        String string2 = zzaq2.zzb(this.mContext);
        this.zzKG = new zzmh(this.zzQR, string2, l);
        zzqj2.zzg(this.zzKG);
    }

    private void zzd(int n, String string2) {
        if (n == 3 || n == -1) {
            zzpe.zzbd((String)string2);
        } else {
            zzpe.zzbe((String)string2);
        }
        this.zzPp = this.zzPp == null ? new zzmk(n) : new zzmk(n, this.zzPp.zzKe);
        zzmh zzmh2 = this.zzKG != null ? this.zzKG : new zzmh(this.zzQR, null, -1L);
        zzov.zza zza2 = new zzov.zza(zzmh2, this.zzPp, this.zzKq, null, n, -1L, this.zzPp.zzRO, null);
        this.zzQQ.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull zzmk zzmk2) {
        zzpe.zzbc((String)"Received ad response.");
        this.zzPp = zzmk2;
        long l = zzv.zzcP().elapsedRealtime();
        Object object = this.zzPr;
        synchronized (object) {
            this.zzQS = null;
        }
        zzv.zzcN().zzd(this.mContext, this.zzPp.zzRB);
        object = null;
        try {
            if (this.zzPp.errorCode != -2 && this.zzPp.errorCode != -3) {
                int n = this.zzPp.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzPp.errorCode);
            }
            this.zziX();
            if (this.zzKG.zzvj.zzzm != null) {
                object = this.zzb(this.zzKG);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzpi.zzWR.removeCallbacks(this.zzPq);
            return;
        }
        zzv.zzcN().zzE(this.zzPp.zzRU);
        zzv.zzcN().zzF(this.zzPp.zzSh);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzPp.zzRS)) {
            try {
                jSONObject = new JSONObject(this.zzPp.zzRS);
            }
            catch (Exception exception) {
                zzpe.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzov.zza zza3 = new zzov.zza(this.zzKG, this.zzPp, this.zzKq, (zzec)object, -2, l, this.zzPp.zzRO, jSONObject);
        this.zzQQ.zza(zza3);
        zzpi.zzWR.removeCallbacks(this.zzPq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzPr;
        synchronized (object) {
            if (this.zzQS != null) {
                this.zzQS.cancel();
            }
        }
    }

    protected void zziX() throws zza {
        if (this.zzPp.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzPp.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzv.zzcN().zzc(this.mContext, this.zzPp.zzRl);
        if (this.zzPp.zzRK) {
            try {
                this.zzKq = new zzjj(this.zzPp.body);
                zzv.zzcN().zzG(this.zzKq.zzKc);
            }
            catch (JSONException jSONException) {
                zzpe.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string2 = String.valueOf(this.zzPp.body);
                throw new zza(string2.length() != 0 ? "Could not parse mediation config: ".concat(string2) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzv.zzcN().zzG(this.zzPp.zzKc);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzPp.zzRC) && zzfx.zzEH.get().booleanValue()) {
            zzpe.zzbc((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzv.zzcL().zzL(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzPp.zzRC);
            }
        }
    }

    protected zzec zzb(zzmh zzmh2) throws zza {
        int n;
        int n2;
        if (this.zzPp.zzzo) {
            for (zzec zzecArray : zzmh2.zzvj.zzzm) {
                if (!zzecArray.zzzo) continue;
                return new zzec(zzecArray, zzmh2.zzvj.zzzm);
            }
        }
        if (this.zzPp.zzRN == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzPp.zzRN.split("x");
        if (stringArray.length != 2) {
            String string2 = String.valueOf(this.zzPp.zzRN);
            throw new zza(string2.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string2) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(this.zzPp.zzRN);
            throw new zza(string3.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string3) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (zzec zzec2 : zzmh2.zzvj.zzzm) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = zzec2.width == -1 ? (int)((float)zzec2.widthPixels / f) : zzec2.width;
            int n5 = n3 = zzec2.height == -2 ? (int)((float)zzec2.heightPixels / f) : zzec2.height;
            if (n2 != n4 || n != n3 || zzec2.zzzo) continue;
            return new zzec(zzec2, zzmh2.zzvj.zzzm);
        }
        String string4 = String.valueOf(this.zzPp.zzRN);
        throw new zza(string4.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string4) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzmb
    static final class zza
    extends Exception {
        private final int zzPF;

        public zza(String string2, int n) {
            super(string2);
            this.zzPF = n;
        }

        public int getErrorCode() {
            return this.zzPF;
        }
    }
}

