/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzqp;
import java.util.Map;

@zzmb
public class zzkl
extends zzko {
    private final Map<String, String> zzFs;
    private final Context mContext;

    public zzkl(zzqp zzqp2, Map<String, String> map) {
        super(zzqp2, "storePicture");
        this.zzFs = map;
        this.mContext = zzqp2.zzkR();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzay("Activity context is not available");
            return;
        }
        zzfp zzfp2 = zzv.zzcJ().zzC(this.mContext);
        if (!zzfp2.zzfi()) {
            this.zzay("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzFs.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzay("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzay(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzax(string2);
        if (!zzv.zzcJ().zzaX(string4)) {
            String string5 = String.valueOf(string4);
            this.zzay(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzv.zzcN().getResources();
        AlertDialog.Builder builder = zzv.zzcJ().zzB(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzkl.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzkl.this.zzj(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkl.this.zzay("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzkl.this.zzay("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzj(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzv.zzcL().zza(request);
        return request;
    }

    String zzax(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

