/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.FragmentTransitionCompat21;
import android.support.v4.app.SharedElementCallback;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LogWriter;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable {
    static final String TAG = "FragmentManager";
    static final boolean SUPPORTS_TRANSITIONS = Build.VERSION.SDK_INT >= 21;
    final FragmentManagerImpl mManager;
    static final int OP_NULL = 0;
    static final int OP_ADD = 1;
    static final int OP_REPLACE = 2;
    static final int OP_REMOVE = 3;
    static final int OP_HIDE = 4;
    static final int OP_SHOW = 5;
    static final int OP_DETACH = 6;
    static final int OP_ATTACH = 7;
    Op mHead;
    Op mTail;
    int mNumOp;
    int mEnterAnim;
    int mExitAnim;
    int mPopEnterAnim;
    int mPopExitAnim;
    int mTransition;
    int mTransitionStyle;
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack = true;
    String mName;
    boolean mCommitted;
    int mIndex = -1;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    ArrayList<String> mSharedElementSourceNames;
    ArrayList<String> mSharedElementTargetNames;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("BackStackEntry{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            sb.append(" #");
            sb.append(this.mIndex);
        }
        if (this.mName != null) {
            sb.append(" ");
            sb.append(this.mName);
        }
        sb.append("}");
        return sb.toString();
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.dump(prefix, writer, true);
    }

    public void dump(String prefix, PrintWriter writer, boolean full) {
        if (full) {
            writer.print(prefix);
            writer.print("mName=");
            writer.print(this.mName);
            writer.print(" mIndex=");
            writer.print(this.mIndex);
            writer.print(" mCommitted=");
            writer.println(this.mCommitted);
            if (this.mTransition != 0) {
                writer.print(prefix);
                writer.print("mTransition=#");
                writer.print(Integer.toHexString(this.mTransition));
                writer.print(" mTransitionStyle=#");
                writer.println(Integer.toHexString(this.mTransitionStyle));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                writer.print(prefix);
                writer.print("mEnterAnim=#");
                writer.print(Integer.toHexString(this.mEnterAnim));
                writer.print(" mExitAnim=#");
                writer.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                writer.print(prefix);
                writer.print("mPopEnterAnim=#");
                writer.print(Integer.toHexString(this.mPopEnterAnim));
                writer.print(" mPopExitAnim=#");
                writer.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                writer.print(" mBreadCrumbTitleText=");
                writer.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbShortTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                writer.print(" mBreadCrumbShortTitleText=");
                writer.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (this.mHead != null) {
            writer.print(prefix);
            writer.println("Operations:");
            String innerPrefix = prefix + "    ";
            Op op = this.mHead;
            int num = 0;
            while (op != null) {
                String cmdStr;
                switch (op.cmd) {
                    case 0: {
                        cmdStr = "NULL";
                        break;
                    }
                    case 1: {
                        cmdStr = "ADD";
                        break;
                    }
                    case 2: {
                        cmdStr = "REPLACE";
                        break;
                    }
                    case 3: {
                        cmdStr = "REMOVE";
                        break;
                    }
                    case 4: {
                        cmdStr = "HIDE";
                        break;
                    }
                    case 5: {
                        cmdStr = "SHOW";
                        break;
                    }
                    case 6: {
                        cmdStr = "DETACH";
                        break;
                    }
                    case 7: {
                        cmdStr = "ATTACH";
                        break;
                    }
                    default: {
                        cmdStr = "cmd=" + op.cmd;
                    }
                }
                writer.print(prefix);
                writer.print("  Op #");
                writer.print(num);
                writer.print(": ");
                writer.print(cmdStr);
                writer.print(" ");
                writer.println(op.fragment);
                if (full) {
                    if (op.enterAnim != 0 || op.exitAnim != 0) {
                        writer.print(prefix);
                        writer.print("enterAnim=#");
                        writer.print(Integer.toHexString(op.enterAnim));
                        writer.print(" exitAnim=#");
                        writer.println(Integer.toHexString(op.exitAnim));
                    }
                    if (op.popEnterAnim != 0 || op.popExitAnim != 0) {
                        writer.print(prefix);
                        writer.print("popEnterAnim=#");
                        writer.print(Integer.toHexString(op.popEnterAnim));
                        writer.print(" popExitAnim=#");
                        writer.println(Integer.toHexString(op.popExitAnim));
                    }
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        writer.print(innerPrefix);
                        if (op.removed.size() == 1) {
                            writer.print("Removed: ");
                        } else {
                            if (i == 0) {
                                writer.println("Removed:");
                            }
                            writer.print(innerPrefix);
                            writer.print("  #");
                            writer.print(i);
                            writer.print(": ");
                        }
                        writer.println(op.removed.get(i));
                    }
                }
                op = op.next;
                ++num;
            }
        }
    }

    public BackStackRecord(FragmentManagerImpl manager) {
        this.mManager = manager;
    }

    @Override
    public int getId() {
        return this.mIndex;
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    @Override
    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    @Override
    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    void addOp(Op op) {
        if (this.mHead == null) {
            this.mHead = this.mTail = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        op.popEnterAnim = this.mPopEnterAnim;
        op.popExitAnim = this.mPopExitAnim;
        ++this.mNumOp;
    }

    @Override
    public FragmentTransaction add(Fragment fragment, String tag) {
        this.doAddOp(0, fragment, tag, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int containerViewId, Fragment fragment) {
        this.doAddOp(containerViewId, fragment, null, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int containerViewId, Fragment fragment, String tag) {
        this.doAddOp(containerViewId, fragment, tag, 1);
        return this;
    }

    private void doAddOp(int containerViewId, Fragment fragment, String tag, int opcmd) {
        Class<?> fragmentClass = fragment.getClass();
        int modifiers = fragmentClass.getModifiers();
        if (fragmentClass.isAnonymousClass() || !Modifier.isPublic(modifiers) || fragmentClass.isMemberClass() && !Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("Fragment " + fragmentClass.getCanonicalName() + " must be a public static class to be  properly recreated from" + " instance state.");
        }
        fragment.mFragmentManager = this.mManager;
        if (tag != null) {
            if (fragment.mTag != null && !tag.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + tag);
            }
            fragment.mTag = tag;
        }
        if (containerViewId != 0) {
            if (containerViewId == -1) {
                throw new IllegalArgumentException("Can't add fragment " + fragment + " with tag " + tag + " to container view with no id");
            }
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != containerViewId) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + containerViewId);
            }
            fragment.mContainerId = fragment.mFragmentId = containerViewId;
        }
        Op op = new Op();
        op.cmd = opcmd;
        op.fragment = fragment;
        this.addOp(op);
    }

    @Override
    public FragmentTransaction replace(int containerViewId, Fragment fragment) {
        return this.replace(containerViewId, fragment, null);
    }

    @Override
    public FragmentTransaction replace(int containerViewId, Fragment fragment, String tag) {
        if (containerViewId == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(containerViewId, fragment, tag, 2);
        return this;
    }

    @Override
    public FragmentTransaction remove(Fragment fragment) {
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction hide(Fragment fragment) {
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction show(Fragment fragment) {
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction detach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 6;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction attach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 7;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction setCustomAnimations(int enter, int exit) {
        return this.setCustomAnimations(enter, exit, 0, 0);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int enter, int exit, int popEnter, int popExit) {
        this.mEnterAnim = enter;
        this.mExitAnim = exit;
        this.mPopEnterAnim = popEnter;
        this.mPopExitAnim = popExit;
        return this;
    }

    @Override
    public FragmentTransaction setTransition(int transition) {
        this.mTransition = transition;
        return this;
    }

    @Override
    public FragmentTransaction addSharedElement(View sharedElement, String name) {
        if (SUPPORTS_TRANSITIONS) {
            String transitionName = FragmentTransitionCompat21.getTransitionName(sharedElement);
            if (transitionName == null) {
                throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
            }
            if (this.mSharedElementSourceNames == null) {
                this.mSharedElementSourceNames = new ArrayList();
                this.mSharedElementTargetNames = new ArrayList();
            }
            this.mSharedElementSourceNames.add(transitionName);
            this.mSharedElementTargetNames.add(name);
        }
        return this;
    }

    @Override
    public FragmentTransaction setTransitionStyle(int styleRes) {
        this.mTransitionStyle = styleRes;
        return this;
    }

    @Override
    public FragmentTransaction addToBackStack(String name) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = name;
        return this;
    }

    @Override
    public boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    @Override
    public FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(int res) {
        this.mBreadCrumbTitleRes = res;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(CharSequence text) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = text;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(int res) {
        this.mBreadCrumbShortTitleRes = res;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(CharSequence text) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = text;
        return this;
    }

    void bumpBackStackNesting(int amt) {
        if (!this.mAddToBackStack) {
            return;
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Bump nesting in " + this + " by " + amt));
        }
        Op op = this.mHead;
        while (op != null) {
            if (op.fragment != null) {
                op.fragment.mBackStackNesting += amt;
                if (FragmentManagerImpl.DEBUG) {
                    Log.v((String)TAG, (String)("Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting));
                }
            }
            if (op.removed != null) {
                for (int i = op.removed.size() - 1; i >= 0; --i) {
                    Fragment r = op.removed.get(i);
                    r.mBackStackNesting += amt;
                    if (!FragmentManagerImpl.DEBUG) continue;
                    Log.v((String)TAG, (String)("Bump nesting of " + r + " to " + r.mBackStackNesting));
                }
            }
            op = op.next;
        }
    }

    @Override
    public int commit() {
        return this.commitInternal(false);
    }

    @Override
    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    @Override
    public void commitNow() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, false);
    }

    @Override
    public void commitNowAllowingStateLoss() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, true);
    }

    int commitInternal(boolean allowStateLoss) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Commit: " + this));
            LogWriter logw = new LogWriter(TAG);
            PrintWriter pw = new PrintWriter((Writer)logw);
            this.dump("  ", null, pw, null);
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, allowStateLoss);
        return this.mIndex;
    }

    @Override
    public void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Run: " + this));
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        TransitionState state = null;
        SparseArray firstOutFragments = null;
        SparseArray lastInFragments = null;
        if (SUPPORTS_TRANSITIONS && this.mManager.mCurState >= 1) {
            firstOutFragments = new SparseArray();
            lastInFragments = new SparseArray();
            this.calculateFragments((SparseArray<Fragment>)firstOutFragments, (SparseArray<Fragment>)lastInFragments);
            state = this.beginTransition((SparseArray<Fragment>)firstOutFragments, (SparseArray<Fragment>)lastInFragments, false);
        }
        int transitionStyle = state != null ? 0 : this.mTransitionStyle;
        int transition = state != null ? 0 : this.mTransition;
        Op op = this.mHead;
        while (op != null) {
            int enterAnim = state != null ? 0 : op.enterAnim;
            int exitAnim = state != null ? 0 : op.exitAnim;
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    int containerId = f.mContainerId;
                    if (this.mManager.mAdded != null) {
                        for (int i = this.mManager.mAdded.size() - 1; i >= 0; --i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)TAG, (String)("OP_REPLACE: adding=" + f + " old=" + old));
                            }
                            if (old.mContainerId != containerId) continue;
                            if (old == f) {
                                f = null;
                                op.fragment = null;
                                continue;
                            }
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(old);
                            old.mNextAnim = exitAnim;
                            if (this.mAddToBackStack) {
                                ++old.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v((String)TAG, (String)("Bump nesting of " + old + " to " + old.mBackStackNesting));
                                }
                            }
                            this.mManager.removeFragment(old, transition, transitionStyle);
                        }
                    }
                    if (f == null) break;
                    f.mNextAnim = enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = exitAnim;
                    this.mManager.removeFragment(f, transition, transitionStyle);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = exitAnim;
                    this.mManager.hideFragment(f, transition, transitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = enterAnim;
                    this.mManager.showFragment(f, transition, transitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = exitAnim;
                    this.mManager.detachFragment(f, transition, transitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = enterAnim;
                    this.mManager.attachFragment(f, transition, transitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, transition, transitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    private static void setFirstOut(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        int containerId;
        if (fragment != null && (containerId = fragment.mContainerId) != 0 && !fragment.isHidden()) {
            if (fragment.isAdded() && fragment.getView() != null && firstOutFragments.get(containerId) == null) {
                firstOutFragments.put(containerId, (Object)fragment);
            }
            if (lastInFragments.get(containerId) == fragment) {
                lastInFragments.remove(containerId);
            }
        }
    }

    private void setLastIn(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        if (fragment != null) {
            int containerId = fragment.mContainerId;
            if (containerId != 0) {
                if (!fragment.isAdded()) {
                    lastInFragments.put(containerId, (Object)fragment);
                }
                if (firstOutFragments.get(containerId) == fragment) {
                    firstOutFragments.remove(containerId);
                }
            }
            if (fragment.mState < 1 && this.mManager.mCurState >= 1) {
                this.mManager.makeActive(fragment);
                this.mManager.moveToState(fragment, 1, 0, 0, false);
            }
        }
    }

    private void calculateFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (f != null && old.mContainerId != f.mContainerId) continue;
                            if (old == f) {
                                f = null;
                                lastInFragments.remove(old.mContainerId);
                                continue;
                            }
                            BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, old);
                        }
                    }
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.next;
        }
    }

    public void calculateBackFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    if (op.removed != null) {
                        for (int i = op.removed.size() - 1; i >= 0; --i) {
                            this.setLastIn(firstOutFragments, lastInFragments, op.removed.get(i));
                        }
                    }
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.prev;
        }
    }

    public TransitionState popFromBackStack(boolean doStateMove, TransitionState state, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("popFromBackStack: " + this));
            LogWriter logw = new LogWriter(TAG);
            PrintWriter pw = new PrintWriter((Writer)logw);
            this.dump("  ", null, pw, null);
        }
        if (SUPPORTS_TRANSITIONS && this.mManager.mCurState >= 1) {
            if (state == null) {
                if (firstOutFragments.size() != 0 || lastInFragments.size() != 0) {
                    state = this.beginTransition(firstOutFragments, lastInFragments, true);
                }
            } else if (!doStateMove) {
                BackStackRecord.setNameOverrides(state, this.mSharedElementTargetNames, this.mSharedElementSourceNames);
            }
        }
        this.bumpBackStackNesting(-1);
        int transitionStyle = state != null ? 0 : this.mTransitionStyle;
        int transition = state != null ? 0 : this.mTransition;
        Op op = this.mTail;
        while (op != null) {
            int popEnterAnim = state != null ? 0 : op.popEnterAnim;
            int popExitAnim = state != null ? 0 : op.popExitAnim;
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popExitAnim;
                    this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (f != null) {
                        f.mNextAnim = popExitAnim;
                        this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    }
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment old = op.removed.get(i);
                        old.mNextAnim = popEnterAnim;
                        this.mManager.addFragment(old, false);
                    }
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popEnterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popEnterAnim;
                    this.mManager.showFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popExitAnim;
                    this.mManager.hideFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popEnterAnim;
                    this.mManager.attachFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = popEnterAnim;
                    this.mManager.detachFragment(f, FragmentManagerImpl.reverseTransit(transition), transitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.prev;
        }
        if (doStateMove) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(transition), transitionStyle, true);
            state = null;
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
        return state;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    @Override
    public boolean isEmpty() {
        return this.mNumOp == 0;
    }

    private TransitionState beginTransition(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, boolean isBack) {
        int containerId;
        int i;
        TransitionState state = new TransitionState();
        state.nonExistentView = new View(this.mManager.mHost.getContext());
        boolean anyTransitionStarted = false;
        for (i = 0; i < firstOutFragments.size(); ++i) {
            containerId = firstOutFragments.keyAt(i);
            if (!this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments)) continue;
            anyTransitionStarted = true;
        }
        for (i = 0; i < lastInFragments.size(); ++i) {
            containerId = lastInFragments.keyAt(i);
            if (firstOutFragments.get(containerId) != null || !this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments)) continue;
            anyTransitionStarted = true;
        }
        if (!anyTransitionStarted) {
            state = null;
        }
        return state;
    }

    private static Object getEnterTransition(Fragment inFragment, boolean isBack) {
        if (inFragment == null) {
            return null;
        }
        return FragmentTransitionCompat21.cloneTransition(isBack ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static Object getExitTransition(Fragment outFragment, boolean isBack) {
        if (outFragment == null) {
            return null;
        }
        return FragmentTransitionCompat21.cloneTransition(isBack ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static Object getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isBack) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        return FragmentTransitionCompat21.wrapSharedElementTransition(isBack ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
    }

    private static Object captureExitingViews(Object exitTransition, Fragment outFragment, ArrayList<View> exitingViews, ArrayMap<String, View> namedViews, View nonExistentView) {
        if (exitTransition != null) {
            exitTransition = FragmentTransitionCompat21.captureExitingViews(exitTransition, outFragment.getView(), exitingViews, namedViews, nonExistentView);
        }
        return exitTransition;
    }

    private ArrayMap<String, View> remapSharedElements(TransitionState state, Fragment outFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        if (this.mSharedElementSourceNames != null) {
            FragmentTransitionCompat21.findNamedViews((Map<String, View>)namedViews, outFragment.getView());
            if (isBack) {
                namedViews.retainAll(this.mSharedElementTargetNames);
            } else {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            }
        }
        if (isBack) {
            if (outFragment.mEnterTransitionCallback != null) {
                outFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, (Map)namedViews);
            }
            this.setBackNameOverrides(state, namedViews, false);
        } else {
            if (outFragment.mExitTransitionCallback != null) {
                outFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, (Map)namedViews);
            }
            this.setNameOverrides(state, namedViews, false);
        }
        return namedViews;
    }

    private boolean configureTransitions(int containerId, TransitionState state, boolean isBack, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        Object transition;
        View epicenterView;
        ViewGroup sceneRoot = (ViewGroup)this.mManager.mContainer.onFindViewById(containerId);
        if (sceneRoot == null) {
            return false;
        }
        final Fragment inFragment = (Fragment)lastInFragments.get(containerId);
        Fragment outFragment = (Fragment)firstOutFragments.get(containerId);
        Object enterTransition = BackStackRecord.getEnterTransition(inFragment, isBack);
        Object sharedElementTransition = BackStackRecord.getSharedElementTransition(inFragment, outFragment, isBack);
        Object exitTransition = BackStackRecord.getExitTransition(outFragment, isBack);
        ArrayMap<String, View> namedViews = null;
        ArrayList<View> sharedElementTargets = new ArrayList<View>();
        if (sharedElementTransition != null) {
            namedViews = this.remapSharedElements(state, outFragment, isBack);
            if (namedViews.isEmpty()) {
                sharedElementTransition = null;
                namedViews = null;
            } else {
                SharedElementCallback callback;
                SharedElementCallback sharedElementCallback = callback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
                if (callback != null) {
                    ArrayList names = new ArrayList(namedViews.keySet());
                    ArrayList views = new ArrayList(namedViews.values());
                    callback.onSharedElementStart(names, views, null);
                }
                this.prepareSharedElementTransition(state, (View)sceneRoot, sharedElementTransition, inFragment, outFragment, isBack, sharedElementTargets, enterTransition, exitTransition);
            }
        }
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return false;
        }
        ArrayList<View> exitingViews = new ArrayList<View>();
        exitTransition = BackStackRecord.captureExitingViews(exitTransition, outFragment, exitingViews, namedViews, state.nonExistentView);
        if (this.mSharedElementTargetNames != null && namedViews != null && (epicenterView = (View)namedViews.get((Object)this.mSharedElementTargetNames.get(0))) != null) {
            if (exitTransition != null) {
                FragmentTransitionCompat21.setEpicenter(exitTransition, epicenterView);
            }
            if (sharedElementTransition != null) {
                FragmentTransitionCompat21.setEpicenter(sharedElementTransition, epicenterView);
            }
        }
        FragmentTransitionCompat21.ViewRetriever viewRetriever = new FragmentTransitionCompat21.ViewRetriever(){

            @Override
            public View getView() {
                return inFragment.getView();
            }
        };
        ArrayList<View> enteringViews = new ArrayList<View>();
        ArrayMap renamedViews = new ArrayMap();
        boolean allowOverlap = true;
        if (inFragment != null) {
            boolean bl = allowOverlap = isBack ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        if ((transition = FragmentTransitionCompat21.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, allowOverlap)) != null) {
            FragmentTransitionCompat21.addTransitionTargets(enterTransition, sharedElementTransition, exitTransition, (View)sceneRoot, viewRetriever, state.nonExistentView, state.enteringEpicenterView, state.nameOverrides, enteringViews, exitingViews, namedViews, (Map<String, View>)renamedViews, sharedElementTargets);
            this.excludeHiddenFragmentsAfterEnter((View)sceneRoot, state, containerId, transition);
            FragmentTransitionCompat21.excludeTarget(transition, state.nonExistentView, true);
            this.excludeHiddenFragments(state, containerId, transition);
            FragmentTransitionCompat21.beginDelayedTransition(sceneRoot, transition);
            FragmentTransitionCompat21.cleanupTransitions((View)sceneRoot, state.nonExistentView, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementTargets, transition, state.hiddenFragmentViews, (Map<String, View>)renamedViews);
        }
        return transition != null;
    }

    private void prepareSharedElementTransition(final TransitionState state, final View sceneRoot, final Object sharedElementTransition, final Fragment inFragment, final Fragment outFragment, final boolean isBack, final ArrayList<View> sharedElementTargets, final Object enterTransition, final Object exitTransition) {
        if (sharedElementTransition != null) {
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    sceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    FragmentTransitionCompat21.removeTargets(sharedElementTransition, sharedElementTargets);
                    sharedElementTargets.remove(state.nonExistentView);
                    FragmentTransitionCompat21.excludeSharedElementViews(enterTransition, exitTransition, sharedElementTransition, sharedElementTargets, false);
                    sharedElementTargets.clear();
                    ArrayMap<String, View> namedViews = BackStackRecord.this.mapSharedElementsIn(state, isBack, inFragment);
                    FragmentTransitionCompat21.setSharedElementTargets(sharedElementTransition, state.nonExistentView, namedViews, sharedElementTargets);
                    BackStackRecord.this.setEpicenterIn(namedViews, state);
                    BackStackRecord.this.callSharedElementEnd(state, inFragment, outFragment, isBack, namedViews);
                    FragmentTransitionCompat21.excludeSharedElementViews(enterTransition, exitTransition, sharedElementTransition, sharedElementTargets, true);
                    return true;
                }
            });
        }
    }

    void callSharedElementEnd(TransitionState state, Fragment inFragment, Fragment outFragment, boolean isBack, ArrayMap<String, View> namedViews) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
        if (sharedElementCallback != null) {
            ArrayList names = new ArrayList(namedViews.keySet());
            ArrayList views = new ArrayList(namedViews.values());
            sharedElementCallback.onSharedElementEnd(names, views, null);
        }
    }

    void setEpicenterIn(ArrayMap<String, View> namedViews, TransitionState state) {
        View epicenter;
        if (this.mSharedElementTargetNames != null && !namedViews.isEmpty() && (epicenter = (View)namedViews.get((Object)this.mSharedElementTargetNames.get(0))) != null) {
            state.enteringEpicenterView.epicenter = epicenter;
        }
    }

    ArrayMap<String, View> mapSharedElementsIn(TransitionState state, boolean isBack, Fragment inFragment) {
        ArrayMap<String, View> namedViews = this.mapEnteringSharedElements(state, inFragment, isBack);
        if (isBack) {
            if (inFragment.mExitTransitionCallback != null) {
                inFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            }
            this.setBackNameOverrides(state, namedViews, true);
        } else {
            if (inFragment.mEnterTransitionCallback != null) {
                inFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            }
            this.setNameOverrides(state, namedViews, true);
        }
        return namedViews;
    }

    private static ArrayMap<String, View> remapNames(ArrayList<String> inMap, ArrayList<String> toGoInMap, ArrayMap<String, View> namedViews) {
        if (namedViews.isEmpty()) {
            return namedViews;
        }
        ArrayMap remappedViews = new ArrayMap();
        int numKeys = inMap.size();
        for (int i = 0; i < numKeys; ++i) {
            View view = (View)namedViews.get((Object)inMap.get(i));
            if (view == null) continue;
            remappedViews.put((Object)toGoInMap.get(i), (Object)view);
        }
        return remappedViews;
    }

    private ArrayMap<String, View> mapEnteringSharedElements(TransitionState state, Fragment inFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        View root = inFragment.getView();
        if (root != null && this.mSharedElementSourceNames != null) {
            FragmentTransitionCompat21.findNamedViews((Map<String, View>)namedViews, root);
            if (isBack) {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            } else {
                namedViews.retainAll(this.mSharedElementTargetNames);
            }
        }
        return namedViews;
    }

    private void excludeHiddenFragmentsAfterEnter(final View sceneRoot, final TransitionState state, final int containerId, final Object transition) {
        sceneRoot.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                sceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                BackStackRecord.this.excludeHiddenFragments(state, containerId, transition);
                return true;
            }
        });
    }

    void excludeHiddenFragments(TransitionState state, int containerId, Object transition) {
        if (this.mManager.mAdded != null) {
            for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                Fragment fragment = this.mManager.mAdded.get(i);
                if (fragment.mView == null || fragment.mContainer == null || fragment.mContainerId != containerId) continue;
                if (fragment.mHidden) {
                    if (state.hiddenFragmentViews.contains(fragment.mView)) continue;
                    FragmentTransitionCompat21.excludeTarget(transition, fragment.mView, true);
                    state.hiddenFragmentViews.add(fragment.mView);
                    continue;
                }
                FragmentTransitionCompat21.excludeTarget(transition, fragment.mView, false);
                state.hiddenFragmentViews.remove(fragment.mView);
            }
        }
    }

    private static void setNameOverride(ArrayMap<String, String> overrides, String source, String target) {
        if (source != null && target != null) {
            for (int index = 0; index < overrides.size(); ++index) {
                if (!source.equals(overrides.valueAt(index))) continue;
                overrides.setValueAt(index, (Object)target);
                return;
            }
            overrides.put((Object)source, (Object)target);
        }
    }

    private static void setNameOverrides(TransitionState state, ArrayList<String> sourceNames, ArrayList<String> targetNames) {
        if (sourceNames != null) {
            for (int i = 0; i < sourceNames.size(); ++i) {
                String source = sourceNames.get(i);
                String target = targetNames.get(i);
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
            }
        }
    }

    private void setBackNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int count = this.mSharedElementTargetNames == null ? 0 : this.mSharedElementTargetNames.size();
        for (int i = 0; i < count; ++i) {
            String source = this.mSharedElementSourceNames.get(i);
            String originalTarget = this.mSharedElementTargetNames.get(i);
            View view = (View)namedViews.get((Object)originalTarget);
            if (view == null) continue;
            String target = FragmentTransitionCompat21.getTransitionName(view);
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    private void setNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int count = namedViews.size();
        for (int i = 0; i < count; ++i) {
            String source = (String)namedViews.keyAt(i);
            String target = FragmentTransitionCompat21.getTransitionName((View)namedViews.valueAt(i));
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    public class TransitionState {
        public ArrayMap<String, String> nameOverrides = new ArrayMap();
        public ArrayList<View> hiddenFragmentViews = new ArrayList();
        public FragmentTransitionCompat21.EpicenterView enteringEpicenterView = new FragmentTransitionCompat21.EpicenterView();
        public View nonExistentView;
    }

    static final class Op {
        Op next;
        Op prev;
        int cmd;
        Fragment fragment;
        int enterAnim;
        int exitAnim;
        int popEnterAnim;
        int popExitAnim;
        ArrayList<Fragment> removed;

        Op() {
        }
    }
}

